/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.map.plot.layout;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.io.IOException;
import java.util.List;
import se.prediktera.map.common.MapProperty;
import se.prediktera.map.common.RandomInputStream;
import se.prediktera.map.common.RandomOutputStream;
import se.prediktera.map.datasetcontainer.DataTreeInterface;
import se.prediktera.map.datasetcontainer.matrix.FoldMatrix;
import se.prediktera.map.main.extclass.AbstractInfo;
import se.prediktera.map.main.extclass.ExtClassLoader;
import se.prediktera.map.plot.axisplot.AbstractAxisLayer;
import se.prediktera.map.plot.axisplot.windows.FloatMainWindow;
import se.prediktera.map.plot.axisplot.windows.FloatTextWindow;
import se.prediktera.map.plot.axisplot.windows.PlotZone;
import se.prediktera.map.plot.layout.AbstractDescInfo;

public class DescriptionTextBox
extends FloatTextWindow {
    private static final Color bgcolor = new Color(255, 255, 225);
    private PlotZone externPlotZone;
    private int primaryIndex;
    private int secondaryIndex;
    private final Point point = new Point();
    private AbstractAxisLayer layer = null;
    private double[] coordinates;

    public DescriptionTextBox(AbstractAxisLayer abstractAxisLayer, int n, int n2, DataTreeInterface dataTreeInterface, int n3, int n4, int n5) {
        this(n, n2);
        this.layer = abstractAxisLayer;
        this.primaryIndex = n3;
        this.secondaryIndex = n4;
        this.addExtendsDesc(dataTreeInterface, n5);
    }

    public DescriptionTextBox(int n, int n2) {
        super(new Font("SansSerif", 1, 16), 2);
        this.setFloatText("[NONE]");
        this.setBackground(bgcolor);
        this.setBorderColor(Color.black);
        this.setWindowLocation(n, n2);
        this.setProtected(false);
    }

    public DescriptionTextBox(RandomInputStream randomInputStream, MapProperty mapProperty) throws IOException {
        super(randomInputStream, mapProperty);
        this.externPlotZone = (PlotZone)mapProperty.resolveNodeFromName(randomInputStream, "ep");
        if (this.externPlotZone != null) {
            this.addPlotZone(this.externPlotZone, 1);
        }
        this.primaryIndex = mapProperty.getPropertyInt("p", -1);
        this.secondaryIndex = mapProperty.getPropertyInt("s", -1);
        this.layer = (AbstractAxisLayer)mapProperty.resolveNodeFromName(randomInputStream, "lr");
        this.coordinates = mapProperty.getPropertyDoubleArray("coord", null);
    }

    public void addExtendsDesc(DataTreeInterface dataTreeInterface, int n) {
        if (dataTreeInterface instanceof FoldMatrix) {
            dataTreeInterface = ((FoldMatrix)dataTreeInterface).getRootReferencedMatrix();
        }
        List<AbstractInfo> list = ExtClassLoader.getAbstractInfoFromType(AbstractInfo.DESC_INFO);
        for (AbstractInfo abstractInfo : list) {
            AbstractDescInfo abstractDescInfo;
            PlotZone plotZone;
            if (!abstractInfo.supportData(dataTreeInterface) || (plotZone = (abstractDescInfo = (AbstractDescInfo)abstractInfo).createDesc(dataTreeInterface, n)) == null) continue;
            this.externPlotZone = plotZone;
            this.addPlotZone(this.externPlotZone, 1);
            this.addTreeNode(this.externPlotZone);
        }
    }

    @Override
    public void componentResized(double d, double d2, boolean bl, boolean bl2) {
        this.superComponentResized(d, d2, bl, bl2);
    }

    @Override
    public void drawLine(Double[] doubleArray) {
        this.coordinates = new double[doubleArray.length];
        for (int i = 0; i < doubleArray.length; ++i) {
            this.coordinates[i] = doubleArray[i];
        }
        this.setDrawLine(true);
    }

    public Point getClosestCorner(Point point) {
        Point point2 = new Point();
        double d = this.getTryOrigoX();
        double d2 = this.getTryOrigoY();
        double d3 = this.getTryWidth();
        double d4 = this.getTryHeight();
        if (point == null) {
            point2.setLocation(d, d2);
        } else {
            double d5 = d + d3 / 3.0;
            double d6 = d + 2.0 * d3 / 3.0;
            double d7 = d2 + d4 / 3.0;
            double d8 = d2 + 2.0 * d4 / 3.0;
            point2.x = (double)point.x < d5 ? (int)d : ((double)point.x < d6 ? (int)(d + d3 / 2.0) : (int)(d + d3 - 1.0));
            point2.y = (double)point.y < d7 ? (int)d2 : ((double)point.y < d8 ? (int)(d2 + d4 / 2.0) : (int)(d2 + d4 - 1.0));
        }
        return point2;
    }

    public AbstractAxisLayer getLayer() {
        return this.layer;
    }

    public Point getMiddle() {
        double d = this.getTryOrigoX();
        double d2 = this.getTryOrigoY();
        double d3 = this.getTryWidth();
        double d4 = this.getTryHeight();
        return new Point((int)(d + d3 / 2.0), (int)(d2 + d4 / 2.0));
    }

    public int getPrimaryIndex() {
        return this.primaryIndex;
    }

    public int getSecondayIndex() {
        return this.secondaryIndex;
    }

    @Override
    public byte getTreeType() {
        return 13;
    }

    @Override
    public void makeScreenShot(Graphics2D graphics2D, boolean bl, boolean bl2) {
        if (this.isDrawLine()) {
            this.drawLine(graphics2D);
        }
        super.makeScreenShot(graphics2D, bl, bl2);
    }

    @Override
    public void paint(Graphics2D graphics2D) {
        if (this.layer == null || this.layer.isLayerVisible()) {
            if (this.isDrawLine()) {
                if (this.drawLine(graphics2D)) {
                    super.paint(graphics2D);
                }
            } else {
                super.paint(graphics2D);
            }
        }
    }

    @Override
    public void SaveProperty(RandomOutputStream randomOutputStream) throws IOException {
        super.SaveProperty(randomOutputStream);
        randomOutputStream.writePropertyNode("ep", this.externPlotZone);
        randomOutputStream.writePropertyInt("p", this.primaryIndex);
        randomOutputStream.writePropertyInt("s", this.secondaryIndex);
        randomOutputStream.writePropertyNode("lr", this.layer);
        randomOutputStream.writePropertyDoubleArray("coord", this.coordinates);
    }

    private boolean drawLine(Graphics2D graphics2D) {
        graphics2D.setColor(Color.black);
        Rectangle rectangle = graphics2D.getClipBounds();
        if (this.coordinates != null) {
            FloatMainWindow floatMainWindow = this.baseWindow.getMainWindow();
            for (int i = 0; i < this.coordinates.length; i += 2) {
                Point point = floatMainWindow.getPointAtCoordsAt(this.coordinates[i], this.coordinates[i + 1]);
                point.setLocation(point.x + floatMainWindow.getX(), point.y + floatMainWindow.getY());
                if (point == null || rectangle != null && !rectangle.contains(point.x, point.y)) continue;
                Point point2 = this.getMiddle();
                graphics2D.drawLine(point.x, point.y, point2.x, point2.y);
            }
            return true;
        }
        Point point = this.baseWindow.getMainWindow().getPointAtCordsAt(this.layer, this.point, this.primaryIndex, this.secondaryIndex);
        if (point != null && (rectangle == null || rectangle.contains(point.x, point.y))) {
            Point point3 = this.getClosestCorner(point);
            graphics2D.drawLine(point.x, point.y, point3.x, point3.y);
            return true;
        }
        return false;
    }
}

