/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.map.plot.layout;

import java.awt.Component;
import java.awt.event.ItemEvent;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import se.prediktera.map.common.cleanup.CleanUpToolBar;
import se.prediktera.map.common.swing.flat.JFlatButton;
import se.prediktera.map.common.swing.flat.JFlatToggleButton;
import se.prediktera.map.common.swing.flat.JFlatToggleButtonComboBox;
import se.prediktera.map.main.GlobalMessageInterface;
import se.prediktera.map.main.Main_GUI;
import se.prediktera.map.plot.AbstractPlot;
import se.prediktera.map.plot.layout.AbstractPlotLayout;
import se.prediktera.map.statistic.AbstractStatistic;

public class PlotLayoutToolbar
extends CleanUpToolBar
implements GlobalMessageInterface {
    private static final byte FLOATWINDOWS = 0;
    private static final byte TEXTBOX = 1;
    private static final byte SHAPERECT = 2;
    private static final byte SHAPEELLIPSE = 3;
    private static final byte SHAPELINE = 4;
    private static final byte LEGEND = 5;
    private static final byte IMAGE = 6;
    private final JFlatToggleButton floatWindows = new JFlatToggleButton();
    private final JFlatToggleButton floatTextBox = new JFlatToggleButton();
    private final JFlatToggleButton floatLegendBox = new JFlatToggleButton();
    private final JFlatToggleButton floatShapeRectTextBox = new JFlatToggleButton();
    private final JFlatToggleButton floatShapeEllipseTextBox = new JFlatToggleButton();
    private final JFlatToggleButton floatShapeLineTextBox = new JFlatToggleButton();
    private final JFlatToggleButton floatImageTextBox = new JFlatToggleButton();
    private AbstractPlotLayout baseWindow;

    public PlotLayoutToolbar(AbstractPlotLayout abstractPlotLayout, ButtonGroup buttonGroup) {
        this.baseWindow = abstractPlotLayout;
        this.floatWindows.setToolTipText("Plot Layout");
        this.floatWindows.setIcon(new ImageIcon(Main_GUI.class.getResource("icons/other/layout.png")));
        this.floatWindows.addItemListener(itemEvent -> this.setLayoutMode(itemEvent));
        this.floatTextBox.setToolTipText("Text Box");
        this.floatTextBox.setIcon(new ImageIcon(AbstractPlot.class.getResource("image/textbox.png")));
        this.floatTextBox.addItemListener(itemEvent -> this.setCreateBoxMode(itemEvent, (byte)0, (byte)1));
        this.floatLegendBox.setToolTipText("Legend");
        this.floatLegendBox.addItemListener(itemEvent -> this.setCreateBoxMode(itemEvent, (byte)5, (byte)5));
        this.floatShapeRectTextBox.setToolTipText("Rectangle Shape");
        this.floatShapeRectTextBox.setIcon(new ImageIcon(AbstractPlot.class.getResource("image/rectangle.png")));
        this.floatShapeRectTextBox.addItemListener(itemEvent -> this.setCreateBoxMode(itemEvent, (byte)1, (byte)2));
        this.floatShapeEllipseTextBox.setToolTipText("Ellipse Shape");
        this.floatShapeEllipseTextBox.setIcon(new ImageIcon(AbstractPlot.class.getResource("image/ellipse.png")));
        this.floatShapeEllipseTextBox.addItemListener(itemEvent -> this.setCreateBoxMode(itemEvent, (byte)2, (byte)3));
        this.floatShapeLineTextBox.setToolTipText("Line Shape");
        this.floatShapeLineTextBox.setIcon(new ImageIcon(AbstractPlot.class.getResource("image/line.gif")));
        this.floatShapeLineTextBox.addItemListener(itemEvent -> this.setCreateBoxMode(itemEvent, (byte)3, (byte)4));
        this.floatImageTextBox.setToolTipText("Image");
        this.floatImageTextBox.setIcon(new ImageIcon(AbstractPlot.class.getResource("image/image.png")));
        this.floatImageTextBox.addItemListener(itemEvent -> this.setCreateBoxMode(itemEvent, (byte)6, (byte)6));
        JFlatButton jFlatButton = new JFlatButton();
        jFlatButton.setToolTipText("Restore Plot Layout");
        jFlatButton.setIcon(new ImageIcon(AbstractPlot.class.getResource("image/autolayout.png")));
        jFlatButton.addActionListener(actionEvent -> this.baseWindow.autoLayout());
        JFlatToggleButtonComboBox jFlatToggleButtonComboBox = new JFlatToggleButtonComboBox();
        jFlatToggleButtonComboBox.setToolTipText("New Plot Field");
        jFlatToggleButtonComboBox.setButtonGroup(buttonGroup);
        buttonGroup.add(this.floatWindows);
        jFlatToggleButtonComboBox.addButton(this.floatTextBox);
        jFlatToggleButtonComboBox.addButton(this.floatShapeRectTextBox);
        jFlatToggleButtonComboBox.addButton(this.floatShapeEllipseTextBox);
        jFlatToggleButtonComboBox.addButton(this.floatShapeLineTextBox);
        jFlatToggleButtonComboBox.addButton(this.floatImageTextBox);
        JFlatToggleButtonComboBox jFlatToggleButtonComboBox2 = new JFlatToggleButtonComboBox();
        jFlatToggleButtonComboBox2.setToolTipText("Show Statistics");
        jFlatToggleButtonComboBox2.setButtonGroup(buttonGroup);
        JFlatToggleButton jFlatToggleButton = new JFlatToggleButton();
        jFlatToggleButton.setToolTipText("Label");
        jFlatToggleButtonComboBox2.addButton(jFlatToggleButton);
        jFlatToggleButton.setIcon(AbstractStatistic.statisticsIcon);
        JFlatToggleButton jFlatToggleButton2 = new JFlatToggleButton();
        jFlatToggleButton2.setToolTipText("Description");
        jFlatToggleButtonComboBox2.addButton(jFlatToggleButton2);
        jFlatToggleButton2.setIcon(AbstractStatistic.statisticsIcon);
        this.setBorder(null);
        this.setFloatable(false);
        this.addSeparator();
        this.add(jFlatButton);
        this.add((Component)this.floatWindows, null);
        this.add(jFlatToggleButtonComboBox);
    }

    public void postGlobalMessage(byte by) {
        if (this.baseWindow != null) {
            this.baseWindow.PostGlobalMessage((byte)3, by);
        }
    }

    public byte sendGlobalMessage(byte by) {
        switch (by) {
            case 0: {
                this.floatWindows.setSelected(true);
                break;
            }
            case 1: {
                this.floatTextBox.setSelected(true);
                break;
            }
            case 5: {
                this.floatLegendBox.setSelected(true);
                break;
            }
            case 2: {
                this.floatShapeRectTextBox.setSelected(true);
                break;
            }
            case 3: {
                this.floatShapeEllipseTextBox.setSelected(true);
                break;
            }
            case 4: {
                this.floatShapeLineTextBox.setSelected(true);
                break;
            }
            case 6: {
                this.floatImageTextBox.setSelected(true);
                break;
            }
            default: {
                assert (false) : "Strange message " + by;
                break;
            }
        }
        return 1;
    }

    @Override
    protected void cleanUpChild() {
        this.baseWindow = null;
    }

    private void setCreateBoxMode(ItemEvent itemEvent, byte by, byte by2) {
        if (itemEvent.getStateChange() == 1) {
            this.baseWindow.createWindow(by);
            this.postGlobalMessage(by2);
        } else {
            this.baseWindow.createWindow((byte)-1);
        }
    }

    private void setLayoutMode(ItemEvent itemEvent) {
        this.baseWindow.setLayoutEnable(itemEvent.getStateChange() == 1);
        if (itemEvent.getStateChange() == 1) {
            this.postGlobalMessage((byte)0);
        }
    }
}

