/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.map.plot.layout;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import se.prediktera.map.plot.axisplot.windows.PlotZone;

public class PlotZoneSwitch
extends PlotZone {
    public static final byte LEFT = 0;
    public static final byte RIGHT = 1;
    public static final byte UP = 2;
    public static final byte DOWN = 3;
    private byte direction;
    private double padding = 0.15;

    public PlotZoneSwitch(Color color, int n, double d, double d2, boolean bl, byte by) {
        super(color, d, d2, (byte)1);
        this.direction = by;
    }

    public byte getDirection() {
        return this.direction;
    }

    public double getPadding() {
        return this.padding;
    }

    @Override
    public void paint(Graphics2D graphics2D, byte by, double d) {
        if (this.floatWindow != null) {
            double d2;
            double d3 = (double)this.width * this.padding;
            double d4 = (double)this.height * this.padding;
            AffineTransform affineTransform = graphics2D.getTransform();
            double d5 = (double)this.width - d3 * 2.0;
            double d6 = (double)this.height - d4 * 2.0;
            double d7 = d2 = d5 < d6 ? d5 : d6;
            if (this.bkcolor != null) {
                graphics2D.setColor(this.bkcolor);
                graphics2D.fillRect(0, 0, this.width, this.height);
            }
            if (this.bordercolor != null) {
                graphics2D.setColor(this.bordercolor);
                graphics2D.drawRect(0, 0, this.width - 1, this.height - 1);
            }
            graphics2D.translate(this.origoX + this.width / 2, this.origoY + this.height / 2);
            switch (this.direction) {
                case 0: {
                    graphics2D.rotate(Math.PI);
                    break;
                }
                case 1: {
                    break;
                }
                case 2: {
                    graphics2D.rotate(Math.PI);
                    break;
                }
            }
            GeneralPath generalPath = new GeneralPath();
            generalPath.moveTo((float)(0.5 * d2), 0.0f);
            generalPath.lineTo((float)(-0.5 * d2), (float)(0.5 * d2));
            generalPath.lineTo((float)(-0.5 * d2), (float)(-0.5 * d2));
            generalPath.closePath();
            graphics2D.setColor(Color.darkGray);
            graphics2D.fill(generalPath);
            graphics2D.setColor(Color.black);
            graphics2D.draw(generalPath);
            graphics2D.setTransform(affineTransform);
        }
    }

    public void setDirection(byte by) {
        this.direction = by;
    }

    public void setPadding(double d) {
        this.padding = d;
    }
}

