/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.map.plot.layout;

import java.awt.Color;
import java.awt.Cursor;
import java.awt.Font;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.io.IOException;
import javax.swing.SwingUtilities;
import se.prediktera.map.common.MapProperty;
import se.prediktera.map.common.RandomInputStream;
import se.prediktera.map.common.RandomOutputStream;
import se.prediktera.map.plot.axisplot.windows.FloatTextWindow;
import se.prediktera.map.plot.axisplot.windows.PlotZone;
import se.prediktera.map.plot.layout.AbstractPlotLayout;
import se.prediktera.map.plot.layout.PlotZoneSwitch;
import se.prediktera.map.plot.layout.SwitchInterface;

public class SwitchTextBox
extends FloatTextWindow {
    private static final Color bgcolor = new Color(255, 255, 225);
    private PlotZone switchLeft;
    private PlotZone switchRight;
    private final String type;

    public SwitchTextBox(RandomInputStream randomInputStream, MapProperty mapProperty) throws IOException {
        super(randomInputStream, mapProperty);
        this.type = mapProperty.getPropertyStringUTF("type");
        this.init();
    }

    public SwitchTextBox(String string) {
        super(new Font("SansSerif", 1, 16), 0);
        this.type = string;
        this.setFloatText("[NONE]");
        this.setBackground(bgcolor);
        this.setBorderColor(Color.black);
        this.setWindowLocation(0.0, 0.0);
        this.setProtected(false);
        this.setFloatText("Switch");
        this.init();
    }

    @Override
    public byte getTreeType() {
        return 16;
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
        super.mouseClicked(mouseEvent);
        if (SwingUtilities.isLeftMouseButton(mouseEvent)) {
            Point point = mouseEvent.getPoint();
            SwitchInterface switchInterface = this.getSwitchInterface();
            if (this.switchLeft.isInside(point.x, point.y)) {
                switchInterface.switchLeft();
            } else if (this.switchRight.isInside(point.x, point.y)) {
                switchInterface.switchRight();
            }
        }
    }

    @Override
    public void mouseMoved(MouseEvent mouseEvent) {
        super.mouseMoved(mouseEvent);
        Point point = mouseEvent.getPoint();
        if (this.switchLeft.isInside(point.x, point.y) || this.switchRight.isInside(point.x, point.y)) {
            this.setCursor(Cursor.getPredefinedCursor(12));
        } else {
            this.setCursor(Cursor.getDefaultCursor());
        }
    }

    @Override
    public void SaveProperty(RandomOutputStream randomOutputStream) throws IOException {
        super.SaveProperty(randomOutputStream);
        randomOutputStream.writePropertyStringUTF("type", this.type);
    }

    private SwitchInterface getSwitchInterface() {
        AbstractPlotLayout abstractPlotLayout = this.getParentBaseWindow();
        if (this.type.equalsIgnoreCase("plotarea")) {
            return abstractPlotLayout.getPlot_GUI();
        }
        return null;
    }

    private void init() {
        this.switchLeft = new PlotZoneSwitch(null, 0, 0.2, 1.0, false, 0);
        this.addPlotZone(this.switchLeft, 2);
        this.addTreeNode(this.switchLeft);
        this.switchRight = new PlotZoneSwitch(null, 0, 0.2, 1.0, false, 1);
        this.addPlotZone(this.switchRight, 3);
        this.addTreeNode(this.switchRight);
    }
}

