/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.map.plot.layout;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.util.Random;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JToolBar;
import javax.swing.UIManager;
import se.prediktera.map.common.MapProperty;
import se.prediktera.map.common.RandomInputStream;
import se.prediktera.map.common.RandomOutputStream;
import se.prediktera.map.common.error.ErrorHandler;
import se.prediktera.map.datasetcontainer.Case;
import se.prediktera.map.datasetcontainer.datainfo.InnerColumnString;
import se.prediktera.map.datasetcontainer.datainfo.Smiles;
import se.prediktera.map.datasetcontainer.matrix.MVmatrix;
import se.prediktera.map.main.Main_GUI;
import se.prediktera.map.main.Project_GUI;
import se.prediktera.map.main.extclass.ExtClassLoader;
import se.prediktera.map.plot.PlotInit;
import se.prediktera.map.plot.axisplot.plot2D.scatter.Scatter2D;

public class TestLayout
extends JFrame {
    private Scatter2D scatter2D;

    public static void main(String[] stringArray) {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception exception) {
            ErrorHandler.logAndReportException(exception);
        }
        new TestLayout(null, null);
    }

    public TestLayout(RandomInputStream randomInputStream, MapProperty mapProperty) {
        try {
            new Main_GUI(true);
            Project_GUI project_GUI = new Project_GUI("", 0);
            ExtClassLoader.findExtendedLibrariesByClassDir();
            if (mapProperty == null) {
                Case case_ = new Case(5, 2);
                MVmatrix mVmatrix = new MVmatrix(5, 2, "test");
                case_.setOriginalMatrix(mVmatrix);
                Smiles smiles = (Smiles)case_.getDataInfo(0).getGroupColumnByType(8);
                smiles.addColumn("smiles");
                InnerColumnString innerColumnString = (InnerColumnString)smiles.getPrimaryColumn();
                Random random = new Random(0L);
                for (int i = 0; i < mVmatrix.getN(); ++i) {
                    innerColumnString.setValue(i, "c1ccc(cc1)CN");
                    for (int j = 0; j < mVmatrix.getK(); ++j) {
                        mVmatrix.setValue(i, j, random.nextDouble());
                    }
                }
                PlotInit plotInit = new PlotInit(mVmatrix);
                plotInit.setDataTreeInterface(mVmatrix);
                this.scatter2D = new Scatter2D(project_GUI.getPlot_GUI(), plotInit);
            } else {
                this.scatter2D = (Scatter2D)mapProperty.resolveNodeFromName(randomInputStream, "scatter2D");
            }
            this.jbInit();
            this.setSize(600, 600);
            this.setLocationRelativeTo(null);
            this.setVisible(true);
            this.scatter2D.setCreated(project_GUI.getPlot_GUI(), false);
        }
        catch (Exception exception) {
            ErrorHandler.logAndReportException(exception);
        }
    }

    private void jbInit() throws Exception {
        JPanel jPanel = (JPanel)this.getContentPane();
        jPanel.setLayout(new BorderLayout());
        jPanel.add((Component)this.scatter2D, "Center");
        Vector<JToolBar> vector = new Vector<JToolBar>();
        this.scatter2D.getToolbars(vector);
        jPanel.add((Component)vector.elementAt(0), "North");
        JButton jButton = new JButton("Save and Open");
        ActionListenerTest actionListenerTest = new ActionListenerTest();
        jButton.addActionListener(actionListenerTest);
        JPanel jPanel2 = new JPanel();
        jPanel2.add(jButton);
        jPanel.add((Component)jPanel2, "South");
    }

    class ActionListenerTest
    implements ActionListener {
        ActionListenerTest() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            try {
                File file = new File("test.map");
                RandomOutputStream randomOutputStream = new RandomOutputStream(file, false, null);
                randomOutputStream.writeHeader(8);
                randomOutputStream.writeIndexTable();
                randomOutputStream.setStartIndex((byte)8, randomOutputStream.getFilePointer());
                randomOutputStream.beginProperty("TestLayout");
                randomOutputStream.writePropertyNode("sctatter2D", TestLayout.this.scatter2D);
                randomOutputStream.endProperty();
                randomOutputStream.setEndIndex((byte)8, randomOutputStream.getFilePointer());
                randomOutputStream.setDatabaseID(5);
                randomOutputStream.writeIndexTable();
                randomOutputStream.close();
                RandomInputStream randomInputStream = new RandomInputStream(file, null);
                randomInputStream.readFileFramework(true);
                MapProperty mapProperty = randomInputStream.readProperties("TestLayout");
                new TestLayout(randomInputStream, mapProperty);
                randomInputStream.close();
            }
            catch (IOException iOException) {
                ErrorHandler.logAndReportException(iOException);
            }
        }
    }
}

