/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.map.plot.layout;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.ArrayList;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import se.prediktera.map.common.JTextFieldButtonUppDown;
import se.prediktera.map.common.error.ErrorHandler;
import se.prediktera.map.common.swing.EvinceBorderFactory;
import se.prediktera.map.plot.axisplot.settings.Color.PlotContinuousColor;
import se.prediktera.map.plot.axisplot.settings.Color.ScalePanel;
import se.prediktera.map.plot.layout.PlotEditInterface;
import se.prediktera.map.plot.layout.PlotWindowInterface;

public class TextProperties
extends JPanel {
    private final ArrayList<PlotWindowInterface> selectedWindows;
    private final JRadioButton radioButtonNone = new JRadioButton("None");
    private final JRadioButton radioButtonLine = new JRadioButton("Line");
    private final JRadioButton radioButtonEllipse = new JRadioButton("Ellipse");
    private final JRadioButton radioButtonRect = new JRadioButton("Rectangle");
    private final JRadioButton radioButtonLeft = new JRadioButton("Left");
    private final JRadioButton radioButtonCenter = new JRadioButton("Center");
    private final JRadioButton radioButtonRight = new JRadioButton("Right");
    private final JCheckBox checkBoxAutoText = new JCheckBox("Auto text");
    private final JCheckBox checkBoxTransparent = new JCheckBox("Transparent");
    private final JTextArea textArea = new JTextArea();
    private final ScalePanel fontColor = new ScalePanel(new PlotContinuousColor("Fixed", Color.black));
    private final ScalePanel borderColor = new ScalePanel(new PlotContinuousColor("Fixed", Color.black));
    private final JTextFieldButtonUppDown borderWidth = new JTextFieldButtonUppDown(0.0, 100.0, true);
    private final ScalePanel backgroundColor = new ScalePanel(new PlotContinuousColor("Fixed", Color.white));
    private final JCheckBox checkDrawLine = new JCheckBox("Draw line to object");

    public TextProperties(ArrayList<PlotWindowInterface> arrayList) {
        super(new GridBagLayout());
        this.selectedWindows = arrayList;
        try {
            this.jbInit();
            for (int i = 0; i < arrayList.size(); ++i) {
                PlotEditInterface plotEditInterface = (PlotEditInterface)arrayList.get(i);
                if (i == 0 || this.checkBoxAutoText.isSelected() == plotEditInterface.hasAutoText()) {
                    this.checkBoxAutoText.setSelected(plotEditInterface.hasAutoText());
                } else {
                    this.checkBoxAutoText.setEnabled(false);
                }
                if (i == 0 || this.textArea.getText().equals(plotEditInterface.getFloatText())) {
                    this.textArea.setText(plotEditInterface.getFloatText());
                    if (this.checkBoxAutoText.isEnabled()) {
                        this.checkBoxAutoText.addItemListener(itemEvent -> this.textArea.setEnabled(itemEvent.getStateChange() == 2));
                    }
                    this.textArea.setEnabled(!this.checkBoxAutoText.isSelected());
                } else {
                    this.textArea.setEnabled(false);
                }
                if (i == 0 || plotEditInterface.getShapeType() == this.getShapeType()) {
                    switch (plotEditInterface.getShapeType()) {
                        case 1: {
                            this.radioButtonRect.setSelected(true);
                            break;
                        }
                        case 2: {
                            this.radioButtonEllipse.setSelected(true);
                            break;
                        }
                        case 3: 
                        case 4: {
                            this.radioButtonLine.setSelected(true);
                            break;
                        }
                        default: {
                            this.radioButtonNone.setSelected(true);
                            break;
                        }
                    }
                } else {
                    this.enableRadioButtons(false);
                }
                if (i == 0 || plotEditInterface.getTextAlignment() == this.getTextAlignment()) {
                    switch (plotEditInterface.getTextAlignment()) {
                        case 2: {
                            this.radioButtonLeft.setSelected(true);
                            break;
                        }
                        case 0: {
                            this.radioButtonCenter.setSelected(true);
                            break;
                        }
                        case 4: {
                            this.radioButtonRight.setSelected(true);
                            break;
                        }
                        default: {
                            this.radioButtonLeft.setSelected(true);
                            break;
                        }
                    }
                } else {
                    this.enableRadioButtons(false);
                }
                if (i == 0 || this.fontColor.getFixedColor().equals(plotEditInterface.getFontColor())) {
                    this.fontColor.setFixedColor(plotEditInterface.getFontColor());
                } else {
                    this.fontColor.setEnabled(false);
                }
                if (i == 0 || this.borderColor.getFixedColor().equals(plotEditInterface.getBorderColor())) {
                    this.borderColor.setFixedColor(plotEditInterface.getBorderColor());
                } else {
                    this.borderColor.setEnabled(false);
                }
                if (i == 0 || this.borderWidth.getNumber() == (double)plotEditInterface.getBorderWidth()) {
                    this.borderWidth.setNumber(plotEditInterface.getBorderWidth());
                } else {
                    this.borderWidth.setEnabled(false);
                }
                if (i == 0 || plotEditInterface.isTransparent() == this.checkBoxTransparent.isSelected()) {
                    this.checkBoxTransparent.setSelected(plotEditInterface.isTransparent());
                } else {
                    this.checkBoxTransparent.setEnabled(true);
                }
                if (i == 0 || this.backgroundColor.getFixedColor().equals(plotEditInterface.getBackground())) {
                    this.backgroundColor.setFixedColor(plotEditInterface.getBackground());
                } else {
                    this.backgroundColor.setEnabled(false);
                    this.checkBoxTransparent.setEnabled(false);
                }
                if (i == 0 || plotEditInterface.isDrawLine() == this.checkDrawLine.isSelected()) {
                    this.checkDrawLine.setSelected(plotEditInterface.isDrawLine());
                    continue;
                }
                this.checkDrawLine.setEnabled(false);
            }
        }
        catch (Exception exception) {
            ErrorHandler.logAndShowEvinceErrorDialogForException(exception);
        }
    }

    public void applyChanges() {
        for (PlotWindowInterface plotWindowInterface : this.selectedWindows) {
            PlotEditInterface plotEditInterface = (PlotEditInterface)plotWindowInterface;
            if (this.checkBoxAutoText.isEnabled()) {
                plotEditInterface.setAutoText(this.checkBoxAutoText.isSelected());
            }
            if (this.textArea.isEnabled()) {
                plotEditInterface.setFloatText(this.textArea.getText(), false);
            }
            if (this.radioButtonNone.isEnabled()) {
                plotEditInterface.setShapeType(this.getShapeType());
            }
            if (this.radioButtonLeft.isEnabled()) {
                plotEditInterface.setTextAlignment(this.getTextAlignment());
            }
            if (this.fontColor.isEnabled()) {
                plotEditInterface.setFontColor(this.fontColor.getFixedColor());
            }
            if (this.borderColor.isEnabled()) {
                plotEditInterface.setBorderColor(this.borderColor.getFixedColor());
            }
            if (this.borderWidth.isEnabled()) {
                plotEditInterface.setBorderWidth((float)this.borderWidth.getNumber());
            }
            if (this.checkBoxTransparent.isEnabled()) {
                if (this.checkBoxTransparent.isSelected()) {
                    plotEditInterface.setBackground(null);
                } else {
                    plotEditInterface.setBackground(this.backgroundColor.getFixedColor());
                }
            }
            if (this.checkDrawLine.isEnabled()) {
                plotEditInterface.setDrawLine(this.checkDrawLine.isSelected());
            }
            plotEditInterface.contentPaint((byte)1);
        }
    }

    private void enableRadioButtons(boolean bl) {
        this.radioButtonNone.setEnabled(bl);
        this.radioButtonRect.setEnabled(bl);
        this.radioButtonEllipse.setEnabled(bl);
        this.radioButtonLine.setEnabled(bl);
        this.radioButtonLeft.setEnabled(bl);
        this.radioButtonCenter.setEnabled(bl);
        this.radioButtonRight.setEnabled(bl);
    }

    private byte getShapeType() {
        if (this.radioButtonRect.isSelected()) {
            return 1;
        }
        if (this.radioButtonEllipse.isSelected()) {
            return 2;
        }
        if (this.radioButtonLine.isSelected()) {
            return 3;
        }
        return -1;
    }

    private byte getTextAlignment() {
        if (!this.radioButtonLeft.isSelected()) {
            if (this.radioButtonCenter.isSelected()) {
                return 0;
            }
            if (this.radioButtonRight.isSelected()) {
                return 4;
            }
        }
        return 2;
    }

    private void jbInit() throws Exception {
        JScrollPane jScrollPane = new JScrollPane();
        this.fontColor.setText("Foo");
        this.borderColor.setText("Foo");
        this.backgroundColor.setText("Foo");
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setBorder(EvinceBorderFactory.createEvinceBorder("Text"));
        jScrollPane.setPreferredSize(new Dimension(100, 100));
        jScrollPane.getViewport().add(this.textArea);
        jPanel.add((Component)jScrollPane, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(6, 6, 0, 6), 0, 0));
        jPanel.add((Component)this.checkBoxAutoText, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 18, 0, new Insets(6, 6, 0, 6), 0, 0));
        jPanel.add((Component)this.checkDrawLine, new GridBagConstraints(0, 2, 1, 1, 1.0, 0.0, 18, 0, new Insets(6, 6, 6, 6), 0, 0));
        this.add((Component)jPanel, new GridBagConstraints(0, 0, 0, 1, 0.0, 0.0, 18, 1, new Insets(0, 0, 0, 0), 0, 0));
        JPanel jPanel2 = new JPanel(new GridBagLayout());
        jPanel2.setBorder(EvinceBorderFactory.createEvinceBorder("Border shape"));
        jPanel2.add((Component)this.radioButtonNone, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(6, 6, 0, 0), 0, 0));
        jPanel2.add((Component)this.radioButtonRect, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 18, 0, new Insets(6, 6, 0, 0), 0, 0));
        jPanel2.add((Component)this.radioButtonEllipse, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 18, 0, new Insets(6, 6, 0, 0), 0, 0));
        jPanel2.add((Component)this.radioButtonLine, new GridBagConstraints(3, 0, 1, 1, 1.0, 0.0, 18, 0, new Insets(6, 6, 0, 6), 0, 0));
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.radioButtonNone);
        buttonGroup.add(this.radioButtonRect);
        buttonGroup.add(this.radioButtonEllipse);
        buttonGroup.add(this.radioButtonLine);
        this.add((Component)jPanel2, new GridBagConstraints(0, 1, 4, 1, 0.0, 0.0, 18, 1, new Insets(0, 0, 0, 0), 0, 0));
        JPanel jPanel3 = new JPanel(new GridBagLayout());
        jPanel3.setBorder(EvinceBorderFactory.createEvinceBorder("Text alignment"));
        jPanel3.add((Component)this.radioButtonLeft, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(6, 6, 0, 0), 0, 0));
        jPanel3.add((Component)this.radioButtonCenter, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 18, 0, new Insets(6, 6, 0, 0), 0, 0));
        jPanel3.add((Component)this.radioButtonRight, new GridBagConstraints(2, 0, 1, 1, 1.0, 1.0, 18, 0, new Insets(6, 6, 0, 0), 0, 0));
        ButtonGroup buttonGroup2 = new ButtonGroup();
        buttonGroup2.add(this.radioButtonLeft);
        buttonGroup2.add(this.radioButtonCenter);
        buttonGroup2.add(this.radioButtonRight);
        this.add((Component)jPanel3, new GridBagConstraints(0, 2, 4, 1, 0.0, 0.0, 18, 1, new Insets(0, 0, 0, 0), 0, 0));
        JPanel jPanel4 = new JPanel(new GridBagLayout());
        jPanel4.setBorder(EvinceBorderFactory.createEvinceBorder("Color"));
        jPanel4.add((Component)new JLabel("Text"), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 18, 0, new Insets(6, 6, 0, 0), 0, 0));
        jPanel4.add((Component)this.fontColor, new GridBagConstraints(1, 0, 0, 1, 0.0, 0.0, 10, 2, new Insets(6, 6, 0, 6), 0, 0));
        jPanel4.add((Component)new JLabel("Border"), new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 18, 0, new Insets(6, 6, 0, 0), 0, 0));
        jPanel4.add((Component)this.borderColor, new GridBagConstraints(1, 1, 0, 1, 0.0, 0.0, 10, 2, new Insets(6, 6, 0, 6), 0, 0));
        jPanel4.add((Component)new JLabel("Background"), new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 18, 0, new Insets(6, 6, 0, 0), 0, 0));
        jPanel4.add((Component)this.backgroundColor, new GridBagConstraints(1, 2, 0, 1, 0.0, 0.0, 18, 2, new Insets(6, 6, 0, 6), 0, 0));
        jPanel4.add((Component)this.checkBoxTransparent, new GridBagConstraints(1, 2, 1, 1, 1.0, 1.0, 18, 0, new Insets(6, 6, 6, 0), 0, 0));
        this.add((Component)jPanel4, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 18, 1, new Insets(0, 0, 0, 0), 0, 0));
        JPanel jPanel5 = new JPanel(new GridBagLayout());
        jPanel5.setBorder(EvinceBorderFactory.createEvinceBorder("Other settings"));
        this.add((Component)jPanel5, new GridBagConstraints(0, 4, 1, 1, 1.0, 1.0, 18, 1, new Insets(0, 0, 0, 0), 0, 0));
        jPanel5.add((Component)new JLabel("Border width"), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 18, 0, new Insets(6, 6, 6, 0), 0, 0));
        jPanel5.add((Component)this.borderWidth, new GridBagConstraints(1, 0, 0, 1, 1.0, 1.0, 10, 2, new Insets(6, 6, 6, 6), 0, 0));
    }
}

