/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.map.plot.plotgenerator;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextArea;
import se.prediktera.map.common.swing.EvinceBorderFactory;
import se.prediktera.map.datasetcontainer.matrix.AbstractDataMatrix;
import se.prediktera.map.plot.PlotInit;
import se.prediktera.map.plot.axisplot.AxisChooseWizard;

public class PlotTypePanel
extends JPanel {
    private final JRadioButton typeColumnsRadioButton = new JRadioButton("Columns");
    private final JLabel typeColumnsLabel = new JLabel(new ImageIcon(PlotTypePanel.class.getResource("image/typecolumns.gif")));
    private final JRadioButton typeRowsRadioButton = new JRadioButton("Rows");
    private final JLabel typeRowsLabel = new JLabel(new ImageIcon(PlotTypePanel.class.getResource("image/typerows.gif")));
    private final JRadioButton typeFoldRadioButton = new JRadioButton("Fold");
    private final JLabel typeFoldLabel = new JLabel(new ImageIcon(PlotTypePanel.class.getResource("image/typefold.gif")));
    private final JTextArea descriptionArea = new JTextArea();
    private PlotInit plotInit = null;
    private final DisableImageListener disableImageListener;
    private final AxisChooseWizard wizardPage;

    public PlotTypePanel(AxisChooseWizard axisChooseWizard) {
        super(new GridBagLayout());
        this.wizardPage = axisChooseWizard;
        this.disableImageListener = new DisableImageListener();
        ButtonGroup buttonGroup = new ButtonGroup();
        this.typeColumnsRadioButton.addItemListener(this.disableImageListener);
        buttonGroup.add(this.typeColumnsRadioButton);
        this.typeRowsRadioButton.addItemListener(this.disableImageListener);
        buttonGroup.add(this.typeRowsRadioButton);
        this.typeFoldRadioButton.addItemListener(this.disableImageListener);
        buttonGroup.add(this.typeFoldRadioButton);
        this.setBorder(EvinceBorderFactory.createEvinceBorder("Plot type"));
        this.add((Component)this.typeColumnsLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 18, 0, new Insets(6, 6, 0, 0), 0, 0));
        this.add((Component)this.typeColumnsRadioButton, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 18, 0, new Insets(6, 6, 6, 0), 0, 0));
        this.add((Component)this.typeRowsLabel, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 18, 0, new Insets(6, 12, 6, 0), 0, 0));
        this.add((Component)this.typeRowsRadioButton, new GridBagConstraints(3, 0, 1, 1, 0.0, 0.0, 18, 0, new Insets(6, 6, 6, 0), 0, 0));
        this.add((Component)this.typeFoldLabel, new GridBagConstraints(4, 0, 1, 1, 0.0, 0.0, 18, 0, new Insets(6, 12, 6, 0), 0, 0));
        this.add((Component)this.typeFoldRadioButton, new GridBagConstraints(5, 0, 1, 1, 0.0, 0.0, 18, 0, new Insets(6, 6, 6, 0), 0, 0));
        this.descriptionArea.setBorder(EvinceBorderFactory.createEvinceBorder("Description"));
        this.descriptionArea.setBackground(this.getBackground());
        this.descriptionArea.setLineWrap(true);
        this.descriptionArea.setWrapStyleWord(true);
        this.descriptionArea.setFont(this.typeFoldLabel.getFont());
        this.add((Component)this.descriptionArea, new GridBagConstraints(0, 1, 6, 1, 1.0, 1.0, 18, 2, new Insets(0, 0, 0, 0), 0, 0));
    }

    public void setPlotInit(PlotInit plotInit) {
        this.plotInit = plotInit;
        this.typeFoldLabel.setVisible(plotInit.isFoldable());
        this.typeFoldRadioButton.setVisible(plotInit.isFoldable());
        if (plotInit.doFold() && plotInit.isFoldable()) {
            this.typeFoldRadioButton.setSelected(true);
        } else if (this.isRowPrimary()) {
            this.typeColumnsRadioButton.setSelected(true);
        } else {
            this.typeRowsRadioButton.setSelected(true);
        }
        AbstractDataMatrix abstractDataMatrix = plotInit.getMatrix(0);
        if (abstractDataMatrix == null || (abstractDataMatrix.getMatrixTag() & 3) != 3) {
            if (plotInit.isFoldable()) {
                this.typeRowsLabel.setVisible(false);
                this.typeRowsRadioButton.setVisible(false);
            } else {
                this.setVisible(false);
            }
        }
    }

    private byte getType() {
        if (this.typeColumnsRadioButton.isSelected() || this.typeFoldRadioButton.isSelected()) {
            return 1;
        }
        return 2;
    }

    private boolean isRowPrimary() {
        return (this.plotInit.plotType & 1) == 1;
    }

    private class DisableImageListener
    implements ItemListener {
        private DisableImageListener() {
        }

        @Override
        public void itemStateChanged(ItemEvent itemEvent) {
            if (itemEvent == null || itemEvent.getStateChange() == 1) {
                PlotTypePanel.this.plotInit.plotType = PlotTypePanel.this.getType();
                PlotTypePanel.this.plotInit.dofold = PlotTypePanel.this.typeFoldRadioButton.isSelected();
                PlotTypePanel.this.typeColumnsLabel.setEnabled(PlotTypePanel.this.typeColumnsRadioButton.isSelected());
                PlotTypePanel.this.typeRowsLabel.setEnabled(PlotTypePanel.this.typeRowsRadioButton.isSelected());
                PlotTypePanel.this.typeFoldLabel.setEnabled(PlotTypePanel.this.typeFoldRadioButton.isSelected());
                PlotTypePanel.this.wizardPage.setWithData(PlotTypePanel.this.plotInit);
                if (PlotTypePanel.this.typeColumnsRadioButton.isSelected()) {
                    PlotTypePanel.this.descriptionArea.setText("Plotting the matrix by column will effectively display one variable for each plot axis.\nThis is equivalent of plotting all observations for the selected variable.");
                } else if (PlotTypePanel.this.typeRowsRadioButton.isSelected()) {
                    PlotTypePanel.this.descriptionArea.setText("Plotting the matrix by row will effectively display one observation for each plot axis.\nThis is equivalent of plotting all variables for the selected observation.");
                } else if (PlotTypePanel.this.typeFoldRadioButton.isSelected()) {
                    PlotTypePanel.this.descriptionArea.setText("N/A");
                }
            }
        }
    }
}

