/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.map.plot.properties;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.ArrayList;
import java.util.Iterator;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTabbedPane;
import se.prediktera.map.common.cleanup.CleanUpPanel;
import se.prediktera.map.common.swing.EvinceBorderFactory;
import se.prediktera.map.datasetcontainer.matrix.AbstractDataMatrix;
import se.prediktera.map.plot.axisplot.AbstractAxisLayer;
import se.prediktera.map.plot.axisplot.AbstractAxisPlot;
import se.prediktera.map.plot.axisplot.settings.AbstractPlotSettingsBox;
import se.prediktera.map.plot.axisplot.windows.LegendInterface;
import se.prediktera.map.plot.axisplot.windows.LegendWindow;
import se.prediktera.map.plot.layout.PlotWindowInterface;

public class LegendProperties
extends JPanel {
    JButton addLegend = new JButton("Add");
    JButton removeLegend = new JButton("Remove");
    JTabbedPane tabbedPane = new JTabbedPane();

    public LegendProperties(AbstractAxisPlot abstractAxisPlot) {
        this.setLayout(new GridBagLayout());
        ArrayList<LegendWindow> arrayList = abstractAxisPlot.getLegends();
        Iterator<LegendWindow> iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            LegendPanel legendPanel = new LegendPanel(abstractAxisPlot, iterator.next());
            this.tabbedPane.addTab("Legend " + (this.tabbedPane.getTabCount() + 1), legendPanel);
        }
        this.addLegend.setPreferredSize(this.removeLegend.getPreferredSize());
        this.addLegend.setMinimumSize(this.removeLegend.getPreferredSize());
        this.addLegend.addActionListener(actionEvent -> {
            LegendWindow legendWindow = new LegendWindow(abstractAxisPlot.getParentBaseWindow());
            legendWindow.setWindowLayout(3);
            LegendPanel legendPanel = new LegendPanel(abstractAxisPlot, legendWindow);
            this.tabbedPane.addTab("Legend " + (this.tabbedPane.getTabCount() + 1), legendPanel);
            this.removeLegend.setEnabled(true);
            this.tabbedPane.setSelectedComponent(legendPanel);
        });
        this.removeLegend.setEnabled(arrayList.size() > 0);
        this.removeLegend.addActionListener(actionEvent -> {
            this.tabbedPane.removeTabAt(this.tabbedPane.getSelectedIndex());
            this.removeLegend.setEnabled(this.tabbedPane.getTabCount() > 0);
        });
        this.add((Component)this.addLegend, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 18, 0, new Insets(6, 6, 0, 0), 0, 0));
        this.add((Component)this.removeLegend, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 18, 0, new Insets(6, 6, 6, 0), 0, 0));
        this.tabbedPane.setPreferredSize(new Dimension(300, 300));
        this.add((Component)this.tabbedPane, new GridBagConstraints(1, 0, 1, 2, 1.0, 1.0, 10, 1, new Insets(6, 6, 6, 6), 0, 0));
    }

    public void applyChanges(AbstractAxisPlot abstractAxisPlot) {
        JPanel jPanel;
        for (int i = 0; i < this.tabbedPane.getTabCount(); ++i) {
            jPanel = (LegendPanel)this.tabbedPane.getComponentAt(i);
            LegendWindow legendWindow = ((LegendPanel)jPanel).getLegend();
            abstractAxisPlot.updateLegend(legendWindow, ((LegendPanel)jPanel).getWindowLayout());
            legendWindow.setSort(((LegendPanel)jPanel).isSort());
            legendWindow.setLegendInterface(((LegendPanel)jPanel).getDataFrom());
            legendWindow.contentPaint((byte)1);
        }
        Iterator<LegendWindow> iterator = abstractAxisPlot.getLegends().iterator();
        while (iterator.hasNext()) {
            jPanel = iterator.next();
            if (this.hasLegend((LegendWindow)jPanel)) continue;
            abstractAxisPlot.getParentBaseWindow().removeWindow((PlotWindowInterface)((Object)jPanel));
            ((CleanUpPanel)jPanel).cleanUp();
            iterator.remove();
        }
    }

    private boolean hasLegend(LegendWindow legendWindow) {
        for (int i = 0; i < this.tabbedPane.getTabCount(); ++i) {
            LegendPanel legendPanel = (LegendPanel)this.tabbedPane.getComponentAt(i);
            if (!legendPanel.getLegend().equals(legendWindow)) continue;
            return true;
        }
        return false;
    }

    private class LegendPanel
    extends JPanel {
        private final JCheckBox checkSort = new JCheckBox("Sort legend elements by name");
        private final JRadioButton radioTop = new JRadioButton("Top");
        private final JRadioButton radioLeft = new JRadioButton("Left");
        private final JRadioButton radioBottom = new JRadioButton("Bottom");
        private final JRadioButton radioRight = new JRadioButton("Right");
        private final JRadioButton radioFree = new JRadioButton("Free");
        private final JComboBox comboCollectDataFrom = new JComboBox();
        private final JComboBox layerBox = new JComboBox();
        private LegendWindow legend = null;

        public LegendPanel(AbstractAxisPlot abstractAxisPlot, LegendWindow legendWindow) {
            this.legend = legendWindow;
            this.setLayout(new BorderLayout());
            this.comboCollectDataFrom.setBorder(BorderFactory.createLoweredBevelBorder());
            this.comboCollectDataFrom.setVisible(false);
            abstractAxisPlot.collectLegendLayers(this.layerBox);
            if (this.layerBox.getItemCount() < 2) {
                this.layerBox.setEnabled(false);
            }
            if (this.layerBox.getItemCount() > 0) {
                this.layerBox.setSelectedIndex(0);
                this.initDataFrom((AbstractAxisLayer)this.layerBox.getSelectedItem());
            }
            this.layerBox.addItemListener(itemEvent -> this.initDataFrom((AbstractAxisLayer)itemEvent.getItem()));
            this.setLegendWindow();
            JPanel jPanel = new JPanel(new GridBagLayout());
            JPanel jPanel2 = new JPanel(new GridBagLayout());
            jPanel.setBorder(EvinceBorderFactory.createEvinceBorder("Position"));
            jPanel2.setBorder(EvinceBorderFactory.createEvinceBorder("General"));
            this.add((Component)jPanel2, "North");
            this.add((Component)jPanel, "Center");
            jPanel2.add((Component)this.checkSort, new GridBagConstraints(0, 0, 3, 1, 0.0, 0.0, 18, 0, new Insets(6, 6, 0, 6), 0, 0));
            jPanel2.add((Component)new JLabel("Layer:"), new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 0, new Insets(12, 12, 12, 0), 0, 0));
            jPanel2.add((Component)this.layerBox, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 10, 2, new Insets(12, 6, 12, 12), 0, 0));
            jPanel2.add((Component)this.comboCollectDataFrom, new GridBagConstraints(2, 1, 1, 1, 1.0, 0.0, 10, 2, new Insets(12, 12, 12, 12), 0, 0));
            jPanel.add((Component)this.radioTop, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(12, 0, 12, 0), 0, 0));
            jPanel.add((Component)this.radioLeft, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 12, 0, 12), 0, 0));
            jPanel.add((Component)this.radioBottom, new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(12, 0, 12, 0), 0, 0));
            jPanel.add((Component)this.radioRight, new GridBagConstraints(2, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 12, 0, 12), 0, 0));
            jPanel.add((Component)this.radioFree, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
            ButtonGroup buttonGroup = new ButtonGroup();
            buttonGroup.add(this.radioTop);
            buttonGroup.add(this.radioLeft);
            buttonGroup.add(this.radioRight);
            buttonGroup.add(this.radioBottom);
            buttonGroup.add(this.radioFree);
            this.selectFirstNonEmptyLayer();
        }

        public LegendInterface getDataFrom() {
            return (LegendInterface)this.comboCollectDataFrom.getSelectedItem();
        }

        public LegendWindow getLegend() {
            return this.legend;
        }

        public boolean isSort() {
            return this.checkSort.isSelected();
        }

        private byte getWindowLayout() {
            if (this.radioTop.isSelected()) {
                return 0;
            }
            if (this.radioBottom.isSelected()) {
                return 1;
            }
            if (this.radioLeft.isSelected()) {
                return 2;
            }
            if (this.radioRight.isSelected()) {
                return 3;
            }
            return 5;
        }

        private void initDataFrom(AbstractAxisLayer abstractAxisLayer) {
            this.comboCollectDataFrom.removeAllItems();
            abstractAxisLayer.collectLegendBoxes(this.comboCollectDataFrom);
            this.comboCollectDataFrom.setEnabled(this.comboCollectDataFrom.getItemCount() > 1);
            if (this.legend.getLegendInterface() == null) {
                this.legend.setLegendInterface(this.getDataFrom());
            }
        }

        private void selectFirstNonEmptyLayer() {
            if (this.layerBox.getItemCount() <= 1) {
                return;
            }
            this.layerBox.setSelectedIndex(0);
            for (int i = 1; i < this.layerBox.getItemCount(); ++i) {
                AbstractAxisLayer abstractAxisLayer;
                if (this.layerBox.getSelectedItem() == null || (abstractAxisLayer = (AbstractAxisLayer)this.layerBox.getSelectedItem()).getPlotInit() == null || abstractAxisLayer.getPlotInit().getMatrix(0) == null) continue;
                AbstractDataMatrix abstractDataMatrix = abstractAxisLayer.getPlotInit().getMatrix(0);
                if (abstractDataMatrix.getDataSize() > 1) break;
                this.layerBox.setSelectedIndex(i);
            }
        }

        private final void setLegendWindow() {
            if (this.legend == null) {
                if (this.layerBox.getItemCount() > 0) {
                    this.layerBox.setSelectedIndex(0);
                }
                this.radioRight.setSelected(true);
            } else {
                this.checkSort.setSelected(this.legend.isSort());
                switch (this.legend.getWindowLayout()) {
                    case 0: {
                        this.radioTop.setSelected(true);
                        break;
                    }
                    case 1: {
                        this.radioBottom.setSelected(true);
                        break;
                    }
                    case 2: {
                        this.radioLeft.setSelected(true);
                        break;
                    }
                    case 3: {
                        this.radioRight.setSelected(true);
                        break;
                    }
                    default: {
                        this.radioFree.setSelected(true);
                    }
                }
                LegendInterface legendInterface = this.legend.getLegendInterface();
                if (legendInterface instanceof AbstractPlotSettingsBox) {
                    AbstractPlotSettingsBox abstractPlotSettingsBox = (AbstractPlotSettingsBox)((Object)legendInterface);
                    AbstractAxisLayer abstractAxisLayer = abstractPlotSettingsBox.getLayer();
                    if (abstractAxisLayer == null && this.layerBox.getItemCount() > 0) {
                        this.layerBox.setSelectedIndex(0);
                    } else {
                        this.layerBox.setSelectedItem(abstractAxisLayer);
                    }
                }
                this.comboCollectDataFrom.setSelectedItem(legendInterface);
            }
        }
    }
}

