/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.map.plot.spectral;

import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.event.ActionEvent;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.awt.image.WritableRaster;
import javax.swing.AbstractAction;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import se.prediktera.map.common.NiceDataFormat;
import se.prediktera.map.common.error.ErrorHandler;
import se.prediktera.map.plot.axisplot.ImageSelection;
import se.prediktera.map.plot.axisplot.rubberband.AbstractRubberband;
import se.prediktera.map.plot.axisplot.rubberband.RubberbandHorizontal;
import se.prediktera.map.plot.axisplot.rubberband.RubberbandVertical;
import se.prediktera.map.plot.spectral.AxisHelper;

public abstract class AbstractPlotPanel
extends JPanel
implements MouseListener,
MouseMotionListener,
MouseWheelListener {
    protected static final BasicStroke singleline = new BasicStroke(1.0f, 0, 0, 10.0f);
    protected int sx;
    protected int sy;
    protected int ex;
    protected int ey;
    protected int width;
    protected int height;
    protected boolean ispreview;
    protected boolean aspectratio = false;
    protected final double[] abs = new double[2];
    protected final double[] minmax = new double[]{-1.0, -1.0, -1.0, -1.0};
    protected final double[] axisMinMax = new double[]{-1.0, -1.0, -1.0, -1.0};
    protected int rh;
    private boolean axisMinMaxSet;
    private double procent;
    private AbstractRubberband.RubberAction rubberAction = AbstractRubberband.RubberAction.Zoom;
    private AbstractRubberband rubberband;
    private Point panBegin;
    private boolean hasSelection = false;
    private Cursor cursor;
    private String xdesc = null;
    private String ydesc = null;
    private double conversionValueX = 1.0;
    private double conversionValueY = 1.0;
    private long axisDate = 0L;
    private String[] values = null;
    private final BufferedImage[] contentImages = new BufferedImage[2];
    private final Clipboard clipboard;
    private Color gridColor;
    private Color zeroColor;
    private boolean zeroLine = true;

    protected static void createFrame(AbstractPlotPanel abstractPlotPanel) {
        abstractPlotPanel.setPreferredSize(new Dimension(500, 500));
        JFrame jFrame = new JFrame();
        jFrame.getContentPane().add((Component)abstractPlotPanel, "Center");
        jFrame.pack();
        jFrame.setLocationRelativeTo(null);
        jFrame.setVisible(true);
    }

    public AbstractPlotPanel() {
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        this.addMouseWheelListener(this);
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        this.clipboard = toolkit.getSystemClipboard();
        this.sx = 40;
        this.ex = 10;
        this.sy = 10;
        this.ey = 40;
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent componentEvent) {
                AbstractPlotPanel.this.contentPaint();
            }
        });
    }

    public void contentPaint() {
        this.contentPaint(ContentType.Base);
        this.contentPaint(ContentType.Selection);
        this.repaint();
    }

    public void contentPaint(ContentType contentType) {
        int n = this.getWidth();
        int n2 = this.getHeight();
        if (n > 0 && n2 > 0) {
            int n3 = contentType.ordinal();
            BufferedImage bufferedImage = this.contentImages[n3];
            if (bufferedImage == null || bufferedImage.getWidth() != n || bufferedImage.getHeight() != n2) {
                this.contentImages[n3] = bufferedImage = new BufferedImage(n, n2, 2);
            }
            Graphics2D graphics2D = (Graphics2D)bufferedImage.getGraphics();
            if (contentType.equals((Object)ContentType.Base)) {
                graphics2D.setColor(this.getBackground());
                graphics2D.fillRect(0, 0, n, n2);
            } else {
                graphics2D.setComposite(AlphaComposite.Clear);
                graphics2D.fillRect(0, 0, bufferedImage.getWidth(), bufferedImage.getHeight());
                graphics2D.setComposite(AlphaComposite.SrcOver);
                if (contentType.equals((Object)ContentType.Selection) && !this.hasSelection) {
                    graphics2D.dispose();
                    return;
                }
            }
            if (this.aspectratio) {
                if (n < n2) {
                    n2 = n;
                } else {
                    n = n2;
                }
            }
            this.rh = n2;
            this.width = n - this.sx - this.ex;
            this.height = n2 - this.sy - this.ey;
            if (this.width > 0 && this.height > 0) {
                graphics2D.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
                graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                try {
                    WritableRaster writableRaster = bufferedImage.getRaster();
                    if (contentType.equals((Object)ContentType.Base)) {
                        this.paintAxis(writableRaster, graphics2D, n, n2);
                        graphics2D.setColor(this.getForeground());
                        graphics2D.drawRect(this.sx, this.sy, this.width - 1, this.height - 1);
                    }
                    graphics2D.setClip(this.sx, this.sy, this.width, this.height);
                    this.paint(writableRaster, graphics2D, n, n2, contentType);
                }
                catch (Exception exception) {
                    ErrorHandler.logAndReportException("Paint error: ", exception);
                }
            }
            graphics2D.dispose();
        }
    }

    public void copyToClipboard() {
        ImageSelection imageSelection = new ImageSelection(this.createImage());
        this.clipboard.setContents(imageSelection, null);
    }

    public BufferedImage createImage() {
        Rectangle rectangle = this.getBounds();
        int n = rectangle.width;
        int n2 = rectangle.height;
        BufferedImage bufferedImage = new BufferedImage(n, n2, 2);
        Graphics2D graphics2D = (Graphics2D)bufferedImage.getGraphics();
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics2D.setColor(this.getBackground());
        graphics2D.fillRect(0, 0, n, n2);
        this.paintAxis(bufferedImage.getRaster(), graphics2D, n, n2);
        this.paint(bufferedImage.getRaster(), graphics2D, n, n2, ContentType.Base);
        graphics2D.setColor(this.getForeground());
        graphics2D.drawRect(this.sx, this.sy, this.width - 1, this.height - 1);
        graphics2D.dispose();
        return bufferedImage;
    }

    public BufferedImage getImage() {
        return this.contentImages[0];
    }

    public boolean isPreview() {
        return this.ispreview;
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseDragged(MouseEvent mouseEvent) {
        Point point = mouseEvent.getPoint();
        if (this.rubberAction == AbstractRubberband.RubberAction.Pan && this.panBegin != null) {
            double[] dArray = new double[2];
            this.diff(dArray, this.panBegin, point);
            this.minmax[0] = this.minmax[0] + dArray[0];
            this.minmax[1] = this.minmax[1] + dArray[0];
            this.minmax[2] = this.minmax[2] + dArray[1];
            this.minmax[3] = this.minmax[3] + dArray[1];
            this.contentPaint();
        }
        this.panBegin = point;
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
        if (this.cursor == null) {
            this.cursor = this.getCursor();
            this.setCursor(Cursor.getDefaultCursor());
        }
    }

    @Override
    public void mouseMoved(MouseEvent mouseEvent) {
        if (this.isInside(mouseEvent.getPoint())) {
            if (this.cursor != null) {
                this.setCursor(this.cursor);
                this.cursor = null;
            }
        } else if (this.cursor == null) {
            this.cursor = this.getCursor();
            this.setCursor(Cursor.getDefaultCursor());
        }
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        if (SwingUtilities.isLeftMouseButton(mouseEvent)) {
            this.panBegin = mouseEvent.getPoint();
        } else {
            this.createPopupMenu(mouseEvent);
        }
    }

    @Override
    public void mouseWheelMoved(MouseWheelEvent mouseWheelEvent) {
        if (!this.isInside(mouseWheelEvent.getPoint())) {
            return;
        }
        int n = mouseWheelEvent.getWheelRotation();
        if (n == 0) {
            return;
        }
        double[] dArray = new double[2];
        this.Screen2Real(dArray, mouseWheelEvent.getX(), mouseWheelEvent.getY());
        double d = Math.pow(1.1, n);
        for (int i = 0; i < 2; ++i) {
            double d2 = this.minmax[i * 2];
            double d3 = this.minmax[i * 2 + 1];
            double d4 = dArray[i];
            double d5 = d4 - d2;
            double d6 = d3 - d4;
            double d7 = d4 - d5 * d;
            double d8 = d4 + d6 * d;
            if (this.axisMinMaxSet && d > 1.0) {
                double d9 = this.axisMinMax[i * 2];
                double d10 = this.axisMinMax[i * 2 + 1];
                if (d2 <= d9 && d3 >= d10) {
                    d7 = d9;
                    d8 = d10;
                } else {
                    if (d7 < d9) {
                        d7 = d9;
                    }
                    if (d8 > d10) {
                        d8 = d10;
                    }
                }
            }
            if (!(d8 - d7 > 0.0)) continue;
            this.minmax[i * 2] = d7;
            this.minmax[i * 2 + 1] = d8;
        }
        this.abs[0] = this.minmax[1] - this.minmax[0];
        this.abs[1] = this.minmax[3] - this.minmax[2];
        this.contentPaint();
    }

    protected void createPopupMenu(MouseEvent mouseEvent) {
        JPopupMenu jPopupMenu = new JPopupMenu();
        this.addToPopup(jPopupMenu);
        jPopupMenu.show(this, mouseEvent.getX(), mouseEvent.getY());
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
        if (SwingUtilities.isLeftMouseButton(mouseEvent) && this.rubberband != null && !mouseEvent.isConsumed()) {
            this.rubberbandEnded(this.rubberband);
            this.rubberband.clear();
            mouseEvent.consume();
        }
        this.panBegin = null;
    }

    @Override
    public void paint(Graphics graphics) {
        super.paint(graphics);
        if (this.contentImages[0] != null) {
            graphics.drawImage(this.contentImages[0], 0, 0, null);
        }
        if (this.hasSelection && this.contentImages[1] != null) {
            graphics.drawImage(this.contentImages[1], 0, 0, null);
        }
    }

    public void paint(Graphics2D graphics2D, int n, int n2) {
        this.setSize(n, n2);
        this.width = n - this.sx - this.ex;
        this.height = n2 - this.sy - this.ey;
        this.rh = n2;
        if (this.width > 0 && this.height > 0) {
            this.paint(null, graphics2D, n, n2, ContentType.Base);
        }
    }

    public void Real2Screen(double[] dArray, double d, double d2) {
        this.Real2ScreenX(dArray, d);
        this.Real2ScreenY(dArray, d2);
    }

    public void Real2ScreenLength(double[] dArray, double d, double d2) {
        dArray[0] = d * ((double)this.width / this.abs[0]);
        dArray[1] = d2 * ((double)this.height / this.abs[1]);
    }

    public void Real2ScreenX(double[] dArray, double d) {
        dArray[0] = (d - this.minmax[0]) * ((double)this.width / this.abs[0]) + (double)this.sx;
    }

    public void Real2ScreenY(double[] dArray, double d) {
        dArray[1] = (double)this.rh - (d - this.minmax[2]) * ((double)this.height / this.abs[1]) - (double)this.ey;
    }

    public void rubberbandEnded(AbstractRubberband abstractRubberband) {
        Rectangle rectangle = abstractRubberband.getBoundingBox();
        double[] dArray = new double[2];
        this.Screen2Real(dArray, rectangle.x, rectangle.y + rectangle.height);
        double[] dArray2 = new double[2];
        this.Screen2Real(dArray2, rectangle.x + rectangle.width, rectangle.y);
        if (this.rubberAction.equals((Object)AbstractRubberband.RubberAction.Zoom)) {
            if (rectangle.width == 0 || rectangle.height == 0) {
                return;
            }
            this.minmax[0] = dArray[0];
            this.minmax[1] = dArray2[0];
            this.minmax[2] = dArray[1];
            this.minmax[3] = dArray2[1];
            this.abs[0] = this.minmax[1] - this.minmax[0];
            this.abs[1] = this.minmax[3] - this.minmax[2];
            this.contentPaint();
        } else {
            this.hasSelection = this.selectArea(dArray, dArray2, abstractRubberband.getShape());
            this.contentPaint(ContentType.Selection);
            this.repaint();
        }
    }

    protected boolean selectArea(double[] dArray, double[] dArray2, Shape shape) {
        return false;
    }

    public void Screen2Real(double[] dArray, double d, double d2) {
        d2 = (double)this.rh - d2 - (double)this.ey;
        dArray[0] = (d -= (double)this.sx) / ((double)this.width / this.abs[0]) + this.minmax[0];
        dArray[1] = d2 / ((double)this.height / this.abs[1]) + this.minmax[2];
    }

    public void setAxisDate(long l) {
        this.axisDate = l;
    }

    public void setConversionValueX(double d) {
        this.conversionValueX = d;
    }

    public void setConversionValueY(double d) {
        this.conversionValueY = d;
    }

    public void setPreview() {
        this.ispreview = true;
        this.ey = 0;
        this.sy = 0;
        this.ex = 0;
        this.sx = 0;
    }

    public void setRubberband(AbstractRubberband abstractRubberband) {
        if (this.rubberband != null) {
            this.rubberband.setActive(false);
        }
        if (abstractRubberband != null) {
            abstractRubberband.setActive(true);
        }
        this.rubberband = abstractRubberband;
    }

    public boolean hasValues() {
        return this.values != null;
    }

    public void setValues(String[] stringArray) {
        this.values = stringArray;
    }

    public String getValue(int n) {
        if (this.values != null && n >= 0 && n < this.values.length) {
            return this.values[n];
        }
        return NiceDataFormat.toString(n);
    }

    public int getNumberOfValues() {
        if (this.values != null) {
            return this.values.length;
        }
        return 0;
    }

    public void setXdesc(String string) {
        this.xdesc = string;
    }

    public void setYdesc(String string) {
        this.ydesc = string;
    }

    public void setRubberAction(AbstractRubberband.RubberAction rubberAction, AbstractRubberband.RubberType rubberType, Cursor cursor) {
        this.rubberAction = rubberAction;
        this.cursor = cursor;
        switch (rubberAction) {
            case Zoom: 
            case Selection: {
                this.setRubberband(this.createRubberband(rubberType));
                break;
            }
            case Pan: {
                this.setRubberband(null);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unexpected value: " + String.valueOf((Object)rubberAction));
            }
        }
    }

    private AbstractRubberband createRubberband(AbstractRubberband.RubberType rubberType) {
        return switch (rubberType) {
            case AbstractRubberband.RubberType.Vertical -> new RubberbandVertical((Component)this, new RubberbandHorizontal.RubberbandMinMax(){

                @Override
                public int getMin(Point point) {
                    return AbstractPlotPanel.this.sy;
                }

                @Override
                public int getMax(Point point) {
                    return AbstractPlotPanel.this.sy + AbstractPlotPanel.this.height;
                }
            }, AbstractRubberband.RubberAction.Zoom);
            default -> AbstractRubberband.createRubberband(rubberType, this.rubberAction, 1, this);
        };
    }

    public void zoomAll() {
        this.setMinMax(-200.0, 200.0, -200.0, 200.0, this.procent);
        this.contentPaint();
    }

    protected void addToPopup(JPopupMenu jPopupMenu) {
        jPopupMenu.add(new AbstractAction("Copy to clipboard"){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                AbstractPlotPanel.this.copyToClipboard();
            }
        });
        jPopupMenu.add(new AbstractAction("Reset zoom"){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                AbstractPlotPanel.this.zoomAll();
            }
        });
    }

    protected AxisHelper createAxisHelperX(AbstractPlotPanel abstractPlotPanel, double d, double d2, double d3, double d4, long l, String[] stringArray) {
        return new AxisHelper(abstractPlotPanel, d, d2, d3, d4, l, stringArray);
    }

    protected AxisHelper createAxisHelperY(AbstractPlotPanel abstractPlotPanel, double d, double d2, double d3, double d4, long l, String[] stringArray) {
        return new AxisHelper(abstractPlotPanel, d, d2, d3, d4, l, stringArray);
    }

    protected int getPlotHeight() {
        return this.height;
    }

    protected int getPlotWidth() {
        return this.width;
    }

    protected String getTitle() {
        return null;
    }

    protected String getXaxisDesc() {
        return this.xdesc;
    }

    protected String getYaxisDesc() {
        return this.ydesc;
    }

    protected abstract void paint(WritableRaster var1, Graphics2D var2, int var3, int var4, ContentType var5);

    private void paintAxis(WritableRaster writableRaster, Graphics2D graphics2D, int n, int n2) {
        graphics2D.setColor(this.getBackground());
        graphics2D.setStroke(singleline);
        graphics2D.fillRect(this.sx, this.sy, this.width, this.height);
        FontMetrics fontMetrics = graphics2D.getFontMetrics();
        String string = this.getTitle();
        if (this.sy > 0 && string != null) {
            graphics2D.setColor(this.getForeground());
            graphics2D.drawString(string, n / 2 - fontMetrics.stringWidth(string) / 2, this.sy / 2 - fontMetrics.getHeight() / 2);
        }
        String string2 = this.getXaxisDesc();
        if (this.ey > 0 && string2 != null) {
            graphics2D.setColor(this.getForeground());
            graphics2D.drawString(string2, this.width / 2 - fontMetrics.stringWidth(string2) / 2 + this.sx, n2 - this.ey / 2 + fontMetrics.getHeight() / 2 + 5);
        }
        String string3 = this.getYaxisDesc();
        if (this.sx > 0 && string3 != null) {
            AffineTransform affineTransform = graphics2D.getTransform();
            graphics2D.setColor(this.getForeground());
            graphics2D.translate(fontMetrics.getHeight() / 2 + 5, this.sy + this.height / 2 + fontMetrics.stringWidth(string3) / 2);
            graphics2D.rotate(-1.5707963267948966);
            graphics2D.drawString(string3, 0, 0);
            graphics2D.setTransform(affineTransform);
        }
        if (!this.ispreview) {
            boolean bl = this.isZeroLine();
            AxisHelper axisHelper = this.createAxisHelperX(this, this.minmax[0], this.minmax[1], this.abs[0], this.conversionValueX, this.axisDate, this.values);
            axisHelper.drawXaxis(graphics2D, this.height, this.sy, this.width, bl);
            AxisHelper axisHelper2 = this.createAxisHelperY(this, this.minmax[2], this.minmax[3], this.abs[1], this.conversionValueY, 0L, null);
            axisHelper2.drawYaxis(graphics2D, this.height, this.sx, this.width, bl);
        }
    }

    protected void setMinMax() {
    }

    protected void setMinMax(double d, double d2, double d3, double d4, double d5) {
        this.procent = d5;
        this.minmax[0] = d;
        this.minmax[1] = d2;
        this.minmax[2] = d3;
        this.minmax[3] = d4;
        this.abs[0] = this.minmax[1] - this.minmax[0];
        this.abs[1] = this.minmax[3] - this.minmax[2];
        if (d5 != 1.0) {
            for (int i = 0; i < 2; ++i) {
                double d6 = this.abs[i] == 0.0 ? d5 : this.abs[i] * d5;
                int n = i * 2;
                this.minmax[n] = this.minmax[n] - d6;
                int n2 = i * 2 + 1;
                this.minmax[n2] = this.minmax[n2] + d6;
                this.abs[i] = this.minmax[i * 2 + 1] - this.minmax[i * 2];
            }
        }
        System.arraycopy(this.minmax, 0, this.axisMinMax, 0, 4);
        this.axisMinMaxSet = true;
    }

    private void diff(double[] dArray, Point point, Point point2) {
        double[] dArray2 = new double[2];
        this.Screen2Real(dArray2, point.x, point.y);
        double[] dArray3 = new double[2];
        this.Screen2Real(dArray3, point2.x, point2.y);
        dArray[0] = dArray2[0] - dArray3[0];
        dArray[1] = dArray2[1] - dArray3[1];
    }

    private boolean isInside(Point point) {
        return point.x > this.sx && point.x < this.sx + this.width && point.y > this.sy && point.y < this.sy + this.height;
    }

    public void setGridColor(Color color) {
        this.gridColor = color;
    }

    public void setZeroColor(Color color) {
        this.zeroColor = color;
    }

    public void setZeroLine(boolean bl) {
        this.zeroLine = bl;
    }

    private boolean isZeroLine() {
        return this.zeroLine;
    }

    public Color getGridColor() {
        if (this.gridColor != null) {
            return this.gridColor;
        }
        return this.getForeground();
    }

    public Color getZeroColor() {
        if (this.zeroColor != null) {
            return this.zeroColor;
        }
        return this.getGridColor();
    }

    public static enum ContentType {
        Base,
        Selection;

    }
}

