/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.map.plot.spectral;

import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.text.SimpleDateFormat;
import java.util.Date;
import se.prediktera.map.common.NiceDataFormat;
import se.prediktera.map.plot.spectral.AbstractPlotPanel;

public class AxisHelper {
    private static final double pow10_8 = Math.pow(10.0, 8.0);
    private static final double pow10_min8 = Math.pow(10.0, -8.0);
    private final AbstractPlotPanel plotPanel;
    private final double min;
    private final double max;
    private final double abs;
    private final double conversionValue;
    private final long axisDate;
    protected String[] values;
    SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd");

    public AxisHelper(AbstractPlotPanel abstractPlotPanel, double d, double d2, double d3, double d4, long l, String[] stringArray) {
        this.plotPanel = abstractPlotPanel;
        this.min = d * d4;
        this.max = d2 * d4;
        this.abs = d3 * d4;
        this.conversionValue = d4;
        this.axisDate = l;
        this.values = stringArray;
    }

    public void drawXaxis(Graphics2D graphics2D, int n, int n2, int n3, boolean bl) {
        if (this.abs > 0.0) {
            double d = this.findSuitableGap(this.abs, n3);
            double d2 = (double)Math.round(this.min / d) * d;
            double[] dArray = new double[2];
            FontMetrics fontMetrics = graphics2D.getFontMetrics();
            String string = null;
            for (double d3 = d2; d3 <= this.max; d3 += d) {
                double d4 = (double)Math.round(d3 * pow10_8) * pow10_min8;
                if (!(d4 >= this.min) || !(d4 <= this.max)) continue;
                graphics2D.setColor(this.plotPanel.getGridColor());
                this.plotPanel.Real2Screen(dArray, d4 / this.conversionValue, 0.0);
                graphics2D.drawLine((int)dArray[0], n2, (int)dArray[0], n2 + n);
                String string2 = this.formatText(d4);
                if (string != null && string.equals(string2)) continue;
                graphics2D.setColor(this.plotPanel.getForeground());
                graphics2D.drawString(string2, (int)dArray[0] - fontMetrics.stringWidth(string2) / 2, n2 + n + fontMetrics.getHeight());
                string = string2;
            }
            if (bl && this.min <= 0.0 && this.max >= 0.0) {
                this.plotPanel.Real2Screen(dArray, 0.0, 0.0);
                graphics2D.setColor(this.plotPanel.getZeroColor());
                graphics2D.drawLine((int)dArray[0], n2, (int)dArray[0], n2 + n);
            }
        }
    }

    public void drawYaxis(Graphics2D graphics2D, int n, int n2, int n3, boolean bl) {
        if (this.abs > 0.0) {
            double d = this.findSuitableGap(this.abs, n);
            double d2 = (double)Math.round(this.min / d) * d;
            double[] dArray = new double[2];
            FontMetrics fontMetrics = graphics2D.getFontMetrics();
            for (double d3 = d2; d3 <= this.max; d3 += d) {
                double d4 = (double)Math.round(d3 * pow10_8) * pow10_min8;
                if (!(d4 >= this.min) || !(d4 <= this.max)) continue;
                graphics2D.setColor(this.plotPanel.getGridColor());
                this.plotPanel.Real2Screen(dArray, 0.0, d4 / this.conversionValue);
                graphics2D.drawLine(n2, (int)dArray[1], n2 + n3, (int)dArray[1]);
                String string = NiceDataFormat.toString(d4);
                graphics2D.setColor(this.plotPanel.getForeground());
                graphics2D.drawString(string, n2 - fontMetrics.stringWidth(string) - 5, (int)dArray[1] + fontMetrics.getHeight() / 3);
            }
            if (bl && this.min <= 0.0 && this.max >= 0.0) {
                this.plotPanel.Real2Screen(dArray, 0.0, 0.0);
                graphics2D.setColor(this.plotPanel.getZeroColor());
                graphics2D.drawLine(n2, (int)dArray[1], n2 + n3, (int)dArray[1]);
            }
        }
    }

    protected String formatText(double d) {
        if (this.values != null) {
            int n = (int)d;
            if (n >= 0 && n < this.values.length) {
                return NiceDataFormat.tryGetNiceString(this.values[n]);
            }
            if (n >= this.values.length) {
                return NiceDataFormat.tryGetNiceString(this.values[this.values.length - 1]);
            }
        } else if (this.axisDate > 0L) {
            return this.simpleDateFormat.format(new Date((long)(d * (double)this.axisDate)));
        }
        return NiceDataFormat.toString(d);
    }

    private double findSuitableGap(double d, double d2) {
        if (d2 <= 0.0 || d < 1.0E-7) {
            return 1.0E-7;
        }
        double d3 = d / (d2 / 80.0);
        double d4 = this.firstValuePosAbs(d3);
        double d5 = Math.round(d3 * Math.pow(10.0, -d4 + 1.0));
        d5 = d5 >= 0.0 && d5 < 15.0 ? 10.0 : (d5 >= 15.0 && d5 < 35.0 ? 25.0 : (d5 >= 35.0 && d5 < 65.0 ? 50.0 : (d5 >= 65.0 && d5 < 85.0 ? 75.0 : 100.0)));
        if (Double.compare(d5 *= Math.pow(10.0, d4 - 1.0), 0.0) == 0) {
            d5 = d;
        }
        return d5;
    }

    private int firstValuePosAbs(double d) {
        int n = 0;
        if (Double.compare(d, 0.0) == 0 || Double.isInfinite(d)) {
            return 0;
        }
        if ((d = Math.abs(d)) < 1.0) {
            while (d < 1.0) {
                d *= 10.0;
                --n;
            }
        } else {
            while (d >= 10.0) {
                d *= 0.1;
                ++n;
            }
        }
        return n;
    }
}

