/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.map.plot.spectral;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Stroke;
import java.util.Arrays;
import no.uib.cipr.matrix.DenseVector;

public class DataWrapper
implements Cloneable {
    private String name;
    private Color color = Color.black;
    private Stroke stroke = new BasicStroke(1.0f, 1, 0, 10.0f);
    private final float[] minmaxX = new float[2];
    private final float[] minmaxY = new float[2];
    private boolean ismain = false;
    private boolean showLine = true;
    private boolean showDots = false;
    private int dotSize = 9;
    private boolean showDotBorder;
    private float[] dataX;
    private float[] dataY;
    private boolean[] selected;
    private int[] dotSizes;
    private int[] dotColors;

    public DataWrapper(String string) {
        this.name = string;
    }

    public DataWrapper(float[] fArray, float[] fArray2, String string) {
        this.dataX = fArray;
        this.dataY = fArray2;
        this.name = string;
    }

    public DataWrapper(float[] fArray, String string) {
        this.dataY = fArray;
        this.name = string;
    }

    public DataWrapper(int n, String string) {
        this.name = string;
        this.setSize(n);
    }

    public void setSize(int n) {
        this.dataY = new float[n];
        Arrays.fill(this.dataY, Float.NaN);
    }

    public boolean calcMinMax(DataWrapper dataWrapper, byte by) {
        Arrays.fill(this.minmaxX, -1.0f);
        Arrays.fill(this.minmaxY, -1.0f);
        boolean bl = true;
        for (int i = 0; i < this.getSize(); ++i) {
            if (this.isMissing(i)) continue;
            float f = this.dataX != null ? this.dataX[i] : (float)i;
            float f2 = this.dataY[i];
            if (!this.ismain && dataWrapper != null) continue;
            if (bl) {
                this.minmaxX[0] = this.minmaxX[1] = f;
                this.minmaxY[0] = this.minmaxY[1] = f2;
                bl = false;
                continue;
            }
            if (this.minmaxX[0] > f) {
                this.minmaxX[0] = f;
            }
            if (this.minmaxX[1] < f) {
                this.minmaxX[1] = f;
            }
            if (this.minmaxY[0] > f2) {
                this.minmaxY[0] = f2;
            }
            if (!(this.minmaxY[1] < f2)) continue;
            this.minmaxY[1] = f2;
        }
        return false;
    }

    public Color getColor() {
        return this.color;
    }

    public void setDotColors(int[] nArray) {
        this.dotColors = nArray;
    }

    public int getDotColor(int n) {
        if (this.dotColors != null) {
            return this.dotColors[n];
        }
        return this.color.getRGB();
    }

    public void setShowDotBorder(boolean bl) {
        this.showDotBorder = bl;
    }

    public boolean showDotBorder() {
        return this.showDotBorder;
    }

    public void setDataX(float[] fArray) {
        this.dataX = fArray;
    }

    public float[] getDataX() {
        return this.dataX;
    }

    public void setDataY(float[] fArray) {
        this.dataY = fArray;
    }

    public float[] getDataY() {
        return this.dataY;
    }

    public boolean[] getSelected() {
        return this.selected;
    }

    public void setSelected(boolean[] blArray) {
        this.selected = blArray;
    }

    public DenseVector getDenseVector() {
        return new DenseVector(DataWrapper.toDouble(this.dataY));
    }

    public int getSize() {
        if (this.dataY != null) {
            if (this.dataX != null) {
                return Math.min(this.dataX.length, this.dataY.length);
            }
            return this.dataY.length;
        }
        return 0;
    }

    public Stroke getStroke() {
        return this.stroke;
    }

    public float getXmin() {
        return this.minmaxX[0];
    }

    public float getXmax() {
        return this.minmaxX[1];
    }

    public void setXvalueAt(int n, float f) {
        this.dataX[n] = f;
    }

    public float getXvalueAt(int n) {
        if (this.dataX != null) {
            return this.dataX[n];
        }
        return n;
    }

    public float getYmin() {
        return this.minmaxY[0];
    }

    public float getYmax() {
        return this.minmaxY[1];
    }

    public void setYvalueAt(int n, float f) {
        this.dataY[n] = f;
    }

    public float getYvalueAt(int n) {
        return this.dataY[n];
    }

    public boolean hasDataX() {
        return this.dataX != null && this.dataX.length > 0;
    }

    public boolean hasDataY() {
        return this.dataY != null && this.dataY.length > 0;
    }

    public void clearData() {
        this.dataX = null;
        this.dataY = null;
    }

    public boolean includeMinMax() {
        return true;
    }

    public boolean isMain() {
        return this.ismain;
    }

    public boolean isMissing(int n) {
        float f = this.dataY[n];
        return Float.isInfinite(f) || Float.isNaN(f);
    }

    public boolean isSelected(int n) {
        return this.selected != null && this.selected[n];
    }

    public boolean isGap(int n) {
        return false;
    }

    public boolean isShowDots() {
        return this.showDots;
    }

    public boolean isShowLine() {
        return this.showLine;
    }

    public void padX(double d) {
        this.minmaxX[0] = (float)((double)this.minmaxX[0] - d);
        this.minmaxX[1] = (float)((double)this.minmaxX[1] + d);
    }

    public void setColor(Color color) {
        this.color = color;
    }

    public void setDotSize(int n) {
        this.dotSize = n;
    }

    public void setDotSizes(int[] nArray) {
        this.dotSizes = nArray;
    }

    public boolean hasDotSizes() {
        return this.dotSizes != null;
    }

    public int getDotSize(int n) {
        if (this.dotSizes != null) {
            return this.dotSizes[n];
        }
        return this.dotSize;
    }

    public void setMain() {
        this.ismain = true;
    }

    public void setShowDots(boolean bl) {
        this.showDots = bl;
    }

    public void setShowLine(boolean bl) {
        this.showLine = bl;
    }

    public void setStroke(Stroke stroke) {
        this.stroke = stroke;
    }

    public void setName(String string) {
        this.name = string;
    }

    public String getName() {
        return this.name;
    }

    public String toString() {
        return this.name;
    }

    public int getIndex(double d) {
        if (this.dataX == null) {
            return 0;
        }
        float f = this.dataX[0];
        for (int i = 1; i < this.dataX.length; ++i) {
            if (d <= (double)f) {
                return i - 1;
            }
            float f2 = this.dataX[i];
            if (d < (double)f2) {
                double d2 = d - (double)f;
                double d3 = (double)f2 - d;
                return d2 < d3 ? i - 1 : i;
            }
            f = f2;
        }
        return this.dataX.length - 1;
    }

    public static double[] toDouble(float[] fArray) {
        double[] dArray = new double[fArray.length];
        for (int i = 0; i < fArray.length; ++i) {
            dArray[i] = fArray[i];
        }
        return dArray;
    }

    public DataWrapper copy() {
        try {
            return (DataWrapper)this.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new RuntimeException(cloneNotSupportedException);
        }
    }
}

