/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.map.plot.spectral;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.event.ActionEvent;
import java.awt.geom.Ellipse2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Path2D;
import java.awt.image.DataBufferInt;
import java.awt.image.WritableRaster;
import java.util.ArrayList;
import java.util.List;
import java.util.TreeSet;
import javax.swing.AbstractAction;
import javax.swing.JFrame;
import javax.swing.JPopupMenu;
import se.prediktera.map.common.NiceDataFormat;
import se.prediktera.map.dataexport.AbstractExportInfo;
import se.prediktera.map.datasetcontainer.datainfo.Description;
import se.prediktera.map.datasetcontainer.matrix.MVmatrix;
import se.prediktera.map.main.Evince;
import se.prediktera.map.plot.axisplot.rubberband.AbstractRubberband;
import se.prediktera.map.plot.axisplot.settings.Color.PerfectSpread;
import se.prediktera.map.plot.spectral.AbstractPlotPanel;
import se.prediktera.map.plot.spectral.DataWrapper;
import se.prediktera.map.plot.spectral.SpectralPlotHelper;

public class SpectralPlot
extends AbstractPlotPanel {
    public static final float[] dot = new float[]{1.0f, 10.0f};
    public static final float[] dash = new float[]{4.0f, 10.0f};
    public static final BasicStroke dotted = new BasicStroke(1.0f, 0, 0, 10.0f, dot, 0.0f);
    public static final BasicStroke dashed = new BasicStroke(1.0f, 0, 0, 10.0f, dash, 0.0f);
    public static final BasicStroke dashed2 = new BasicStroke(2.0f, 0, 0, 10.0f, dash, 0.0f);
    public static final BasicStroke line = new BasicStroke(2.0f, 0, 0, 10.0f);
    private final double xpercent = 0.05;
    private final double[] minmaxX = new double[2];
    private final double[] minmaxY = new double[2];
    private List<DataWrapper> pointWrapperList = new ArrayList<DataWrapper>();
    private Double fixedYmax;
    private final SpectralPlotHelper.CircleMaskCache maskCache = new SpectralPlotHelper.CircleMaskCache();
    protected final Color selectionColor = PerfectSpread.createTransparentColor(Color.yellow, 100);
    private Font noValueFont = new Font(this.getFont().getName(), this.getFont().getStyle(), 12);

    public double getXmin() {
        return this.minmaxX[0];
    }

    public double getXmax() {
        return this.minmaxX[1];
    }

    public double getYmin() {
        return this.minmaxY[0];
    }

    public double getYmax() {
        return this.minmaxY[1];
    }

    public void setYmax(Double d) {
        this.fixedYmax = d;
    }

    public void setData(List<DataWrapper> list) {
        this.pointWrapperList = list;
        this.setMinMax();
        this.contentPaint();
    }

    public List<DataWrapper> getPointWrapperList() {
        return this.pointWrapperList;
    }

    public DataWrapper getWrapper(int n) {
        if (n < this.pointWrapperList.size()) {
            return this.pointWrapperList.get(n);
        }
        return null;
    }

    @Override
    public String getValue(int n) {
        DataWrapper dataWrapper;
        float[] fArray;
        if (this.hasValues()) {
            return super.getValue(n);
        }
        if (this.pointWrapperList.size() > 0 && (fArray = (dataWrapper = this.pointWrapperList.get(0)).getDataX()) != null && n < fArray.length) {
            return NiceDataFormat.toString(fArray[n]);
        }
        return NiceDataFormat.toString(n);
    }

    public float getValueFloatInterpolate(float f) {
        DataWrapper dataWrapper;
        float[] fArray;
        if (this.pointWrapperList.size() > 0 && (fArray = (dataWrapper = this.pointWrapperList.get(0)).getDataX()) != null) {
            return SpectralPlotHelper.interpolate(fArray, f);
        }
        return f;
    }

    @Override
    public int getNumberOfValues() {
        DataWrapper dataWrapper;
        float[] fArray;
        if (this.hasValues()) {
            return super.getNumberOfValues();
        }
        if (this.pointWrapperList.size() > 0 && (fArray = (dataWrapper = this.pointWrapperList.get(0)).getDataX()) != null) {
            return fArray.length;
        }
        return 0;
    }

    public void Screen2Index(double[] dArray, double d, double d2) {
        this.Screen2Real(dArray, d, d2);
        dArray[0] = this.getIndexInterpolate((float)dArray[0]);
        dArray[1] = this.getIndexInterpolate((float)dArray[1]);
    }

    public float getIndexInterpolate(float f) {
        DataWrapper dataWrapper;
        float[] fArray;
        if (this.pointWrapperList.size() > 0 && (fArray = (dataWrapper = this.pointWrapperList.get(0)).getDataX()) != null) {
            return SpectralPlotHelper.inverseInterpolate(fArray, f);
        }
        return 0.0f;
    }

    public void Index2Screen(double[] dArray, double d) {
        this.Real2Screen(dArray, this.getValueFloatInterpolate((float)d), 0.0);
    }

    public int getIndex(double d) {
        if (this.pointWrapperList.size() > 0) {
            return this.pointWrapperList.get(0).getIndex(d);
        }
        return 0;
    }

    public DataWrapper getWrapperClosestTo(double d, double d2) {
        DataWrapper dataWrapper = null;
        double d3 = Double.MAX_VALUE;
        int n = this.getIndex(d);
        for (DataWrapper dataWrapper2 : this.pointWrapperList) {
            double d4;
            float[] fArray;
            if (!dataWrapper2.hasDataY() || n >= (fArray = dataWrapper2.getDataY()).length || !((d4 = Math.abs((double)fArray[n] - d2)) < d3)) continue;
            dataWrapper = dataWrapper2;
            d3 = d4;
        }
        return dataWrapper;
    }

    public int getIndexClosestTo(float f, float f2) {
        int n = -1;
        float f3 = Float.MAX_VALUE;
        for (DataWrapper dataWrapper : this.pointWrapperList) {
            for (int i = 0; i < dataWrapper.getSize(); ++i) {
                float f4;
                float f5;
                float f6 = dataWrapper.getXvalueAt(i);
                float f7 = f - f6;
                float f8 = f7 * f7 + (f5 = f2 - (f4 = dataWrapper.getYvalueAt(i))) * f5;
                if (!(f8 < f3)) continue;
                f3 = f8;
                n = i;
            }
        }
        return n;
    }

    @Override
    public void setMinMax() {
        boolean bl = true;
        DataWrapper dataWrapper = null;
        for (DataWrapper dataWrapper2 : this.pointWrapperList) {
            if (dataWrapper2 == null || !dataWrapper2.hasDataY() || !dataWrapper2.includeMinMax() || dataWrapper2.calcMinMax(dataWrapper, (byte)0)) continue;
            if (bl) {
                this.minmaxX[0] = dataWrapper2.getXmin();
                this.minmaxX[1] = dataWrapper2.getXmax();
                this.minmaxY[0] = dataWrapper2.getYmin();
                this.minmaxY[1] = dataWrapper2.getYmax();
                bl = false;
                continue;
            }
            if (this.minmaxX[0] > (double)dataWrapper2.getXmin()) {
                this.minmaxX[0] = dataWrapper2.getXmin();
            }
            if (this.minmaxX[1] < (double)dataWrapper2.getXmax()) {
                this.minmaxX[1] = dataWrapper2.getXmax();
            }
            if (this.minmaxY[0] > (double)dataWrapper2.getYmin()) {
                this.minmaxY[0] = dataWrapper2.getYmin();
            }
            if (!(this.minmaxY[1] < (double)dataWrapper2.getYmax())) continue;
            this.minmaxY[1] = dataWrapper2.getYmax();
        }
        double d = this.minmaxX[1] - this.minmaxX[0];
        if (d == 0.0) {
            d = 1.0;
        }
        this.minmaxX[0] = this.minmaxX[0] - d * 0.05;
        this.minmaxX[1] = this.minmaxX[1] + d * 0.05;
        double d2 = this.minmaxY[1] - this.minmaxY[0];
        if (d2 == 0.0) {
            d2 = 1.0;
        }
        this.minmaxY[0] = this.minmaxY[0] - d2 * 0.05;
        this.minmaxY[1] = this.minmaxY[1] + d2 * 0.05;
        if (this.fixedYmax != null) {
            this.minmaxY[0] = 0.0;
            this.minmaxY[1] = this.fixedYmax;
        }
        this.setMinMax(this.minmaxX[0], this.minmaxX[1], this.minmaxY[0], this.minmaxY[1], 1.0);
    }

    @Override
    public void zoomAll() {
        this.setMinMax(this.minmaxX[0], this.minmaxX[1], this.minmaxY[0], this.minmaxY[1], 1.0);
        this.contentPaint();
    }

    protected String getNoSpectraDesc() {
        return "No spectra(s) available";
    }

    @Override
    protected String getXaxisDesc() {
        if (super.getXaxisDesc() == null) {
            return "Channel";
        }
        return super.getXaxisDesc();
    }

    protected boolean hasData() {
        if (this.pointWrapperList != null) {
            for (DataWrapper dataWrapper : this.pointWrapperList) {
                if (!dataWrapper.hasDataY()) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    protected boolean selectArea(double[] dArray, double[] dArray2, Shape shape) {
        boolean bl = false;
        for (DataWrapper dataWrapper : this.pointWrapperList) {
            boolean[] blArray = dataWrapper.getSelected();
            if (blArray == null) {
                blArray = new boolean[dataWrapper.getSize()];
                dataWrapper.setSelected(blArray);
            }
            for (int i = 0; i < dataWrapper.getSize(); ++i) {
                float f = dataWrapper.getXvalueAt(i);
                float f2 = dataWrapper.getYvalueAt(i);
                if ((double)f >= dArray[0] && (double)f2 >= dArray[1] && (double)f < dArray2[0] && (double)f2 < dArray2[1]) {
                    blArray[i] = true;
                    bl = true;
                    continue;
                }
                blArray[i] = false;
            }
        }
        return bl;
    }

    @Override
    protected void paint(WritableRaster writableRaster, Graphics2D graphics2D, int n, int n2, AbstractPlotPanel.ContentType contentType) {
        if (contentType.equals((Object)AbstractPlotPanel.ContentType.Base)) {
            if (!this.hasData()) {
                this.ispreview = true;
                Font font = graphics2D.getFont();
                graphics2D.setFont(this.noValueFont);
                FontMetrics fontMetrics = graphics2D.getFontMetrics();
                String string = this.getNoSpectraDesc();
                graphics2D.setColor(this.getForeground());
                graphics2D.drawString(string, this.sx + this.width / 2 - fontMetrics.stringWidth(string) / 2, this.sy + this.height / 2 - fontMetrics.getHeight() / 3);
                graphics2D.setFont(font);
                return;
            }
            this.ispreview = false;
            graphics2D.setColor(this.getForeground());
            double[] dArray = new double[2];
            for (DataWrapper object2 : this.pointWrapperList) {
                if (object2 == null || !object2.isShowLine()) continue;
                graphics2D.setColor(object2.getColor());
                graphics2D.setStroke(object2.getStroke());
                Object object = null;
                int n3 = 0;
                for (int i = 0; i < object2.getSize(); ++i) {
                    if (object2.isGap(i)) {
                        if (n3 <= true) continue;
                        graphics2D.draw((Shape)object);
                        object = null;
                        n3 = 0;
                        continue;
                    }
                    if (object2.isMissing(i)) continue;
                    float nArray2 = object2.getXvalueAt(i);
                    float d = object2.getYvalueAt(i);
                    this.Real2Screen(dArray, nArray2, d);
                    if (object == null) {
                        object = new GeneralPath();
                        ((Path2D.Float)object).moveTo((float)dArray[0], (float)dArray[1]);
                    } else {
                        ((Path2D.Float)object).lineTo((float)dArray[0], (float)dArray[1]);
                    }
                    ++n3;
                }
                if (n3 <= true) continue;
                graphics2D.draw((Shape)object);
            }
        }
        boolean bl = contentType.equals((Object)AbstractPlotPanel.ContentType.Selection);
        int n4 = this.selectionColor.getRGB();
        Color color = bl ? Color.yellow : this.getForeground();
        graphics2D.setStroke(singleline);
        for (DataWrapper dataWrapper : this.pointWrapperList) {
            if (dataWrapper == null || !dataWrapper.isShowDots()) continue;
            int[] nArray = ((DataBufferInt)writableRaster.getDataBuffer()).getData();
            int[] nArray2 = new int[n * n2];
            double d = this.minmax[0];
            double d2 = this.minmax[2];
            float f = (float)((double)this.width / this.abs[0]);
            float f2 = (float)((double)this.height / this.abs[1]);
            float[] fArray = dataWrapper.getDataX();
            float[] fArray2 = dataWrapper.getDataY();
            boolean bl2 = dataWrapper.showDotBorder();
            SpectralPlotHelper.CircleMaskCache.CircleMask circleMask = dataWrapper.hasDotSizes() ? null : this.maskCache.getMask(dataWrapper.getDotSize(0));
            for (int i = 0; i < dataWrapper.getSize(); ++i) {
                int n5;
                if (dataWrapper.isMissing(i) || bl && !dataWrapper.isSelected(i)) continue;
                int n6 = bl ? n4 : dataWrapper.getDotColor(i);
                int n7 = dataWrapper.getDotSize(i);
                float f3 = fArray[i];
                float f4 = fArray2[i];
                int n8 = (int)(((double)f3 - d) * (double)f) + this.sx;
                int n9 = (int)((double)this.rh - ((double)f4 - d2) * (double)f2) - this.ey;
                if (n8 < this.sx || n8 >= n - this.ex || n9 < this.sy || n9 >= n2 - this.ey || nArray2[n5 = n9 * n + n8] >= n7) continue;
                nArray2[n5] = n7;
                int n10 = n6;
                if (n7 == 1) {
                    nArray[n5] = n10;
                } else {
                    SpectralPlotHelper.CircleMaskCache.CircleMask f6 = circleMask != null ? circleMask : this.maskCache.getMask(n7);
                    this.maskCache.drawMask(nArray, n, n2, n8, n9, n10, f6);
                }
                if (!bl2) continue;
                float f5 = (float)n7 / 2.0f;
                Ellipse2D.Double double_ = new Ellipse2D.Double((float)n8 - f5, (float)n9 - f5, n7, n7);
                graphics2D.setColor(color);
                graphics2D.draw(double_);
            }
        }
        if (bl) {
            SpectralPlotHelper.drawSelectionBorders(writableRaster, Color.black);
        }
    }

    @Override
    protected void addToPopup(JPopupMenu jPopupMenu) {
        super.addToPopup(jPopupMenu);
        jPopupMenu.add(new AbstractAction("Save spectral data"){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SpectralPlot.this.exportSpectra();
            }
        });
    }

    public int getMaxSize() {
        int n = 0;
        for (DataWrapper dataWrapper : this.pointWrapperList) {
            n = Math.max(n, dataWrapper.getSize());
        }
        return n;
    }

    public void exportSpectra() {
        AbstractExportInfo.ExportDataNow(this.getSpectralMatrix().createTableModel(true), false);
    }

    private float[] getWavelength() {
        Object object;
        TreeSet<Float> treeSet = new TreeSet<Float>();
        for (DataWrapper dataWrapper : this.getPointWrapperList()) {
            for (float f : object = dataWrapper.getDataX()) {
                treeSet.add(Float.valueOf(f));
            }
        }
        Object object2 = new float[treeSet.size()];
        int n = 0;
        object = treeSet.iterator();
        while (object.hasNext()) {
            Object object3 = (Float)object.next();
            object2[n++] = ((Float)object3).floatValue();
        }
        return object2;
    }

    public MVmatrix getSpectralMatrix() {
        return this.getSpectralMatrix(this.pointWrapperList);
    }

    public MVmatrix getSpectralMatrix(List<? extends DataWrapper> list) {
        float[] fArray = this.getWavelength();
        int n = fArray.length;
        MVmatrix mVmatrix = new MVmatrix(list.size(), n);
        mVmatrix.setName("Spectral data");
        Description description = new Description(n);
        description.addStringColumn("ColDescr");
        for (int i = 0; i < n; ++i) {
            description.setValue(i, 0, NiceDataFormat.toString(fArray[i]));
        }
        mVmatrix.setColumnDescription(description);
        Description description2 = new Description(list.size());
        description2.addStringColumn("RowDescr");
        for (int i = 0; i < list.size(); ++i) {
            DataWrapper dataWrapper = list.get(i);
            description2.setValue(i, 0, dataWrapper.getName());
            for (int j = 0; j < n; ++j) {
                float f = SpectralPlotHelper.interpolateOrZero(dataWrapper.getDataX(), dataWrapper.getDataY(), fArray[j]);
                mVmatrix.setValue(i, j, f, f == 0.0f);
            }
        }
        mVmatrix.setRowDescription(description2);
        return mVmatrix;
    }

    public void setNoValueFont(Font font) {
        this.noValueFont = font;
    }

    public static void main(String[] stringArray) {
        Evince.initNoShow();
        JFrame jFrame = new JFrame("Spectral Plot");
        SpectralPlot spectralPlot = new SpectralPlot();
        spectralPlot.setGridColor(Color.gray);
        spectralPlot.setZeroColor(Color.black);
        spectralPlot.setRubberAction(AbstractRubberband.RubberAction.Selection, AbstractRubberband.RubberType.Rectangle, Cursor.getDefaultCursor());
        ArrayList<DataWrapper> arrayList = new ArrayList<DataWrapper>();
        float[] fArray = new float[]{1.0f, 2.0f, 1.0f, 2.0f, 1.0f};
        float[] fArray2 = new float[]{10.0f, 20.0f, 30.0f, 40.0f, 50.0f};
        DataWrapper dataWrapper = new DataWrapper(fArray2, fArray, "Test 1");
        dataWrapper.setDotSize(11);
        dataWrapper.setColor(Color.red);
        dataWrapper.setShowDots(true);
        arrayList.add(dataWrapper);
        spectralPlot.setData(arrayList);
        jFrame.setSize(600, 600);
        jFrame.setDefaultCloseOperation(3);
        jFrame.setContentPane(spectralPlot);
        jFrame.setLocationRelativeTo(null);
        jFrame.setVisible(true);
    }
}

