/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.map.plot.spectral;

import java.awt.Color;
import java.awt.image.DataBufferInt;
import java.awt.image.WritableRaster;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import se.prediktera.map.main.ColorScalesHelper;
import se.prediktera.map.plot.spectral.DataWrapper;

public class SpectralPlotHelper {
    public static float interpolate(float[] fArray, float f) {
        int n = fArray.length - 1;
        if (f < 0.0f) {
            float f2 = fArray[0];
            float f3 = fArray[1];
            return f2 + (f3 - f2) * f;
        }
        if (f >= (float)n) {
            float f4 = fArray[n - 1];
            float f5 = fArray[n];
            return f5 + (f5 - f4) * (f - (float)n);
        }
        int n2 = (int)Math.floor(f);
        int n3 = n2 + 1;
        float f6 = f - (float)n2;
        float f7 = fArray[n2];
        float f8 = fArray[n3];
        return f7 + (f8 - f7) * f6;
    }

    public static float inverseInterpolate(float[] fArray, float f) {
        int n = fArray.length;
        if (n == 1) {
            return 0.0f;
        }
        if (f < fArray[0]) {
            float f2 = fArray[1];
            float f3 = fArray[0];
            float f4 = f2 - f3;
            return f4 != 0.0f ? (f - f3) / f4 : 0.0f;
        }
        int n2 = n - 1;
        if (f > fArray[n2]) {
            float f5 = fArray[n2 - 1];
            float f6 = fArray[n2];
            float f7 = f6 - f5;
            return (float)n2 + (f7 != 0.0f ? (f - f6) / f7 : 0.0f);
        }
        for (int i = 0; i < n - 1; ++i) {
            float f8 = fArray[i];
            float f9 = fArray[i + 1];
            if (!(f >= f8 && f <= f9) && (!(f <= f8) || !(f >= f9))) continue;
            float f10 = f9 - f8;
            if (f10 == 0.0f) {
                return i;
            }
            float f11 = (f - f8) / f10;
            return (float)i + f11;
        }
        return n2;
    }

    private static int estimateGridSize(int n) {
        int n2 = (int)Math.sqrt((float)n / 10.0f);
        return Math.max(50, Math.min(n2, 512));
    }

    public static void computeDensityBuckets(DataWrapper dataWrapper) {
        int n;
        int n2;
        float f;
        float f2;
        int n3;
        int n4;
        int n5 = n4 = SpectralPlotHelper.estimateGridSize(dataWrapper.getSize());
        int n6 = n4;
        int[] nArray = new int[n5 * n6];
        float f3 = dataWrapper.getXmin();
        float f4 = dataWrapper.getXmax();
        float f5 = dataWrapper.getYmin();
        float f6 = dataWrapper.getYmax();
        float[] fArray = dataWrapper.getDataX();
        float[] fArray2 = dataWrapper.getDataY();
        if (fArray == null || fArray2 == null || fArray.length == 0 || fArray.length != fArray2.length) {
            return;
        }
        float f7 = f4 - f3 == 0.0f ? 1.0f : f4 - f3;
        float f8 = f6 - f5 == 0.0f ? 1.0f : f6 - f5;
        float f9 = 1.0f / f7;
        float f10 = 1.0f / f8;
        int n7 = fArray.length;
        for (n3 = 0; n3 < n7; ++n3) {
            int n8;
            float f11 = fArray[n3];
            float f12 = fArray2[n3];
            if (f12 == 0.0f) continue;
            float f13 = (f11 - f3) * f9;
            float f14 = (f12 - f5) * f10;
            if (f13 < 0.0f || f13 > 1.0f || f14 < 0.0f || f14 > 1.0f) continue;
            f2 = f13 * (float)(n5 - 1);
            f = (1.0f - f14) * (float)(n6 - 1);
            int n9 = (int)f2;
            n2 = (int)f;
            if (n9 < 0) {
                n9 = 0;
            } else if (n9 >= n5) {
                n9 = n5 - 1;
            }
            if (n2 < 0) {
                n2 = 0;
            } else if (n2 >= n6) {
                n2 = n6 - 1;
            }
            int n10 = n = n2 * n5 + n9;
            nArray[n10] = nArray[n10] + 1;
            if (n2 < n6 - 1) {
                int n11 = n8 = (n2 + 1) * n5 + n9;
                nArray[n11] = nArray[n11] + 1;
            }
            if (n9 < n5 - 1) {
                int n12 = n8 = n2 * n5 + (n9 + 1);
                nArray[n12] = nArray[n12] + 1;
            }
            if (n2 >= n6 - 1 || n9 >= n5 - 1) continue;
            int n13 = n8 = (n2 + 1) * n5 + (n9 + 1);
            nArray[n13] = nArray[n13] + 1;
        }
        n3 = 0;
        for (int n14 : nArray) {
            if (n14 <= n3) continue;
            n3 = n14;
        }
        if (n3 == 0) {
            n3 = 1;
        }
        int[] nArray2 = ColorScalesHelper.getInstance().getColorScale("jet").toRgbArray();
        int[] nArray3 = new int[n7];
        for (int i = 0; i < n7; ++i) {
            int n15;
            float f15 = (fArray[i] - f3) * f9;
            f2 = (fArray2[i] - f5) * f10;
            if (f15 < 0.0f || f15 > 1.0f || f2 < 0.0f || f2 > 1.0f) continue;
            f = f15 * (float)(n5 - 1);
            float f16 = (1.0f - f2) * (float)(n6 - 1);
            n2 = (int)f;
            n = (int)f16;
            if (n2 < 0) {
                n2 = 0;
            } else if (n2 >= n5) {
                n2 = n5 - 1;
            }
            if (n < 0) {
                n = 0;
            } else if (n >= n6) {
                n = n6 - 1;
            }
            float f17 = f16 - (float)n;
            float f18 = f - (float)n2;
            int n16 = n * n5 + n2;
            float f19 = (1.0f - f17) * (1.0f - f18) * (float)nArray[n16];
            if (n < n6 - 1) {
                n15 = (n + 1) * n5 + n2;
                f19 += f17 * (1.0f - f18) * (float)nArray[n15];
            }
            if (n2 < n5 - 1) {
                n15 = n * n5 + (n2 + 1);
                f19 += (1.0f - f17) * f18 * (float)nArray[n15];
            }
            if (n < n6 - 1 && n2 < n5 - 1) {
                n15 = (n + 1) * n5 + (n2 + 1);
                f19 += f17 * f18 * (float)nArray[n15];
            }
            float f20 = Math.min(f19 / (float)n3, 1.0f);
            float f21 = (float)Math.sqrt(f20);
            int n17 = (int)(f21 * 255.0f + 0.5f);
            nArray3[i] = nArray2[n17 & 0xFF];
        }
        dataWrapper.setDotColors(nArray3);
    }

    public static void drawSelectionBorders(WritableRaster writableRaster, Color color) {
        int n;
        int n2;
        int n3;
        int n4 = writableRaster.getWidth();
        int n5 = writableRaster.getHeight();
        int[] nArray = ((DataBufferInt)writableRaster.getDataBuffer()).getData();
        boolean[] blArray = new boolean[n4 * n5];
        boolean[] blArray2 = new boolean[n4 * n5];
        for (n3 = 0; n3 < nArray.length; ++n3) {
            n2 = nArray[n3];
            n = n2 >>> 24 & 0xFF;
            blArray[n3] = n > 0;
        }
        for (n3 = 0; n3 < n5; ++n3) {
            n2 = n3 * n4;
            for (n = 0; n < n4; ++n) {
                int n6 = n2 + n;
                if (!blArray[n6]) continue;
                boolean bl = false;
                block3: for (int i = -1; i <= 1 && !bl; ++i) {
                    int n7 = n3 + i;
                    if (n7 < 0 || n7 >= n5) {
                        bl = true;
                        break;
                    }
                    int n8 = n7 * n4;
                    for (int j = -1; j <= 1; ++j) {
                        if (j == 0 && i == 0) continue;
                        int n9 = n + j;
                        if (n9 < 0 || n9 >= n4) {
                            bl = true;
                            continue block3;
                        }
                        int n10 = n8 + n9;
                        if (blArray[n10]) continue;
                        bl = true;
                        continue block3;
                    }
                }
                if (!bl) continue;
                blArray2[n6] = true;
            }
        }
        n3 = color.getRGB();
        for (n2 = 0; n2 < nArray.length; ++n2) {
            if (!blArray2[n2]) continue;
            nArray[n2] = n3;
        }
    }

    public static float interpolateOrZero(float[] fArray, float[] fArray2, float f) {
        int n = Arrays.binarySearch(fArray, f);
        if (n >= 0) {
            return fArray2[n];
        }
        int n2 = -n - 1;
        if (n2 == 0 || n2 == fArray.length) {
            return 0.0f;
        }
        int n3 = n2 - 1;
        int n4 = n2;
        float f2 = fArray[n3];
        float f3 = fArray[n4];
        float f4 = fArray2[n3];
        float f5 = fArray2[n4];
        if (f3 == f2) {
            return f4;
        }
        float f6 = (f - f2) / (f3 - f2);
        return f4 + f6 * (f5 - f4);
    }

    public static class CircleMaskCache {
        private final Map<Integer, CircleMask> maskCache = new HashMap<Integer, CircleMask>();

        public CircleMask getMask(int n) {
            if (n <= 0) {
                throw new IllegalArgumentException("Diameter must be > 0");
            }
            return this.maskCache.computeIfAbsent(n, this::createMask);
        }

        public void drawMask(int[] nArray, int n, int n2, int n3, int n4, int n5, CircleMask circleMask) {
            byte[][] byArray = circleMask.alphaMask();
            int n6 = circleMask.diameter();
            int n7 = circleMask.radius();
            int n8 = n3 - n7;
            int n9 = n4 - n7;
            int n10 = Math.max(0, n8);
            int n11 = Math.min(n - 1, n8 + n6 - 1);
            int n12 = Math.max(0, n9);
            int n13 = Math.min(n2 - 1, n9 + n6 - 1);
            if (n10 > n11 || n12 > n13) {
                return;
            }
            int n14 = n5 & 0xFFFFFF;
            for (int i = n12; i <= n13; ++i) {
                int n15 = i - n9;
                int n16 = i * n;
                for (int j = n10; j <= n11; ++j) {
                    int n17 = j - n8;
                    int n18 = byArray[n17][n15] & 0xFF;
                    if (n18 == 0) continue;
                    int n19 = n16 + j;
                    int n20 = nArray[n19];
                    int n21 = n20 >>> 24 & 0xFF;
                    int n22 = n21 == 0 && n18 < 255 ? n18 : 255;
                    nArray[n19] = n22 << 24 | n14;
                }
            }
        }

        private CircleMask createMask(int n) {
            float f;
            int n2;
            float f2;
            int n3 = n;
            int n4 = n3 / 2;
            byte[][] byArray = new byte[n3][n3];
            float f3 = f2 = (float)(n3 - 1) * 0.5f;
            float f4 = f2;
            float f5 = f2 - 0.5f;
            float f6 = f2 + 0.5f;
            float f7 = f5 * f5;
            float f8 = f6 * f6;
            float f9 = f6 - f5;
            float f10 = f9 != 0.0f ? 1.0f / f9 : 0.0f;
            float[] fArray = new float[n3];
            for (n2 = 0; n2 < n3; ++n2) {
                f = (float)n2 - f4;
                fArray[n2] = f * f;
            }
            for (n2 = 0; n2 < n3; ++n2) {
                f = fArray[n2];
                byte[] byArray2 = byArray[n2];
                for (int i = 0; i < n3; ++i) {
                    int n5;
                    float f11 = (float)i - f3;
                    float f12 = f11 * f11 + f;
                    if (f12 <= f7) {
                        n5 = 255;
                    } else if (f12 >= f8 || f9 == 0.0f) {
                        n5 = 0;
                    } else {
                        float f13 = (float)Math.sqrt(f12);
                        float f14 = (f13 - f5) * f10;
                        float f15 = 1.0f - f14;
                        n5 = Math.round(f15 * 255.0f);
                    }
                    byArray2[i] = (byte)n5;
                }
            }
            return new CircleMask(byArray, n4, n);
        }

        public record CircleMask(byte[][] alphaMask, int radius, int diameter) {
        }
    }
}

