/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.map.register;

import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import se.prediktera.map.common.error.Logg;

public class IniFileReader {
    private static IniFileReader instance;
    private final Map<String, Map<String, String>> sections = new HashMap<String, Map<String, String>>();
    public static final String NO_CAMERAS = "No Camera";

    private IniFileReader(File file) throws IOException {
        this.parse(file);
    }

    public static synchronized void initialize(File file) throws IOException {
        instance = new IniFileReader(file);
    }

    private static synchronized void initialize() throws IOException, URISyntaxException {
        Path path = Paths.get(IniFileReader.class.getProtectionDomain().getCodeSource().getLocation().toURI()).getParent();
        File file = path.getParent().resolve("Runtime").resolve("Cameras.ini").toFile();
        if (!file.exists()) {
            Logg.debug("Cameras.ini not found at: " + file.getAbsolutePath(), new Object[0]);
        }
        instance = new IniFileReader(file);
    }

    public static IniFileReader getInstance() {
        if (instance == null) {
            try {
                IniFileReader.initialize();
            }
            catch (IOException | URISyntaxException exception) {
                try {
                    Logg.error("Cannot initialize IniFileReader:", exception);
                    return new IniFileReader(new File(""){

                        @Override
                        public boolean exists() {
                            return false;
                        }
                    });
                }
                catch (IOException iOException) {
                    throw new RuntimeException(iOException);
                }
            }
        }
        return instance;
    }

    public static synchronized void clearInstance() {
        instance = null;
    }

    private void parse(File file) throws IOException {
        if (!file.exists()) {
            return;
        }
        String string = null;
        for (String string2 : Files.readAllLines(file.toPath())) {
            if ((string2 = string2.trim()).isEmpty() || string2.startsWith(";") || string2.startsWith("#")) continue;
            if (string2.startsWith("[") && string2.endsWith("]")) {
                string = string2.substring(1, string2.length() - 1);
                this.sections.putIfAbsent(string, new HashMap());
                continue;
            }
            if (!string2.contains("=") || string == null) continue;
            String[] stringArray = string2.split("=", 2);
            String string3 = stringArray[0].trim();
            String string4 = stringArray.length > 1 ? stringArray[1].trim().replaceAll("^\"|\"$", "") : "";
            this.sections.get(string).put(string3, string4);
        }
    }

    public Optional<String> get(String string, String string2) {
        Map<String, String> map = this.sections.get(string);
        return map != null ? Optional.ofNullable(map.get(string2)) : Optional.empty();
    }

    public boolean isCameraInstalled(String string) {
        Optional<String> optional = this.get("Settings", string);
        return optional.filter("1"::equals).isPresent();
    }

    public List<String> getInstalledCamerasWithoutBuiltin() {
        return this.sections.getOrDefault("Settings", Collections.emptyMap()).keySet().stream().filter(this::notBuiltin).toList();
    }

    public boolean isNoExternalCamera() {
        return this.getInstalledCamerasWithoutBuiltin().isEmpty();
    }

    private boolean notBuiltin(String string) {
        return !string.startsWith("Prediktera") && !string.startsWith("Rgb USB") && !string.startsWith(NO_CAMERAS);
    }

    public Optional<String> getDriverVersion(String string) {
        return this.get("Drivers", string);
    }

    public Map<String, String> getSection(String string) {
        return this.sections.getOrDefault(string, Collections.emptyMap());
    }
}

