/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.map.register;

import com.auth0.jwt.JWT;
import com.auth0.jwt.JWTCreator;
import com.auth0.jwt.algorithms.Algorithm;
import com.auth0.jwt.exceptions.JWTCreationException;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.StringTokenizer;
import java.util.stream.Collectors;
import javax.swing.JOptionPane;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang3.StringUtils;
import se.prediktera.map.InitClass;
import se.prediktera.map.common.NiceDataFormat;
import se.prediktera.map.common.error.Logg;
import se.prediktera.map.common.update.UpdateHelper;
import se.prediktera.map.main.extclass.ExtClassLoader;
import se.prediktera.map.register.RegKeyParserException;
import se.prediktera.map.register.RegisterKeyManager;
import se.prediktera.map.register.UniqueIdManager;

public class RegInfo {
    public boolean professional = false;
    public int ID;
    public int LID;
    public String ipmask = null;
    public String claim = "1 of 1";
    public String serialUAC = null;
    public String serialUDC = null;
    public String serialUFC = null;
    public String serialUMC = null;
    public String maxBreezeVersionStr = null;
    public boolean isPerpetual = false;
    public boolean isFloating = false;
    public boolean isArchived = false;
    public long created;
    public String version;
    public String company = null;
    public String name = null;
    public String email = null;
    public byte range;
    public List<Item> libLicenses = new ArrayList<Item>();
    public List<LicenseFeature> features = new ArrayList<LicenseFeature>();
    public String signature;
    public String regtext = "";
    public String regtextWithSignature = "";
    public long TimeStamp = 0L;
    private boolean isprotected = false;
    private boolean demolicense = false;
    int pos;

    public RegInfo() {
    }

    public RegInfo(File file) {
        if (file.exists()) {
            byte[] byArray = new byte[(int)file.length()];
            try (FileInputStream fileInputStream = new FileInputStream(file);){
                fileInputStream.read(byArray);
                this.parse(new String(byArray));
            }
            catch (IOException iOException) {
            }
            catch (RegKeyParserException regKeyParserException) {
                JOptionPane.showConfirmDialog(null, regKeyParserException.getMessage() + "\nContact license@prediktera.se for assistance", "Corrupt license file", -1, 0, null);
            }
        }
    }

    public RegInfo(String string) throws RegKeyParserException {
        this.parse(string);
    }

    private void parse(String string) throws RegKeyParserException {
        if (Base64.isBase64((String)string)) {
            string = new String(Base64.decodeBase64((String)string));
        }
        try {
            String string2;
            String string3;
            this.pos = 0;
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd");
            while (!this.licenseStart(string3 = this.readLine(string))) {
            }
            this.addRegText(string3);
            string3 = this.readLine(string);
            this.addRegText(string3);
            RegInfo.getRowColumn(string3, 0, false);
            do {
                if (string3.startsWith("Created")) {
                    string2 = RegInfo.getRowColumn(string3, 1, true);
                    if (!string2.isEmpty()) {
                        this.created = simpleDateFormat.parse(string2).getTime();
                    }
                } else if (string3.startsWith("TimeStamp")) {
                    this.TimeStamp = Long.parseLong(RegInfo.getRowColumn(string3, 1, true));
                } else if (string3.startsWith("ID")) {
                    this.ID = NiceDataFormat.toNumberInt(RegInfo.getRowColumn(string3, 1, true));
                } else if (string3.startsWith("LID") || string3.startsWith("LicenseID")) {
                    this.LID = NiceDataFormat.toNumberInt(RegInfo.getRowColumn(string3, 1, true));
                } else if (string3.startsWith("LicenseClaim")) {
                    this.claim = RegInfo.getRowColumn(string3, 1, true);
                } else if (string3.startsWith("Company")) {
                    this.company = RegInfo.getRowColumn(string3, 1, true);
                } else if (string3.startsWith("MaxBreezeVersion")) {
                    this.maxBreezeVersionStr = RegInfo.getRowColumn(string3, 1, true);
                } else if (string3.startsWith("IsPerpetual")) {
                    this.isPerpetual = Boolean.parseBoolean(RegInfo.getRowColumn(string3, 1, true));
                } else if (string3.startsWith("IsFloating")) {
                    this.isFloating = Boolean.parseBoolean(RegInfo.getRowColumn(string3, 1, true));
                } else if (string3.startsWith("IsArchived")) {
                    this.isArchived = Boolean.parseBoolean(RegInfo.getRowColumn(string3, 1, true));
                } else if (string3.startsWith("Name")) {
                    this.name = RegInfo.getRowColumn(string3, 1, true);
                } else if (string3.startsWith("Email")) {
                    this.email = RegInfo.getRowColumn(string3, 1, true);
                } else if (string3.startsWith("Range")) {
                    RegInfo.getRowColumn(string3, 1, true);
                } else if (string3.startsWith("License")) {
                    this.professional = RegInfo.getRowColumn(string3, 1, true).equals("Professional");
                } else if (string3.startsWith("Feature")) {
                    string2 = RegInfo.getRowColumn(string3, 1, true);
                    if (!StringUtils.isEmpty((CharSequence)string2)) {
                        this.features = Arrays.stream(string2.split(";")).map(LicenseFeature::fromString).filter(Objects::nonNull).collect(Collectors.toList());
                    }
                } else if (string3.startsWith("Version")) {
                    this.version = RegInfo.getRowColumn(string3, 1, true);
                } else if (string3.startsWith("Domain")) {
                    this.ipmask = RegInfo.getRowColumn(string3, 1, true);
                } else if (string3.startsWith("UAC")) {
                    this.serialUAC = RegInfo.getRowColumn(string3, 1, true);
                } else if (string3.startsWith("UDC")) {
                    this.serialUDC = RegInfo.getRowColumn(string3, 1, true);
                } else if (string3.startsWith("UFC")) {
                    this.serialUFC = RegInfo.getRowColumn(string3, 1, true);
                } else if (string3.startsWith("UMC")) {
                    this.serialUMC = RegInfo.getRowColumn(string3, 1, true);
                }
                string3 = this.readLine(string);
                this.addRegText(string3);
            } while (!string3.equals("-----------------------------"));
            this.addRegText(this.readLine(string));
            string3 = this.readLine(string);
            this.addRegText(string3);
            while (!this.containsText(string3, "Signature")) {
                string2 = RegInfo.getRowColumn(string3, 0, false);
                String string4 = RegInfo.getRowColumn(string3, 1, false);
                String string5 = RegInfo.getRowColumn(string3, 2, false);
                long l = 0L;
                if (!string5.isEmpty()) {
                    l = simpleDateFormat.parse(string5).getTime();
                }
                try {
                    this.addLicense(ExtClassLoader.LicenseLibrary.valueOf(string2), LicenseType.valueOf(string4), l);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    Logg.info("License library (" + string2 + ") or type (" + string4 + ") not supported", new Object[0]);
                }
                string3 = this.readLine(string);
                this.addRegText(string3);
            }
            this.signature = this.readLine(string);
            if (this.containsText(this.signature, "DO NOT EDIT")) {
                this.addRegText(this.signature);
                this.signature = "";
            } else {
                this.regtextWithSignature = this.regtextWithSignature + this.signature + "\n";
                this.addRegText(this.readLine(string));
            }
            this.setProtected(true);
        }
        catch (ParseException parseException) {
            throw new RegKeyParserException();
        }
    }

    private void addRegText(String string) {
        this.regtext = this.regtext + string;
        this.regtextWithSignature = this.regtextWithSignature + string + "\n";
    }

    private static String getRowColumn(String string, int n, boolean bl) {
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        Object object = null;
        for (int i = 0; i <= n; ++i) {
            if (!stringTokenizer.hasMoreTokens()) {
                return "";
            }
            object = stringTokenizer.nextToken();
        }
        if (bl) {
            while (stringTokenizer.hasMoreTokens()) {
                object = (String)object + " " + stringTokenizer.nextToken();
            }
        }
        return object;
    }

    private String readLine(String string) throws RegKeyParserException {
        int n = 0;
        StringBuilder stringBuilder = new StringBuilder(30);
        if (this.pos >= string.length()) {
            throw new RegKeyParserException("License error: no more lines to read");
        }
        while (this.pos < string.length()) {
            if (string.charAt(this.pos) == "<br>".charAt(n)) {
                if (++n == "<br>".length()) {
                    ++this.pos;
                    return stringBuilder.substring(0, stringBuilder.length() - 3);
                }
            } else {
                n = 0;
            }
            if (string.charAt(this.pos) != '\r') {
                if (string.charAt(this.pos) == '\n') {
                    if (!stringBuilder.isEmpty()) {
                        ++this.pos;
                        return stringBuilder.toString();
                    }
                } else {
                    stringBuilder.append(string.charAt(this.pos));
                }
            }
            ++this.pos;
        }
        return stringBuilder.toString();
    }

    private boolean licenseStart(String string) {
        return this.containsText(string, "#### Evince License File ####") || this.containsText(string, "#### Prediktera License File ####");
    }

    private boolean containsText(String string, String string2) {
        if (string != null && string2 != null) {
            return string.contains(string2);
        }
        return false;
    }

    public void save(File file) {
        try {
            File file2 = File.createTempFile("license", "key", file.getParentFile());
            Files.writeString(file2.toPath(), (CharSequence)Base64.encodeBase64String((byte[])this.regtextWithSignature.getBytes()), new OpenOption[0]);
            if (!(file.exists() && !file.delete() || file2.renameTo(file))) {
                Logg.warn("Failed to move license key file", new Object[0]);
            }
        }
        catch (IOException iOException) {
            JOptionPane.showConfirmDialog(null, "The license.key file could not be created, please check that it isn't open or write protected.", "Can't create license.key", -1, 0, null);
        }
    }

    public boolean addLicense(ExtClassLoader.LicenseLibrary licenseLibrary, LicenseType licenseType, long l) {
        if (!this.isprotected) {
            this.libLicenses.add(new Item(licenseLibrary, licenseType, l));
            if (licenseLibrary.equals((Object)ExtClassLoader.LicenseLibrary.BREEZE) && !this.hasLibraryExpired(ExtClassLoader.LicenseLibrary.BREEZE)) {
                this.features.add(LicenseFeature.Application);
            }
            if (licenseLibrary.equals((Object)ExtClassLoader.LicenseLibrary.BREEZEAPI) && !this.hasLibraryExpired(ExtClassLoader.LicenseLibrary.BREEZEAPI)) {
                this.features.add(LicenseFeature.Industrial);
            }
            return true;
        }
        return false;
    }

    public String getCompany() {
        return this.company;
    }

    public static boolean isApplicationFeature() {
        return RegInfo.isFeatureActiveStatic(LicenseFeature.Application);
    }

    public static boolean isGeoFeature() {
        return RegInfo.isFeatureActiveStatic(LicenseFeature.Application) && RegInfo.isFeatureActiveStatic(LicenseFeature.Geo);
    }

    public static boolean isRecordFeature() {
        return RegInfo.isFeatureActiveStatic(LicenseFeature.Record) || RegInfo.isFeatureActiveStatic(LicenseFeature.HySpexRecorder);
    }

    public static void disableFeature(LicenseFeature licenseFeature) {
        RegisterKeyManager.getRegInfo().features.remove((Object)licenseFeature);
    }

    public static void addFeature(LicenseFeature licenseFeature) {
        RegisterKeyManager.getRegInfo().features.add(licenseFeature);
    }

    public static boolean isFeatureActiveStatic(LicenseFeature licenseFeature) {
        return RegisterKeyManager.getRegInfo().isFeatureActive(licenseFeature);
    }

    public boolean isFeatureActive(LicenseFeature licenseFeature) {
        return this.features.contains((Object)licenseFeature);
    }

    public boolean hasLicense(UpdateHelper.Product product) {
        return switch (product) {
            case UpdateHelper.Product.Breeze -> {
                if (RegInfo.isRecordFeature() || this.hasItem(ExtClassLoader.LicenseLibrary.BREEZE)) {
                    yield true;
                }
                yield false;
            }
            case UpdateHelper.Product.BreezeRuntimeClient, UpdateHelper.Product.BreezeRuntime, UpdateHelper.Product.BreezeRuntimeDemo -> {
                if (this.hasItem(ExtClassLoader.LicenseLibrary.BREEZE) || this.hasItem(ExtClassLoader.LicenseLibrary.BREEZEAPI)) {
                    yield true;
                }
                yield false;
            }
            default -> this.hasItem(ExtClassLoader.LicenseLibrary.EVINCE);
        };
    }

    public int getDaysLeft(ExtClassLoader.LicenseLibrary licenseLibrary) {
        Item item = this.getItem(licenseLibrary);
        if (item != null) {
            long l = item.expired - System.currentTimeMillis();
            if (l < 0L) {
                return 0;
            }
            return (int)(l / 86400000L);
        }
        return 0;
    }

    public int getDaysLeftEvince() {
        return this.getDaysLeft(ExtClassLoader.LicenseLibrary.EVINCE);
    }

    public int getDaysUntilExpireEvince() {
        return this.getDaysUntilExpire(ExtClassLoader.LicenseLibrary.EVINCE);
    }

    public int getDaysUntilExpire(UpdateHelper.Product product) {
        return switch (product) {
            case UpdateHelper.Product.Breeze -> this.getDaysUntilExpire(ExtClassLoader.LicenseLibrary.BREEZE);
            case UpdateHelper.Product.BreezeRuntimeClient, UpdateHelper.Product.BreezeRuntime, UpdateHelper.Product.BreezeRuntimeDemo -> Math.max(this.getDaysUntilExpire(ExtClassLoader.LicenseLibrary.BREEZE), this.getDaysUntilExpire(ExtClassLoader.LicenseLibrary.BREEZEAPI));
            default -> this.getDaysUntilExpire(ExtClassLoader.LicenseLibrary.EVINCE);
        };
    }

    public int getDaysUntilExpire(ExtClassLoader.LicenseLibrary licenseLibrary) {
        Item item = this.getItem(licenseLibrary);
        if (item != null) {
            long l = item.expired;
            long l2 = System.currentTimeMillis();
            long l3 = l - l2;
            return (int)Math.ceil((double)l3 / 1000.0 / 3600.0 / 24.0);
        }
        return 0;
    }

    public Item getEvinceLicense() {
        return this.getItem(ExtClassLoader.LicenseLibrary.EVINCE);
    }

    public Item getItem(ExtClassLoader.LicenseLibrary licenseLibrary) {
        for (Item item : this.libLicenses) {
            if (item.library != licenseLibrary) continue;
            return item;
        }
        return null;
    }

    public boolean hasItem(ExtClassLoader.LicenseLibrary licenseLibrary) {
        return this.getItem(licenseLibrary) != null;
    }

    public String getName() {
        return this.name;
    }

    public boolean hasAllLibrariesExpired(boolean bl) {
        for (Item item : this.libLicenses) {
            if (this.hasLibraryExpired(item.library) || !bl && item.type == LicenseType.FREE) continue;
            return false;
        }
        return true;
    }

    public boolean hasLibraryExpired(ExtClassLoader.LicenseLibrary licenseLibrary) {
        if (this.demolicense) {
            return false;
        }
        Item item = this.getItem(licenseLibrary);
        if (item != null) {
            return System.currentTimeMillis() > item.expired;
        }
        return true;
    }

    public boolean isLicenseTooOld() {
        if (this.created > 0L) {
            try {
                SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyyMMdd");
                Date date = simpleDateFormat.parse("20150101");
                return date.getTime() > this.created;
            }
            catch (ParseException parseException) {
                // empty catch block
            }
        }
        return false;
    }

    public boolean hasLicenseExpired() {
        if (RegInfo.isRecordFeature()) {
            return false;
        }
        return this.hasAllLibrariesExpired(true);
    }

    public boolean isDemoLicense() {
        return this.demolicense;
    }

    public boolean isEvinceExpired() {
        return this.hasLibraryExpired(ExtClassLoader.LicenseLibrary.EVINCE);
    }

    public boolean isProfessional() {
        return this.professional;
    }

    public boolean isProtected() {
        return this.isprotected;
    }

    public boolean isTrialLicense() {
        Item item = this.getItem(ExtClassLoader.LicenseLibrary.EVINCE);
        return item != null && item.type == LicenseType.TRIAL;
    }

    public boolean matchIp() {
        if (this.ipmask != null && !this.ipmask.equals("*") && !this.ipmask.isEmpty()) {
            String string = UniqueIdManager.getIpNumber();
            if (string != null) {
                for (int i = 0; i < this.ipmask.length(); ++i) {
                    if (this.ipmask.charAt(i) == '*') {
                        return true;
                    }
                    if (this.ipmask.charAt(i) == string.charAt(i)) continue;
                    return false;
                }
                return true;
            }
            return false;
        }
        return true;
    }

    public boolean matchSerial() {
        Object object;
        if (this.serialUAC != null) {
            return UniqueIdManager.matchAllSerial(this.serialUAC);
        }
        if (this.serialUDC != null && !this.serialUDC.equals(object = UniqueIdManager.getHardwareSerial((byte)1))) {
            return false;
        }
        if (this.serialUFC != null && !this.serialUFC.equals((object = UniqueIdManager.getFileNumber())[0])) {
            return false;
        }
        return this.serialUMC == null || this.serialUMC.equals(object = UniqueIdManager.getMacAddress());
    }

    public boolean isUnbound() {
        return RegInfo.coalesce(this.serialUAC, this.serialUDC, this.serialUFC, this.serialUMC) == null;
    }

    private static String coalesce(String ... stringArray) {
        for (String string : stringArray) {
            if (string == null) continue;
            return string;
        }
        return null;
    }

    public String getActiveSerial() {
        if (this.serialUAC != null) {
            return this.serialUAC;
        }
        if (this.serialUDC != null) {
            return this.serialUDC;
        }
        if (this.serialUFC != null) {
            return this.serialUFC;
        }
        if (this.serialUMC != null) {
            return this.serialUMC;
        }
        return UniqueIdManager.getDeviceId();
    }

    public boolean matchVersionDates() {
        Date date = InitClass.getLastVersionDate();
        if (date != null) {
            long l = System.currentTimeMillis() + 86400000L;
            long l2 = date.getTime() - l;
            if (l2 < 0L) {
                return true;
            }
        }
        return false;
    }

    public void setDemoLicense() {
        this.demolicense = true;
        this.features.add(LicenseFeature.Application);
    }

    public void setProtected(boolean bl) {
        this.isprotected = bl;
    }

    public static String getPassiveClaimToken(RegInfo regInfo, String string) {
        try {
            Algorithm algorithm = Algorithm.HMAC256((String)String.valueOf(new char[]{'P', 'm', 'h', '7', '5', '9', 'n', '7', 'k', 'B', 'E', 'a', 'N', 'b', '7', 'j', 'd', 'h', 'c', 'i', 'W', 'r', 'd', 'W', 'W', 'r', 'B', 'E', 'r', 'U', 'u', 'h', '1', 'A', '2', 'F', 'p', 'p', 'K', 'v'}));
            JWTCreator.Builder builder = JWT.create();
            builder.withIssuer("Breeze");
            builder.withExpiresAt(Date.from(Instant.now().plus(48L, ChronoUnit.HOURS)));
            builder.withClaim("uid", Integer.valueOf(regInfo.ID == 0 && regInfo.isFeatureActive(LicenseFeature.HySpexRecorder) ? LicenseFeature.HySpexRecorder.getCode() : regInfo.ID));
            builder.withClaim("lid", Integer.valueOf(regInfo.LID));
            builder.withClaim("uac", string);
            return builder.sign(algorithm);
        }
        catch (JWTCreationException jWTCreationException) {
            return null;
        }
    }

    public static enum LicenseType {
        COMMERCIAL,
        RESEARCH,
        EDUCATION,
        TRIAL,
        FREE,
        NONE;

    }

    public static class Item {
        public ExtClassLoader.LicenseLibrary library;
        public LicenseType type;
        public long expired;

        public Item(ExtClassLoader.LicenseLibrary licenseLibrary, LicenseType licenseType, long l) {
            this.library = licenseLibrary;
            this.type = licenseType;
            this.expired = l;
        }

        public String toString() {
            return String.valueOf((Object)this.library) + " " + String.valueOf((Object)this.type) + " " + this.expired;
        }
    }

    public static enum LicenseFeature {
        Geo(0),
        Record(1),
        CoreScanner(2),
        Application(100),
        HySpexRecorder(4420),
        Industrial(11112);

        public final int code;

        private LicenseFeature(int n2) {
            this.code = n2;
        }

        public static LicenseFeature fromString(String string) {
            if (StringUtils.isNumeric((CharSequence)string)) {
                return LicenseFeature.fromCode(Integer.parseInt(string));
            }
            for (LicenseFeature licenseFeature : LicenseFeature.values()) {
                if (!licenseFeature.toString().equalsIgnoreCase(string)) continue;
                return licenseFeature;
            }
            return null;
        }

        public static LicenseFeature fromCode(int n) {
            for (LicenseFeature licenseFeature : LicenseFeature.values()) {
                if (licenseFeature.code != n) continue;
                return licenseFeature;
            }
            return null;
        }

        public int getCode() {
            return this.code;
        }
    }

    public static enum LicenseRange {
        SINGLE,
        GROUP,
        SITE;

    }
}

