/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.map.register;

import java.io.File;
import java.nio.charset.StandardCharsets;
import java.security.InvalidKeyException;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.security.Signature;
import java.security.SignatureException;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.X509EncodedKeySpec;
import javax.swing.JOptionPane;
import se.prediktera.map.common.error.Logg;
import se.prediktera.map.common.update.UpdateHelper;
import se.prediktera.map.main.IniManager;
import se.prediktera.map.register.IniFileReader;
import se.prediktera.map.register.RegInfo;

public class RegisterKeyManager {
    public static boolean umbiolicense = false;
    public static final String publicKeyString = "l8N0t2YV1lX17dXW8uBD440B26l724NV0p{UI5N7q9G@HyiHRv2wZUjyGRgJxxDG0Bh7{0diGOHP5q5FX4qzOqIYNe{k5MkjlN{nQL5QM7tD0r1Ck9kOVSwPO2KeZzucdIlTF8XlEiQfMw{i6k1zwRqu6YfeKx01wEdyIMh73AFCJCWLL4eBrMsxjjHNMgnwnAn0OpOp85lm2J10M26JELm8AlhhHbgVXjDWA0ELRJk01680s7Dd5Pybytynxj@MrVwKub7akjgzvdjVuU5IApo12TLJOSaYvHSLEOTR70GV0HQHL4s8do4@LBmiEcVBBXheWoY5vi8Kxq8@VEfgThnhbLMZjCvUAdU8q8LxwAbT1FnDBIPxzXPJFb8f3zStPKzc68uXbu5VwKK9Z50Iwt{o9en01L8024NV0hTy1hBMXzz12h7FD33rLGYxxSkoil050kPbDkK{1{Y1J3ZVCPu{YZJm4PtkJZm30qaYh@JIUS@5V1zYmN9o{c6f1SejThy5ccHLrFrhQlsRxg{W2uxb@huRIrzWWdfz@T1KcedGX9BfHHEc7GoLr2WDQrYZyjY5BrqhHMdBxUy7";
    public static final String publicKeyStringTrial = "l8N0s2YV1lX17dXW8uBD440B26l724NV0p{UI5N7q9G@HyiHRv2wZUjyGRgJxxDG0Bh7{0diGOHP5q5FX4qzOqIYNe{k5MkjlN{nQL5QM7tD0r1Ck9kOVSwPO2KeZzucdIlTF8XlEiQfMw{i6k1zwRqu6YfeKx01wEdyIMh73AFCJCWLL4eBrMsxjjHNMgnwnAn0OpOp85lm2J10M26JELm8AlhhHbgVXjDWA0ELRJk01680s7Dd5Pybytynxj@MrVwKub7akjgzvdjVuU5IApo12TLJOSaYvHSLEOTR70GV0HQHL4s8do4@LBmiEcVBBXheWoY5vi8Kxq8@VEfgThnhbLMZjCvUAdU8q8LxwAbT1FnDBIPxzXPJFb8f3zStPKzc68uXbu5VwKK9Z50Iwt{o9en01H80248VvtN3L04U{eEJlTYumq0onVBx1nFHDSwnkmSbpc7e16lPsVk@A0krpt9Ohzd{M3GWyp7dtOaUfzUcRV6GB5p8@0kZYqj@r9ZxaeDlUyjqLEnku0yniCS6ovxq196wj7ZIbZpotEsU8gQHxhXNleXj{mBLSbSbSu{jIdlM@3jpmN0";
    public static RegInfo regInfo;
    private final UpdateHelper.Product product;
    private static String[] developers;

    public RegisterKeyManager(UpdateHelper.Product product) {
        this.product = product;
    }

    public static String convertKeyToText(byte[] byArray) {
        byte[] byArray2 = new byte[byArray.length * 2];
        int n = 0;
        int n2 = 0;
        for (byte by : byArray) {
            for (int i = 0; i < 8; ++i) {
                int n3 = n;
                byArray2[n3] = (byte)(byArray2[n3] | (byte)((by >> i & 1) << n2));
                if (++n2 != 6) continue;
                RegisterKeyManager.byteEscape(byArray2, n);
                n2 = 0;
                ++n;
            }
        }
        if (n2 != 0) {
            RegisterKeyManager.byteEscape(byArray2, n);
            ++n;
        }
        return new String(byArray2, 0, n, StandardCharsets.ISO_8859_1);
    }

    private static void byteEscape(byte[] byArray, int n) {
        int n2 = byArray[n];
        n2 = n2 >= 37 ? 97 + n2 - 37 : (n2 >= 10 ? 64 + n2 - 10 : (n2 += 48));
        byArray[n] = (byte)n2;
    }

    public static byte[] convertTextToKey(String string) {
        byte[] byArray = new byte[string.length()];
        byte[] byArray2 = string.getBytes(StandardCharsets.ISO_8859_1);
        int n = 0;
        int n2 = 0;
        for (int n3 : byArray2) {
            int n4 = n3;
            int n5 = n4;
            n5 = n5 >= 97 ? n5 + 37 - 97 : (n5 >= 64 ? n5 + 10 - 64 : (n5 -= 48));
            n4 = (byte)n5;
            for (int i = 0; i < 6; ++i) {
                int n6 = n++;
                byArray[n6] = (byte)(byArray[n6] | (byte)((n4 >> i & 1) << n2));
                if (++n2 != 8) continue;
                n2 = 0;
            }
        }
        byte[] byArray3 = new byte[n];
        System.arraycopy(byArray, 0, byArray3, 0, n);
        return byArray3;
    }

    public static String getAlgorithm() {
        return "DSA";
    }

    public static RegInfo getRegInfo() {
        if (regInfo == null) {
            RegisterKeyManager.setDemoLicense();
        }
        return regInfo;
    }

    public static boolean isPredikteraDevelopmentLicense() {
        if (umbiolicense && regInfo != null && regInfo.getCompany() != null && regInfo.getName() != null) {
            String string = regInfo.getCompany().toLowerCase();
            String string2 = regInfo.getName().toLowerCase();
            return string.startsWith("prediktera") && RegisterKeyManager.contains(string2, developers);
        }
        return false;
    }

    public static boolean isPredikteraLicense() {
        return umbiolicense && RegisterKeyManager.usingPredikteraLicense();
    }

    public static boolean usingPredikteraDevelopmentLicense() {
        return RegisterKeyManager.usingPredikteraDevelopmentLicense(developers);
    }

    public static boolean usingPredikteraDevelopmentLicense(String ... stringArray) {
        if (regInfo != null && regInfo.getCompany() != null && regInfo.getName() != null) {
            String string = regInfo.getCompany().toLowerCase();
            String string2 = regInfo.getName().toLowerCase();
            return string.startsWith("prediktera") && RegisterKeyManager.contains(string2, stringArray);
        }
        return false;
    }

    private static boolean contains(String string, String ... stringArray) {
        for (String string2 : stringArray) {
            if (!string.startsWith(string2)) continue;
            return true;
        }
        return false;
    }

    public static boolean usingPredikteraLicense() {
        if (regInfo != null && regInfo.getCompany() != null) {
            String string = regInfo.getCompany().toLowerCase();
            return string.startsWith("prediktera");
        }
        return true;
    }

    public static String processString(String string) {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) < '!' || string.charAt(i) >= '\u007f') continue;
            stringBuilder.append(string.charAt(i));
        }
        return stringBuilder.toString().replace("<br>", "");
    }

    public static String processString2(String string) {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) < '!' || string.charAt(i) >= '\u00ff') continue;
            stringBuilder.append(string.charAt(i));
        }
        return stringBuilder.toString().replace("<br>", "");
    }

    public static void setDemoLicense() {
        regInfo = new RegInfo();
        regInfo.setDemoLicense();
    }

    public static void setHySpexRecorderLicense() {
        if (regInfo != null) {
            throw new IllegalStateException("License already set");
        }
        regInfo = new RegInfo();
        RegisterKeyManager.regInfo.features.add(RegInfo.LicenseFeature.Record);
        RegisterKeyManager.regInfo.features.add(RegInfo.LicenseFeature.HySpexRecorder);
    }

    public static boolean VerifyString(String string, String string2, String string3) {
        try {
            KeyFactory keyFactory = KeyFactory.getInstance(RegisterKeyManager.getAlgorithm());
            byte[] byArray = RegisterKeyManager.convertTextToKey(string3);
            X509EncodedKeySpec x509EncodedKeySpec = new X509EncodedKeySpec(byArray);
            PublicKey publicKey = keyFactory.generatePublic(x509EncodedKeySpec);
            Signature signature = Signature.getInstance(publicKey.getAlgorithm());
            signature.initVerify(publicKey);
            String string4 = RegisterKeyManager.processString(string);
            String string5 = RegisterKeyManager.processString2(string);
            signature.update(string4.getBytes(), 0, string4.length());
            byte[] byArray2 = RegisterKeyManager.convertTextToKey(string2);
            boolean bl = signature.verify(byArray2);
            signature.update(string5.getBytes(), 0, string5.length());
            return bl || signature.verify(byArray2);
        }
        catch (InvalidKeyException | NoSuchAlgorithmException | SignatureException | InvalidKeySpecException generalSecurityException) {
            return false;
        }
    }

    public boolean parseRegAndVerifyInfoFile() {
        File file = IniManager.getEvinceSettingsFile("license.key");
        if (!file.exists()) {
            if (this.product == UpdateHelper.Product.Breeze) {
                try {
                    if (IniFileReader.getInstance().isCameraInstalled("HySpex SDK")) {
                        RegisterKeyManager.setHySpexRecorderLicense();
                        return true;
                    }
                }
                catch (Exception exception) {
                    Logg.debug(exception.getMessage(), new Object[0]);
                }
            }
            return false;
        }
        regInfo = new RegInfo(file);
        if (RegisterKeyManager.verifyRegInfo(regInfo)) {
            return true;
        }
        JOptionPane.showConfirmDialog(null, "The license file doesn't contain the correct signature\nContact license@prediktera.se for assistance.", "Verification failed", -1, 0, null);
        return false;
    }

    public static boolean verifyRegInfo(RegInfo regInfo) {
        if (regInfo != null) {
            if (regInfo.created > System.currentTimeMillis()) {
                return false;
            }
            if (regInfo.signature != null) {
                if (RegisterKeyManager.VerifyString(regInfo.regtext, regInfo.signature, publicKeyString)) {
                    return true;
                }
                if (regInfo.isTrialLicense()) {
                    return RegisterKeyManager.VerifyString(regInfo.regtext, regInfo.signature, publicKeyStringTrial);
                }
            }
        }
        return false;
    }

    static {
        developers = new String[]{"oskar", "thomas", "erik", "david"};
    }
}

