/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.map.register;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Random;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.SystemUtils;
import org.json.JSONObject;
import se.prediktera.map.common.error.Logg;
import se.prediktera.map.common.swing.filechooser.StringTools;
import se.prediktera.map.main.IniManager;
import se.prediktera.map.main.RESTInvoker;
import se.prediktera.map.register.RegInfo;
import se.prediktera.map.register.RegisterKeyManager;
import se.prediktera.map.register.VerifyDeviceIdHelper;

public class UniqueIdManager {
    public static final byte MOTHERBOARD = 0;
    public static final byte DRIVE = 1;
    public static boolean useHardwareUacs = true;
    private static String allUAC;
    private static String oneUAC;
    private static String deviceID;
    private static Path exePath;

    public static String generateUniqueId() {
        if (allUAC == null) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("Breeze and Evince Activation Codes\n");
            String string = UniqueIdManager.getDeviceId();
            stringBuilder.append("DeviceId: ").append(string).append("\n");
            stringBuilder.append("UAC: ").append(UniqueIdManager.getHardwareSerial((byte)0)).append("\n");
            stringBuilder.append("UDC: ").append(UniqueIdManager.getHardwareSerial((byte)1)).append("\n");
            String[] stringArray = UniqueIdManager.getFileNumber();
            assert (stringArray != null);
            if (stringArray[0].equals(stringArray[1])) {
                stringBuilder.append("UFC: ").append(stringArray[0]).append("\n");
            } else {
                stringBuilder.append("UFC1: ").append(stringArray[0]).append("\n");
                stringBuilder.append("UFC2: ").append(stringArray[1] != null ? stringArray[1] : "N/A").append("\n");
            }
            String string2 = UniqueIdManager.getMacAddress();
            stringBuilder.append("UMC: ").append(string2 != null ? string2 : "N/A").append("\n");
            RegInfo regInfo = RegisterKeyManager.getRegInfo();
            stringBuilder.append("TOKEN: ").append(RegInfo.getPassiveClaimToken(regInfo, string)).append("\n");
            stringBuilder.append("USER_ID: ").append(regInfo.ID).append("\n");
            stringBuilder.append("LICENSE_ID: ").append(regInfo.LID).append("\n");
            String string3 = UniqueIdManager.getIpNumber();
            stringBuilder.append("IP: ").append(string3 != null ? string3.trim() : "N/A").append("\n");
            stringBuilder.append("OS: ").append(System.getProperty("os.name")).append("\n");
            stringBuilder.append("Version: ").append(System.getProperty("os.version"));
            allUAC = stringBuilder.toString();
        }
        return allUAC;
    }

    public static String generateOneUniqueId() {
        if (oneUAC == null) {
            if (useHardwareUacs) {
                String[] stringArray = UniqueIdManager.getDeviceId();
                if (UniqueIdManager.validUAC((String)stringArray)) {
                    oneUAC = stringArray;
                    return stringArray;
                }
                String string = UniqueIdManager.getHardwareSerial((byte)0);
                if (UniqueIdManager.validUAC(string)) {
                    oneUAC = string;
                    return oneUAC;
                }
                String string2 = UniqueIdManager.getHardwareSerial((byte)1);
                if (UniqueIdManager.validUAC(string2)) {
                    oneUAC = string2;
                    return oneUAC;
                }
                String string3 = UniqueIdManager.getMacAddress();
                if (UniqueIdManager.validUAC(string3)) {
                    oneUAC = string3;
                    return oneUAC;
                }
            }
            for (String string3 : UniqueIdManager.getFileNumber()) {
                if (!UniqueIdManager.validUAC(string3)) continue;
                oneUAC = string3;
                return oneUAC;
            }
            oneUAC = "";
        }
        return oneUAC;
    }

    public static boolean matchAllSerial(String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(UniqueIdManager.getDeviceId());
        arrayList.add(UniqueIdManager.getHardwareSerial((byte)0));
        arrayList.add(UniqueIdManager.getHardwareSerial((byte)1));
        arrayList.add(UniqueIdManager.getMacAddress());
        String[] stringArray = UniqueIdManager.getFileNumber();
        if (stringArray != null) {
            arrayList.addAll(Arrays.asList(stringArray));
        }
        arrayList.removeIf(StringUtils::isEmpty);
        return arrayList.stream().anyMatch(string2 -> string2.equals(string));
    }

    private static boolean validUAC(String string) {
        return string != null && string.length() > 5 && !string.contains(" ");
    }

    public static String[] getFileNumber() {
        try {
            File file = new File(IniManager.getIdFile());
            if (file.exists()) {
                Random random = new Random(file.lastModified());
                String string = String.valueOf(random.nextInt());
                string = RegisterKeyManager.convertKeyToText(string.getBytes());
                string = string.toUpperCase();
                BufferedReader bufferedReader = new BufferedReader(new FileReader(file));
                String string2 = bufferedReader.readLine();
                bufferedReader.close();
                return new String[]{string, string2};
            }
            if (file.createNewFile()) {
                Random random = new Random(file.lastModified());
                String string = String.valueOf(random.nextInt());
                string = RegisterKeyManager.convertKeyToText(string.getBytes());
                string = string.toUpperCase();
                BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(file));
                bufferedWriter.write(string);
                bufferedWriter.flush();
                bufferedWriter.close();
                return new String[]{string, string};
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    public static void doCheckSumValidation(File file) {
        try {
            String string;
            if (SystemUtils.IS_OS_WINDOWS) {
                string = "8E5F4C5D039BE8A98A9F389340CF2A8C8E25C5F6121B53FDEFCE6B4C098F405F";
            } else if (SystemUtils.IS_OS_LINUX) {
                string = "9E5CEDC1192B7981D8217A2DE023E80D059B5198A79ED75BB613986D9A186C2F";
            } else if (SystemUtils.IS_OS_MAC_OSX) {
                string = "C4A9CA953939DE80E772813CB44E49477681EC1B7AF917B53E12B264B1180100";
            } else {
                throw new RuntimeException("Failed to identify OS");
            }
            try (FileInputStream fileInputStream = new FileInputStream(file);){
                if (!DigestUtils.sha256Hex((InputStream)fileInputStream).equalsIgnoreCase(string)) {
                    throw new RuntimeException("Checksum validation failed");
                }
            }
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
    }

    public static String getDeviceId() {
        String string;
        BufferedReader bufferedReader;
        Object object;
        if (deviceID != null) {
            return deviceID;
        }
        StringBuilder stringBuilder = new StringBuilder();
        Path path = UniqueIdManager.getExePath();
        if (path != null && path.toFile().exists()) {
            try {
                object = new ProcessBuilder(path.toAbsolutePath().toString()).start();
            }
            catch (IOException iOException) {
                Logg.error("Failed to create DeviceId", iOException);
                return null;
            }
            try {
                bufferedReader = new BufferedReader(new InputStreamReader(((Process)object).getInputStream()));
                try {
                    while ((string = bufferedReader.readLine()) != null) {
                        stringBuilder.append(string);
                    }
                }
                finally {
                    bufferedReader.close();
                }
            }
            catch (IOException iOException) {
                Logg.error("Failed to create DeviceId", iOException);
            }
        } else {
            Logg.error("Device Id not found: " + String.valueOf(path), new Object[0]);
            throw new RuntimeException("Device Id could not be determined");
        }
        object = stringBuilder.toString();
        if (StringTools.startsWith((CharSequence)object, "{") && StringTools.endsWith((CharSequence)object, "}")) {
            String string2;
            bufferedReader = new JSONObject((String)object);
            string = bufferedReader.getString("hardwareId");
            if (!VerifyDeviceIdHelper.verifyData(string, string2 = bufferedReader.getString("signature"))) {
                throw new RuntimeException("Device Id could not be verified");
            }
            deviceID = string;
            return deviceID;
        }
        Logg.warn("Legacy Device Id format", new Object[0]);
        deviceID = object;
        return deviceID;
    }

    private static synchronized Path getExePath() {
        if (exePath != null) {
            return exePath;
        }
        try {
            Path path = Paths.get(UniqueIdManager.class.getProtectionDomain().getCodeSource().getLocation().toURI()).getParent();
            Logg.trace("rootPath: " + String.valueOf(path), new Object[0]);
            boolean bl = path.getParent().resolve("ReleaseScripts").toFile().exists();
            Path path2 = bl ? path.getParent().resolve("ReleaseScripts").resolve("Windows") : (path.endsWith("Lib") ? path.resolveSibling("Runtime") : path.resolve("Lib"));
            if (SystemUtils.IS_OS_WINDOWS) {
                exePath = path2.resolve("PredikteraDeviceId.exe");
            } else if (SystemUtils.IS_OS_LINUX) {
                exePath = path2.resolve("PredikteraDeviceId");
            } else if (SystemUtils.IS_OS_MAC_OSX) {
                Path path3 = path.resolve("Runtime");
                if (Files.exists(path3, new LinkOption[0])) {
                    path = path3;
                }
                exePath = path.resolve("PredikteraDeviceId");
            }
        }
        catch (Exception exception) {
            Logg.error("Cannot resolve file:", exception);
        }
        return exePath;
    }

    public static String getHardwareSerial(byte by) {
        StringBuilder stringBuilder = new StringBuilder();
        try {
            String string;
            File file = File.createTempFile("realhowto", ".vbs");
            file.deleteOnExit();
            FileWriter fileWriter = new FileWriter(file);
            String string2 = "";
            if (by == 0) {
                string2 = "Set objWMIService = GetObject(\"winmgmts:\\\\.\\root\\cimv2\")\nSet colItems = objWMIService.ExecQuery _ \n   (\"Select * from Win32_BaseBoard\") \nFor Each objItem in colItems \n    Wscript.Echo objItem.SerialNumber \n    exit for  ' do the first cpu only! \nNext \n";
            } else if (by == 1) {
                string2 = "Set objFSO = CreateObject(\"Scripting.FileSystemObject\")\nSet colDrives = objFSO.Drives\nSet objDrive = colDrives.item(\"C\")\nWscript.Echo objDrive.SerialNumber";
            }
            fileWriter.write(string2);
            fileWriter.close();
            Process process = new ProcessBuilder("cscript", "//NoLogo", file.getPath()).start();
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(process.getInputStream()));
            while ((string = bufferedReader.readLine()) != null) {
                stringBuilder.append(string);
            }
            bufferedReader.close();
        }
        catch (Exception exception) {
            return "N/A";
        }
        return stringBuilder.toString().trim();
    }

    public static String getIpNumber() {
        try {
            return RESTInvoker.getInstance().getIPrequest();
        }
        catch (Exception exception) {
            return "N/A";
        }
    }

    public static String getMacAddress() {
        try {
            Process process = new ProcessBuilder("getmac /fo csv /nh").start();
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(process.getInputStream()));
            String string = bufferedReader.readLine();
            String[] stringArray = string.split(",");
            return stringArray[0].replace("\"", "").replace("-", "").trim();
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static void main(String[] stringArray) {
        System.out.println("DeviceId: " + UniqueIdManager.getDeviceId());
    }

    private UniqueIdManager() {
    }
}

