/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.map.register;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.math.BigInteger;
import java.nio.charset.StandardCharsets;
import java.security.GeneralSecurityException;
import java.security.KeyFactory;
import java.security.PublicKey;
import java.security.Signature;
import java.security.spec.X509EncodedKeySpec;
import java.util.Arrays;
import java.util.Base64;
import se.prediktera.map.common.error.Logg;

public class VerifyDeviceIdHelper {
    private static final String EC_PUBLIC = "MFkwEwYHKoZIzj0CAQYIKoZIzj0DAQcDQgAEY0JcOmx/Rq3CEuFIcKgWyRishxFoWpI4LwvHL2JA5QTBzzOVsFG1EMEFEhJHkYxCsvTmsfJU1hboG3Dl0YkC7w==";

    public static boolean verifyData(String string, String string2) {
        try {
            byte[] byArray = string.getBytes(StandardCharsets.UTF_8);
            byte[] byArray2 = Base64.getDecoder().decode(string2);
            byte[] byArray3 = VerifyDeviceIdHelper.convertToDER(byArray2);
            PublicKey publicKey = VerifyDeviceIdHelper.loadPublicKeyFromPem();
            Signature signature = Signature.getInstance("SHA256withECDSA");
            signature.initVerify(publicKey);
            signature.update(byArray);
            return signature.verify(byArray3);
        }
        catch (Exception exception) {
            Logg.warn("Failed to verify data", exception);
            return false;
        }
    }

    private static byte[] convertToDER(byte[] byArray) throws GeneralSecurityException {
        int n = byArray.length / 2;
        BigInteger bigInteger = new BigInteger(1, Arrays.copyOfRange(byArray, 0, n));
        BigInteger bigInteger2 = new BigInteger(1, Arrays.copyOfRange(byArray, n, byArray.length));
        return VerifyDeviceIdHelper.derEncode(bigInteger, bigInteger2);
    }

    private static byte[] derEncode(BigInteger bigInteger, BigInteger bigInteger2) throws GeneralSecurityException {
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
            dataOutputStream.write(48);
            ByteArrayOutputStream byteArrayOutputStream2 = new ByteArrayOutputStream();
            DataOutputStream dataOutputStream2 = new DataOutputStream(byteArrayOutputStream2);
            VerifyDeviceIdHelper.writeDerInteger(dataOutputStream2, bigInteger);
            VerifyDeviceIdHelper.writeDerInteger(dataOutputStream2, bigInteger2);
            byte[] byArray = byteArrayOutputStream2.toByteArray();
            dataOutputStream.write(byArray.length);
            dataOutputStream.write(byArray);
            return byteArrayOutputStream.toByteArray();
        }
        catch (IOException iOException) {
            throw new GeneralSecurityException("Failed to DER-encode signature", iOException);
        }
    }

    private static void writeDerInteger(DataOutputStream dataOutputStream, BigInteger bigInteger) throws IOException {
        byte[] byArray = bigInteger.toByteArray();
        dataOutputStream.write(2);
        dataOutputStream.write(byArray.length);
        dataOutputStream.write(byArray);
    }

    private static PublicKey loadPublicKeyFromPem() throws GeneralSecurityException {
        byte[] byArray = Base64.getDecoder().decode(EC_PUBLIC);
        X509EncodedKeySpec x509EncodedKeySpec = new X509EncodedKeySpec(byArray);
        KeyFactory keyFactory = KeyFactory.getInstance("EC");
        return keyFactory.generatePublic(x509EncodedKeySpec);
    }
}

