/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.map.register.wizard;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.io.IOException;
import java.nio.file.Files;
import javax.swing.JButton;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.filechooser.FileNameExtensionFilter;
import org.apache.commons.lang3.SystemUtils;
import se.prediktera.map.common.swing.filechooser.jopensaveDialog;
import se.prediktera.map.common.update.UpdateHelper;
import se.prediktera.map.register.RegInfo;
import se.prediktera.map.register.RegisterKeyManager;
import se.prediktera.map.register.wizard.RegisterWizard;
import se.prediktera.map.register.wizard.swing.RegisterPage;

public class ActiveFromTextPage
extends RegisterPage {
    private final JTextArea textAreaLicense = new JTextArea();

    public ActiveFromTextPage(RegisterWizard registerWizard) {
        super(registerWizard, "Activate license from text");
        JButton jButton = new JButton("Paste from clipboard");
        jButton.setPreferredSize(new Dimension(120, 30));
        jButton.setActionCommand("Paste from clipboard");
        jButton.setMargin(new Insets(2, 2, 2, 2));
        jButton.addActionListener(actionEvent -> {
            this.textAreaLicense.setText("");
            this.textAreaLicense.paste();
            this.textAreaLicense.setText(this.FormatText(this.textAreaLicense.getText()));
        });
        JButton jButton2 = new JButton("Open .txt Prediktera License File");
        jButton2.setPreferredSize(new Dimension(220, 30));
        jButton2.setMargin(new Insets(2, 2, 2, 2));
        jButton2.addActionListener(actionEvent -> {
            jopensaveDialog jopensaveDialog2 = new jopensaveDialog("Prediktera License File", registerWizard);
            FileNameExtensionFilter fileNameExtensionFilter = new FileNameExtensionFilter("Text License File (*.txt)", "txt");
            jopensaveDialog2.setFileFilter(fileNameExtensionFilter);
            if (jopensaveDialog2.openshow()) {
                this.textAreaLicense.setText("");
                try {
                    this.textAreaLicense.setText(this.FormatText(Files.readString(jopensaveDialog2.getSelectedFile().toPath())));
                }
                catch (IOException iOException) {
                    throw new RuntimeException(iOException);
                }
            }
        });
        this.textAreaLicense.setFont(new Font("Dialog", 0, 11));
        this.textAreaLicense.setText("");
        this.textAreaLicense.setLineWrap(false);
        this.textAreaLicense.setWrapStyleWord(false);
        this.textAreaLicense.getDocument().addDocumentListener(this.getChangeListener());
        this.textAreaLicense.setName("activeFromTextTextArea");
        int n = 0;
        this.add((Component)this.createInformationText("Before you can continue, you must verify the license text that you received from Prediktera. Paste the license text into the field below or open the .txt file and press Finish"), new GridBagConstraints(0, n++, 1, 1, 1.0, 0.0, 10, 1, new Insets(12, 12, 0, 12), 0, 0));
        this.add((Component)jButton, new GridBagConstraints(0, n, 1, 1, 0.0, 0.0, 17, 0, new Insets(12, 12, 0, 0), 0, 0));
        this.add((Component)jButton2, new GridBagConstraints(0, n++, 1, 1, 0.0, 0.0, 17, 0, new Insets(12, SystemUtils.IS_OS_WINDOWS ? 150 : 200, 3, 0), 0, 0));
        JScrollPane jScrollPane = new JScrollPane(this.textAreaLicense);
        jScrollPane.setHorizontalScrollBarPolicy(31);
        this.add((Component)jScrollPane, new GridBagConstraints(0, n, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 12, 12, 12), 0, 0));
    }

    @Override
    public boolean canNext() {
        return !this.textAreaLicense.getText().isEmpty();
    }

    @Override
    public boolean finishedPressed() {
        return this.getWizard().activateLicense(this.textAreaLicense.getText());
    }

    public String FormatText(String string) {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '\r') continue;
            stringBuilder.append(string.charAt(i));
        }
        return stringBuilder.toString().replace("<br>", "\n");
    }

    @Override
    public boolean nextPressed() {
        return this.finishedPressed();
    }

    @Override
    public void pageShown() {
        RegInfo regInfo = this.getWizard().getCurrentRegInfo();
        new RegisterKeyManager(UpdateHelper.Product.Evince);
        this.textAreaLicense.setText("");
        if (regInfo.regtext != null && regInfo.signature != null && !regInfo.signature.isEmpty()) {
            this.textAreaLicense.setText(this.FormatText(regInfo.regtextWithSignature));
            this.textAreaLicense.select(0, 0);
        }
    }
}

