/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.map.register.wizard;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import javax.swing.SwingUtilities;
import se.prediktera.map.common.error.Logg;
import se.prediktera.map.main.RESTInvoker;
import se.prediktera.map.register.RegInfo;
import se.prediktera.map.register.UniqueIdManager;
import se.prediktera.map.register.wizard.RegisterWizard;
import se.prediktera.map.register.wizard.swing.RegisterLabel;
import se.prediktera.map.register.wizard.swing.RegisterPage;
import se.prediktera.map.register.wizard.swing.RegisterPasswordField;
import se.prediktera.map.register.wizard.swing.RegisterTextField;

public class ActiveLoginPage
extends RegisterPage {
    private final RegisterTextField usernameTextfield = new RegisterTextField(this);
    private final RegisterPasswordField passwordTextfield = new RegisterPasswordField(this);

    public ActiveLoginPage(RegisterWizard registerWizard) {
        super(registerWizard, "Activate license by login");
        int n = 0;
        GridBagConstraints gridBagConstraints = new GridBagConstraints(0, n++, 1, 1, 1.0, 0.0, 10, 1, new Insets(12, 12, 0, 12), 0, 0);
        this.add((Component)this.createInformationText("Before you can continue, you must login.\nPlease enter your username or email and password and press Finish"), gridBagConstraints);
        gridBagConstraints = new GridBagConstraints(0, n++, 1, 1, 1.0, 0.0, 18, 0, new Insets(12, 12, 0, 0), 0, 0);
        this.add((Component)new RegisterLabel("Username or email"), gridBagConstraints);
        Insets insets = new Insets(6, 12, 0, 12);
        gridBagConstraints = new GridBagConstraints(0, n++, 2, 1, 0.0, 0.0, 18, 2, insets, 0, 0);
        this.add((Component)this.usernameTextfield, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints(0, n++, 1, 1, 0.0, 0.0, 18, 0, insets, 0, 0);
        this.add((Component)new RegisterLabel("Password"), gridBagConstraints);
        gridBagConstraints = new GridBagConstraints(0, n++, 1, 1, 0.0, 1.0, 18, 2, insets, 0, 0);
        this.add((Component)this.passwordTextfield, gridBagConstraints);
    }

    @Override
    public boolean backPressed() {
        return true;
    }

    @Override
    public boolean canNext() {
        return !this.usernameTextfield.getText().isEmpty() && this.passwordTextfield.getPassword().length > 0;
    }

    @Override
    public boolean finishedPressed() {
        return this.getWizard().activateLicense(RESTInvoker.postServer(this, () -> RESTInvoker.getInstance().getLicenseText(this.usernameTextfield.getText(), new String(this.passwordTextfield.getPassword()), ActiveLoginPage.getUac((RegisterWizard)this.wizard))));
    }

    @Override
    public boolean handleFocus() {
        return true;
    }

    @Override
    public boolean nextPressed() {
        return this.finishedPressed();
    }

    @Override
    public void pageShown() {
        SwingUtilities.invokeLater(this.usernameTextfield::requestFocus);
    }

    public static String getUac(RegisterWizard registerWizard) {
        RegInfo regInfo = registerWizard.getCurrentRegInfo();
        if (regInfo != null && regInfo.serialUAC != null && !regInfo.serialUAC.isEmpty()) {
            if (UniqueIdManager.matchAllSerial(regInfo.serialUAC)) {
                return regInfo.serialUAC;
            }
            Logg.debug("Not valid uac for getting license by username and password, using default instead", new Object[0]);
        }
        return UniqueIdManager.generateOneUniqueId();
    }
}

