/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.map.register.wizard;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JOptionPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.validator.routines.EmailValidator;
import se.prediktera.map.common.update.UpdateHelper;
import se.prediktera.map.main.RESTInvoker;
import se.prediktera.map.register.IniFileReader;
import se.prediktera.map.register.PasswordGenerator;
import se.prediktera.map.register.RegInfo;
import se.prediktera.map.register.UniqueIdManager;
import se.prediktera.map.register.wizard.RegisterWizard;
import se.prediktera.map.register.wizard.swing.RegisterComboBox;
import se.prediktera.map.register.wizard.swing.RegisterLabel;
import se.prediktera.map.register.wizard.swing.RegisterPage;
import se.prediktera.map.register.wizard.swing.RegisterTextField;

public class CreateTrialPage
extends RegisterPage {
    public static List<String> INTERESTS = List.of("Laboratory", "Industrial", "Field", "UAV", "Airborne", "Drill core", "Other");
    private final RegisterTextField emailTextField = new RegisterTextField(this);
    private final RegisterTextField firstNameTextField = new RegisterTextField(this);
    private final RegisterTextField lastNameTextField = new RegisterTextField(this);
    private final RegisterTextField organisationTextField = new RegisterTextField(this);
    private final JTextField cameraTextField = new JTextField();
    private final RegisterComboBox areaOfInterestComboBox = new RegisterComboBox(this, INTERESTS);
    private boolean chooseFeatureAvailable;

    public CreateTrialPage(RegisterWizard registerWizard) {
        super(registerWizard, "");
        this.setTitle("Activate 30 days Free Trial" + (registerWizard.getProduct() == UpdateHelper.Product.Breeze ? " (1 of 2)" : ""));
        this.cameraTextField.setFont(this.cameraTextField.getFont().deriveFont(14.0f));
        int n = 0;
        this.add((Component)this.createInformationText("Register an account to activate your 30 days Free Trial."), new GridBagConstraints(0, n++, 1, 1, 1.0, 0.0, 10, 1, new Insets(12, 12, 12, 12), 0, 0));
        this.add((Component)new RegisterLabel("First name*"), new GridBagConstraints(0, n++, 1, 1, 1.0, 0.0, 18, 0, new Insets(12, 12, 0, 0), 0, 0));
        this.add((Component)this.firstNameTextField, new GridBagConstraints(0, n++, 2, 1, 0.0, 0.0, 18, 2, new Insets(6, 12, 0, 12), 0, 0));
        this.add((Component)new RegisterLabel("Last name*"), new GridBagConstraints(0, n++, 1, 1, 1.0, 0.0, 18, 0, new Insets(12, 12, 0, 0), 0, 0));
        this.add((Component)this.lastNameTextField, new GridBagConstraints(0, n++, 2, 1, 0.0, 0.0, 18, 2, new Insets(6, 12, 0, 12), 0, 0));
        this.add((Component)new RegisterLabel("Organisation*"), new GridBagConstraints(0, n++, 1, 1, 1.0, 0.0, 18, 0, new Insets(12, 12, 0, 0), 0, 0));
        this.add((Component)this.organisationTextField, new GridBagConstraints(0, n++, 2, 1, 0.0, 0.0, 18, 2, new Insets(6, 12, 0, 12), 0, 0));
        this.add((Component)new RegisterLabel("Email*"), new GridBagConstraints(0, n++, 1, 1, 1.0, 0.0, 18, 0, new Insets(12, 12, 0, 0), 0, 0));
        this.add((Component)this.emailTextField, new GridBagConstraints(0, n++, 2, 1, 0.0, 0.0, 18, 2, new Insets(6, 12, 0, 12), 0, 0));
        this.add((Component)new RegisterLabel("Area of interest*"), new GridBagConstraints(0, n++, 1, 1, 1.0, 0.0, 18, 0, new Insets(12, 12, 0, 0), 0, 0));
        this.add((Component)this.areaOfInterestComboBox, new GridBagConstraints(0, n++, 2, 1, 0.0, 1.0, 18, 2, new Insets(6, 12, 0, 12), 0, 0));
        if (registerWizard.getProduct() == UpdateHelper.Product.Breeze && IniFileReader.getInstance().isNoExternalCamera()) {
            this.add((Component)new RegisterLabel("Enter camera - or leave empty if not applicable"), new GridBagConstraints(0, n++, 1, 1, 1.0, 0.0, 18, 0, new Insets(12, 12, 0, 0), 0, 0));
            this.add((Component)this.cameraTextField, new GridBagConstraints(0, n++, 2, 1, 0.0, 2.0, 18, 2, new Insets(6, 12, 0, 12), 0, 0));
        }
        JTextArea jTextArea = this.createInformationText("All fields are required.\n\nThe email must not already be associated with an existing account.");
        this.add((Component)jTextArea, new GridBagConstraints(0, n++, 1, 1, 1.0, 0.0, 10, 1, new Insets(12, 12, 12, 12), 0, 0));
    }

    @Override
    public boolean canNext() {
        return !StringUtils.isEmpty((CharSequence)this.emailTextField.getText()) && !StringUtils.isEmpty((CharSequence)this.firstNameTextField.getText()) && !StringUtils.isEmpty((CharSequence)this.lastNameTextField.getText()) && !StringUtils.isEmpty((CharSequence)this.organisationTextField.getText()) && this.areaOfInterestComboBox.isValidSelection();
    }

    @Override
    public boolean canFinish() {
        return !this.chooseFeatureAvailable && this.canNext();
    }

    @Override
    public boolean nextPressed() {
        if (this.chooseFeatureAvailable) {
            return this.validatePage();
        }
        return this.finishedPressed();
    }

    @Override
    public boolean finishedPressed() {
        return this.activateLicense(new ArrayList<RegInfo.LicenseFeature>());
    }

    public boolean activateLicense(List<RegInfo.LicenseFeature> list) {
        if (!this.validatePage()) {
            return false;
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        if (this.getWizard().getProduct() == UpdateHelper.Product.Breeze) {
            IniFileReader iniFileReader = IniFileReader.getInstance();
            if (iniFileReader.isNoExternalCamera() && StringUtils.isNotBlank((CharSequence)this.cameraTextField.getText())) {
                arrayList.add(this.cameraTextField.getText());
            } else if (!iniFileReader.isNoExternalCamera()) {
                arrayList.addAll(iniFileReader.getInstalledCamerasWithoutBuiltin());
            }
        }
        return this.getWizard().activateLicense(RESTInvoker.postServer(this, () -> RESTInvoker.getInstance().createLicense(this.firstNameTextField.getText(), this.lastNameTextField.getText(), this.emailTextField.getText(), this.organisationTextField.getText(), PasswordGenerator.generateOfLength(12), UniqueIdManager.generateOneUniqueId(), CreateTrialPage.getFeatures(list), new String[]{(String)this.areaOfInterestComboBox.getSelectedItem()}, arrayList.toArray(new String[0]), this.getWizard().getProduct())));
    }

    private static String getFeatures(List<RegInfo.LicenseFeature> list) {
        StringBuffer stringBuffer = new StringBuffer();
        for (RegInfo.LicenseFeature licenseFeature : list) {
            if (!stringBuffer.isEmpty()) {
                stringBuffer.append(";");
            }
            stringBuffer.append(licenseFeature.code);
        }
        return stringBuffer.toString();
    }

    private boolean validatePage() {
        if (!EmailValidator.getInstance().isValid(this.emailTextField.getText())) {
            JOptionPane.showConfirmDialog(this, "Email address not valid", "Information", -1, 0, null);
            return false;
        }
        return this.areaOfInterestComboBox.isValidSelection();
    }

    @Override
    public void pageShown() {
        SwingUtilities.invokeLater(this.emailTextField::requestFocus);
    }

    public void chooseFeatureAvailable(boolean bl) {
        this.chooseFeatureAvailable = bl;
    }
}

