/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.map.register.wizard;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import se.prediktera.map.InitClass;
import se.prediktera.map.common.update.UpdateHelper;
import se.prediktera.map.common.wizard.AbstractWizard;
import se.prediktera.map.common.wizard.WizardDialog;
import se.prediktera.map.common.wizard.WizardFrame;
import se.prediktera.map.common.wizard.WizardPageClass;
import se.prediktera.map.main.Evince;
import se.prediktera.map.main.IniManager;
import se.prediktera.map.register.RegInfo;
import se.prediktera.map.register.RegKeyParserException;
import se.prediktera.map.register.RegisterKeyManager;
import se.prediktera.map.register.UniqueIdManager;
import se.prediktera.map.register.wizard.ActiveCodePage;
import se.prediktera.map.register.wizard.ActiveFromTextPage;
import se.prediktera.map.register.wizard.ActiveLoginPage;
import se.prediktera.map.register.wizard.CreateTrialPage;
import se.prediktera.map.register.wizard.RegisterFirstPage;
import se.prediktera.map.register.wizard.TrialFeaturePage;
import se.prediktera.map.register.wizard.UniqueIdPage;
import se.prediktera.map.register.wizard.swing.RegisterPage;

public class RegisterWizard
extends AbstractWizard {
    private final JLabel titleLabel = new JLabel();
    private final RegisterFirstPage page1;
    private final CreateTrialPage createTrialPage;
    private final ActiveLoginPage loginPage;
    private final ActiveCodePage codePage;
    private final ActiveFromTextPage verifyTrialPage;
    private final UniqueIdPage uniqueIdPage;
    private RegInfo curRegInfo;
    private UpdateHelper.Product product;
    private UpdateHelper.UpdateVersion version = InitClass.getEvinceVersion();

    public RegisterWizard(RegInfo regInfo) {
        this(regInfo, UpdateHelper.Product.Evince);
    }

    public RegisterWizard(RegInfo regInfo, UpdateHelper.Product product) {
        super("RegisterWizard");
        this.curRegInfo = regInfo;
        this.product = product;
        this.page1 = new RegisterFirstPage(this);
        this.createTrialPage = new CreateTrialPage(this);
        this.loginPage = new ActiveLoginPage(this);
        this.codePage = new ActiveCodePage(this);
        this.verifyTrialPage = new ActiveFromTextPage(this);
        this.uniqueIdPage = new UniqueIdPage(this);
        this.addPage(this.page1, "Welcome");
        JPanel jPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(10, 15, 10, 0);
        ImageIcon imageIcon = new ImageIcon(this.getClass().getResource("/images/logo/predikteraRegister.png"));
        jPanel.add((Component)new JLabel(imageIcon), gridBagConstraints);
        this.titleLabel.setText("Test");
        this.titleLabel.setFont(new Font(this.getFont().getFontName(), 0, 20));
        GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.gridx = 1;
        gridBagConstraints2.weightx = 1.0;
        gridBagConstraints2.weighty = 1.0;
        gridBagConstraints2.insets = new Insets(12, 20, 10, 20);
        gridBagConstraints2.anchor = 17;
        jPanel.add((Component)this.titleLabel, gridBagConstraints2);
        jPanel.setBackground(Color.white);
        jPanel.setBorder(BorderFactory.createMatteBorder(1, 0, 1, 0, Color.lightGray));
        this.add((Component)jPanel, "North");
    }

    public boolean backPressedProtected() {
        int n;
        if (this.curRegInfo.isProtected() && (n = JOptionPane.showConfirmDialog(this, "If you go back from this page you may have to reenter the license key\nand redo the verification!\nDo you want to continue?", "Warning!", 0, 2, null)) == 1) {
            return false;
        }
        this.curRegInfo.setProtected(false);
        return true;
    }

    @Override
    public void beginWizard() {
        if (this.curRegInfo != null) {
            this.page1.setDefaultPage();
        } else {
            this.curRegInfo = new RegInfo();
        }
    }

    public UpdateHelper.Product getProduct() {
        return this.product;
    }

    public UpdateHelper.UpdateVersion getVersion() {
        return this.version;
    }

    @Override
    public boolean canFinish() {
        return (this.currentPage == null || this.currentPage.canFinish()) && !this.isFirstPage();
    }

    public int executeWizard(Frame frame, UpdateHelper.Product product, UpdateHelper.UpdateVersion updateVersion) {
        this.product = product;
        this.version = updateVersion;
        this.init();
        this.wizardWindow = new WizardDialog(frame, "License Wizard", this, null, true, false, false);
        return this.wizardWindow.executeWizard();
    }

    @Override
    public int executeWizard() {
        return this.executeWizard(IniManager.getMainFrame(), UpdateHelper.Product.Evince, InitClass.getEvinceVersion());
    }

    public int executeWizardFrame(UpdateHelper.Product product) {
        this.product = product;
        this.init();
        this.wizardWindow = new WizardFrame("License Wizard", this, null, product, true, false, false, true);
        return this.wizardWindow.executeWizard();
    }

    private void init() {
        this.setPreferredSize(new Dimension(520, 550));
    }

    public RegInfo getCurrentRegInfo() {
        return this.curRegInfo;
    }

    @Override
    public String getDescription() {
        return "Evince License";
    }

    @Override
    public ImageIcon getIcon() {
        return null;
    }

    public void setCurrentRegInfo(RegInfo regInfo) {
        this.curRegInfo = regInfo;
    }

    @Override
    protected String getHelpID() {
        return "evinceLicense";
    }

    @Override
    protected void pageChangedLocal(WizardPageClass wizardPageClass, int n) {
        if (n == 0 && this.page1 != null) {
            this.removePagesKeepOne();
            switch (this.page1.createWizardType()) {
                case Trial: {
                    this.addPage(this.createTrialPage, "30 days Free Trial");
                    if (this.product.equals((Object)UpdateHelper.Product.Breeze)) {
                        this.createTrialPage.chooseFeatureAvailable(true);
                        this.addPage(new TrialFeaturePage(this, this.createTrialPage), "30 days Free Trial");
                        break;
                    }
                    this.createTrialPage.chooseFeatureAvailable(false);
                    break;
                }
                case Login: {
                    this.addPage(this.loginPage, "Login Page");
                    break;
                }
                case ActivationCode: {
                    this.addPage(this.codePage, "Activation Code");
                    break;
                }
                case Text: {
                    this.addPage(this.verifyTrialPage, "Verify Page");
                    break;
                }
                case GenerateId: {
                    this.addPage(this.uniqueIdPage, "Unique Page");
                    break;
                }
            }
        }
    }

    @Override
    public void updateTitle() {
        RegisterPage registerPage = (RegisterPage)this.getCurrentPage();
        if (registerPage != null) {
            this.titleLabel.setText(registerPage.getTitle());
        }
        super.updateTitle();
    }

    public boolean activateLicense(String string) {
        if (string != null) {
            if (this.verifyAndActivateLicense(string)) {
                if (this.curRegInfo.hasLicenseExpired()) {
                    JOptionPane.showConfirmDialog(this, "The license is expired", "Expired", -1, 0, null);
                    return false;
                }
                if (!this.curRegInfo.matchSerial()) {
                    JOptionPane.showConfirmDialog(this, "The license does not contain this device's identification code", "Invalid device id", -1, 0, null);
                    return false;
                }
                if (!this.curRegInfo.matchIp()) {
                    JOptionPane.showConfirmDialog(this, "Your IP address is not within the range of the IP specified in your license\nIf your IP is within range, Please check that your computer is connected to Internet and try again", "IP not in range", -1, 0, null);
                    return false;
                }
                JOptionPane.showConfirmDialog(this, "Your license is now activated!\n\nPlease restart " + String.valueOf((Object)this.product) + " again manually", "License activation successful", -1, 1, null);
                this.getCurrentRegInfo().save(IniManager.getEvinceSettingsFile("license.key"));
                UpdateHelper.Product.getRunningProduct().exit();
                return true;
            }
            JOptionPane.showConfirmDialog(this, "The signature is incorrect!\nPlease check that the signature is correctly written and try again", "Incorrect Signature", -1, 0, null);
        }
        return false;
    }

    private boolean verifyAndActivateLicense(String string) {
        try {
            RegInfo regInfo = new RegInfo(string);
            if (RegisterKeyManager.verifyRegInfo(regInfo)) {
                this.setCurrentRegInfo(regInfo);
                return true;
            }
        }
        catch (RegKeyParserException regKeyParserException) {
            regKeyParserException.printStackTrace();
            JOptionPane.showConfirmDialog(this, "Error in license! Please contact Prediktera on license@prediktera.se", "License error", -1, 0, null);
        }
        return false;
    }

    public static void main(String[] stringArray) {
        UniqueIdManager.useHardwareUacs = false;
        Evince.initNoShow();
        RegisterKeyManager registerKeyManager = new RegisterKeyManager(UpdateHelper.Product.Evince);
        registerKeyManager.parseRegAndVerifyInfoFile();
        RegInfo regInfo = RegisterKeyManager.getRegInfo();
        RegisterWizard registerWizard = new RegisterWizard(regInfo);
        registerWizard.executeWizardFrame(UpdateHelper.Product.Evince);
        ((JFrame)((Object)registerWizard.getWizardWindow())).setDefaultCloseOperation(3);
    }
}

