/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.map.register.wizard.swing;

import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Desktop;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.MouseEvent;
import java.io.InputStream;
import java.net.URI;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.plaf.basic.BasicCheckBoxUI;

public final class BreezeFeatureCheckBox
extends JCheckBox {
    private static final Font FEATURE_FONT = BreezeFeatureCheckBox.loadFont();
    private final Icon featureIcon;
    private final Icon helpIcon;
    private Rectangle helpBounds;
    private final String helpUrl;
    private boolean allowSelection = true;

    public BreezeFeatureCheckBox(String string, Color color, String string2) {
        super(string);
        this.featureIcon = new FeatureIcon(color);
        this.helpIcon = new ImageIcon(this.getClass().getResource("/images/material/open_in_browser.png"));
        this.helpUrl = string2;
        this.setUI(new LeftIconCheckBoxUI());
        this.setFont(FEATURE_FONT);
        this.setOpaque(false);
        this.enableEvents(32L);
        this.setFocusable(false);
    }

    public void setAllowSelection(boolean bl) {
        this.allowSelection = bl;
    }

    @Override
    protected void processMouseMotionEvent(MouseEvent mouseEvent) {
        if (this.helpBounds != null && this.helpBounds.contains(mouseEvent.getPoint())) {
            this.setCursor(Cursor.getPredefinedCursor(12));
        } else {
            this.setCursor(Cursor.getDefaultCursor());
        }
        super.processMouseMotionEvent(mouseEvent);
    }

    @Override
    public void doClick() {
        if (this.allowSelection) {
            super.doClick();
        }
    }

    @Override
    public void setSelected(boolean bl) {
        if (this.allowSelection) {
            super.setSelected(bl);
        }
    }

    private static Font loadFont() {
        try {
            InputStream inputStream = BreezeFeatureCheckBox.class.getResourceAsStream("/fonts/ProximaNova-Semibold.otf");
            if (inputStream != null) {
                Font font = Font.createFont(0, inputStream);
                return font.deriveFont(16.0f);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return new Font("SansSerif", 1, 16);
    }

    @Override
    protected void processMouseEvent(MouseEvent mouseEvent) {
        Point point = mouseEvent.getPoint();
        if (this.helpBounds != null && this.helpBounds.contains(point)) {
            if (mouseEvent.getID() == 500 && this.helpUrl != null && !this.helpUrl.isBlank() && Desktop.isDesktopSupported()) {
                try {
                    Desktop.getDesktop().browse(URI.create(this.helpUrl));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return;
        }
        if (!(this.allowSelection || mouseEvent.getID() != 501 && mouseEvent.getID() != 502 && mouseEvent.getID() != 500)) {
            return;
        }
        super.processMouseEvent(mouseEvent);
    }

    public static final class FeatureIcon
    implements Icon {
        private final Color color;
        private final int size;

        public FeatureIcon(Color color) {
            this.color = color;
            this.size = 14;
        }

        @Override
        public int getIconWidth() {
            return this.size;
        }

        @Override
        public int getIconHeight() {
            return this.size;
        }

        @Override
        public void paintIcon(Component component, Graphics graphics, int n, int n2) {
            Graphics2D graphics2D = (Graphics2D)graphics.create();
            graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            FontMetrics fontMetrics = component.getFontMetrics(component.getFont());
            int n3 = fontMetrics != null ? fontMetrics.getAscent() : this.size;
            int n4 = Math.max(0, (n3 - this.size) / 2);
            int n5 = n2 + n4;
            graphics2D.setColor(this.color);
            graphics2D.fillOval(n, n5, this.size, this.size);
            graphics2D.dispose();
        }
    }

    private final class LeftIconCheckBoxUI
    extends BasicCheckBoxUI {
        private LeftIconCheckBoxUI() {
        }

        @Override
        public void paint(Graphics graphics, JComponent jComponent) {
            BreezeFeatureCheckBox breezeFeatureCheckBox = (BreezeFeatureCheckBox)jComponent;
            Graphics2D graphics2D = (Graphics2D)graphics.create();
            graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            FontMetrics fontMetrics = jComponent.getFontMetrics(jComponent.getFont());
            Icon icon = this.getDefaultIcon();
            int n = icon.getIconWidth();
            int n2 = icon.getIconHeight();
            int n3 = jComponent.getHeight();
            icon.paintIcon(jComponent, graphics2D, 0, (n3 - n2) / 2);
            int n4 = breezeFeatureCheckBox.featureIcon.getIconWidth();
            int n5 = breezeFeatureCheckBox.featureIcon.getIconHeight();
            int n6 = fontMetrics.getAscent() + fontMetrics.getDescent();
            int n7 = n + 8;
            int n8 = (n3 - n6) / 2 + (fontMetrics.getAscent() - n5) / 2;
            breezeFeatureCheckBox.featureIcon.paintIcon(jComponent, graphics2D, n7, n8);
            int n9 = n7 + n4 + 4;
            int n10 = (n3 + fontMetrics.getAscent() - fontMetrics.getDescent()) / 2;
            graphics2D.setColor(jComponent.getForeground());
            graphics2D.drawString(breezeFeatureCheckBox.getText(), n9, n10);
            if (breezeFeatureCheckBox.helpUrl != null && !breezeFeatureCheckBox.helpUrl.isBlank()) {
                int n11 = fontMetrics.stringWidth(breezeFeatureCheckBox.getText());
                int n12 = n9 + n11 + 6;
                int n13 = BreezeFeatureCheckBox.this.helpIcon.getIconHeight();
                int n14 = (n3 - n13) / 2;
                BreezeFeatureCheckBox.this.helpIcon.paintIcon(jComponent, graphics2D, n12, n14);
                breezeFeatureCheckBox.helpBounds = new Rectangle(n12, n14, BreezeFeatureCheckBox.this.helpIcon.getIconWidth(), n13);
            } else {
                breezeFeatureCheckBox.helpBounds = null;
            }
            graphics2D.dispose();
        }

        @Override
        public Dimension getPreferredSize(JComponent jComponent) {
            BreezeFeatureCheckBox breezeFeatureCheckBox = (BreezeFeatureCheckBox)jComponent;
            FontMetrics fontMetrics = jComponent.getFontMetrics(jComponent.getFont());
            Icon icon = this.getDefaultIcon();
            int n = icon.getIconWidth();
            int n2 = icon.getIconHeight();
            int n3 = BreezeFeatureCheckBox.this.featureIcon.getIconWidth();
            int n4 = BreezeFeatureCheckBox.this.featureIcon.getIconHeight();
            int n5 = fontMetrics.stringWidth(breezeFeatureCheckBox.getText());
            int n6 = fontMetrics.getHeight();
            int n7 = n + 8 + n3 + 4 + n5;
            int n8 = Math.max(n2, Math.max(n4, n6));
            if (BreezeFeatureCheckBox.this.helpUrl != null && !BreezeFeatureCheckBox.this.helpUrl.isBlank()) {
                n7 += 6 + BreezeFeatureCheckBox.this.helpIcon.getIconWidth();
                n8 = Math.max(n8, BreezeFeatureCheckBox.this.helpIcon.getIconHeight());
            }
            return new Dimension(n7 + 6, n8 + 6);
        }
    }
}

