/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.map.simpletableeditor;

import java.awt.Color;
import java.awt.geom.GeneralPath;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.Properties;
import java.util.StringTokenizer;
import se.prediktera.map.common.MapProperty;
import se.prediktera.map.common.RandomInputStream;
import se.prediktera.map.common.RandomOutputStream;
import se.prediktera.map.common.error.ErrorHandler;
import se.prediktera.map.common.progress.ProgressManager;
import se.prediktera.map.common.progress.ProgressManagerImpl;
import se.prediktera.map.common.update.UpdateHelper;
import se.prediktera.map.dataimport.AbstractImportInfo;
import se.prediktera.map.dataimport.FastDecimal;
import se.prediktera.map.dataimport.MvInfo;
import se.prediktera.map.dataimport.breeze.Interleave;
import se.prediktera.map.datasetcontainer.dataset.DataSet;
import se.prediktera.map.datasetcontainer.matrix.AbstractBasicMatrix;
import se.prediktera.map.datasetcontainer.matrix.AbstractDataMatrix;
import se.prediktera.map.datasetcontainer.matrix.DataTypeInterface;
import se.prediktera.map.main.Main_GUI;
import se.prediktera.map.main.StatusBar;
import se.prediktera.map.main.script.AbstractScriptInfo;
import se.prediktera.map.main.script.ScriptHelper;
import se.prediktera.map.model.AbstractModel;
import se.prediktera.map.model.modelgenerator.AbstractModelInfo;
import se.prediktera.map.simpletableeditor.CMModifierInterface;
import se.prediktera.map.simpletableeditor.CellIdentifier;
import se.prediktera.map.simpletableeditor.ExtendTableModel;
import se.prediktera.map.simpletableeditor.ShiftClass;

public abstract class CellIdentifierModel
extends ExtendTableModel
implements CellIdentifier,
DataTypeInterface,
AutoCloseable {
    private static final int ID_TEXT = 0;
    private static final int ID_EMPTY = 20;
    private static final int ID_MISSING = 100;
    private static final int ID_DATA = 250;
    private static final int[] ID_LIST = new int[]{0, 100, 250, 20};
    private byte[][] identifier = new byte[3][];
    public int dKp;
    public int dNp;
    public int dKc;
    public int dNr;
    public String dataSetName;
    public boolean createQuickTable = true;
    public boolean createDatasetTable = false;
    public AbstractModelInfo modelComponent = null;
    private AbstractScriptInfo script;
    private int primObs = -1;
    private int primVar = -1;
    private boolean valid = false;
    private final boolean[] missingCheck = new boolean[4];
    private boolean[][] mvboolMatrix;
    private double other;
    protected boolean isdatasource = false;
    protected boolean isdatasourcematrix = false;
    private boolean calibrated = false;
    private boolean replaceMissingWithMedian = false;
    protected ArrayList<ShiftClass> shiftArray = new ArrayList();
    protected int dataType = UpdateHelper.Product.isRunningProductEvince() ? 5 : 4;
    protected boolean unsigned = true;
    private AbstractModel calibrationModel;
    private final int[] resolution = new int[]{1, 1, 1};
    private AbstractImportInfo importInfo;
    protected ArrayList<SelectionPath> pathList = new ArrayList();
    private boolean forceMultiLayer;

    public static Color getColorByType(int n) {
        return CellIdentifierModel.getColorByType(n, false);
    }

    public static Color getColorByType(int n, boolean bl) {
        return switch (n) {
            case -2 -> colorMissing;
            case 0 -> {
                if (bl) {
                    yield colorVarIdPrimary;
                }
                yield colorVarId;
            }
            case 1 -> {
                if (bl) {
                    yield colorObsIdPrimary;
                }
                yield colorObsId;
            }
            case 3 -> colorCategory;
            case 4 -> colorData;
            case 5 -> colorSmile;
            case 6 -> colorDNA;
            case 7 -> colorRNA;
            case 8 -> colorAA;
            case 9 -> colorText;
            case 10 -> colorDataY;
            case 14 -> colorDataImage;
            case 15 -> colorProjectLink;
            case 11 -> Color.white;
            case 16 -> colorDescriptor;
            default -> Color.lightGray;
        };
    }

    private static int getID(int n) {
        int n2 = 0;
        int n3 = 9999999;
        for (int i = 0; i < ID_LIST.length; ++i) {
            int n4 = ID_LIST[i] - n;
            if ((n4 *= n4) >= n3) continue;
            n2 = i;
            n3 = n4;
        }
        return n2;
    }

    private static boolean isImage(FastDecimal fastDecimal) {
        String string = fastDecimal.getString();
        int n = string.lastIndexOf(".");
        if (n > 0) {
            String string2 = string.substring(n + 1).toLowerCase();
            return string2.equals("gif") || string2.equals("jpg") || string2.equals("png") || string2.equals("tif");
        }
        return false;
    }

    private static boolean isLink(FastDecimal fastDecimal) {
        String string = fastDecimal.getString();
        int n = string.lastIndexOf(".");
        if (n > 0) {
            String string2 = string.substring(n + 1).toLowerCase();
            return string2.equals("map") || string2.equals("raw") || string2.equals("xml");
        }
        return false;
    }

    private static boolean isSmile(FastDecimal fastDecimal) {
        double d = 0.0;
        int n = fastDecimal.getSize();
        for (int i = 0; i < n; ++i) {
            byte by = fastDecimal.getByteAt(i);
            if (by != 99 && by != 67) continue;
            d += 1.0;
        }
        if (d > 1.0) {
            return d / (double)n > 0.3;
        }
        return false;
    }

    public CellIdentifierModel(int n, int n2) {
        super(n, n2, false);
        this.clear(true);
    }

    public CellIdentifierModel(RandomInputStream randomInputStream, MapProperty mapProperty) throws IOException {
        super(randomInputStream, mapProperty);
        this.replaceMissingWithMedian = mapProperty.getPropertyBoolean("replmm");
        this.isdatasource = mapProperty.getPropertyBoolean("ds");
        this.isdatasourcematrix = mapProperty.getPropertyBoolean("dsm");
        int n = mapProperty.getPropertyInt("shs");
        for (int i = 0; i < n; ++i) {
            mapProperty.setPrefix(String.valueOf(i));
            this.shiftArray.add(ShiftClass.load(mapProperty));
        }
        mapProperty.setPrefix("");
        this.dataType = mapProperty.getPropertyInt("dtype");
        this.unsigned = mapProperty.getPropertyBoolean("unsigned", true);
    }

    public void addColumnAt(int n, int n2) {
        super.setColumnCount(this.getColumnCount() + n2);
        if (this.identifier[1] != null) {
            byte[] byArray = new byte[this.getColumnCount()];
            System.arraycopy(this.identifier[1], 0, byArray, 0, n);
            Arrays.fill(byArray, n, n + n2, (byte)4);
            System.arraycopy(this.identifier[1], n, byArray, n + n2, this.identifier[1].length - n);
            this.identifier[1] = byArray;
            if (n <= this.primObs) {
                this.primObs += n2;
            }
        }
    }

    public void init(ProgressManager progressManager) {
    }

    public void addInterval(int n, int n2, byte by) {
        if (n2 < 0) {
            return;
        }
        if (n == 0 && by == 0 && this.getPrimaryRow() == -1) {
            this.setPrimaryRow(n2);
        }
        if (n == 1 && by == 1 && this.getPrimaryCol() == -1) {
            this.setPrimaryCol(n2);
        }
        if (this.identifier[n] == null && by != 4) {
            if (n == 0) {
                int n3 = this.getRowCount();
                this.identifier[0] = new byte[n3];
                for (int i = 0; i < n3; ++i) {
                    this.identifier[0][i] = 4;
                }
            } else if (n == 1) {
                int n4 = this.getColumnCount();
                this.identifier[1] = new byte[n4];
                for (int i = 0; i < n4; ++i) {
                    this.identifier[1][i] = 4;
                }
            } else {
                int n5 = this.getLayerCount();
                this.identifier[2] = new byte[n5];
                for (int i = 0; i < n5; ++i) {
                    this.identifier[2][i] = 4;
                }
            }
        }
        if (this.identifier[n] != null && n2 < this.identifier[n].length) {
            this.identifier[n][n2] = by;
        }
    }

    public void addPostModifier(CMModifierInterface cMModifierInterface) {
    }

    public void addRowAt(int n, int n2) {
        super.setRowCount(this.getRowCount() + n2);
        if (this.identifier[0] != null) {
            byte[] byArray = new byte[this.getRowCount()];
            System.arraycopy(this.identifier[0], 0, byArray, 0, n);
            Arrays.fill(byArray, n, n + n2, (byte)4);
            System.arraycopy(this.identifier[0], n, byArray, n + n2, this.identifier[0].length - n);
            this.identifier[0] = byArray;
            if (n <= this.primVar) {
                this.primVar += n2;
            }
        }
    }

    public void addShiftClass(ShiftClass shiftClass) {
        this.shiftArray.add(shiftClass);
    }

    public int analyzeLayer() {
        int n = 0;
        int n2 = this.getLayerCount();
        for (int i = 0; i < n2; ++i) {
            if (this.getLayerType(i) < 4) continue;
            ++n;
        }
        return n;
    }

    public int analyzeObs() {
        int n = 0;
        this.dNp = 0;
        this.dNr = -1;
        int n2 = this.getRowCount();
        for (int i = 0; i < n2; ++i) {
            if (this.getRowType(i) < 4) continue;
            if (this.dNr == -1) {
                this.dNr = i;
            }
            ++this.dNp;
            if (!this.isRowTypeData(i)) continue;
            ++n;
        }
        return n;
    }

    public int analyzeVar() {
        int n = 0;
        this.dKp = 0;
        this.dKc = -1;
        int n2 = this.getColumnCount();
        for (int i = 0; i < n2; ++i) {
            if (this.getColumnType(i) < 4) continue;
            if (this.dKc == -1) {
                this.dKc = i;
            }
            ++this.dKp;
            if (!this.isColumnTypeData(i)) continue;
            ++n;
        }
        return n;
    }

    public void applyModifier(ProgressManager progressManager, AbstractDataMatrix abstractDataMatrix) {
    }

    public void autoIdentifyData(ProgressManager progressManager, int n) {
        this.autoIdentifyData(progressManager, n, null);
    }

    public void autoIdentifyData(ProgressManager progressManager, final int n, final Properties properties) {
        if (this.isMultiLayer()) {
            return;
        }
        if (progressManager != null) {
            this.autoIdentifyDataLocal(progressManager, n, properties);
        } else {
            ProgressManagerImpl progressManagerImpl = new ProgressManagerImpl(this){
                final /* synthetic */ CellIdentifierModel this$0;
                {
                    this.this$0 = cellIdentifierModel;
                }

                @Override
                public Object doWork() {
                    this.this$0.autoIdentifyDataLocal(this, n, properties);
                    this.Finish();
                    return null;
                }
            };
            progressManagerImpl.invokeNow();
        }
    }

    public void checkAndRemoveZeroVariance(ProgressManager progressManager) {
        ArrayList<Integer> arrayList = this.checkZeroVariance(progressManager);
        if (!arrayList.isEmpty()) {
            if (progressManager != null) {
                // empty if block
            }
            Main_GUI.setStatusMessage(StatusBar.MessageType.INFORMATION, "One or more variables with zero variance have been excluded", 10);
            this.removeZeroVariance(arrayList);
        }
    }

    public boolean checkMissing(int n, int n2, FastDecimal fastDecimal, int n3) {
        if (n != -1 && this.mvboolMatrix != null && this.mvboolMatrix[n][n2] || fastDecimal.isEmpty()) {
            return true;
        }
        if (this.missingCheck[1] && fastDecimal.getValue() == this.other) {
            return true;
        }
        return (n3 == 4 || n3 == 10 || n3 == 16) && fastDecimal.isMissing();
    }

    public boolean checkMissing(int n, int n2, String string, int n3) {
        if (this.hasMissing()) {
            this.fastDecimal.parseString(string.getBytes(), (short)string.length());
            return this.checkMissing(n, n2, this.fastDecimal, n3);
        }
        return false;
    }

    public ArrayList<Integer> checkZeroVariance(ProgressManager progressManager) {
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        FastDecimal fastDecimal = new FastDecimal();
        int n = this.getColumnCount();
        int n2 = this.getRowCount();
        if (progressManager != null) {
            progressManager.setInfoText("Performing zero variance check");
            progressManager.setMaximumAndReset(n);
        }
        for (int i = 0; i < n; ++i) {
            if (!this.isTypeData(1, i)) continue;
            boolean bl = true;
            boolean bl2 = false;
            double d = 0.0;
            for (int j = 0; j < n2; ++j) {
                FastDecimal fastDecimal2 = this.getDoubleAt(j, i, fastDecimal);
                if (fastDecimal2.isMissing()) continue;
                double d2 = fastDecimal2.getValue();
                if (bl) {
                    bl = false;
                    d = d2;
                    continue;
                }
                if (Double.compare(d2, d) == 0) continue;
                bl2 = true;
                break;
            }
            if (!bl && !bl2) {
                arrayList.add(i);
            }
            if (progressManager == null) continue;
            progressManager.incStep();
        }
        return arrayList;
    }

    public void clear(boolean bl) {
        this.setPrimaryRow(-1);
        this.setPrimaryCol(-1);
        for (int i = 0; i < 4; ++i) {
            this.missingCheck[i] = false;
        }
        this.identifier[0] = null;
        this.identifier[1] = null;
        this.identifier[2] = null;
        if (bl) {
            this.shiftArray.clear();
        }
    }

    public void closeConnections() {
    }

    public ArrayList<GeneralPath> createGeneralPath() {
        ArrayList<GeneralPath> arrayList = new ArrayList<GeneralPath>();
        if (this.pathList.size() > 0) {
            int[] nArray = this.getConsecutiveNumber((byte)1, (byte)2);
            int[] nArray2 = this.getConsecutiveNumber((byte)0, (byte)2);
            for (SelectionPath selectionPath : this.pathList) {
                GeneralPath generalPath = new GeneralPath();
                for (int i = 0; i < selectionPath.path.length; ++i) {
                    int[] nArray3 = selectionPath.path[i];
                    int n = Math.min(nArray.length - 1, nArray3[0] + selectionPath.sx);
                    int n2 = Math.min(nArray2.length - 1, nArray3[1] + selectionPath.sy);
                    int n3 = nArray[n];
                    n -= n3;
                    int n4 = nArray2[n2];
                    n2 -= n4;
                    if (i == 0) {
                        generalPath.moveTo(n, n2);
                        continue;
                    }
                    generalPath.lineTo(n, n2);
                }
                generalPath.closePath();
                arrayList.add(generalPath);
            }
        }
        return arrayList;
    }

    public boolean[] createIncludedArray() {
        boolean[] blArray = null;
        if (this.identifier[2] != null) {
            int n = this.getLayerCount();
            for (int i = 0; i < n; ++i) {
                if (this.identifier[2][i] != 2) continue;
                if (blArray == null) {
                    blArray = new boolean[n];
                    Arrays.fill(blArray, true);
                }
                blArray[i] = false;
            }
        }
        return blArray;
    }

    public AbstractDataMatrix createSuitableMatrix(int n, int n2) {
        if (this.isMultiLayer() && this.dataType > 4) {
            this.dataType = 4;
        }
        if (this.calibrated && this.dataType < 4) {
            return AbstractBasicMatrix.createMatrix(n, n2, "N/A", 4, this.unsigned);
        }
        return AbstractBasicMatrix.createMatrix(n, n2, "N/A", this.dataType, this.unsigned);
    }

    public void crop(ProgressManager progressManager, File file, int n, int n2, int n3, int n4) throws Exception {
    }

    public void excludeByInsets(String string) {
        int[][] nArray;
        if (string != null && string.length() > 0 && (nArray = CellIdentifierModel.parseIntArray(string)) != null) {
            int n;
            boolean bl = false;
            for (n = 0; n < nArray[0].length; ++n) {
                if (nArray[0][n] <= 0) continue;
                bl = true;
                break;
            }
            if (bl) {
                n = this.getRowCount();
                int n2 = this.getColumnCount();
                int n3 = nArray[0][2];
                int n4 = nArray[0][0];
                int n5 = n2 - nArray[0][3];
                int n6 = n - nArray[0][1];
                SelectionPath selectionPath = new SelectionPath(new int[][]{{n3, n4}, {n5, n4}, {n5, n6}, {n3, n6}});
                this.pathList.add(selectionPath);
                this.includeFromPathList(this.pathList);
            }
        }
    }

    public void excludeByInsets(int[] nArray) {
        if (nArray != null && nArray.length > 0) {
            boolean bl = false;
            for (int n : nArray) {
                if (n <= 0) continue;
                bl = true;
                break;
            }
            if (bl) {
                int n;
                int n2 = this.getRowCount();
                int n3 = this.getColumnCount();
                int n4 = nArray[2];
                n = nArray[0];
                int n5 = n3 - nArray[3];
                int n6 = n2 - nArray[1];
                SelectionPath selectionPath = new SelectionPath(new int[][]{{n4, n}, {n5, n}, {n5, n6}, {n4, n6}});
                this.pathList.add(selectionPath);
                this.includeFromPathList(this.pathList);
            }
        }
    }

    public void excludeBySelectionPath(String string) {
        if (string != null && string.length() > 0) {
            String[] stringArray;
            for (String string2 : stringArray = string.split(";")) {
                this.pathList.add(new SelectionPath(CellIdentifierModel.parseIntArray(string2)));
            }
            this.includeFromPathList(this.pathList);
        }
    }

    public static int[][] parseIntArray(String string) {
        int[][] nArray = null;
        if (string.length() > 0) {
            String[] stringArray = string.split("[\\[\\],]");
            int n = (int)Double.parseDouble(stringArray[1]);
            int n2 = (int)Double.parseDouble(stringArray[2]);
            nArray = new int[n][n2];
            int n3 = 0;
            int n4 = 3;
            while (n4 < stringArray.length) {
                int n5 = n3 / n2;
                int n6 = n3 % n2;
                nArray[n5][n6] = (int)Float.parseFloat(stringArray[n4]);
                ++n4;
                ++n3;
            }
        }
        return nArray;
    }

    public AbstractModel getCalibrationModel() {
        return this.calibrationModel;
    }

    public double getCellVolume() {
        return -1.0;
    }

    public int getColumnType(int n) {
        if (n >= 0 && this.identifier[1] != null && n < this.identifier[1].length) {
            return this.identifier[1][n];
        }
        return 4;
    }

    public int getCount(int n) {
        return switch (n) {
            case 0 -> this.getRowCount();
            case 1 -> this.getColumnCount();
            case 2 -> this.getLayerCount();
            default -> 0;
        };
    }

    public int[] getDataIndex(int n) {
        int n2 = this.getCount(n);
        int n3 = 0;
        for (int i = 0; i < n2; ++i) {
            if (!this.isTypeData(n, i)) continue;
            ++n3;
        }
        int[] nArray = new int[n3];
        int n4 = 0;
        for (int i = 0; i < n2; ++i) {
            if (!this.isTypeData(n, i)) continue;
            nArray[n4++] = i;
        }
        return nArray;
    }

    public int getDataType() {
        return this.dataType;
    }

    public int getDataTypeSize() {
        if (this.isMultiLayer() && (this.dataType > 4 || this.calibrated)) {
            return TYPE_SIZE[4];
        }
        return TYPE_SIZE[this.dataType];
    }

    public int[] getDefaultBand() {
        return null;
    }

    public void setDefaultBand(int[] nArray) {
    }

    public final double getDirectDoubleAt(int n, int n2) {
        if (this.transpose) {
            return this.getDoubleAt_Transpose(n2, n, this.fastDecimal).getValue();
        }
        return this.getDoubleAt_Transpose(n, n2, this.fastDecimal).getValue();
    }

    public final FastDecimal getDirectDoubleAt(int n, int n2, int n3, FastDecimal fastDecimal) {
        this.setCurrentLayer(n3);
        if (this.transpose) {
            return this.getDoubleAt_Transpose(n2, n, fastDecimal);
        }
        return this.getDoubleAt_Transpose(n, n2, fastDecimal);
    }

    public double getDirectDoubleAtNoMissing(int n, int n2) {
        return this.getDirectDoubleAt(n, n2);
    }

    public double getDirectDoubleAtNoMissing(int n, int n2, int n3) {
        this.setCurrentLayer(n3);
        return this.getDirectDoubleAtNoMissing(n, n2);
    }

    public FastDecimal getDirectDoubleAtNoSync(int n, int n2, FastDecimal fastDecimal) {
        double d = this.getDirectDoubleAtNoMissing(n, n2);
        if (Double.isNaN(d)) {
            return fastDecimal.error();
        }
        return fastDecimal.setValue(d);
    }

    @Override
    public FastDecimal getDoubleAt(int n, int n2, FastDecimal fastDecimal) {
        return this.getDoubleAt(n, n2, -1, fastDecimal);
    }

    public synchronized FastDecimal getDoubleAt(int n, int n2, int n3, FastDecimal fastDecimal) {
        if (n3 >= 0) {
            this.setCurrentLayer(n3);
        }
        this.getDoubleAtInternal(n, n2, fastDecimal);
        if (this.isdatasource && this.replaceMissingWithMedian && fastDecimal.isMissing()) {
            int n4;
            FastDecimal fastDecimal2 = new FastDecimal();
            ArrayList<Double> arrayList = new ArrayList<Double>(4);
            for (n4 = n - 1; n4 >= 0; --n4) {
                if (!this.isRowTypeData(n4)) continue;
                this.getDoubleAtInternal(n4, n2, fastDecimal2);
                if (fastDecimal2.isMissing()) break;
                arrayList.add(fastDecimal2.getValue());
                break;
            }
            for (n4 = n + 1; n4 < this.rows; ++n4) {
                if (!this.isRowTypeData(n4)) continue;
                this.getDoubleAtInternal(n4, n2, fastDecimal2);
                if (fastDecimal2.isMissing()) break;
                arrayList.add(fastDecimal2.getValue());
                break;
            }
            for (n4 = n2 - 1; n4 > 0; --n4) {
                if (!this.isColumnTypeData(n4)) continue;
                this.getDoubleAtInternal(n, n4, fastDecimal2);
                if (fastDecimal2.isMissing()) break;
                arrayList.add(fastDecimal2.getValue());
                break;
            }
            for (n4 = n2 + 1; n4 < this.columns; ++n4) {
                if (!this.isColumnTypeData(n4)) continue;
                this.getDoubleAtInternal(n, n4, fastDecimal2);
                if (fastDecimal2.isMissing()) break;
                arrayList.add(fastDecimal2.getValue());
                break;
            }
            if (arrayList.size() == 1) {
                fastDecimal.setValue((Double)arrayList.get(0));
            } else if (arrayList.size() == 2) {
                fastDecimal.setValue(0.5 * ((Double)arrayList.get(0) + (Double)arrayList.get(1)));
            } else if (arrayList.size() > 2) {
                Collections.sort(arrayList);
                if (arrayList.size() == 3) {
                    fastDecimal.setValue((Double)arrayList.get(1));
                } else {
                    fastDecimal.setValue(0.5 * ((Double)arrayList.get(1) + (Double)arrayList.get(2)));
                }
            }
        }
        return fastDecimal;
    }

    public Properties getEnvProperties() {
        return null;
    }

    public AbstractImportInfo getImportInfo() {
        return this.importInfo;
    }

    public Interleave getInterleave() {
        return switch (this.getDataOrder()[0]) {
            case 1 -> Interleave.BIL;
            case 2 -> Interleave.BIP;
            default -> Interleave.BSQ;
        };
    }

    public int getLayerCount() {
        return 1;
    }

    public String getLayerName(int n) {
        return null;
    }

    public String[] getLayerNames() {
        String[] stringArray = new String[this.getLayerCount()];
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray[i] = this.getLayerName(i);
        }
        return stringArray;
    }

    public final int getLayerType(int n) {
        if (n >= 0 && this.identifier[2] != null && n < this.identifier[2].length) {
            return this.identifier[2][n];
        }
        return 4;
    }

    public int getMaskLayer() {
        return -1;
    }

    public int getMaskSampleId() {
        return 0;
    }

    public int[][] getMatrixInfo() {
        int n;
        int[][] nArray = new int[3][2];
        for (n = 0; n < this.getRowCount(); ++n) {
            if (this.isRowTypeData(n)) {
                int[] nArray2 = nArray[0];
                nArray2[0] = nArray2[0] + 1;
                continue;
            }
            if (this.getRowType(n) != 2) continue;
            int[] nArray3 = nArray[0];
            nArray3[1] = nArray3[1] + 1;
        }
        for (n = 0; n < this.getColumnCount(); ++n) {
            if (this.isColumnTypeData(n)) {
                int[] nArray4 = nArray[1];
                nArray4[0] = nArray4[0] + 1;
                continue;
            }
            if (this.getColumnType(n) != 2) continue;
            int[] nArray5 = nArray[1];
            nArray5[1] = nArray5[1] + 1;
        }
        for (n = 0; n < this.getLayerCount(); ++n) {
            if (this.isLayerTypeData(n)) {
                int[] nArray6 = nArray[2];
                nArray6[0] = nArray6[0] + 1;
                continue;
            }
            if (this.getLayerType(n) != 2) continue;
            int[] nArray7 = nArray[2];
            nArray7[1] = nArray7[1] + 1;
        }
        return nArray;
    }

    public Properties getMetaProperties() {
        return null;
    }

    public int[] getMinMax() {
        return null;
    }

    public double getOther() {
        return this.other;
    }

    public ArrayList<SelectionPath> getPathList() {
        return this.pathList;
    }

    public int getPrimaryCol() {
        return this.primObs;
    }

    public int getPrimaryRow() {
        return this.primVar;
    }

    public String getReferenceFileName() {
        return null;
    }

    public String getReferenceCategory(int n) {
        return null;
    }

    public String[] getReferenceCategoryClasses(int n) {
        return null;
    }

    public String[] getReferenceCategoryColor(int n) {
        return null;
    }

    public int getReferenceCategorys() {
        return 0;
    }

    public String getReferenceCategoryValue(int n) {
        return null;
    }

    public String getReferenceName(int n) {
        return null;
    }

    public FastDecimal getReferenceValue(int n, int n2, int n3) {
        return this.getReferenceValue(n, n2, n3, this.fastDecimal);
    }

    public FastDecimal getReferenceValue(int n, int n2, int n3, FastDecimal fastDecimal) {
        return fastDecimal.error();
    }

    public int getReferenceValues() {
        return 0;
    }

    public Properties getRefProperties() {
        return null;
    }

    public int getResolution(int n) {
        return this.resolution[n];
    }

    public File getRootFolder() {
        return null;
    }

    public int getRowType(int n) {
        if (n >= 0 && this.identifier[0] != null && n < this.identifier[0].length) {
            return this.identifier[0][n];
        }
        return 4;
    }

    public double getSaturatedValue() {
        return Double.MAX_VALUE;
    }

    public AbstractScriptInfo getScriptInfo() {
        return this.script;
    }

    public int getType(int n, int n2) {
        int n3 = 4;
        int n4 = 4;
        if (this.identifier[0] != null && n <= this.identifier[0].length) {
            n3 = this.identifier[0][n];
        }
        if (this.identifier[1] != null && n2 <= this.identifier[1].length) {
            n4 = this.identifier[1][n2];
        }
        if (n3 == 2 || n4 == 2) {
            return 2;
        }
        if (n3 == 0 && n4 == 1) {
            return -1;
        }
        if (n3 < 4) {
            return n3;
        }
        return n4;
    }

    public final String getTypeDescription(int n, int n2, Object object) {
        int n3 = this.getType(n, n2);
        if (n3 >= 4 && this.checkMissing(n, n2, (String)object, n3)) {
            return "Missing Value";
        }
        if (n3 == 0 && this.getPrimaryRow() == n) {
            return "Primary Variable Description";
        }
        if (n3 == 1 && this.getPrimaryCol() == n2) {
            return "Primary Observation Description";
        }
        return cdescr[n3 + 1];
    }

    @Override
    public Object getValueAt(int n, int n2) {
        if (this.shiftArray.size() > 0) {
            for (int i = this.shiftArray.size() - 1; i >= 0; --i) {
                ShiftClass shiftClass = this.shiftArray.get(i);
                n2 += shiftClass.shiftX(n, n2);
                ShiftClass.State state = shiftClass.getState();
                if (state == ShiftClass.State.NotAffected) {
                    n += shiftClass.shiftY(n, n2);
                    state = shiftClass.getState();
                }
                if (state != ShiftClass.State.ExactHit) continue;
                return shiftClass.getValue(n, n2);
            }
            if (n2 < 0 || n < 0) {
                return "";
            }
        }
        return super.getValueAt(n, n2);
    }

    public double getVariance(boolean bl, int n) {
        int n2;
        if (bl && this.getColumnType(n) != 4 || !bl && this.getRowType(n) != 4) {
            return -1.0;
        }
        int n3 = n2 = bl ? this.getRowCount() : this.getColumnCount();
        if (n2 <= 1) {
            return 0.0;
        }
        int n4 = 0;
        double d = 0.0;
        double d2 = 0.0;
        ArrayList<FastDecimal> arrayList = new ArrayList<FastDecimal>(n2);
        if (bl) {
            for (var10_8 = 0; var10_8 < n2; ++var10_8) {
                if (this.getType(var10_8, n) != 4) continue;
                var11_10 = this.getDoubleAt(var10_8, n);
                arrayList.add(var11_10);
                d += var11_10.getValue();
                ++n4;
            }
        } else {
            for (var10_8 = 0; var10_8 < n2; ++var10_8) {
                if (this.getType(n, var10_8) != 4) continue;
                var11_10 = this.getDoubleAt(n, var10_8);
                arrayList.add(var11_10);
                d += var11_10.getValue();
                ++n4;
            }
        }
        if (n4 <= 1) {
            return 0.0;
        }
        d /= (double)n4;
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            double d3 = ((FastDecimal)iterator.next()).getValue() - d;
            d2 += d3 * d3;
        }
        return d2 /= (double)(n4 - 1);
    }

    public final boolean hasDataY() {
        int n = this.getColumnCount();
        for (int i = 0; i < n; ++i) {
            if (this.getColumnType(i) != 10) continue;
            return true;
        }
        return false;
    }

    public boolean hasMissing() {
        return true;
    }

    public boolean supportMultiThread() {
        return false;
    }

    public void identifyData(Double[] doubleArray, int n, Double[] doubleArray2, int n2, String string) {
        if (doubleArray != null) {
            for (Double object : doubleArray) {
                this.addInterval(1, object.intValue() - 1, (byte)1);
            }
            if (n != -1) {
                this.setPrimaryCol(n);
            }
        }
        if (doubleArray2 != null) {
            for (Double d : doubleArray2) {
                this.addInterval(0, d.intValue() - 1, (byte)0);
            }
            if (n2 != -1) {
                this.setPrimaryRow(n2);
            }
        }
        if (string != null) {
            StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
            while (stringTokenizer.hasMoreTokens()) {
                try {
                    int n3 = Integer.parseInt(stringTokenizer.nextToken());
                    this.addInterval(1, n3 - 1, (byte)5);
                }
                catch (NumberFormatException numberFormatException) {
                    ErrorHandler.logAndReportException(numberFormatException);
                }
            }
        }
    }

    public void importComplete(ProgressManager progressManager, DataSet dataSet) {
    }

    public boolean isCalibrated() {
        return this.calibrated;
    }

    @Override
    public boolean isCellEditable(int n, int n2) {
        if (this.shiftArray.size() > 0) {
            for (int i = this.shiftArray.size() - 1; i >= 0; --i) {
                ShiftClass shiftClass = this.shiftArray.get(i);
                n2 += shiftClass.shiftX(n, n2);
                ShiftClass.State state = shiftClass.getState();
                if (state == ShiftClass.State.NotAffected) {
                    n += shiftClass.shiftY(n, n2);
                    state = shiftClass.getState();
                }
                if (state != ShiftClass.State.ExactHit) continue;
                return true;
            }
        }
        return false;
    }

    public final boolean isColumnTypeData(int n) {
        int n2 = this.getColumnType(n);
        return n2 == 4 || n2 == 10 || n2 == 16;
    }

    public boolean isDataSource() {
        return this.isdatasource;
    }

    public boolean isDataSourceMatrix() {
        return this.isdatasourcematrix;
    }

    public final boolean isLayerTypeData(int n) {
        int n2 = this.getLayerType(n);
        return n2 == 4;
    }

    public boolean isMissing(int n) {
        return this.missingCheck[n];
    }

    public boolean isMultiImport() {
        return false;
    }

    public boolean isMultiLayer() {
        return this.getLayerCount() > 1 || this.forceMultiLayer;
    }

    public boolean isReplaceMissingWithMedian() {
        return this.replaceMissingWithMedian;
    }

    public final boolean isRowTypeData(int n) {
        int n2 = this.getRowType(n);
        return n2 == 4 || n2 == 10 || n2 == 16;
    }

    public final boolean isTypeData(int n, int n2) {
        if (this.identifier[n] != null && n2 < this.identifier[n].length) {
            return this.identifier[n][n2] == 4 || this.identifier[n][n2] == 10 || this.identifier[n][n2] == 16;
        }
        return true;
    }

    public boolean isValid() {
        return this.valid;
    }

    public ArrayList<MvInfo> mvToleranceCheck(double d, boolean bl) {
        int n;
        int n2;
        if (bl) {
            n2 = this.getColumnCount();
            n = this.analyzeObs();
        } else {
            n2 = this.getRowCount();
            n = this.analyzeVar();
        }
        ArrayList<MvInfo> arrayList = new ArrayList<MvInfo>(n2);
        for (int i = 0; i < n2; ++i) {
            int n3 = this.getMissingCount(bl, i);
            double d2 = (double)n3 / (double)n * 100.0;
            if (!(d2 >= d)) continue;
            arrayList.add(new MvInfo(d2, i, true));
        }
        return arrayList;
    }

    public void openConnections() throws IOException {
    }

    public void removeColumnAt(int n, int n2) {
        super.setColumnCount(this.getColumnCount() - n2);
        if (this.identifier[1] != null) {
            byte[] byArray = new byte[this.getColumnCount()];
            System.arraycopy(this.identifier[1], 0, byArray, 0, n);
            System.arraycopy(this.identifier[1], n + n2, byArray, n, byArray.length - n);
            this.identifier[1] = byArray;
            if (n <= this.primObs) {
                this.primObs -= n2;
            }
        }
    }

    public void removeRowAt(int n, int n2) {
        super.setRowCount(this.getRowCount() - n2);
        if (this.identifier[0] != null) {
            byte[] byArray = new byte[this.getRowCount()];
            System.arraycopy(this.identifier[0], 0, byArray, 0, n);
            System.arraycopy(this.identifier[0], n + n2, byArray, n, byArray.length - n);
            this.identifier[0] = byArray;
            if (n <= this.primVar) {
                this.primVar -= n2;
            }
        }
    }

    public void removeZeroVariance(ArrayList<Integer> arrayList) {
        for (Integer n : arrayList) {
            this.addInterval(1, n, (byte)2);
        }
    }

    public void resize() {
        int n;
        byte[] byArray;
        if (this.identifier[0] != null) {
            byArray = new byte[this.getRowCount()];
            for (n = 0; n < byArray.length; ++n) {
                byArray[n] = n < this.identifier[0].length ? this.identifier[0][n] : 4;
            }
            this.identifier[0] = byArray;
        }
        if (this.identifier[1] != null) {
            byArray = new byte[this.getColumnCount()];
            for (n = 0; n < byArray.length; ++n) {
                byArray[n] = n < this.identifier[1].length ? this.identifier[1][n] : 4;
            }
            this.identifier[1] = byArray;
        }
        if (this.identifier[2] != null) {
            byArray = new byte[this.getLayerCount()];
            for (n = 0; n < byArray.length; ++n) {
                byArray[n] = n < this.identifier[2].length ? this.identifier[2][n] : 4;
            }
        }
    }

    @Override
    public void SavePropertyLocal(RandomOutputStream randomOutputStream) throws IOException {
        super.SavePropertyLocal(randomOutputStream);
        randomOutputStream.writePropertyBoolean("ds", this.isdatasource);
        randomOutputStream.writePropertyBoolean("dsm", this.isdatasourcematrix);
        randomOutputStream.writePropertyBoolean("replmm", this.replaceMissingWithMedian);
        randomOutputStream.writePropertyInt("shs", this.shiftArray.size());
        for (int i = 0; i < this.shiftArray.size(); ++i) {
            randomOutputStream.setPrefix(String.valueOf(i));
            this.shiftArray.get(i).saveProperty(randomOutputStream);
        }
        randomOutputStream.setPrefix("");
        randomOutputStream.writePropertyInt("dtype", this.dataType);
        randomOutputStream.writePropertyBoolean("unsigned", this.unsigned);
    }

    public void setCalibrated(boolean bl) {
        this.calibrated = bl;
    }

    public void setCalibrationModel(AbstractModel abstractModel) {
        this.calibrationModel = abstractModel;
    }

    public void setColumnType(int n, byte by) {
        if (this.identifier[1] == null) {
            this.identifier[1] = new byte[this.getColumnCount()];
        }
        this.identifier[1][n] = by;
    }

    public void setCurrentLayer(int n) {
    }

    public void setDataSource(boolean bl) {
        this.isdatasource = bl;
    }

    public void setDataSourceMatrix(boolean bl) {
        this.isdatasourcematrix = bl;
    }

    public void setExclusionByResolution() {
        int n;
        int n2;
        int n3 = this.getRowCount();
        if (this.resolution[0] > 1) {
            for (n2 = 0; n2 < n3; ++n2) {
                if (n2 % this.resolution[0] != 0) {
                    this.setRowType(n2, (byte)2);
                    continue;
                }
                if (this.getRowType(n2) == 2) continue;
                this.setRowType(n2, (byte)4);
            }
        }
        n2 = this.getColumnCount();
        if (this.resolution[1] > 1) {
            for (n = 0; n < n2; ++n) {
                if (n % this.resolution[1] != 0) {
                    this.setColumnType(n, (byte)2);
                    continue;
                }
                if (this.getColumnType(n) == 2) continue;
                this.setColumnType(n, (byte)4);
            }
        }
        n = this.getLayerCount();
        if (this.resolution[2] > 1) {
            for (int i = 0; i < n; ++i) {
                if (i % this.resolution[2] != 0) {
                    this.setLayerType(i, (byte)2);
                    continue;
                }
                if (this.getLayerType(i) == 2) continue;
                this.setLayerType(i, (byte)4);
            }
        }
    }

    public void setImportInfo(AbstractImportInfo abstractImportInfo) {
        this.importInfo = abstractImportInfo;
    }

    public void setLayerType(int n, byte by) {
        if (this.identifier[2] == null) {
            this.identifier[2] = new byte[this.getLayerCount()];
        }
        this.identifier[2][n] = by;
    }

    public void setMissing(int n, boolean bl, double d) {
        this.missingCheck[n] = bl;
        if (bl && n == 1) {
            this.other = d;
        }
    }

    public void setMissing(int n, int n2) {
        if (n < 0 || n >= this.getRowCount() || n2 < 0 || n2 > this.getColumnCount()) {
            return;
        }
        if (this.mvboolMatrix == null) {
            this.mvboolMatrix = new boolean[this.getRowCount()][this.getColumnCount()];
        }
        this.mvboolMatrix[n][n2] = true;
    }

    public void setPrimaryCol(int n) {
        this.primObs = n;
    }

    public void setPrimaryRow(int n) {
        this.primVar = n;
    }

    public void setProperties(Properties properties) {
    }

    public void setReplaceMissingWithMedian(boolean bl) {
        this.replaceMissingWithMedian = bl;
    }

    public void setResolution(int n, int n2) {
        this.resolution[n] = n2;
    }

    public void setRowType(int n, byte by) {
        if (this.identifier[0] == null) {
            this.identifier[0] = new byte[this.getRowCount()];
        }
        this.identifier[0][n] = by;
    }

    public void setScriptInfo(AbstractScriptInfo abstractScriptInfo) {
        this.script = abstractScriptInfo;
    }

    @Override
    public void setTranspose(boolean bl) {
        if (this.transpose != bl) {
            int n;
            int n2 = this.getRowCount();
            int n3 = this.getColumnCount();
            super.setTranspose(bl);
            byte[] byArray = this.identifier[0];
            this.identifier[0] = this.identifier[1];
            this.identifier[1] = byArray;
            boolean[][] blArray = null;
            if (this.mvboolMatrix != null) {
                blArray = new boolean[this.getRowCount()][this.getColumnCount()];
            }
            for (n = 0; n < n3; ++n) {
                if (this.identifier[0] != null) {
                    this.identifier[0][n] = this.identifier[0][n] == 1 ? (byte)0 : this.identifier[0][n];
                    this.identifier[0][n] = this.identifier[0][n] == 1 ? (byte)0 : this.identifier[0][n];
                }
                for (int i = 0; i < n2; ++i) {
                    if (n == 0 && this.identifier[1] != null) {
                        byte by = this.identifier[1][i] = this.identifier[1][i] == 0 ? (byte)1 : this.identifier[1][i];
                    }
                    if (this.mvboolMatrix == null) continue;
                    blArray[n][i] = this.mvboolMatrix[i][n];
                }
            }
            this.mvboolMatrix = blArray;
            n = this.primVar;
            this.primVar = this.primObs;
            this.primObs = n;
            for (ShiftClass shiftClass : this.shiftArray) {
                shiftClass.transpose();
            }
        }
    }

    public void setValid(boolean bl) {
        this.valid = bl;
    }

    @Override
    public void setValueAt(Object object, int n, int n2) {
        if (this.shiftArray.size() > 0) {
            for (int i = this.shiftArray.size() - 1; i >= 0; --i) {
                ShiftClass shiftClass = this.shiftArray.get(i);
                n2 += shiftClass.shiftX(n, n2);
                ShiftClass.State state = shiftClass.getState();
                if (state == ShiftClass.State.NotAffected) {
                    n += shiftClass.shiftY(n, n2);
                    state = shiftClass.getState();
                }
                if (state != ShiftClass.State.ExactHit) continue;
                shiftClass.setValue(object, n, n2);
                return;
            }
        }
        super.setValueAt(object, n, n2);
    }

    protected void ClearDataLocal() throws IOException {
        this.identifier = null;
    }

    protected void includeFromPathList(ArrayList<SelectionPath> arrayList) {
        if (arrayList.size() > 0) {
            int n;
            for (n = 0; n < this.getRowCount(); ++n) {
                this.addInterval(0, n, (byte)2);
            }
            for (n = 0; n < this.getColumnCount(); ++n) {
                this.addInterval(1, n, (byte)2);
            }
            for (SelectionPath selectionPath : arrayList) {
                int n2;
                boolean bl = true;
                for (int[] nArray : selectionPath.path) {
                    int n3 = nArray[0] + selectionPath.sx;
                    int n4 = nArray[1] + selectionPath.sy;
                    if (bl) {
                        selectionPath.minx = selectionPath.maxx = n3;
                        selectionPath.miny = selectionPath.maxy = n4;
                        bl = false;
                        continue;
                    }
                    if (selectionPath.minx > n3) {
                        selectionPath.minx = n3;
                    }
                    if (selectionPath.maxx < n3) {
                        selectionPath.maxx = n3;
                    }
                    if (selectionPath.miny > n4) {
                        selectionPath.miny = n4;
                    }
                    if (selectionPath.maxy >= n4) continue;
                    selectionPath.maxy = n4;
                }
                for (n2 = selectionPath.miny; n2 < selectionPath.maxy; ++n2) {
                    this.addInterval(0, n2, (byte)4);
                }
                for (n2 = selectionPath.minx; n2 < selectionPath.maxx; ++n2) {
                    this.addInterval(1, n2, (byte)4);
                }
            }
        }
    }

    protected void LoadDataLocal(RandomInputStream randomInputStream) throws IOException {
        int n;
        int n2;
        int n3 = this.getRowCount();
        this.identifier[0] = new byte[n3];
        for (n2 = 0; n2 < n3; ++n2) {
            this.identifier[0][n2] = randomInputStream.ReadBlockByte();
        }
        n2 = this.getColumnCount();
        this.identifier[1] = new byte[n2];
        for (n = 0; n < n2; ++n) {
            this.identifier[1][n] = randomInputStream.ReadBlockByte();
        }
        n = this.getLayerCount();
        this.identifier[2] = new byte[n];
        for (int i = 0; i < n; ++i) {
            this.identifier[2][i] = randomInputStream.ReadBlockByte();
        }
    }

    protected void SaveDataLocal(RandomOutputStream randomOutputStream) throws IOException {
        int n;
        int n2;
        int n3 = this.getRowCount();
        for (n2 = 0; n2 < n3; ++n2) {
            if (this.identifier[0] == null) {
                randomOutputStream.WriteBlockByte((byte)4);
                continue;
            }
            randomOutputStream.WriteBlockByte(this.identifier[0][n2]);
        }
        n2 = this.getColumnCount();
        for (n = 0; n < n2; ++n) {
            if (this.identifier[1] == null) {
                randomOutputStream.WriteBlockByte((byte)4);
                continue;
            }
            randomOutputStream.WriteBlockByte(this.identifier[1][n]);
        }
        n = this.getLayerCount();
        for (int i = 0; i < n; ++i) {
            if (this.identifier[2] == null) {
                randomOutputStream.WriteBlockByte((byte)4);
                continue;
            }
            randomOutputStream.WriteBlockByte(this.identifier[2][i]);
        }
    }

    private void autoIdentifyDataLocal(ProgressManager progressManager, int n, Properties properties) {
        boolean bl = true;
        boolean bl2 = true;
        boolean bl3 = false;
        if (properties != null) {
            if (ScriptHelper.hasKey(properties, "removezerovariance")) {
                bl = ScriptHelper.getPropertyBool(properties, "removezerovariance");
            }
            if (ScriptHelper.hasKey(properties, "autoexclude")) {
                bl2 = ScriptHelper.getPropertyBool(properties, "autoexclude");
            }
            if (ScriptHelper.hasKey(properties, "forcerowdata")) {
                bl3 = ScriptHelper.getPropertyBool(properties, "forcerowdata");
            }
        }
        if (this.getRowCount() * this.getColumnCount() < n) {
            FastDecimal fastDecimal = new FastDecimal();
            int n2 = this.getRowCount();
            int n3 = this.getColumnCount();
            progressManager.setInfoText("Auto Identifying");
            int[] nArray = new int[n2];
            progressManager.setMaximumAndReset(n3);
            for (int i = 0; i < n3; ++i) {
                int n4;
                int n5 = 0;
                progressManager.incStep();
                for (n4 = 0; n4 < n2; ++n4) {
                    this.getDoubleAt(n4, i, fastDecimal);
                    int n6 = this.getPointID(fastDecimal);
                    n5 += n6;
                    if (bl3) {
                        this.addInterval(0, n4, (byte)4);
                        continue;
                    }
                    if (i == 0) {
                        nArray[n4] = n6;
                        continue;
                    }
                    if (i == n3 - 1) {
                        nArray[n4] = (nArray[n4] + n6) / n3;
                        int n7 = CellIdentifierModel.getID(nArray[n4]);
                        if (n7 == 0) {
                            this.addInterval(0, n4, (byte)0);
                            continue;
                        }
                        if (n7 == 1 || n7 == 2) {
                            this.addInterval(0, n4, (byte)4);
                            continue;
                        }
                        if (n7 != 3 || !bl2) continue;
                        this.addInterval(0, n4, (byte)2);
                        continue;
                    }
                    int n8 = n4;
                    nArray[n8] = nArray[n8] + n6;
                }
                n4 = CellIdentifierModel.getID(n5 /= n2);
                if (n4 == 0) {
                    double d = 0.0;
                    double d2 = 0.0;
                    double d3 = 0.0;
                    for (int j = 0; j < n2; ++j) {
                        this.getDoubleAt(j, i, fastDecimal);
                        if (!fastDecimal.isMissing()) continue;
                        if (CellIdentifierModel.isSmile(fastDecimal)) {
                            d += 1.0;
                            continue;
                        }
                        if (CellIdentifierModel.isImage(fastDecimal)) {
                            d2 += 1.0;
                            continue;
                        }
                        if (!CellIdentifierModel.isLink(fastDecimal)) continue;
                        d3 += 1.0;
                    }
                    if (d / (double)n2 > 0.3) {
                        this.addInterval(1, i, (byte)5);
                        continue;
                    }
                    if (d2 / (double)n2 > 0.3) {
                        this.addInterval(1, i, (byte)14);
                        continue;
                    }
                    if (d3 / (double)n2 > 0.3) {
                        this.addInterval(1, i, (byte)15);
                        continue;
                    }
                    this.addInterval(1, i, (byte)1);
                    continue;
                }
                if (n4 == 1 || n4 == 2) {
                    this.addInterval(1, i, (byte)4);
                    continue;
                }
                if (n4 != 3 || !bl2) continue;
                this.addInterval(1, i, (byte)2);
            }
        } else {
            Main_GUI.setStatusMessage(StatusBar.MessageType.INFORMATION, "Automatic identification not run due to large data. You can choose to run it under \"Tools\" if you wish to.", 20);
        }
        if (bl) {
            this.checkAndRemoveZeroVariance(progressManager);
        }
    }

    private int[] getConsecutiveNumber(byte by, byte by2) {
        int[] nArray = new int[this.identifier[by].length];
        int n = 0;
        for (int i = 0; i < this.identifier[by].length; ++i) {
            if (this.identifier[by][i] == by2) {
                // empty if block
            }
            nArray[i] = ++n;
        }
        return nArray;
    }

    private FastDecimal getDoubleAtInternal(int n, int n2, FastDecimal fastDecimal) {
        if (this.shiftArray.size() > 0) {
            for (int i = this.shiftArray.size() - 1; i >= 0; --i) {
                ShiftClass shiftClass = this.shiftArray.get(i);
                n2 += shiftClass.shiftX(n, n2);
                ShiftClass.State state = shiftClass.getState();
                if (state == ShiftClass.State.NotAffected) {
                    n += shiftClass.shiftY(n, n2);
                    state = shiftClass.getState();
                }
                if (state != ShiftClass.State.ExactHit) continue;
                return shiftClass.getDoubleAt(n, n2, fastDecimal);
            }
            if (n2 < 0 || n < 0) {
                return fastDecimal.error();
            }
        }
        fastDecimal = super.getDoubleAt(n, n2, fastDecimal);
        if (this.missingCheck[1]) {
            try {
                double d = this.other;
                if (Double.compare(fastDecimal.getValue(), d) == 0) {
                    return fastDecimal.error();
                }
            }
            catch (NumberFormatException numberFormatException) {
                return fastDecimal.error();
            }
        }
        return fastDecimal;
    }

    private int getMissingCount(boolean bl, int n) {
        if (bl && this.getColumnType(n) != 4 || !bl && this.getRowType(n) != 4) {
            return -1;
        }
        int n2 = 0;
        if (bl) {
            int n3 = this.getRowCount();
            for (int i = 0; i < n3; ++i) {
                if (this.getType(i, n) != 4 || !this.checkMissing(i, n, this.getDoubleAt(i, n), 4)) continue;
                ++n2;
            }
        } else {
            int n4 = this.getColumnCount();
            for (int i = 0; i < n4; ++i) {
                if (this.getType(n, i) != 4 || !this.checkMissing(n, i, this.getDoubleAt(n, i), 4)) continue;
                ++n2;
            }
        }
        return n2;
    }

    private int getPointID(FastDecimal fastDecimal) {
        if (fastDecimal.isEmpty()) {
            return 20;
        }
        if (fastDecimal.isMissing()) {
            if (this.checkMissing(-1, -1, fastDecimal, -1)) {
                return 100;
            }
            return 0;
        }
        return 250;
    }

    @Override
    public void close() throws RuntimeException {
        this.cleanUp();
    }

    public void setForceMultiLayer(boolean bl) {
        this.forceMultiLayer = bl;
    }

    protected static class SelectionPath {
        public int[][] path;
        public int sx;
        public int sy;
        public int minx;
        public int maxx;
        public int miny;
        public int maxy;

        public SelectionPath(int[][] nArray) {
            this.path = nArray;
        }
    }
}

