/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.map.simpletableeditor;

import java.awt.Color;
import java.awt.Component;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.ArrayList;
import javax.swing.AbstractListModel;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPopupMenu;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import se.prediktera.map.common.PopupInterface;
import se.prediktera.map.common.cleanup.CleanUpTable;
import se.prediktera.map.datasetcontainer.DataTreeInterface;
import se.prediktera.map.main.Project_GUI;
import se.prediktera.map.simpletableeditor.DescriptionListener;
import se.prediktera.map.simpletableeditor.ExtendTableModel;
import se.prediktera.map.simpletableeditor.ExtendTableRenderer;
import se.prediktera.map.simpletableeditor.TableActions;

public abstract class ExtendScrollTable
extends CleanUpTable
implements PopupInterface {
    public int selectState = -1;
    protected JList rowHeader = null;
    protected HeaderListeners rowHeaderListeners;
    protected JTableHeader colHeader = null;
    protected HeaderListeners colHeaderListeners;
    protected TableCellRenderer headerRenderer = new ButtonHeaderRenderer();
    protected JScrollPane scrollPane;
    private final ArrayList<DescriptionListener> descriptionListeners = new ArrayList();
    private AbstractTableModel tableModel;
    private TableActions tableActions = null;

    public ExtendScrollTable(AbstractTableModel abstractTableModel, JScrollPane jScrollPane, boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        this(jScrollPane, bl, bl2, bl3, bl4);
        this.setModel(abstractTableModel);
    }

    public ExtendScrollTable(JScrollPane jScrollPane, boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        this.scrollPane = jScrollPane;
        if (jScrollPane instanceof DropTargetListener) {
            new DropTarget(this, (DropTargetListener)((Object)jScrollPane));
        }
        for (int i = 0; i < jScrollPane.getComponentCount(); ++i) {
            Component component = jScrollPane.getComponent(i);
            if (!(component instanceof JScrollBar)) continue;
            ((JScrollBar)component).setBlockIncrement(200);
        }
        this.setCellSelectionEnabled(false);
        this.setColumnSelectionAllowed(true);
        this.setRowSelectionAllowed(true);
        this.setDefaultRenderer(String.class, new ExtendTableRenderer());
        this.tableActions = new TableActions(this, bl, bl2);
        if (bl4) {
            this.addColHeader();
        }
        if (bl3) {
            this.addRowHeader();
        }
        this.getTableHeader().setReorderingAllowed(false);
        jScrollPane.setViewportView(this);
    }

    public void addColHeader() {
        this.addColHeader(this);
    }

    public void addColHeader(ExtendScrollTable extendScrollTable) {
        this.colHeader = this.getTableHeader();
        this.colHeaderListeners = new HeaderListeners(false, extendScrollTable.getColumnModel().getSelectionModel(), extendScrollTable.getSelectionModel());
        this.colHeaderListeners.setHeaderModel(this.tableModel);
        this.colHeader.addMouseListener(this.colHeaderListeners);
        this.colHeader.addMouseMotionListener(this.colHeaderListeners);
        this.colHeader.addKeyListener(this.colHeaderListeners);
        this.colHeader.setSize(0, 19);
        extendScrollTable.getColumnModel().getSelectionModel().addListSelectionListener(new headerListener(false));
    }

    public TableColumn addColumn(int n, int n2) {
        TableColumn tableColumn = new TableColumn(n);
        tableColumn.setWidth(n2);
        tableColumn.setPreferredWidth(n2);
        tableColumn.setHeaderRenderer(this.headerRenderer);
        this.addColumn(tableColumn);
        return tableColumn;
    }

    public void addDescriptionListener(DescriptionListener descriptionListener) {
        this.descriptionListeners.add(descriptionListener);
    }

    public void addDropTarget(DropTargetListener dropTargetListener) {
        new DropTarget(this.scrollPane, dropTargetListener);
        new DropTarget(this, dropTargetListener);
        if (this.rowHeader != null) {
            new DropTarget(this.rowHeader, dropTargetListener);
        }
    }

    public void addGlobalMouseListener(MouseListener mouseListener) {
        this.addMouseListener(mouseListener);
    }

    @Override
    public boolean addToPopup(Project_GUI project_GUI, DataTreeInterface dataTreeInterface, Point point, JPopupMenu jPopupMenu, boolean bl) {
        if (bl && this.tableActions != null) {
            this.tableActions.addToPopupMenu(jPopupMenu, true);
            return true;
        }
        return false;
    }

    public void clearSelections() {
        this.selectState = -1;
        if (this.rowHeader != null) {
            this.rowHeader.clearSelection();
        }
        this.clearSelection();
        this.updateTable();
    }

    public HeaderListeners getHeaderListeners(boolean bl) {
        if (bl) {
            return this.rowHeaderListeners;
        }
        return this.colHeaderListeners;
    }

    public JList getRowHeader() {
        return this.rowHeader;
    }

    @Override
    public int getScrollableBlockIncrement(Rectangle rectangle, int n, int n2) {
        if (n == 0) {
            TableColumn tableColumn;
            int n3 = this.columnAtPoint(new Point(rectangle.x, rectangle.y));
            if (n2 < 0 && n3 > 0) {
                --n3;
            }
            if ((tableColumn = this.getColumnModel().getColumn(n3)) != null) {
                return tableColumn.getWidth();
            }
            return 40;
        }
        return this.getRowHeight();
    }

    @Override
    public int getScrollableUnitIncrement(Rectangle rectangle, int n, int n2) {
        if (n == 0) {
            TableColumn tableColumn;
            int n3 = this.columnAtPoint(new Point(rectangle.x, rectangle.y));
            if (n2 < 0 && n3 > 0) {
                --n3;
            }
            if ((tableColumn = this.getColumnModel().getColumn(n3)) != null) {
                return tableColumn.getWidth();
            }
            return 40;
        }
        return this.getRowHeight();
    }

    public int getSelectState() {
        return this.selectState;
    }

    public boolean getShowGrid() {
        return this.getShowHorizontalLines() || this.getShowVerticalLines();
    }

    public void removeDescriptionListener(DescriptionListener descriptionListener) {
        this.descriptionListeners.remove(descriptionListener);
    }

    public void removeGlobalMouseListener(MouseListener mouseListener) {
        this.removeMouseListener(mouseListener);
    }

    public void setCanPaste(boolean bl) {
        if (this.tableActions != null) {
            this.tableActions.setCanPaste(bl);
        }
    }

    public void setModel(AbstractTableModel abstractTableModel) {
        this.tableModel = abstractTableModel;
        if (abstractTableModel != null) {
            super.setModel(abstractTableModel);
            this.updateTable();
            if (this.colHeader != null) {
                this.updateColumnRenderer();
            }
        }
    }

    @Override
    public void setRowHeight(int n) {
        super.setRowHeight(n);
        if (this.rowHeader != null) {
            this.rowHeader.setFixedCellHeight(n);
        }
    }

    public boolean setSelectState(int n) {
        if (this.selectState != n) {
            this.selectState = n;
            return true;
        }
        return false;
    }

    public void updateColumnRenderer() {
        TableColumnModel tableColumnModel = this.getColumnModel();
        int n = tableColumnModel.getColumnCount();
        for (int i = 0; i < n; ++i) {
            tableColumnModel.getColumn(i).setHeaderRenderer(this.headerRenderer);
        }
    }

    public void updateTable() {
        this.repaint();
        if (this.colHeader != null) {
            this.colHeader.repaint();
        }
        if (this.rowHeader != null) {
            this.rowHeader.invalidate();
            this.rowHeader.repaint();
        }
    }

    protected JList addRowHeader() {
        return this.addRowHeader(this);
    }

    protected JList addRowHeader(ExtendScrollTable extendScrollTable) {
        AbstractListModel abstractListModel = new AbstractListModel(){

            @Override
            public Object getElementAt(int n) {
                return String.valueOf(n + 1);
            }

            @Override
            public int getSize() {
                if (ExtendScrollTable.this.tableModel == null) {
                    return 0;
                }
                return ExtendScrollTable.this.tableModel.getRowCount();
            }
        };
        return this.addRowHeader(abstractListModel, extendScrollTable);
    }

    protected JList addRowHeader(ListModel listModel, ExtendScrollTable extendScrollTable) {
        this.rowHeader = new JList(listModel);
        this.rowHeader.setFixedCellWidth(50);
        this.rowHeader.setFixedCellHeight(this.getRowHeight());
        this.rowHeader.setCellRenderer(new RowHeaderRenderer());
        if (extendScrollTable != null) {
            extendScrollTable.getSelectionModel().addListSelectionListener(new headerListener(true));
            this.rowHeaderListeners = new HeaderListeners(true, extendScrollTable.getSelectionModel(), extendScrollTable.getColumnModel().getSelectionModel());
            this.rowHeader.addMouseListener(this.rowHeaderListeners);
            this.rowHeader.addMouseMotionListener(this.rowHeaderListeners);
            this.rowHeader.addKeyListener(this.rowHeaderListeners);
        }
        this.rowHeader.setBackground(this.getTableHeader().getBackground());
        this.scrollPane.setRowHeaderView(this.rowHeader);
        if (this.scrollPane instanceof DropTargetListener) {
            new DropTarget(this.rowHeader, (DropTargetListener)((Object)this.scrollPane));
        }
        return this.rowHeader;
    }

    @Override
    protected void cleanUpChild() {
        this.descriptionListeners.clear();
        if (this.tableModel instanceof ExtendTableModel) {
            ((ExtendTableModel)this.tableModel).cleanUp();
            this.tableModel = null;
        }
        this.tableActions = null;
    }

    protected void setDescriptionTables(ExtendScrollTable extendScrollTable, ExtendScrollTable extendScrollTable2, ExtendScrollTable extendScrollTable3) {
        if (this.tableActions != null) {
            this.tableActions.setDescriptionTables(extendScrollTable, extendScrollTable2, extendScrollTable3);
        }
    }

    class ButtonHeaderRenderer
    extends JLabel
    implements TableCellRenderer {
        private final Color bkcolor;
        private final Border raisedBorder = BorderFactory.createRaisedBevelBorder();
        private final Border loweredBorder = BorderFactory.createLoweredBevelBorder();

        public ButtonHeaderRenderer() {
            this.setBorder(this.raisedBorder);
            this.setOpaque(true);
            this.setHorizontalTextPosition(0);
            this.setHorizontalAlignment(0);
            this.bkcolor = this.getBackground();
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            boolean bl3;
            this.setText(object == null ? "" : object.toString());
            boolean bl4 = bl3 = jTable.isColumnSelected(n2) && (ExtendScrollTable.this.selectState == 1 || ExtendScrollTable.this.selectState == -1);
            if (bl3) {
                this.setBorder(this.loweredBorder);
                this.setBackground(jTable.getSelectionBackground());
                this.setForeground(UIManager.getColor("Tree.selectionForeground"));
            } else {
                this.setBorder(this.raisedBorder);
                this.setBackground(this.bkcolor);
                this.setForeground(UIManager.getColor("Tree.textForeground"));
            }
            this.setToolTipText(object == null ? null : object.toString());
            return this;
        }
    }

    public class HeaderListeners
    extends MouseAdapter
    implements MouseMotionListener,
    KeyListener {
        private boolean keydown = false;
        private final ListSelectionModel selection;
        private final ListSelectionModel oppositeselection;
        private final boolean isrow;
        private TableModel headerModel = null;

        public HeaderListeners(boolean bl, ListSelectionModel listSelectionModel, ListSelectionModel listSelectionModel2) {
            this.selection = listSelectionModel;
            this.oppositeselection = listSelectionModel2;
            this.isrow = bl;
        }

        @Override
        public void keyPressed(KeyEvent keyEvent) {
            ExtendScrollTable.this.processEvent(keyEvent);
        }

        @Override
        public void keyReleased(KeyEvent keyEvent) {
        }

        @Override
        public void keyTyped(KeyEvent keyEvent) {
        }

        @Override
        public void mouseDragged(MouseEvent mouseEvent) {
            if (SwingUtilities.isLeftMouseButton(mouseEvent) && this.keydown) {
                int n = this.getIndexFromPoint(mouseEvent.getPoint());
                if (n == -1) {
                    return;
                }
                this.keydown = true;
                this.selectInterval(n, true, false);
                Rectangle rectangle = ExtendScrollTable.this.getCellRect(this.isrow ? n : 0, this.isrow ? 0 : n, true);
                ExtendScrollTable.this.scrollRectToVisible(rectangle);
                ExtendScrollTable.this.updateTable();
            }
        }

        @Override
        public void mouseMoved(MouseEvent mouseEvent) {
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            int n = this.getIndexFromPoint(mouseEvent.getPoint());
            if (n == -1) {
                return;
            }
            this.keydown = true;
            if (SwingUtilities.isLeftMouseButton(mouseEvent) || !this.selection.isSelectedIndex(n)) {
                this.selectInterval(n, mouseEvent.isShiftDown(), mouseEvent.isControlDown());
            }
            ExtendScrollTable.this.selectState = this.isrow ? 0 : 1;
            ExtendScrollTable.this.updateTable();
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
            if (SwingUtilities.isLeftMouseButton(mouseEvent)) {
                this.keydown = false;
            }
        }

        public int selectInterval(int n, boolean bl, boolean bl2) {
            int n2;
            int n3;
            if (this.headerModel == null) {
                n3 = ExtendScrollTable.this.getColumnCount();
                n2 = ExtendScrollTable.this.getRowCount();
                if (!this.isrow) {
                    n3 = ExtendScrollTable.this.getRowCount();
                    n2 = ExtendScrollTable.this.getColumnCount();
                }
            } else {
                n3 = this.headerModel.getColumnCount();
                n2 = this.headerModel.getRowCount();
                if (!this.isrow) {
                    n3 = this.headerModel.getRowCount();
                    n2 = this.headerModel.getColumnCount();
                }
            }
            if (n < 0) {
                n = 0;
            }
            if (n >= n2) {
                n = n2 - 1;
            }
            if (n3 != 0) {
                this.oppositeselection.setSelectionInterval(0, n3 - 1);
            }
            if (bl) {
                int n4 = this.selection.getAnchorSelectionIndex();
                int n5 = this.selection.getLeadSelectionIndex();
                if (n4 == -1) {
                    this.selection.setSelectionInterval(n, n);
                } else {
                    boolean bl3 = this.selection.getValueIsAdjusting();
                    this.selection.setValueIsAdjusting(true);
                    boolean bl4 = this.selection.isSelectedIndex(n4);
                    if (n5 != -1) {
                        if (bl4) {
                            this.selection.removeSelectionInterval(n4, n5);
                        } else {
                            this.selection.addSelectionInterval(n4, n5);
                        }
                    }
                    if (bl4) {
                        this.selection.addSelectionInterval(n4, n);
                    } else {
                        this.selection.removeSelectionInterval(n4, n);
                    }
                    this.selection.setValueIsAdjusting(bl3);
                }
            } else if (bl2) {
                if (this.selection.isSelectedIndex(n)) {
                    this.selection.removeSelectionInterval(n, n);
                } else {
                    this.selection.addSelectionInterval(n, n);
                }
            } else {
                this.selection.setSelectionInterval(n, n);
            }
            return n;
        }

        public void setHeaderModel(TableModel tableModel) {
            this.headerModel = tableModel;
        }

        private int getIndexFromPoint(Point point) {
            if (this.isrow) {
                if (!ExtendScrollTable.this.getRowSelectionAllowed()) {
                    return -1;
                }
                return ExtendScrollTable.this.rowHeader.locationToIndex(point);
            }
            JTableHeader jTableHeader = ExtendScrollTable.this.getTableHeader();
            TableColumnModel tableColumnModel = jTableHeader.getColumnModel();
            if (!tableColumnModel.getColumnSelectionAllowed()) {
                return -1;
            }
            return jTableHeader.columnAtPoint(point);
        }
    }

    protected class headerListener
    implements ListSelectionListener {
        private final boolean isrow;

        public headerListener(boolean bl) {
            this.isrow = bl;
        }

        @Override
        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            if (ExtendScrollTable.this.rowHeader != null) {
                ExtendScrollTable.this.rowHeader.repaint();
            }
            if (ExtendScrollTable.this.colHeader != null) {
                ExtendScrollTable.this.colHeader.repaint();
                ExtendScrollTable.this.updateColumnRenderer();
            }
            if (this.isrow) {
                for (DescriptionListener descriptionListener : ExtendScrollTable.this.descriptionListeners) {
                    descriptionListener.RowHeaderSelected(ExtendScrollTable.this.getSelectedRows());
                }
            } else {
                for (DescriptionListener descriptionListener : ExtendScrollTable.this.descriptionListeners) {
                    descriptionListener.ColHeaderSelected(ExtendScrollTable.this.getSelectedColumns());
                }
            }
        }
    }

    protected class RowHeaderRenderer
    extends JLabel
    implements ListCellRenderer {
        private final Color bkcolor;
        private final Border raisedBorder = BorderFactory.createRaisedBevelBorder();
        private final Border loweredBorder = BorderFactory.createLoweredBevelBorder();

        public RowHeaderRenderer() {
            this.setOpaque(true);
            this.setBorder(this.raisedBorder);
            this.setHorizontalTextPosition(0);
            this.setHorizontalAlignment(0);
            this.bkcolor = this.getBackground();
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            TableCellRenderer tableCellRenderer;
            Component component;
            boolean bl3 = ExtendScrollTable.this.isRowSelected(n) && (ExtendScrollTable.this.selectState == 0 || ExtendScrollTable.this.selectState == -1);
            this.setText(object == null ? "" : object.toString());
            if (bl3) {
                this.setBorder(this.loweredBorder);
                this.setBackground(ExtendScrollTable.this.getSelectionBackground());
                this.setForeground(UIManager.getColor("Tree.selectionForeground"));
            } else {
                this.setBorder(this.raisedBorder);
                this.setBackground(this.bkcolor);
                this.setForeground(UIManager.getColor("Tree.textForeground"));
            }
            if (ExtendScrollTable.this.getColumnCount() > 0 && (component = (tableCellRenderer = ExtendScrollTable.this.getCellRenderer(n, 0)).getTableCellRendererComponent(ExtendScrollTable.this, ExtendScrollTable.this.getValueAt(n, 0), false, false, n, 0)) instanceof JLabel) {
                this.setToolTipText(((JLabel)component).getText());
            }
            return this;
        }
    }
}

