/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.map.simpletableeditor;

import java.io.IOException;
import se.prediktera.map.common.MapProperty;
import se.prediktera.map.common.RandomInputStream;
import se.prediktera.map.common.RandomOutputStream;
import se.prediktera.map.common.cleanup.CleanUpTableModel;
import se.prediktera.map.dataimport.FastDecimal;

public abstract class ExtendTableModel
extends CleanUpTableModel {
    protected boolean transpose;
    protected int[] columnIndex;
    protected int[] rowIndex;
    protected int rows;
    protected int columns;
    protected FastDecimal fastDecimal = new FastDecimal();

    public ExtendTableModel(int n, int n2, boolean bl) {
        this.rows = n;
        this.columns = n2;
        this.transpose = bl;
    }

    public ExtendTableModel(RandomInputStream randomInputStream, MapProperty mapProperty) throws IOException {
        if (mapProperty.hasProperty("rows")) {
            this.rows = mapProperty.getLVInt();
        }
        if (mapProperty.hasProperty("cols")) {
            this.columns = mapProperty.getLVInt();
        }
        if (mapProperty.hasProperty("tp")) {
            this.transpose = mapProperty.getLVBoolean();
        }
    }

    @Override
    public Class<?> getColumnClass(int n) {
        return String.class;
    }

    @Override
    public int getColumnCount() {
        if (this.transpose) {
            if (this.rowIndex != null) {
                return this.rowIndex.length;
            }
            return this.rows;
        }
        if (this.columnIndex != null) {
            return this.columnIndex.length;
        }
        return this.columns;
    }

    public final int[] getColumnIndex() {
        if (this.transpose) {
            return this.rowIndex;
        }
        return this.columnIndex;
    }

    @Override
    public String getColumnName(int n) {
        return String.valueOf(n + 1);
    }

    public int[] getDataOrder() {
        if (this.transpose) {
            return new int[]{0, 1, 2};
        }
        return new int[]{1, 0, 2};
    }

    public FastDecimal getDoubleAt(int n, int n2) {
        return this.getDoubleAt(n, n2, this.fastDecimal);
    }

    public FastDecimal getDoubleAt(int n, int n2, FastDecimal fastDecimal) {
        int[] nArray;
        int[] nArray2 = this.getRowIndex();
        if (nArray2 != null && n < nArray2.length) {
            n = nArray2[n];
        }
        if ((nArray = this.getColumnIndex()) != null && n2 < nArray.length) {
            n2 = nArray[n2];
        }
        if (this.transpose) {
            return this.getDoubleAt_Transpose(n2, n, fastDecimal);
        }
        return this.getDoubleAt_Transpose(n, n2, fastDecimal);
    }

    public FastDecimal getDoubleAt_Transpose(int n, int n2, FastDecimal fastDecimal) {
        Object object = this.getValueAt_Transpose(n, n2);
        byte[] byArray = object.toString().getBytes();
        fastDecimal.parseString(byArray, (short)byArray.length);
        return fastDecimal;
    }

    public int getOrigColumnCount() {
        if (this.transpose) {
            return this.rows;
        }
        return this.columns;
    }

    public int getOrigRowCount() {
        if (this.transpose) {
            return this.columns;
        }
        return this.rows;
    }

    public Object getRenderedTableValue(int n, int n2) {
        return this.getValueAt(n, n2);
    }

    @Override
    public int getRowCount() {
        if (this.transpose) {
            if (this.columnIndex != null) {
                return this.columnIndex.length;
            }
            return this.columns;
        }
        if (this.rowIndex != null) {
            return this.rowIndex.length;
        }
        return this.rows;
    }

    public final int[] getRowIndex() {
        if (this.transpose) {
            return this.columnIndex;
        }
        return this.rowIndex;
    }

    public boolean getTranspose() {
        return this.transpose;
    }

    public byte getTypeAt(int n, int n2) {
        return 4;
    }

    @Override
    public Object getValueAt(int n, int n2) {
        int[] nArray;
        int[] nArray2 = this.getRowIndex();
        if (nArray2 != null && n < nArray2.length) {
            n = nArray2[n];
        }
        if ((nArray = this.getColumnIndex()) != null && n2 < nArray.length) {
            n2 = nArray[n2];
        }
        if (n < 0 || n2 < 0) {
            return "Index out of bounds < 0";
        }
        if (this.transpose) {
            return this.getValueAt_Transpose(n2, n);
        }
        return this.getValueAt_Transpose(n, n2);
    }

    public abstract Object getValueAt_Transpose(int var1, int var2);

    public void SavePropertyLocal(RandomOutputStream randomOutputStream) throws IOException {
        randomOutputStream.writePropertyInt("rows", this.rows);
        randomOutputStream.writePropertyInt("cols", this.columns);
        randomOutputStream.writePropertyBoolean("tp", this.transpose);
    }

    @Override
    public void setColumnCount(int n) {
        if (this.transpose) {
            if (this.rowIndex == null) {
                this.rows = n;
            }
        } else if (this.columnIndex == null) {
            this.columns = n;
        }
        this.fireTableStructureChanged();
    }

    public int[] setColumnIndex(int[] nArray) {
        if (this.transpose) {
            this.rowIndex = nArray;
            return nArray;
        }
        this.columnIndex = nArray;
        return nArray;
    }

    @Override
    public void setRowCount(int n) {
        if (this.transpose) {
            if (this.columnIndex == null) {
                this.columns = n;
            }
        } else if (this.rowIndex == null) {
            this.rows = n;
        }
        this.fireTableStructureChanged();
    }

    public int[] setRowIndex(int[] nArray) {
        if (this.transpose) {
            this.columnIndex = nArray;
            return nArray;
        }
        this.rowIndex = nArray;
        return nArray;
    }

    public void setTranspose(boolean bl) {
        this.transpose = bl;
        this.fireTableStructureChanged();
    }

    @Override
    public void setValueAt(Object object, int n, int n2) {
        if (this.rowIndex != null) {
            n = this.rowIndex[n];
        }
        if (this.columnIndex != null) {
            n2 = this.columnIndex[n2];
        }
        if (this.transpose) {
            this.setValueAt_Transpose(object, n2, n);
        } else {
            this.setValueAt_Transpose(object, n, n2);
        }
    }

    public void setValueAt_Transpose(Object object, int n, int n2) {
    }

    @Override
    protected void cleanUpChild() {
        this.columnIndex = null;
        this.rowIndex = null;
    }
}

