/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.map.simpletableeditor;

import java.io.IOException;
import se.prediktera.map.common.MapProperty;
import se.prediktera.map.common.RandomOutputStream;
import se.prediktera.map.dataimport.FastDecimal;
import se.prediktera.map.simpletableeditor.ShiftClass;

public class PasteClass
extends ShiftClass {
    private String[][] pastedData = null;

    public PasteClass(MapProperty mapProperty) {
        super(mapProperty);
        int n = mapProperty.getPropertyInt("dSrow");
        int n2 = mapProperty.getPropertyInt("dScolumn");
        if (n > 0 && n2 > 0) {
            this.pastedData = new String[n2][n];
            for (int i = 0; i < n2; ++i) {
                for (int j = 0; j < n; ++j) {
                    this.pastedData[i][j] = mapProperty.getPropertyStringUTF("str" + i + i * j);
                }
            }
        }
    }

    public PasteClass(String[][] stringArray, byte by, int n, int n2) {
        super(by, n, n2, stringArray.length);
        this.pastedData = stringArray;
    }

    @Override
    public FastDecimal getDoubleAt(int n, int n2, FastDecimal fastDecimal) {
        return fastDecimal.parseString(this.getValue(n, n2));
    }

    @Override
    public String getValue(int n, int n2) {
        int n3;
        int n4;
        if (this.row == -1) {
            n4 = n;
            n3 = n2 - this.column;
        } else {
            n4 = n2;
            n3 = n - this.row;
        }
        if (this.pastedData != null && this.pastedData.length > 0 && n3 >= 0 && n3 < this.pastedData.length && n4 >= 0 && n4 < this.pastedData[0].length) {
            if (this.pastedData[n3][n4] == null) {
                return "";
            }
            return this.pastedData[n3][n4];
        }
        return "";
    }

    @Override
    public void saveProperty(RandomOutputStream randomOutputStream) throws IOException {
        super.saveProperty(randomOutputStream);
        int n = this.pastedData == null ? 0 : this.pastedData.length;
        int n2 = n > 0 ? this.pastedData[0].length : 0;
        randomOutputStream.writePropertyInt("dScolumn", n);
        randomOutputStream.writePropertyInt("dSrow", n2);
        for (int i = 0; i < n; ++i) {
            int n3 = this.pastedData[i].length;
            for (int j = 0; j < n3; ++j) {
                randomOutputStream.writePropertyStringUTF("str" + i + i * j, this.pastedData[i][j]);
            }
        }
    }

    @Override
    public void setValue(Object object, int n, int n2) {
        int n3;
        int n4;
        if (this.row == -1) {
            n4 = n;
            n3 = n2 - this.column;
        } else {
            n4 = n2;
            n3 = n - this.row;
        }
        if (this.pastedData != null && n3 >= 0 && n3 < this.pastedData.length && n4 >= 0 && this.pastedData.length > 0) {
            if (n4 >= this.pastedData[0].length) {
                for (int i = 0; i < this.pastedData.length; ++i) {
                    String[] stringArray = new String[n4 + 1];
                    System.arraycopy(this.pastedData[i], 0, stringArray, 0, this.pastedData[i].length);
                    this.pastedData[i] = stringArray;
                }
            }
            this.pastedData[n3][n4] = object.toString();
        }
    }
}

