/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.map.simpletableeditor;

import java.io.IOException;
import se.prediktera.map.common.MapProperty;
import se.prediktera.map.common.RandomOutputStream;
import se.prediktera.map.dataimport.FastDecimal;
import se.prediktera.map.simpletableeditor.PasteClass;

public class ShiftClass {
    public static final byte SHIFT_LEFT = 0;
    public static final byte SHIFT_RIGHT = 1;
    public static final byte SHIFT_UP = 2;
    public static final byte SHIFT_DOWN = 3;
    public static final byte SHIFT_DELETE = 4;
    public static final byte DELETE_X = 5;
    public static final byte DELETE_Y = 6;
    private byte type;
    protected int row;
    protected int column;
    protected final int size;
    private State state;

    public static ShiftClass load(MapProperty mapProperty) {
        if (mapProperty.getPropertyBoolean("pst")) {
            return new PasteClass(mapProperty);
        }
        return new ShiftClass(mapProperty);
    }

    public ShiftClass(byte by, int n, int n2) {
        this(by, n, n2, 1);
    }

    public ShiftClass(byte by, int n, int n2, int n3) {
        this.type = by;
        this.row = n;
        this.column = n2;
        this.size = n3;
    }

    public ShiftClass(MapProperty mapProperty) {
        this.type = mapProperty.getPropertyByte("ty");
        this.row = mapProperty.getPropertyInt("row");
        this.column = mapProperty.getPropertyInt("col");
        this.size = mapProperty.getPropertyInt("size", 1);
    }

    public int getColumn() {
        return this.column;
    }

    public FastDecimal getDoubleAt(int n, int n2, FastDecimal fastDecimal) {
        return fastDecimal.error();
    }

    public int getRow() {
        return this.row;
    }

    public int getSize() {
        return this.size;
    }

    public State getState() {
        return this.state;
    }

    public byte getType() {
        return this.type;
    }

    public String getValue(int n, int n2) {
        return "";
    }

    public void saveProperty(RandomOutputStream randomOutputStream) throws IOException {
        randomOutputStream.writePropertyByte("ty", this.type);
        randomOutputStream.writePropertyInt("row", this.row);
        randomOutputStream.writePropertyInt("col", this.column);
        randomOutputStream.writePropertyInt("size", this.size);
    }

    public void setValue(Object object, int n, int n2) {
    }

    public int shiftX(int n, int n2) {
        if (n == this.row || this.row < 0 && this.column >= 0) {
            switch (this.type) {
                case 0: {
                    if (n2 >= this.column && this.column != -1) break;
                    this.state = State.Affected;
                    return this.size;
                }
                case 1: {
                    if (n2 >= this.column && n2 < this.column + this.size) {
                        this.state = State.ExactHit;
                        return 0;
                    }
                    if (n2 <= this.column && this.column != -1) break;
                    this.state = State.Affected;
                    return -this.size;
                }
                case 5: {
                    if (n2 < this.column && this.column != -1) break;
                    this.state = State.Affected;
                    return this.size;
                }
            }
            if (n2 == this.column && this.column != -1 && this.row >= 0) {
                this.state = State.ExactHit;
                return 0;
            }
        }
        this.state = State.NotAffected;
        return 0;
    }

    public int shiftY(int n, int n2) {
        if (n2 == this.column || this.column < 0 && this.row >= 0) {
            switch (this.type) {
                case 2: {
                    if (n >= this.row && this.row != -1) break;
                    this.state = State.Affected;
                    return this.size;
                }
                case 3: {
                    if (n >= this.row && n < this.row + this.size) {
                        this.state = State.ExactHit;
                        return 0;
                    }
                    if (n <= this.row && this.row != -1) break;
                    this.state = State.Affected;
                    return -this.size;
                }
                case 6: {
                    if (n < this.row && this.row != -1) break;
                    this.state = State.Affected;
                    return this.size;
                }
            }
            if (n == this.row && this.row != -1 && this.column >= 0) {
                this.state = State.ExactHit;
                return 0;
            }
        }
        this.state = State.NotAffected;
        return 0;
    }

    public void transpose() {
        switch (this.type) {
            case 0: {
                this.type = (byte)2;
                break;
            }
            case 1: {
                this.type = (byte)3;
                break;
            }
            case 2: {
                this.type = 0;
                break;
            }
            case 3: {
                this.type = 1;
                break;
            }
            case 5: {
                this.type = (byte)6;
                break;
            }
            case 6: {
                this.type = (byte)5;
            }
        }
        int n = this.row;
        this.row = this.column;
        this.column = n;
    }

    public static enum State {
        NotAffected,
        ExactHit,
        Affected;

    }
}

