/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.map.simpletableeditor;

import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.KeyStroke;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import se.prediktera.map.common.CMenuItem;
import se.prediktera.map.data.SimpleTable;
import se.prediktera.map.data.datasettable.table.DataControlTable;
import se.prediktera.map.datasetcontainer.matrix.AbstractDataMatrix;
import se.prediktera.map.main.Main_GUI;
import se.prediktera.map.simpletableeditor.ExtendScrollTable;
import se.prediktera.map.simpletableeditor.ExtendTableModel;

public class TableActions
implements ActionListener {
    private final Clipboard system = Toolkit.getDefaultToolkit().getSystemClipboard();
    private final boolean cancopy;
    private boolean canpaste;
    private final ExtendScrollTable table;
    private ExtendScrollTable rowDesc = null;
    private ExtendScrollTable colDesc = null;
    private ExtendScrollTable cornerDesc;

    private static void copySelectionToClipboard(StringBuilder stringBuilder, ExtendScrollTable extendScrollTable, ExtendScrollTable extendScrollTable2, ExtendScrollTable extendScrollTable3, ExtendScrollTable extendScrollTable4) {
        int n;
        int n2;
        int n3;
        int n4 = extendScrollTable.getSelectedColumnCount();
        int n5 = extendScrollTable.getSelectedRowCount();
        int[] nArray = null;
        int[] nArray2 = null;
        if (n4 <= 0 || n5 <= 0) {
            n4 = extendScrollTable.getColumnCount();
            n5 = extendScrollTable.getRowCount();
        } else {
            nArray = extendScrollTable.getSelectedRows();
            nArray2 = extendScrollTable.getSelectedColumns();
        }
        if (extendScrollTable instanceof DataControlTable) {
            n4 = extendScrollTable.getColumnCount();
            nArray2 = new int[n4];
            for (n3 = 0; n3 < nArray2.length; ++n3) {
                nArray2[n3] = n3;
            }
        }
        if (nArray != null && nArray2 != null && (n5 - 1 != nArray[nArray.length - 1] - nArray[0] || n5 != nArray.length || n4 - 1 != nArray2[nArray2.length - 1] - nArray2[0] || n4 != nArray2.length)) {
            JOptionPane.showMessageDialog(null, "Invalid Copy Selection", "Invalid Copy Selection", 0);
            return;
        }
        n3 = extendScrollTable2 == null ? 0 : extendScrollTable2.getColumnCount();
        int n6 = extendScrollTable3 == null ? 0 : extendScrollTable3.getRowCount();
        for (n2 = 0; n2 < n6; ++n2) {
            int n7;
            for (n7 = 0; n7 < n3; ++n7) {
                if (n7 > 0) {
                    stringBuilder.append("\t");
                }
                stringBuilder.append(extendScrollTable4.getValueAt(n2, n7));
            }
            for (n7 = 0; n7 < n4; ++n7) {
                if (n3 > 0 || n7 > 0) {
                    stringBuilder.append("\t");
                }
                stringBuilder.append(extendScrollTable3.getValueAt(n2, nArray2 != null ? nArray2[n7] : n7));
            }
            stringBuilder.append("\n");
        }
        if (extendScrollTable instanceof DataControlTable && extendScrollTable2 != null) {
            TableColumn tableColumn;
            JTableHeader jTableHeader = extendScrollTable2.getTableHeader();
            TableColumnModel tableColumnModel = jTableHeader.getColumnModel();
            for (n = 0; n < n3; ++n) {
                if (n > 0) {
                    stringBuilder.append("\t");
                }
                tableColumn = tableColumnModel.getColumn(n);
                stringBuilder.append(tableColumn.getHeaderValue());
            }
            jTableHeader = extendScrollTable.getTableHeader();
            tableColumnModel = jTableHeader.getColumnModel();
            for (n = 0; n < tableColumnModel.getColumnCount(); ++n) {
                if (n3 > 0 || n > 0) {
                    stringBuilder.append("\t");
                }
                tableColumn = tableColumnModel.getColumn(n);
                stringBuilder.append(tableColumn.getHeaderValue());
            }
            stringBuilder.append("\n");
        }
        n2 = 0;
        for (int i = 0; i < n5; ++i) {
            while (n2 < i) {
                stringBuilder.append("\n");
                ++n2;
            }
            for (n = 0; n < n3; ++n) {
                stringBuilder.append(extendScrollTable2.getValueAt(nArray != null ? nArray[i] : i, n));
                stringBuilder.append("\t");
            }
            n = 0;
            for (int j = 0; j < n4; ++j) {
                Object object = extendScrollTable.getValueAt(nArray != null ? nArray[i] : i, nArray2 != null ? nArray2[j] : j);
                if (object == null) continue;
                String string = null;
                string = extendScrollTable instanceof DataControlTable ? ((DataControlTable)extendScrollTable).getRenderedValue(object, j) : String.valueOf(object);
                if (string.length() == 0) continue;
                while (n < j) {
                    stringBuilder.append("\t");
                    ++n;
                }
                stringBuilder.append(string);
            }
        }
    }

    public TableActions(ExtendScrollTable extendScrollTable, boolean bl, boolean bl2) {
        this.table = extendScrollTable;
        this.cancopy = bl;
        this.canpaste = bl2;
        this.table.registerKeyboardAction(this, "CopyWdesc", KeyStroke.getKeyStroke(67, Main_GUI.getCntrKey() | 1), 0);
        this.table.registerKeyboardAction(this, "Copy", Main_GUI.getCtrlStroke(67), 0);
        this.table.registerKeyboardAction(this, "Paste", Main_GUI.getCtrlStroke(86), 0);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (this.cancopy && actionEvent.getActionCommand().compareTo("Copy") == 0) {
            this.copySelectionToClipboard();
        } else if (this.canpaste && actionEvent.getActionCommand().compareTo("Paste") == 0) {
            this.copyFromClipboardIntoTable();
        } else if (this.cancopy && this.rowDesc != null && this.colDesc != null && actionEvent.getActionCommand().compareTo("CopyWdesc") == 0) {
            this.copySelectionWithDescriptionsToClipboard();
        }
    }

    public void addToPopupMenu(JPopupMenu jPopupMenu, boolean bl) {
        if ((this.cancopy || this.canpaste) && jPopupMenu.getSubElements().length > 0) {
            jPopupMenu.addSeparator();
        }
        if (this.cancopy) {
            if (this.rowDesc != null && this.colDesc != null) {
                jPopupMenu.add(new CMenuItem("Copy with Identifiers", bl){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        TableActions.this.copySelectionWithDescriptionsToClipboard();
                    }
                });
            }
            jPopupMenu.add(new CMenuItem("Copy", bl){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    TableActions.this.copySelectionToClipboard();
                }
            });
        }
        if (this.canpaste) {
            jPopupMenu.add(new CMenuItem("Paste", bl){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    TableActions.this.copyFromClipboardIntoTable();
                }
            });
        }
    }

    public void setCanPaste(boolean bl) {
        this.canpaste = bl;
    }

    protected void setDescriptionTables(ExtendScrollTable extendScrollTable, ExtendScrollTable extendScrollTable2, ExtendScrollTable extendScrollTable3) {
        this.rowDesc = extendScrollTable;
        this.colDesc = extendScrollTable2;
        this.cornerDesc = extendScrollTable3;
    }

    private void copyFromClipboardIntoTable() {
        AbstractDataMatrix abstractDataMatrix = null;
        if (this.table instanceof SimpleTable) {
            abstractDataMatrix = ((SimpleTable)this.table).getMatrix();
        }
        int n = this.table.getSelectedRow();
        int n2 = this.table.getSelectedColumn();
        if (n >= 0 && n2 >= 0) {
            if (abstractDataMatrix != null) {
                abstractDataMatrix.beginCalculations();
            }
            try {
                String string = (String)this.system.getContents(this).getTransferData(DataFlavor.stringFlavor);
                String[] stringArray = string.split("\n");
                for (int i = n; i < n + stringArray.length; ++i) {
                    String[] stringArray2 = stringArray[i - n].split("[ \t]");
                    for (int j = n2; j < n2 + stringArray2.length; ++j) {
                        String string2 = stringArray2[j - n2].replace(",", ".");
                        if (abstractDataMatrix != null) {
                            abstractDataMatrix.beginUpdate(i, j);
                        }
                        if (i >= this.table.getRowCount() || j >= this.table.getColumnCount()) continue;
                        this.table.setValueAt(string2, i, j);
                    }
                }
            }
            catch (UnsupportedFlavorException | IOException exception) {
                // empty catch block
            }
            if (abstractDataMatrix != null) {
                abstractDataMatrix.endUpdate();
                abstractDataMatrix.endCalculations();
            } else if (this.table.getModel() instanceof ExtendTableModel) {
                ((ExtendTableModel)this.table.getModel()).fireTableDataChanged();
            }
        }
    }

    private void copySelectionToClipboard() {
        StringBuilder stringBuilder = new StringBuilder();
        TableActions.copySelectionToClipboard(stringBuilder, this.table, null, null, null);
        StringSelection stringSelection = new StringSelection(stringBuilder.toString());
        this.system.setContents(stringSelection, stringSelection);
    }

    private void copySelectionWithDescriptionsToClipboard() {
        StringBuilder stringBuilder = new StringBuilder();
        TableActions.copySelectionToClipboard(stringBuilder, this.table, this.rowDesc, this.colDesc, this.cornerDesc);
        StringSelection stringSelection = new StringSelection(stringBuilder.toString());
        this.system.setContents(stringSelection, stringSelection);
    }
}

