/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.map.simpletableeditor;

import com.stevesoft.pat.Regex;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import javax.help.CSH;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.table.TableCellRenderer;
import se.prediktera.map.common.error.ErrorHandler;
import se.prediktera.map.common.polynom.PolyNode;
import se.prediktera.map.common.polynom.PolynomParser;
import se.prediktera.map.common.selection.AbstractSelectionPage;
import se.prediktera.map.common.swing.EvinceBorderFactory;
import se.prediktera.map.data.AbstractTable;
import se.prediktera.map.data.DataInit;
import se.prediktera.map.data.DataSelectionDialog;
import se.prediktera.map.data.SimpleTable;
import se.prediktera.map.data.SimpleTableModel;
import se.prediktera.map.data.quicktable.QuickTable;
import se.prediktera.map.dataimport.FastDecimal;
import se.prediktera.map.datasetcontainer.Case;
import se.prediktera.map.datasetcontainer.classes.InnerColumnClass;
import se.prediktera.map.datasetcontainer.datainfo.AbstractDataInfo;
import se.prediktera.map.datasetcontainer.datainfo.ObservationInfo;
import se.prediktera.map.datasetcontainer.datainfo.VariablesInfo;
import se.prediktera.map.datasetcontainer.dataset.DataSet;
import se.prediktera.map.datasetcontainer.matrix.MVmatrix;
import se.prediktera.map.datasetcontainer.transform.category.Category;
import se.prediktera.map.main.layer.LayerContainer;
import se.prediktera.map.main.window.AbstractWindow;

public class TableSelectionPage
extends AbstractSelectionPage {
    private final JComboBox comboTextSearch = new JComboBox();
    private final JRadioButton checkNormalSearch = new JRadioButton("Normal");
    private final JCheckBox checkCaseSensitive = new JCheckBox("Case sensitive");
    private final JRadioButton checkRegularExpressions = new JRadioButton("Regular expressions");
    private final JRadioButton checkRelationships = new JRadioButton("Relationship");
    private final JLabel errorText = new JLabel();
    private final JComboBox comboBoxDirection = new JComboBox();
    private final JLabel directionLabel = new JLabel();
    private final JComboBox comboBoxFieldA = new JComboBox();
    private final JComboBox comboBoxFieldB = new JComboBox();
    private final SimpleTable table;
    private final SimpleTableModel model;
    private String searchValue;
    private Double searchNum;
    private final Regex regex = new Regex();
    private final PolynomParser polynomParser = new PolynomParser();
    private int dir = 0;

    public static void main(String[] stringArray) {
        Case case_ = new Case(2, 4);
        DataSet dataSet = case_.getOriginalDataSet();
        ObservationInfo observationInfo = dataSet.getObsDataInfo();
        Category category = new Category((AbstractDataInfo)observationInfo, "Category1", true);
        category.setCreated(null, observationInfo);
        LayerContainer layerContainer = (LayerContainer)observationInfo.getTransformationNode(category.getTransformationType());
        category.setLayerVisible(true);
        layerContainer.addTreeNode(category);
        InnerColumnClass innerColumnClass = category.getInnerColumn();
        innerColumnClass.getObject().addString("Class a");
        innerColumnClass.getObject().addString("Class b");
        VariablesInfo variablesInfo = dataSet.getVarDataInfo();
        Category category2 = new Category((AbstractDataInfo)variablesInfo, "Category2", false);
        category2.setCreated(null, variablesInfo);
        LayerContainer layerContainer2 = (LayerContainer)variablesInfo.getTransformationNode(category2.getTransformationType());
        category2.setLayerVisible(true);
        layerContainer2.addTreeNode(category2);
        MVmatrix mVmatrix = new MVmatrix(new double[][]{{1.0, 2.0, 3.0, 4.0}, {1.0, 2.0, 3.0, 4.0}}, 2, 4);
        case_.setOriginalMatrix(mVmatrix);
        DataInit dataInit = new DataInit(mVmatrix);
        QuickTable quickTable = new QuickTable(dataInit);
        new DataSelectionDialog(quickTable).showModal(quickTable);
    }

    public TableSelectionPage(AbstractTable abstractTable, SimpleTable simpleTable) {
        super(abstractTable);
        this.table = simpleTable;
        this.model = simpleTable.getSimpleTableModel();
        try {
            this.jbInit();
        }
        catch (Exception exception) {
            ErrorHandler.logAndReportException(exception);
        }
    }

    @Override
    protected void cleanUpChild() {
    }

    @Override
    protected void doSelection(int n) {
        Object object = this.comboTextSearch.getSelectedItem();
        if (object != null) {
            int n2 = this.comboBoxFieldA.getSelectedIndex();
            int n3 = this.comboBoxFieldB.getSelectedIndex();
            boolean bl = true;
            if (n == 1) {
                bl = false;
            }
            if (this.dir >= 0 && n2 >= 0) {
                FieldClass[] fieldClassArray = new FieldClass[]{new FieldClass('A'), new FieldClass('B')};
                this.searchValue = object.toString();
                try {
                    this.searchNum = Double.parseDouble(this.searchValue);
                }
                catch (NumberFormatException numberFormatException) {
                    this.searchNum = null;
                }
                this.table.getSelectedRows();
                if (!this.initSearch(this.searchValue, fieldClassArray)) {
                    return;
                }
                this.table.beginInteraction();
                if (this.dir == 0) {
                    int n4;
                    boolean[] blArray = null;
                    if (n == 2) {
                        blArray = new boolean[this.table.getRowCount()];
                        for (n4 = 0; n4 < this.table.getRowCount(); ++n4) {
                            if (!this.table.isRowSelected(n4)) continue;
                            blArray[n4] = true;
                        }
                        this.table.clearSelections();
                    }
                    this.table.selectState = 0;
                    this.table.getColumnModel().getSelectionModel().setSelectionInterval(0, this.table.getColumnCount() - 1);
                    for (n4 = 0; n4 < this.table.getRowCount(); ++n4) {
                        FastDecimal fastDecimal = this.model.getDoubleAt(n4, n2);
                        if (fastDecimal.isMissing()) {
                            fieldClassArray[0].setValue(this.getStringAt(n4, n2));
                            fieldClassArray[0].setNumerical(false);
                        } else {
                            fieldClassArray[0].setNum(fastDecimal.getValue());
                            fieldClassArray[0].setValue(String.valueOf(fastDecimal.getValue()));
                            if (fieldClassArray[1].isIncluded()) {
                                fieldClassArray[1].setNum(this.model.getDoubleAt(n4, n3).getValue());
                            }
                        }
                        if (!this.search(fieldClassArray[0]) || blArray != null && !blArray[n4]) continue;
                        if (bl) {
                            this.table.setRowSelectionInterval(n4, n4);
                            bl = false;
                            continue;
                        }
                        this.table.addRowSelectionInterval(n4, n4);
                    }
                } else if (this.dir == 1) {
                    int n5;
                    boolean[] blArray = null;
                    if (n == 2) {
                        blArray = new boolean[this.table.getColumnCount()];
                        for (n5 = 0; n5 < this.table.getColumnCount(); ++n5) {
                            if (!this.table.isColumnSelected(n5)) continue;
                            blArray[n5] = true;
                        }
                        this.table.clearSelections();
                    }
                    this.table.selectState = 1;
                    this.table.getSelectionModel().setSelectionInterval(0, this.table.getRowCount() - 1);
                    for (n5 = 0; n5 < this.table.getColumnCount(); ++n5) {
                        FastDecimal fastDecimal = this.model.getDoubleAt(n2, n5);
                        if (fastDecimal.isMissing()) {
                            fieldClassArray[0].setValue(this.getStringAt(n2, n5));
                        } else {
                            fieldClassArray[0].setNum(fastDecimal.getValue());
                            fieldClassArray[0].setValue(String.valueOf(fastDecimal.getValue()));
                            if (fieldClassArray[1].isIncluded()) {
                                fieldClassArray[1].setNum(this.model.getDoubleAt(n3, n5).getValue());
                            }
                        }
                        if (!this.search(fieldClassArray[0]) || blArray != null && !blArray[n5]) continue;
                        if (bl) {
                            this.table.setColumnSelectionInterval(n5, n5);
                            bl = false;
                            continue;
                        }
                        this.table.addColumnSelectionInterval(n5, n5);
                    }
                }
                this.table.endInteraction();
                this.table.getAbstractTable().interactiveSelection();
            }
        }
    }

    @Override
    protected void initPage(AbstractWindow abstractWindow) {
        this.directionChanged();
    }

    private void directionChanged() {
        this.dir = this.comboBoxDirection.getSelectedIndex();
        this.directionLabel.setText("In " + (this.dir == 0 ? "Column(s)" : "Row(s)") + ":");
        if (this.table != null) {
            int n = this.dir == 0 ? this.table.getColumnCount() : this.table.getRowCount();
            int n2 = this.comboBoxFieldA.getSelectedIndex() >= 0 ? this.comboBoxFieldA.getSelectedIndex() : 0;
            this.comboBoxFieldA.setModel(new CustomComboBoxModel(n));
            if (this.comboBoxFieldA.getItemCount() > n2) {
                this.comboBoxFieldA.setSelectedIndex(n2);
            }
            int n3 = this.comboBoxFieldB.getSelectedIndex() >= 0 ? this.comboBoxFieldB.getSelectedIndex() : 0;
            this.comboBoxFieldB.setModel(new CustomComboBoxModel(n));
            if (this.comboBoxFieldB.getItemCount() > n3) {
                this.comboBoxFieldB.setSelectedIndex(n3);
            }
        }
    }

    private String getStringAt(int n, int n2) {
        Object object = this.table.getValueAt(n, n2);
        TableCellRenderer tableCellRenderer = this.table.getCellRenderer(n, n2);
        Component component = tableCellRenderer.getTableCellRendererComponent(this.table, object, false, false, n, n2);
        return component.toString();
    }

    private boolean initSearch(String string, FieldClass[] fieldClassArray) {
        try {
            this.errorText.setText("");
            if (!this.checkCaseSensitive.isSelected()) {
                string = string.toUpperCase();
            }
            if (this.checkRegularExpressions.isSelected()) {
                this.regex.compile(string);
                this.regex.setIgnoreCase(!this.checkCaseSensitive.isSelected());
            }
            if (this.checkRelationships.isSelected()) {
                this.polynomParser.parse(string, fieldClassArray);
            }
            return true;
        }
        catch (Exception exception) {
            this.errorText.setText(exception.getMessage());
            return false;
        }
    }

    private void jbInit() throws Exception {
        this.setLayout(new BorderLayout());
        JPanel jPanel = new JPanel(new BorderLayout());
        JPanel jPanel2 = new JPanel(new GridBagLayout());
        JPanel jPanel3 = new JPanel(new GridLayout());
        jPanel.setBorder(BorderFactory.createRaisedBevelBorder());
        this.comboTextSearch.setEditable(true);
        this.checkCaseSensitive.setSelected(false);
        this.checkNormalSearch.setSelected(true);
        ItemListener itemListener = itemEvent -> this.comboBoxFieldB.setEnabled(this.checkRelationships.isSelected());
        this.checkNormalSearch.addItemListener(itemListener);
        this.checkRegularExpressions.addItemListener(itemListener);
        this.checkRelationships.addItemListener(itemListener);
        JPanel jPanel4 = new JPanel(new GridBagLayout());
        jPanel4.setBorder(EvinceBorderFactory.createEvinceBorder("Search method"));
        JPanel jPanel5 = new JPanel(new GridBagLayout());
        jPanel5.setBorder(EvinceBorderFactory.createEvinceBorder("Search for"));
        this.comboTextSearch.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent keyEvent) {
                if (keyEvent.getKeyCode() == 10) {
                    TableSelectionPage.this.doSelection(0);
                }
            }
        });
        this.comboBoxDirection.addItemListener(itemEvent -> {
            if (itemEvent.getStateChange() == 1) {
                this.directionChanged();
            }
        });
        this.comboBoxDirection.addItem("Rows");
        this.comboBoxDirection.addItem("Columns");
        this.add((Component)jPanel, "Center");
        jPanel.add((Component)jPanel2, "North");
        this.errorText.setForeground(Color.red);
        jPanel2.add((Component)new JLabel("Text to select:"), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 18, 0, new Insets(6, 6, 0, 0), 0, 0));
        jPanel2.add((Component)this.errorText, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 12, 0, new Insets(6, 6, 0, 6), 0, 0));
        jPanel2.add((Component)this.comboTextSearch, new GridBagConstraints(0, 1, 2, 1, 1.0, 0.0, 18, 2, new Insets(6, 6, 6, 6), 0, 0));
        jPanel.add((Component)jPanel3, "Center");
        jPanel3.add((Component)jPanel5, null);
        jPanel5.add((Component)this.comboBoxDirection, new GridBagConstraints(0, 0, 2, 1, 1.0, 0.0, 10, 2, new Insets(0, 6, 0, 6), 0, 0));
        jPanel5.add((Component)this.directionLabel, new GridBagConstraints(0, 1, 2, 1, 1.0, 0.0, 10, 2, new Insets(6, 18, 0, 6), 0, 0));
        jPanel5.add((Component)new JLabel("A:"), new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 18, 0, new Insets(6, 18, 0, 0), 0, 0));
        jPanel5.add((Component)this.comboBoxFieldA, new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 11, 2, new Insets(6, 6, 0, 6), 0, 0));
        jPanel5.add((Component)new JLabel("B:"), new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 18, 0, new Insets(6, 18, 0, 0), 0, 0));
        this.comboBoxFieldB.setEnabled(false);
        jPanel5.add((Component)this.comboBoxFieldB, new GridBagConstraints(1, 3, 1, 1, 1.0, 1.0, 11, 2, new Insets(6, 6, 6, 6), 0, 0));
        jPanel3.add((Component)jPanel4, null);
        jPanel4.add((Component)this.checkNormalSearch, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 18, 0, new Insets(6, 6, 0, 0), 0, 0));
        jPanel4.add((Component)new JLabel("ex: \"1.0\""), new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 18, 0, new Insets(6, 18, 0, 0), 0, 0));
        CSH.setHelpIDString((Component)this.checkRegularExpressions, (String)"tableSearchRegular");
        CSH.setHelpIDString((Component)this.checkRelationships, (String)"tableSearchRelation");
        jPanel4.add((Component)this.checkRelationships, new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 18, 0, new Insets(6, 6, 0, 0), 0, 0));
        jPanel4.add((Component)new JLabel("ex: \"A = 1 and B > 10\""), new GridBagConstraints(0, 5, 1, 1, 0.0, 0.0, 18, 0, new Insets(6, 18, 0, 0), 0, 0));
        jPanel4.add((Component)this.checkCaseSensitive, new GridBagConstraints(0, 6, 1, 1, 1.0, 1.0, 18, 0, new Insets(6, 6, 0, 0), 0, 0));
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.checkNormalSearch);
        buttonGroup.add(this.checkRegularExpressions);
        buttonGroup.add(this.checkRelationships);
    }

    private boolean search(FieldClass fieldClass) {
        if (this.checkNormalSearch.isSelected()) {
            if (this.searchNum != null && fieldClass.isNumerical()) {
                return this.searchNum.doubleValue() == fieldClass.getNum();
            }
            if (!this.checkCaseSensitive.isSelected()) {
                fieldClass.setValue(fieldClass.getValue().toUpperCase());
            }
            return fieldClass.getValue().equals(this.searchValue);
        }
        if (this.checkRegularExpressions.isSelected()) {
            return this.regex.search(fieldClass.getValue());
        }
        return this.polynomParser.evaluateRelation();
    }

    static class FieldClass
    extends PolyNode {
        private String value;

        public FieldClass(char c) {
            super(6, c);
        }

        @Override
        public String getValue() {
            return this.value;
        }

        public void setValue(String string) {
            this.value = string;
        }
    }

    class CustomComboBoxModel
    extends DefaultComboBoxModel {
        private final int size;

        public CustomComboBoxModel(int n) {
            this.size = n;
        }

        @Override
        public Object getElementAt(int n) {
            if (TableSelectionPage.this.dir == 0) {
                return TableSelectionPage.this.model.getRowDescription(0, n);
            }
            return TableSelectionPage.this.model.getColumnDescription(n, 0);
        }

        @Override
        public int getSize() {
            return this.size;
        }
    }
}

