/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.map.simpletableeditor.sortable;

import java.awt.Container;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.AbstractAction;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.JTableHeader;
import se.prediktera.map.data.fixed.FixedCornerTable;
import se.prediktera.map.datasetcontainer.DataTreeInterface;
import se.prediktera.map.main.Project_GUI;
import se.prediktera.map.simpletableeditor.ExtendScrollTable;
import se.prediktera.map.simpletableeditor.sortable.ExtendSortableTableModel;
import se.prediktera.map.simpletableeditor.sortable.SortButtonRenderer;

public class ExtendSortableScrollTable
extends ExtendScrollTable {
    protected HeaderListener headerListener;
    private int currentCol = -1;
    protected int clickCol = -1;
    private final PopupMenuListener pListener = new PopupMenuListener(){

        @Override
        public void popupMenuCanceled(PopupMenuEvent popupMenuEvent) {
        }

        @Override
        public void popupMenuWillBecomeInvisible(PopupMenuEvent popupMenuEvent) {
            int n = ExtendSortableScrollTable.this.getTableHeader().getTable().convertColumnIndexToView(ExtendSortableScrollTable.this.clickCol);
            ExtendSortableScrollTable.this.repaintColumn(n);
        }

        @Override
        public void popupMenuWillBecomeVisible(PopupMenuEvent popupMenuEvent) {
        }
    };

    public ExtendSortableScrollTable(JScrollPane jScrollPane, boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        super(jScrollPane, bl, bl2, bl3, bl4);
        this.setShowVerticalLines(true);
        this.setShowHorizontalLines(false);
        if (bl4) {
            this.addColListener();
        }
    }

    @Override
    public void addColHeader(ExtendScrollTable extendScrollTable) {
        this.addColListener();
        super.addColHeader(extendScrollTable);
    }

    public void addColListener() {
        JTableHeader jTableHeader = this.getTableHeader();
        this.headerRenderer = new SortButtonRenderer();
        this.headerListener = new HeaderListener(jTableHeader, (SortButtonRenderer)this.headerRenderer);
        jTableHeader.addMouseListener(this.headerListener);
    }

    public void addToHeaderPopup(MouseEvent mouseEvent, JPopupMenu jPopupMenu, int n) {
    }

    @Override
    public boolean addToPopup(Project_GUI project_GUI, DataTreeInterface dataTreeInterface, Point point, JPopupMenu jPopupMenu, boolean bl) {
        if (point != null) {
            jPopupMenu.addPopupMenuListener(this.pListener);
        }
        return super.addToPopup(project_GUI, dataTreeInterface, point, jPopupMenu, bl);
    }

    public int getCurrentColumnIndex() {
        return this.clickCol;
    }

    public HeaderListener getHeaderListener() {
        return this.headerListener;
    }

    public int getSortCol() {
        return this.headerListener.sortCol;
    }

    public boolean isAscending() {
        return this.headerListener.isAscent;
    }

    public boolean isDescription() {
        return this.headerListener.sortTable != null;
    }

    public void noSort() {
        if (this.headerListener != null) {
            this.headerListener.noSort();
        }
    }

    public void removeColListener() {
        if (this.headerListener != null) {
            JTableHeader jTableHeader = this.getTableHeader();
            jTableHeader.removeMouseListener(this.headerListener);
            this.headerListener = null;
        }
    }

    public void setCurrentColumn(int n) {
        this.setCurrentColumnNoPropagate(n);
    }

    public void setCurrentColumn(Point point) {
        this.setCurrentColumn(this.getTableHeader().columnAtPoint(point));
    }

    public void setCurrentColumnNoPropagate(int n) {
        if (this.clickCol >= 0) {
            this.repaintColumn(this.clickCol);
        }
        JTable jTable = this.getTableHeader().getTable();
        if (n >= 0 && n < jTable.getColumnCount()) {
            this.clickCol = jTable.convertColumnIndexToModel(n);
            this.repaintColumn(this.clickCol);
        }
        this.currentCol = this.clickCol;
    }

    @Override
    public void setModel(AbstractTableModel abstractTableModel) {
        super.setModel(abstractTableModel);
        if (this.colHeader != null) {
            this.getTableHeader().setDefaultRenderer(this.headerRenderer);
        }
    }

    public void sort() {
        if (this.headerListener != null) {
            this.headerListener.sort();
        }
    }

    public void sort(boolean bl, int n, boolean bl2, ExtendSortableScrollTable extendSortableScrollTable) {
        this.headerListener.sort(bl, n, bl2, extendSortableScrollTable);
    }

    public void sortAll() {
        if (this.headerListener != null) {
            this.headerListener.sortAll();
        }
    }

    public void updateInfo() {
    }

    @Override
    protected void cleanUpChild() {
        super.cleanUpChild();
        if (this.headerListener != null) {
            this.getTableHeader().removeMouseListener(this.headerListener);
            this.headerListener = null;
        }
    }

    private void repaintColumn(int n) {
        Rectangle rectangle = this.getCellRect(0, n, true);
        rectangle.height = this.getHeight();
        this.repaint(rectangle);
        this.getTableHeader().repaint();
    }

    protected class HeaderListener
    extends MouseAdapter {
        protected SortButtonRenderer renderer;
        protected boolean sortAll = false;
        protected int sortCol = -1;
        protected boolean isAscent = true;
        protected JTableHeader header;
        private ExtendSortableScrollTable sortTable = null;

        protected HeaderListener(JTableHeader jTableHeader, SortButtonRenderer sortButtonRenderer) {
            this.header = jTableHeader;
            this.renderer = sortButtonRenderer;
        }

        public ExtendSortableTableModel getHeaderModel() {
            return (ExtendSortableTableModel)this.header.getTable().getModel();
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            if (!(ExtendSortableScrollTable.this instanceof FixedCornerTable.CornerTable)) {
                ExtendSortableScrollTable.this.setCurrentColumn(this.header.columnAtPoint(mouseEvent.getPoint()));
            }
            this.showPopupMenu(mouseEvent);
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
            this.showPopupMenu(mouseEvent);
        }

        public void noSort() {
            ExtendSortableTableModel extendSortableTableModel = (ExtendSortableTableModel)this.header.getTable().getModel();
            extendSortableTableModel.sortByColumn(false, -1, true, this.sortTable == null ? null : this.sortTable.getModel());
        }

        public void selectColumn(int n) {
            this.renderer.setPressedColumn(n);
            this.renderer.setSelectedColumn(this.sortAll, n, this.isAscent);
        }

        public void set(boolean bl, int n, boolean bl2, ExtendSortableScrollTable extendSortableScrollTable) {
            this.sortAll = bl;
            this.sortCol = n;
            this.isAscent = bl2;
            if (this.sortTable != null && !this.sortTable.equals(extendSortableScrollTable)) {
                this.sortTable.getHeaderListener().selectColumn(-1);
            }
            if (extendSortableScrollTable != null) {
                this.selectColumn(-1);
            }
            this.sortTable = extendSortableScrollTable;
        }

        public void showPopupMenu(MouseEvent mouseEvent) {
            if (mouseEvent.isPopupTrigger() && this.header.getTable().getModel() instanceof ExtendSortableTableModel) {
                Point point = mouseEvent.getPoint();
                JPopupMenu jPopupMenu = new JPopupMenu();
                jPopupMenu.add(new JMenuItem(new AbstractAction("Sort by Index"){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        HeaderListener.this.sort(HeaderListener.this.sortAll, -1, true, null);
                    }
                }));
                jPopupMenu.add(new JMenuItem(new AbstractAction("Sort Ascending"){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        HeaderListener.this.sort(HeaderListener.this.sortAll, ExtendSortableScrollTable.this.currentCol, true, null);
                    }
                }));
                jPopupMenu.add(new JMenuItem(new AbstractAction("Sort Descending"){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        HeaderListener.this.sort(HeaderListener.this.sortAll, ExtendSortableScrollTable.this.currentCol, false, null);
                    }
                }));
                ExtendSortableScrollTable.this.addToHeaderPopup(mouseEvent, jPopupMenu, ExtendSortableScrollTable.this.clickCol);
                jPopupMenu.addPopupMenuListener(ExtendSortableScrollTable.this.pListener);
                jPopupMenu.show(this.header, point.x, point.y);
            }
        }

        public void sort() {
            Container container;
            this.header.repaint();
            this.selectColumn(this.sortTable == null ? this.sortCol : -1);
            if (this.header.getTable().isEditing()) {
                this.header.getTable().getCellEditor().stopCellEditing();
            }
            ExtendSortableTableModel extendSortableTableModel = this.getHeaderModel();
            extendSortableTableModel.sortByColumn(this.sortAll, this.sortCol, this.isAscent, this.sortTable == null ? null : this.sortTable.getModel());
            extendSortableTableModel.fireTableDataChanged();
            this.renderer.setPressedColumn(-1);
            this.header.repaint();
            Container container2 = this.header;
            while ((container = container2.getParent()) != null) {
                if (container instanceof Project_GUI) {
                    Project_GUI project_GUI = (Project_GUI)container;
                    project_GUI.getData_GUI().repaint();
                }
                container2 = container;
            }
        }

        public void sort(boolean bl, int n, boolean bl2, ExtendSortableScrollTable extendSortableScrollTable) {
            this.set(bl, n, bl2, extendSortableScrollTable);
            this.sort();
            ExtendSortableScrollTable.this.updateInfo();
        }

        public void sortAll() {
            this.sortAll = true;
            ExtendSortableTableModel extendSortableTableModel = (ExtendSortableTableModel)this.header.getTable().getModel();
            extendSortableTableModel.sortByColumn(this.sortAll, 0, true, this.sortTable == null ? null : this.sortTable.getModel());
        }
    }
}

