/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.map.simpletableeditor.sortable;

import javax.swing.table.TableModel;
import se.prediktera.map.dataimport.FastDecimal;
import se.prediktera.map.simpletableeditor.ExtendTableModel;
import se.prediktera.map.simpletableeditor.sortable.TableSorter;

public abstract class ExtendSortableTableModel
extends ExtendTableModel {
    private int[][] indexes;
    private int[][] resolveindexes;
    private boolean sortAll = false;
    private TableSorter sorter;

    public ExtendSortableTableModel(int n, int n2, boolean bl) {
        super(n, n2, bl);
    }

    @Override
    public FastDecimal getDoubleAt_Transpose(int n, int n2, FastDecimal fastDecimal) {
        if (this.transpose) {
            return this.getDoubleAt_Transpose_Sort(n, this.getSortedRow(n2, n), fastDecimal);
        }
        return this.getDoubleAt_Transpose_Sort(this.getSortedRow(n, n2), n2, fastDecimal);
    }

    public abstract FastDecimal getDoubleAt_Transpose_Sort(int var1, int var2, FastDecimal var3);

    public int[][] getIndexes() {
        int n;
        int n2 = this.getRowCount();
        int n3 = n = this.sortAll ? this.getColumnCount() : 1;
        if (this.indexes != null && this.indexes.length == n) {
            if (this.indexes[0].length == n2) {
                return this.indexes;
            }
        } else {
            this.indexes = new int[n][];
        }
        for (int i = 0; i < this.indexes.length; ++i) {
            this.indexes[i] = new int[n2];
        }
        return this.indexes;
    }

    public int getSortedRow(int n, int n2) {
        if (this.sortAll) {
            return this.indexes[n2][n];
        }
        return this.getSortIndexForRow(n);
    }

    public int getSortIndexForRow(int n) {
        if (this.indexes != null && n < this.indexes[0].length) {
            n = this.indexes[0][n];
        }
        return n;
    }

    @Override
    public Object getValueAt(int n, int n2) {
        int[] nArray;
        int[] nArray2 = this.getRowIndex();
        if (this.indexes != null && n < this.indexes[0].length) {
            n = this.getSortedRow(n, n2);
        }
        if (nArray2 != null && n < nArray2.length) {
            n = nArray2[n];
        }
        if ((nArray = this.getColumnIndex()) != null && n2 < nArray.length) {
            n2 = nArray[n2];
        }
        if (n < 0 || n2 < 0) {
            return "Index out of bounds < 0";
        }
        if (this.transpose) {
            return this.getValueAt_Sort(n2, n);
        }
        return this.getValueAt_Sort(n, n2);
    }

    public abstract Object getValueAt_Sort(int var1, int var2);

    @Override
    public Object getValueAt_Transpose(int n, int n2) {
        if (this.transpose) {
            return this.getValueAt_Sort(n, this.getSortedRow(n2, n));
        }
        return this.getValueAt_Sort(this.getSortedRow(n, n2), n2);
    }

    public int resolveRowSortIndex(int n) {
        if (this.resolveindexes != null) {
            if (n < 0 || n >= this.resolveindexes[0].length) {
                return -1;
            }
            n = this.resolveindexes[0][n];
        }
        return n;
    }

    @Override
    public void setValueAt(Object object, int n, int n2) {
        int[] nArray;
        int[] nArray2 = this.getRowIndex();
        if (this.indexes != null && n < this.indexes[0].length) {
            n = this.getSortedRow(n, n2);
        }
        if (nArray2 != null) {
            n = nArray2[n];
        }
        if ((nArray = this.getColumnIndex()) != null) {
            n2 = nArray[n2];
        }
        if (this.transpose) {
            this.setValueAt_Sort(object, n2, n);
        } else {
            this.setValueAt_Sort(object, n, n2);
        }
    }

    public abstract void setValueAt_Sort(Object var1, int var2, int var3);

    @Override
    public void setValueAt_Transpose(Object object, int n, int n2) {
        if (this.transpose) {
            this.setValueAt_Sort(object, n, this.getSortedRow(n2, n));
        }
        this.setValueAt_Sort(object, this.getSortedRow(n, n2), n2);
    }

    public void sortByColumn(boolean bl, int n, boolean bl2, TableModel tableModel) {
        this.sortAll = bl;
        if (n < 0) {
            this.indexes = null;
            this.resolveindexes = null;
        } else {
            if (this.sorter == null) {
                this.sorter = new TableSorter(this);
            }
            this.indexes = this.sorter.sort(bl, n, tableModel, bl2);
            if (this.indexes != null) {
                this.resolveindexes = new int[this.indexes.length][];
                for (int i = 0; i < this.indexes.length; ++i) {
                    this.resolveindexes[i] = new int[this.indexes[i].length];
                    for (int j = 0; j < this.indexes[i].length; ++j) {
                        this.resolveindexes[i][this.indexes[i][j]] = j;
                    }
                }
            }
        }
    }
}

