/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.map.simpletableeditor.sortable;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import javax.swing.table.TableModel;
import se.prediktera.map.data.SimpleTableModel;
import se.prediktera.map.dataimport.FastDecimal;
import se.prediktera.map.simpletableeditor.sortable.ExtendSortableTableModel;

public class TableSorter {
    private final ExtendSortableTableModel model;
    private SimpleTableModel simpleModel;
    private int sortColumn;

    public TableSorter(ExtendSortableTableModel extendSortableTableModel) {
        this.model = extendSortableTableModel;
        if (extendSortableTableModel instanceof SimpleTableModel) {
            this.simpleModel = (SimpleTableModel)extendSortableTableModel;
        }
    }

    public void resetOrder() {
        int[][] nArray = this.model.getIndexes();
        for (int i = 0; i < nArray.length; ++i) {
            if (nArray[i] == null) continue;
            for (int j = 0; j < nArray[i].length; ++j) {
                nArray[i][j] = j;
            }
        }
    }

    public int[][] sort(boolean bl, int n, TableModel tableModel, boolean bl2) {
        Comparator<Integer> comparator;
        this.sortColumn = n;
        int n2 = this.model.getRowCount();
        int[][] nArray = this.model.getIndexes();
        ArrayList<Integer> arrayList = new ArrayList<Integer>(n2);
        for (int i = 0; i < n2; ++i) {
            arrayList.add(i);
        }
        if (this.simpleModel == null) {
            comparator = new DefaultTableSorter();
        } else {
            this.simpleModel.beginCalculations();
            comparator = tableModel == null ? new SimpleTableComparator(this.simpleModel) : new TableComparator(tableModel);
        }
        for (int i = 0; i < nArray.length; ++i) {
            int n3;
            if (bl) {
                this.sortColumn = i;
            }
            for (n3 = 0; n3 < n2; ++n3) {
                nArray[i][n3] = n3;
            }
            Collections.sort(arrayList, comparator);
            for (n3 = 0; n3 < n2; ++n3) {
                nArray[i][n3] = (Integer)arrayList.get(bl2 ? n3 : n2 - n3 - 1);
            }
        }
        if (this.simpleModel != null) {
            this.simpleModel.endCalculations();
        }
        return nArray;
    }

    public class DefaultTableSorter
    implements Comparator<Integer> {
        @Override
        public int compare(Integer n, Integer n2) {
            Object object = TableSorter.this.model.getValueAt(n, TableSorter.this.sortColumn);
            Object object2 = TableSorter.this.model.getValueAt(n2, TableSorter.this.sortColumn);
            if (object == null && object2 == null) {
                return 0;
            }
            if (object == null) {
                return -1;
            }
            if (object2 == null) {
                return 1;
            }
            Class<?> clazz = TableSorter.this.model.getColumnClass(TableSorter.this.sortColumn);
            if (clazz.getSuperclass() == Number.class) {
                return this.compareInternal((Integer)object, (Integer)object2);
            }
            if (clazz == String.class) {
                return ((String)object).compareToIgnoreCase((String)object2);
            }
            if (clazz == Date.class) {
                return this.compareInternal((Date)object, (Date)object2);
            }
            if (clazz == Boolean.class) {
                return this.compareInternal((Boolean)object, (Boolean)object2);
            }
            return 1;
        }

        public int compareInternal(Boolean bl, Boolean bl2) {
            boolean bl3;
            boolean bl4 = bl;
            if (bl4 == (bl3 = bl2.booleanValue())) {
                return 0;
            }
            if (bl4) {
                return 1;
            }
            return -1;
        }

        public int compareInternal(Date date, Date date2) {
            long l = date.getTime();
            long l2 = date2.getTime();
            return Double.compare(l, l2);
        }

        public int compareInternal(Integer n, Integer n2) {
            return Double.compare(n.intValue(), n2.intValue());
        }
    }

    public class SimpleTableComparator
    implements Comparator<Integer> {
        private final SimpleTableModel sortModel;

        public SimpleTableComparator(SimpleTableModel simpleTableModel) {
            this.sortModel = simpleTableModel;
        }

        @Override
        public int compare(Integer n, Integer n2) {
            FastDecimal fastDecimal = this.sortModel.getDoubleAt(n, TableSorter.this.sortColumn);
            if (fastDecimal == null) {
                return 0;
            }
            double d = fastDecimal.getValue();
            FastDecimal fastDecimal2 = this.sortModel.getDoubleAt(n2, TableSorter.this.sortColumn);
            if (fastDecimal2 == null) {
                return 0;
            }
            double d2 = fastDecimal2.getValue();
            return Double.compare(d, d2);
        }
    }

    public class TableComparator
    implements Comparator<Integer> {
        private final TableModel sortModel;

        public TableComparator(TableModel tableModel) {
            this.sortModel = tableModel;
        }

        @Override
        public int compare(Integer n, Integer n2) {
            String string = this.sortModel.getValueAt(n, TableSorter.this.sortColumn).toString();
            String string2 = this.sortModel.getValueAt(n2, TableSorter.this.sortColumn).toString();
            Double d = null;
            Double d2 = null;
            try {
                d = Double.valueOf(string);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            try {
                d2 = Double.valueOf(string2);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            if (d != null && d2 != null) {
                return d.compareTo(d2);
            }
            if (d != null) {
                return 1;
            }
            if (d2 != null) {
                return -1;
            }
            return string.compareToIgnoreCase(string2);
        }
    }
}

