/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.map.statistic;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import se.prediktera.map.common.CMenu;
import se.prediktera.map.common.CMenuItem;
import se.prediktera.map.common.MapProperty;
import se.prediktera.map.common.RandomInputStream;
import se.prediktera.map.common.RandomOutputStream;
import se.prediktera.map.common.error.ErrorHandler;
import se.prediktera.map.common.progress.ProgressManagerImpl;
import se.prediktera.map.common.wizard.AbstractWizardInfo;
import se.prediktera.map.common.wizard.WizardInfoInterface;
import se.prediktera.map.components.paint.AbstractPaint;
import se.prediktera.map.data.modeltable.ModelTableInterface;
import se.prediktera.map.datasetcontainer.DataTreeInterface;
import se.prediktera.map.datasetcontainer.dataset.DataSet;
import se.prediktera.map.datasetcontainer.event.DataTreeEvent;
import se.prediktera.map.main.IniManager;
import se.prediktera.map.main.Main_GUI;
import se.prediktera.map.main.Project_GUI;
import se.prediktera.map.main.script.AbstractScriptDataClass;
import se.prediktera.map.main.script.ScriptManager;
import se.prediktera.map.model.ModelListener;
import se.prediktera.map.statistic.AbstractStatisticInfo;
import se.prediktera.map.statistic.StatisticGeneratorWizard;

public abstract class AbstractStatistic
extends AbstractScriptDataClass
implements ModelTableInterface {
    public static final ImageIcon statisticsIcon = AbstractPaint.createIcon(17);
    private final ArrayList<ModelListener> listeners = new ArrayList();

    public static void createWindowFromWizard(final DataSet dataSet, WizardInfoInterface wizardInfoInterface) {
        final StatisticGeneratorWizard statisticGeneratorWizard = new StatisticGeneratorWizard(null, dataSet.getStatisticContainer(), dataSet, (AbstractStatisticInfo)wizardInfoInterface);
        if (statisticGeneratorWizard.executeWizard() == 1 && statisticGeneratorWizard.checkStatistic(dataSet)) {
            ProgressManagerImpl progressManagerImpl = new ProgressManagerImpl(){

                @Override
                public Object doWork() {
                    Object var1_1 = null;
                    try {
                        AbstractStatisticInfo abstractStatisticInfo = statisticGeneratorWizard.getSelectedInfo();
                        if (abstractStatisticInfo != null) {
                            String string;
                            AbstractStatistic abstractStatistic = abstractStatisticInfo.createStatistic(this, dataSet, null);
                            dataSet.getStatisticContainer().addTreeNode(abstractStatistic);
                            Project_GUI project_GUI = dataSet.getProject_GUI();
                            if (project_GUI != null) {
                                project_GUI.updateDataTree(abstractStatistic);
                            }
                            if ((string = abstractStatisticInfo.getScript()).length() > 0) {
                                ScriptManager scriptManager = new ScriptManager(null);
                                scriptManager.addVariable(abstractStatistic, "statistic");
                                scriptManager.evaluteScript(this, string);
                            }
                        }
                    }
                    catch (Exception exception) {
                        ErrorHandler.logAndShowEvinceErrorDialogForException(exception);
                    }
                    return var1_1;
                }
            };
            progressManagerImpl.invokeNow();
        }
        statisticGeneratorWizard.cleanUp();
    }

    public static CMenu getStatisticMenu(DataSet dataSet) {
        CMenu cMenu = new CMenu("New Statistics", false);
        cMenu.setIcon(statisticsIcon);
        Vector<AbstractWizardInfo> vector = new Vector<AbstractWizardInfo>();
        StatisticGeneratorWizard.addExternStatistic(vector, dataSet, false);
        if (vector.isEmpty()) {
            return null;
        }
        if (vector.size() > 1) {
            CMenuItem cMenuItem = new CMenuItem("Wizard", false);
            cMenuItem.addActionListener(actionEvent -> AbstractStatistic.createWindowFromWizard(dataSet, null));
            cMenu.add(cMenuItem);
            cMenu.addSeparator();
        }
        for (int i = 0; i < vector.size(); ++i) {
            AbstractStatisticInfo abstractStatisticInfo = (AbstractStatisticInfo)vector.elementAt(i);
            CMenuItem cMenuItem = new CMenuItem(abstractStatisticInfo.toString(), false);
            cMenuItem.addActionListener(actionEvent -> AbstractStatistic.createWindowFromWizard(dataSet, abstractStatisticInfo));
            cMenuItem.setEnabled(abstractStatisticInfo.supportData(dataSet));
            cMenu.add(cMenuItem);
        }
        return cMenu;
    }

    public AbstractStatistic() {
        super("Statistics");
    }

    public AbstractStatistic(RandomInputStream randomInputStream, MapProperty mapProperty) throws IOException {
        super(randomInputStream, mapProperty);
    }

    @Override
    public void addModelListener(ModelListener modelListener) {
        this.listeners.add(modelListener);
    }

    public void addToPopupMenu(final Project_GUI project_GUI, JPopupMenu jPopupMenu) {
        if (project_GUI == null) {
            return;
        }
        jPopupMenu.add(project_GUI.getData_GUI().getTableMenu(this));
        jPopupMenu.add(project_GUI.getPlot_GUI().getPlotMenu(this));
        jPopupMenu.addSeparator();
        CMenuItem cMenuItem = new CMenuItem(this, "Delete", new ImageIcon(Main_GUI.class.getResource("gif/delete.png"))){
            final /* synthetic */ AbstractStatistic this$0;
            {
                this.this$0 = abstractStatistic;
                super(string, imageIcon);
            }

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                int n = JOptionPane.showConfirmDialog(IniManager.getMainFrame(), "Really delete \"" + String.valueOf(this.this$0) + "\"?", "Really delete?", 2);
                if (n == 0) {
                    this.this$0.cleanUp();
                    if (project_GUI != null) {
                        project_GUI.purgeSignal();
                    }
                }
            }
        };
        jPopupMenu.add(cMenuItem);
        cMenuItem = new CMenuItem("Rename", true);
        cMenuItem.setIcon(new ImageIcon(Main_GUI.class.getResource("gif/rename.png")));
        cMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                String string = JOptionPane.showInputDialog(IniManager.getMainFrame(), "Enter the new name for the model:", AbstractStatistic.this.toString());
                if (string != null) {
                    AbstractStatistic.this.setName(string);
                    AbstractStatistic.this.triggerPropertyEvent(new DataTreeEvent((Object)this, (DataTreeInterface)AbstractStatistic.this, string));
                }
            }
        });
        jPopupMenu.add(cMenuItem);
    }

    @Override
    public ImageIcon getIcon(byte by) {
        return statisticsIcon;
    }

    @Override
    public void removeModelListener(ModelListener modelListener) {
        this.listeners.remove(modelListener);
    }

    @Override
    protected void SavePropertyLocal(RandomOutputStream randomOutputStream) throws IOException {
    }
}

