/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.mda.model;

import java.util.AbstractList;
import java.util.Properties;
import java.util.Vector;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import se.prediktera.map.common.error.ErrorHandler;
import se.prediktera.map.common.progress.ProgressManager;
import se.prediktera.map.common.wizard.AbstractInit;
import se.prediktera.map.datasetcontainer.Case;
import se.prediktera.map.datasetcontainer.DataContainer;
import se.prediktera.map.datasetcontainer.DataTreeClass;
import se.prediktera.map.datasetcontainer.DataTreeInterface;
import se.prediktera.map.datasetcontainer.DataTreeManager;
import se.prediktera.map.datasetcontainer.classes.ClassTypes;
import se.prediktera.map.datasetcontainer.classes.InnerColumnClass;
import se.prediktera.map.datasetcontainer.datainfo.AbstractInnerColumn;
import se.prediktera.map.datasetcontainer.datainfo.InnerColumnBooleanIncExc;
import se.prediktera.map.datasetcontainer.datainfo.InnerColumnBooleanXY;
import se.prediktera.map.datasetcontainer.datainfo.InnerColumnType;
import se.prediktera.map.datasetcontainer.datainfo.VariablesInfo;
import se.prediktera.map.datasetcontainer.dataset.DataSet;
import se.prediktera.map.datasetcontainer.matrix.AbstractDataMatrix;
import se.prediktera.map.datasetcontainer.matrix.LayerMatrix;
import se.prediktera.map.datasetcontainer.transform.category.EqualSizeAnalysisInfo;
import se.prediktera.map.main.script.AbstractScriptInfo;
import se.prediktera.map.main.script.EvinceScriptCommands;
import se.prediktera.map.main.script.ScriptHelper;
import se.prediktera.map.main.script.ScriptManager;
import se.prediktera.map.main.window.AbstractWindow;
import se.prediktera.map.model.AbstractModel;
import se.prediktera.map.model.AbstractModelContainerWindow;
import se.prediktera.map.model.ModelHelper;
import se.prediktera.map.model.modelgenerator.AbstractModelInfo;
import se.prediktera.map.model.modelgenerator.ModelInit;
import se.prediktera.mda.model.AbstractMDAModel;
import se.prediktera.mda.model.CommonPanel;
import se.prediktera.mda.model.CrossvalidationPanel;
import se.prediktera.mda.model.ModelContainer;
import se.prediktera.mda.model.PCA.PCAModelInformation;
import se.prediktera.mda.model.PLS.PLSModel;
import se.prediktera.mda.model.PLS.PLSModelInformation;

public abstract class AbstractCVModelInfo
extends AbstractModelInfo {
    protected CommonPanel commonPanel;

    @Override
    public void beginWizard(AbstractInit abstractInit) {
        ModelInit modelInit = (ModelInit)abstractInit;
        modelInit.setModelName(this.toString());
        modelInit.setModelType(this.getType());
        Vector<AbstractModelContainerWindow> vector = this.getSupportedModelWindows(modelInit.getDataContainer());
        if (this.commonPanel != null) {
            this.commonPanel.beginWizard(modelInit, vector, this.baseModel);
        }
    }

    @Override
    public boolean checkModel(ModelInit modelInit) {
        return this.checkCurrentDataSet(modelInit.getDataSet());
    }

    @Override
    public AbstractModel createModel(ProgressManager progressManager, DataSet dataSet, int n, Properties properties) {
        int n2;
        Object object;
        ModelInit modelInit = new ModelInit(dataSet);
        modelInit.setModelName(dataSet.getUniqueName(this.toString()));
        if (properties != null) {
            if (ScriptHelper.hasKeyValue(properties, "crossvalidation", "true")) {
                if (ScriptHelper.hasKey(properties, "cvfull")) {
                    modelInit.typeisfull = ScriptHelper.getPropertyBool(properties, "cvfull");
                }
                if (ScriptHelper.hasKey(properties, "cvgroups")) {
                    modelInit.nr_groups = ScriptHelper.getPropertyInt(properties, "cvgroups");
                }
                modelInit.crossvalidationType = 1;
                if (ScriptHelper.hasKey(properties, "cvtype")) {
                    object = EvinceScriptCommands.removeSpace(ScriptHelper.getProperty(properties, "cvtype"));
                    for (n2 = 0; n2 < AbstractMDAModel.CV_NAME.length; n2 = (int)((byte)(n2 + 1))) {
                        if (!((String)object).equalsIgnoreCase(EvinceScriptCommands.removeSpace(AbstractMDAModel.CV_NAME[n2]))) continue;
                        modelInit.crossvalidationType = (byte)n2;
                        break;
                    }
                }
            }
            if (ScriptHelper.hasKey(properties, "randomseed")) {
                modelInit.randomSeed = (long)ScriptHelper.getPropertyDouble(properties, "randomseed");
            }
            if (ScriptHelper.hasKey(properties, "calcci")) {
                modelInit.calc_ci = ScriptHelper.getPropertyBool(properties, "calcci");
                modelInit.setConfidenceInterval(modelInit.calc_ci);
            }
            if (ScriptHelper.hasKey(properties, "cvcategory")) {
                modelInit.cvCategoryName = ScriptHelper.getProperty(properties, "cvcategory");
            }
            if (ScriptHelper.hasKey(properties, "category")) {
                modelInit.categoryName = ScriptHelper.getProperty(properties, "category");
            }
            if (ScriptHelper.hasKey(properties, "singley")) {
                modelInit.singleY = ScriptHelper.getPropertyBool(properties, "singley");
            }
            if (ScriptHelper.hasKey(properties, "ycategory")) {
                modelInit.yCategoryName = ScriptHelper.getProperty(properties, "ycategory");
            }
            if (ScriptHelper.hasKey(properties, "name")) {
                modelInit.setModelName(ScriptHelper.getProperty(properties, "name"));
            }
            if (ScriptHelper.hasKey(properties, "rethrowexceptions")) {
                modelInit.rethrowExceptions = ScriptHelper.getPropertyBool(properties, "rethrowexceptions");
            }
            if (ScriptHelper.hasKey(properties, "removezerovariance")) {
                modelInit.removeZeroVariance = ScriptHelper.getPropertyBool(properties, "removezerovariance");
            }
            if (ScriptHelper.hasKey(properties, "calcdmodx")) {
                modelInit.calcDmodx = ScriptHelper.getPropertyBool(properties, "calcdmodx");
            }
        }
        object = this.createNewModel(progressManager, modelInit);
        if (properties != null && object != null) {
            if (ScriptHelper.hasKey(properties, "concentration") && object instanceof PLSModel) {
                ((PLSModel)object).setConcentration(ScriptHelper.getPropertyBool(properties, "concentration"));
            }
            if (ScriptHelper.hasKey(properties, "cutofflow")) {
                ((AbstractModel)object).setCutOffLow(ScriptHelper.getPropertyDouble(properties, "cutofflow"));
            }
            if (ScriptHelper.hasKey(properties, "cutoffhigh")) {
                ((AbstractModel)object).setCutOffHigh(ScriptHelper.getPropertyDouble(properties, "cutoffhigh"));
            }
            if (ScriptHelper.hasKey(properties, "dcrit")) {
                ((AbstractModel)object).setDcritX(ScriptHelper.getPropertyDouble(properties, "dcrit"));
            }
            if (ScriptHelper.hasKey(properties, "min_variance")) {
                n2 = ScriptHelper.getPropertyInt(properties, "min_variance");
                ((AbstractMDAModel)object).setMinvariance(n2);
            }
            if (ScriptHelper.hasKey(properties, "min_variance_percent")) {
                double d = ScriptHelper.getPropertyDouble(properties, "min_variance_percent");
                AbstractDataMatrix abstractDataMatrix = dataSet.getOriginalMatrix();
                int n3 = (int)(d / 100.0 * (double)abstractDataMatrix.getN());
                ((AbstractMDAModel)object).setMinvariance(n3);
            }
            if (ScriptHelper.hasKey(properties, "maxcomponents")) {
                ((AbstractMDAModel)object).setMaxComponents(ScriptHelper.getPropertyInt(properties, "maxcomponents"));
            }
        }
        if (n < 0) {
            this.beginWizard(modelInit);
            n = this.getNumberOfComponents(dataSet);
        }
        this.calcModel(progressManager, (AbstractMDAModel)object, dataSet, n);
        dataSet.addTreeNode((DataTreeInterface)object);
        return object;
    }

    @Override
    public AbstractWindow createModel(ProgressManager progressManager, ModelInit modelInit) {
        AbstractList abstractList;
        AbstractModelContainerWindow abstractModelContainerWindow;
        boolean bl = modelInit.getDataTreeInterface() instanceof AbstractModel;
        if (this.commonPanel.getCurrentMcw() != null) {
            abstractModelContainerWindow = this.commonPanel.getCurrentMcw();
        } else {
            abstractList = this.getSupportedModelWindows(modelInit.getDataContainer());
            abstractModelContainerWindow = ((Vector)abstractList).get(0);
        }
        abstractList = modelInit.getDataSet();
        progressManager.setInfoText("Preparing model");
        DataTreeManager dataTreeManager = ((DataTreeClass)abstractList).getDataTreeManager();
        AbstractDataMatrix abstractDataMatrix = ((DataSet)abstractList).getOriginalMatrix();
        dataTreeManager.ClearDataFromMemoryIfExceedPercent(abstractDataMatrix, progressManager, abstractDataMatrix.getDataByteSize(), 0.5);
        this.setModelInitFromPanel(modelInit, (DataSet)abstractList);
        if (modelInit.isEqualsize()) {
            EqualSizeAnalysisInfo.performAnalysis(progressManager, (DataSet)abstractList, modelInit.getIcClass());
        }
        AbstractMDAModel abstractMDAModel = this.createNewModel(progressManager, modelInit);
        DataContainer dataContainer = abstractModelContainerWindow.getDataContainer();
        if (abstractMDAModel != null) {
            String string;
            if (abstractDataMatrix.isLoaded()) {
                dataTreeManager.ClearDataFromMemoryIfExceedPercent(abstractDataMatrix, progressManager, 0L, 0.5);
            }
            System.gc();
            if (!(modelInit.getDataTreeInterface() instanceof AbstractModel)) {
                ((DataTreeClass)abstractList).addTreeNode(abstractMDAModel);
                dataContainer.addShortcut(abstractMDAModel);
            }
            int n = this.getNumberOfComponents((DataSet)abstractList);
            if (bl) {
                abstractMDAModel.changeComponent(progressManager, -abstractMDAModel.getComponentsInt());
            }
            this.calcModel(progressManager, abstractMDAModel, (DataSet)abstractList, n);
            dataTreeManager.ClearDataFromMemoryIfExceedPercent(abstractMDAModel, progressManager, 0L, 0.5);
            System.gc();
            abstractMDAModel.updateModelContainer((byte)-1);
            SwingUtilities.invokeLater(() -> abstractModelContainerWindow.selectInformation(abstractMDAModel));
            AbstractScriptInfo abstractScriptInfo = this.commonPanel.getScriptInfo(modelInit);
            if (abstractScriptInfo != null && (string = abstractScriptInfo.getScript()).length() > 0) {
                try {
                    if (!(modelInit.getDataTreeInterface() instanceof AbstractModel)) {
                        ScriptManager scriptManager = new ScriptManager(null);
                        scriptManager.addVariable(abstractMDAModel, "model");
                        scriptManager.evaluteScript(progressManager, string);
                    }
                }
                catch (Exception exception) {
                    ErrorHandler.logAndReportException(exception);
                }
            }
        }
        if (this.commonPanel != null) {
            this.commonPanel.cleanUp();
            this.commonPanel = null;
        }
        abstractDataMatrix.exitDiskMode();
        return abstractModelContainerWindow;
    }

    @Override
    public AbstractModelContainerWindow createModelContainerWindow(Case case_, DataContainer dataContainer) {
        String string = this.getType();
        if (string.equals("pca")) {
            return new PCAModelInformation(case_, dataContainer);
        }
        return new PLSModelInformation(case_, dataContainer);
    }

    @Override
    public Vector<JComponent> createWizard() {
        this.wizard.removeAllElements();
        this.commonPanel = this.createCommonPanel();
        this.wizard.add(this.commonPanel);
        return this.wizard;
    }

    @Override
    public boolean supportData(DataTreeInterface dataTreeInterface) {
        if (!super.supportData(dataTreeInterface)) {
            return false;
        }
        DataSet dataSet = this.getDataSet(dataTreeInterface);
        return dataSet != null && dataSet.getMatrix(0).getN() > 1 && dataSet.getMatrix(0).getK() > 0;
    }

    @Override
    protected void cleanUpChild() {
    }

    protected ModelContainer createClassContainer(DataSet dataSet, String string, String string2, int n) {
        return new ModelContainer(dataSet, string, string2, n);
    }

    protected CommonPanel createCommonPanel() {
        return new CommonPanel(this);
    }

    protected abstract AbstractMDAModel createNewModel(ProgressManager var1, ModelInit var2, int[] var3, int[] var4, int var5, String var6);

    protected DataSet getDataSet(DataTreeInterface dataTreeInterface) {
        DataSet dataSet = null;
        if (dataTreeInterface instanceof DataSet) {
            dataSet = (DataSet)dataTreeInterface;
        } else if (dataTreeInterface instanceof AbstractModel) {
            dataSet = ((AbstractModel)dataTreeInterface).getDataSet();
        }
        return dataSet;
    }

    protected String getDefaultName(ModelInit modelInit) {
        AbstractList abstractList;
        AbstractModelContainerWindow abstractModelContainerWindow = this.commonPanel.getCurrentMcw();
        if (abstractModelContainerWindow == null) {
            abstractList = this.getSupportedModelWindows(modelInit.getDataContainer());
            abstractModelContainerWindow = (AbstractModelContainerWindow)((Vector)abstractList).get(0);
        }
        abstractList = abstractModelContainerWindow.getDataContainer();
        return ((DataTreeClass)abstractList).getUniqueName(this.toString());
    }

    protected int getNumberOfComponents(DataSet dataSet) {
        if (this.commonPanel == null) {
            return -1;
        }
        int n = this.commonPanel.getNumberOfComponents();
        if (n < 0 && dataSet.getOriginalMatrix() instanceof LayerMatrix) {
            return 3;
        }
        return n;
    }

    protected boolean hasYClass(DataSet dataSet) {
        return this.hasYWithType(dataSet, "Category");
    }

    protected boolean hasYData(DataSet dataSet) {
        return this.hasYWithType(dataSet, "Data") || this.hasYWithType(dataSet, "Added data");
    }

    protected void setModelInitFromPanel(ModelInit modelInit, DataSet dataSet) {
        CrossvalidationPanel crossvalidationPanel = this.commonPanel.getCvPanel();
        modelInit.calc_ci = crossvalidationPanel.isCI();
        modelInit.typeisfull = crossvalidationPanel.isFullCV();
        if (crossvalidationPanel.hasGroup()) {
            modelInit.nr_groups = crossvalidationPanel.getNumberGroups();
        }
        modelInit.crossvalidationType = crossvalidationPanel.getCrossvalidationType(dataSet.getOriginalMatrix());
        Object object = crossvalidationPanel.getCrossvalidationClass();
        if (object instanceof InnerColumnClass) {
            modelInit.cvCategoryName = ((InnerColumnClass)object).toString();
        }
        modelInit.setConfidenceInterval(crossvalidationPanel.calculateConfidenceInterval());
        if (this.commonPanel.hasIncludeXBy()) {
            InnerColumnClass innerColumnClass = (InnerColumnClass)this.commonPanel.getIncludeXByItem();
            modelInit.categoryName = innerColumnClass.toString();
        }
        modelInit.setModelName(this.commonPanel.getModelName(this.getDefaultName(modelInit)));
    }

    private void calcModel(ProgressManager progressManager, AbstractMDAModel abstractMDAModel, DataSet dataSet, int n) {
        if (abstractMDAModel != null) {
            long l = System.currentTimeMillis();
            abstractMDAModel.beginUpdateRecursive();
            progressManager.setMaximumAndReset(abstractMDAModel.getNitmax() * n);
            progressManager.setInfoText("Loading data into memory");
            abstractMDAModel.beginCalculations();
            abstractMDAModel.calcModel(progressManager, n);
            abstractMDAModel.endCalculations();
            abstractMDAModel.setDuration(System.currentTimeMillis() - l);
            abstractMDAModel.endUpdateRecursive();
        }
    }

    private AbstractMDAModel createModel(ProgressManager progressManager, ModelInit modelInit, int[] nArray, int n) {
        if (modelInit.categoryName != null) {
            InnerColumnClass innerColumnClass = modelInit.getClassColumn(modelInit.categoryName);
            ClassTypes classTypes = innerColumnClass.getObject();
            AbstractDataMatrix abstractDataMatrix = modelInit.getDataSet().getMatrix(0);
            ModelContainer modelContainer = this.createClassContainer(modelInit.getDataSet(), modelInit.getModelName(), innerColumnClass.toString(), n);
            for (int i = 1; i < classTypes.size(); ++i) {
                AbstractMDAModel abstractMDAModel;
                int[] nArray2 = modelContainer.getXindxByClass(abstractDataMatrix, innerColumnClass, i);
                if (nArray2[nArray2.length - 1] >= nArray2.length - 1 || (abstractMDAModel = this.createNewModel(progressManager, modelInit, nArray2, nArray, n, classTypes.getTypeDescription(i))) == null) continue;
                modelContainer.addTreeNode(abstractMDAModel);
            }
            return modelContainer;
        }
        return this.createNewModel(progressManager, modelInit, null, nArray, n, "");
    }

    private AbstractMDAModel createNewModel(ProgressManager progressManager, ModelInit modelInit) {
        if (modelInit.singleY) {
            DataSet dataSet = modelInit.getDataSet();
            dataSet.excludeNonVarying(progressManager, true);
            AbstractDataMatrix abstractDataMatrix = dataSet.getMatrix(2);
            int n = abstractDataMatrix.getK();
            ModelContainer modelContainer = new ModelContainer(dataSet, modelInit.getModelName(), true, modelInit.categoryName);
            for (int i = 0; i < n; ++i) {
                int[] nArray = ModelHelper.createYindx(dataSet, i);
                modelContainer.addTreeNode(this.createModel(progressManager, modelInit, nArray, i));
            }
            return modelContainer;
        }
        return this.createModel(progressManager, modelInit, null, -1);
    }

    private boolean hasYWithType(DataSet dataSet, String string) {
        int n;
        VariablesInfo variablesInfo = dataSet.getVarDataInfo();
        if (variablesInfo == null) {
            return false;
        }
        AbstractInnerColumn abstractInnerColumn = null;
        AbstractInnerColumn abstractInnerColumn2 = null;
        AbstractInnerColumn abstractInnerColumn3 = null;
        for (n = 0; n < variablesInfo.getAllColumnCount(); ++n) {
            AbstractInnerColumn abstractInnerColumn4 = variablesInfo.getAllInnerColumn(n);
            if (abstractInnerColumn4 != null && abstractInnerColumn4.toString().equals("X/Y")) {
                abstractInnerColumn = (InnerColumnBooleanXY)variablesInfo.getAllInnerColumn(n);
                continue;
            }
            if (abstractInnerColumn4 instanceof InnerColumnType) {
                abstractInnerColumn2 = (InnerColumnType)variablesInfo.getAllInnerColumn(n);
                continue;
            }
            if (abstractInnerColumn4 == null || !abstractInnerColumn4.toString().equals("Inc/Exc")) continue;
            abstractInnerColumn3 = (InnerColumnBooleanIncExc)variablesInfo.getAllInnerColumn(n);
        }
        if (abstractInnerColumn == null || abstractInnerColumn2 == null || abstractInnerColumn3 == null || abstractInnerColumn.getSize() != abstractInnerColumn2.getSize() || abstractInnerColumn.getSize() != abstractInnerColumn3.getSize()) {
            return false;
        }
        for (n = 0; n < abstractInnerColumn.getSize(); ++n) {
            if (!((InnerColumnBooleanIncExc)abstractInnerColumn3).getValueBool(n) || ((Boolean)abstractInnerColumn.getValue(n)).booleanValue() || !((String)abstractInnerColumn2.getValue(n)).equals(string)) continue;
            return true;
        }
        return false;
    }
}

