/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.mda.model;

import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JTree;
import se.prediktera.map.common.CMenuItem;
import se.prediktera.map.common.swing.flat.JFlatButton;
import se.prediktera.map.common.swing.flat.JFlatButtonComboBox;
import se.prediktera.map.common.swing.flat.JFlatToggleButton;
import se.prediktera.map.common.wizard.AbstractWizardInfo;
import se.prediktera.map.data.AbstractTable;
import se.prediktera.map.data.tablegenerator.TableGeneratorWizard;
import se.prediktera.map.datasetcontainer.AbstractDataNode;
import se.prediktera.map.datasetcontainer.Case;
import se.prediktera.map.datasetcontainer.DataContainer;
import se.prediktera.map.datasetcontainer.DataTreeInterface;
import se.prediktera.map.datasetcontainer.dataset.DataSet;
import se.prediktera.map.main.Main_GUI;
import se.prediktera.map.model.AbstractModelContainerWindow;
import se.prediktera.map.model.ModelTreeTableModel;
import se.prediktera.map.plot.AbstractPlot;
import se.prediktera.map.plot.plotgenerator.AbstractPlotInfo;
import se.prediktera.map.plot.plotgenerator.PlotGeneratorWizard;
import se.prediktera.mda.model.AbstractMDAModel;
import se.prediktera.mda.model.ComponentHistoryNode;
import se.prediktera.mda.model.info.ModelPlotInfo;

public abstract class AbstractMDAContainerWindow
extends AbstractModelContainerWindow {
    private final JFlatToggleButton lockButton = new JFlatToggleButton();
    private final JFlatButton propagateButton = new JFlatButton();
    private final JFlatButton buttonAddOneComp = new JFlatButton();
    private final JFlatButton buttonRemoveOneComp = new JFlatButton();
    private final JFlatButtonComboBox buttonTables = new JFlatButtonComboBox();
    private final JLabel labelName = new JLabel("None");
    private final JFlatButtonComboBox buttonPlots = new JFlatButtonComboBox();

    public AbstractMDAContainerWindow(String string, Case case_, String[] stringArray, DataContainer dataContainer) {
        super(string, case_, dataContainer, stringArray);
        this.lockButton.setToolTipText("Protect Model");
        this.lockButton.setIcon(new ImageIcon(Main_GUI.class.getResource("gif/unlock.png")));
        this.lockButton.addActionListener(actionEvent -> this.protectModel(this.lockButton.isSelected()));
        this.propagateButton.setToolTipText("Apply DataSet Changes");
        this.propagateButton.setIcon(new ImageIcon(Main_GUI.class.getResource("gif/update.png")));
        this.propagateButton.addActionListener(actionEvent -> {
            this.applyChanges();
            this.propagateButton.setEnabled(false);
        });
        this.propagateButton.setEnabled(false);
        this.buttonAddOneComp.setToolTipText("Add One Component");
        this.buttonAddOneComp.setIcon(new ImageIcon(Main_GUI.class.getResource("gif/compplus.gif")));
        this.buttonAddOneComp.addActionListener(actionEvent -> this.changeComponent(1));
        this.buttonRemoveOneComp.setToolTipText("Remove One Component");
        this.buttonRemoveOneComp.setIcon(new ImageIcon(Main_GUI.class.getResource("gif/compminus.gif")));
        this.buttonRemoveOneComp.addActionListener(actionEvent -> this.changeComponent(-1));
        JFlatButton jFlatButton = new JFlatButton();
        jFlatButton.setToolTipText("New " + this.getModeltype() + " Model");
        jFlatButton.setIcon(new ImageIcon(Main_GUI.class.getResource("gif/new.gif")));
        jFlatButton.addActionListener(actionEvent -> this.createNewModel());
        this.buttonTables.setToolTipText("New Table");
        this.buttonTables.setIcon(AbstractTable.tableIcon);
        this.buttonTables.setEnabled(false);
        this.buttonPlots.setToolTipText("New Plot");
        this.buttonPlots.setIcon(AbstractPlot.plotIcon);
        this.buttonPlots.setEnabled(false);
        this.labelName.setToolTipText(null);
        this.informationToolbar.setBackground(Color.white);
        this.informationToolbar.add((Component)this.buttonSave, null);
        this.informationToolbar.add((Component)this.buttonRemove, null);
        this.informationToolbar.add((Component)this.buttonRename, null);
        this.informationToolbar.addSeparator();
        this.informationToolbar.add(this.lockButton);
        this.informationToolbar.add(this.propagateButton);
        this.informationToolbar.addSeparator();
        this.informationToolbar.add((Component)this.buttonAddOneComp, null);
        this.informationToolbar.add((Component)this.buttonRemoveOneComp, null);
        this.informationToolbar.addSeparator();
        this.informationToolbar.add((Component)this.buttonTables, null);
        this.informationToolbar.addSeparator();
        this.informationToolbar.add((Component)this.buttonPlots, null);
        this.correctTableColumnWidth();
    }

    @Override
    public void addToPopupMenu(JMenu jMenu, DataSet dataSet) {
        jMenu.add(new AbstractAction(this.getModeltype() + " Model"){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                AbstractMDAContainerWindow.this.createNewModel();
            }
        });
    }

    @Override
    public AbstractPlotInfo createModelCollectionPlots() {
        return new ModelPlotInfo();
    }

    public DataContainer getModels() {
        return this.informationContainer;
    }

    @Override
    protected DataContainer createContainer(String string) {
        return new DataContainer(string, 1);
    }

    @Override
    protected ModelTreeTableModel createTreeTableModel() {
        return new AnalysTreeTableModel(this, this.informationContainer, this.cNames);
    }

    @Override
    protected void setCurrentInformation(boolean bl, DataTreeInterface dataTreeInterface) {
        this.currentInformation = dataTreeInterface;
        AbstractMDAModel abstractMDAModel = (AbstractMDAModel)this.currentInformation;
        this.buttonTables.removeAll();
        JFlatButton jFlatButton = new JFlatButton(AbstractTable.tableIcon);
        jFlatButton.setToolTipText("Table Wizard");
        jFlatButton.addActionListener(actionEvent -> this.getProject_GUI().getData_GUI().createWindowFromWizard(abstractMDAModel, null));
        this.buttonTables.addButton(jFlatButton);
        this.buttonTables.addSeparator();
        this.buttonPlots.removeAll();
        JFlatButton jFlatButton2 = new JFlatButton(AbstractPlot.plotIcon);
        jFlatButton2.setToolTipText("Plot Wizard");
        jFlatButton2.addActionListener(actionEvent -> this.getProject_GUI().getPlot_GUI().createWindowFromWizard(abstractMDAModel, null));
        this.buttonPlots.addButton(jFlatButton2);
        this.buttonPlots.addSeparator();
        if (abstractMDAModel == null) {
            this.labelName.setText("None");
            this.lockButton.setEnabled(false);
            this.lockButton.setSelected(false);
            this.propagateButton.setEnabled(false);
            this.buttonRemoveOneComp.setEnabled(false);
            this.buttonAddOneComp.setEnabled(false);
        } else {
            Object object;
            this.labelName.setText(abstractMDAModel.toString());
            this.lockButton.setEnabled(true);
            this.lockButton.setSelected(abstractMDAModel.isProtected());
            this.propagateButton.setEnabled(abstractMDAModel.getDatasetchanged());
            this.buttonRemoveOneComp.setEnabled(abstractMDAModel.canRemoveComponent());
            this.buttonAddOneComp.setEnabled(abstractMDAModel.canAddComponent());
            Vector<AbstractWizardInfo> vector = new Vector<AbstractWizardInfo>();
            TableGeneratorWizard.addExternTables(vector, abstractMDAModel);
            for (AbstractWizardInfo object22 : vector) {
                object = new JFlatButton(AbstractTable.tableIcon);
                ((JComponent)object).setToolTipText(object22.toString());
                ((JFlatButton)object).setObject(object22);
                ((JFlatButton)object).addActionListener(actionEvent -> {
                    JFlatButton jFlatButton = this.getSource(actionEvent.getSource());
                    AbstractWizardInfo abstractWizardInfo = (AbstractWizardInfo)jFlatButton.getObject();
                    this.getProject_GUI().getData_GUI().createWindowFromWizard(abstractMDAModel, abstractWizardInfo);
                });
                this.buttonTables.addButton((AbstractButton)object);
            }
            Vector vector2 = new Vector();
            PlotGeneratorWizard.addExternPlots(vector2, abstractMDAModel, null);
            Iterator iterator = vector2.iterator();
            while (iterator.hasNext()) {
                object = (AbstractWizardInfo)iterator.next();
                JFlatButton jFlatButton3 = new JFlatButton(AbstractPlot.plotIcon);
                jFlatButton3.setToolTipText(object.toString());
                jFlatButton3.setObject(object);
                jFlatButton3.addActionListener(actionEvent -> {
                    JFlatButton jFlatButton = this.getSource(actionEvent.getSource());
                    AbstractWizardInfo abstractWizardInfo = (AbstractWizardInfo)jFlatButton.getObject();
                    this.getProject_GUI().getPlot_GUI().createWindowFromWizard(abstractMDAModel, abstractWizardInfo);
                });
                this.buttonPlots.addButton(jFlatButton3);
            }
        }
        this.buttonSave.setEnabled(abstractMDAModel != null);
        this.buttonRemove.setEnabled(abstractMDAModel != null);
        this.buttonRename.setEnabled(abstractMDAModel != null);
        this.buttonTables.setEnabled(abstractMDAModel != null);
        this.buttonPlots.setEnabled(abstractMDAModel != null);
        this.getWindowGui().selectedWindowUpdated(this, true);
        if (this.treeTable != null) {
            this.treeTable.repaint();
        }
    }

    private void applyChanges() {
        DataContainer dataContainer = this.getAllSelectedModelItems();
        if (!dataContainer.isEmpty()) {
            for (DataTreeInterface dataTreeInterface : dataContainer) {
                AbstractMDAModel abstractMDAModel = (AbstractMDAModel)dataTreeInterface;
                abstractMDAModel.doUpdate(null);
            }
        }
    }

    private void changeComponent(int n) {
        DataContainer dataContainer = this.getAllSelectedModelItems();
        if (!dataContainer.isEmpty()) {
            for (DataTreeInterface dataTreeInterface : dataContainer) {
                AbstractMDAModel abstractMDAModel = (AbstractMDAModel)dataTreeInterface;
                ComponentHistoryNode componentHistoryNode = new ComponentHistoryNode(abstractMDAModel, n);
                abstractMDAModel.postEdit(componentHistoryNode);
            }
        }
    }

    private JFlatButton getSource(Object object) {
        if (object instanceof JFlatButton) {
            return (JFlatButton)object;
        }
        return (JFlatButton)((CMenuItem)object).getButton();
    }

    private void protectModel(boolean bl) {
        DataContainer dataContainer = this.getAllSelectedModelItems();
        if (!dataContainer.isEmpty()) {
            for (DataTreeInterface dataTreeInterface : dataContainer) {
                AbstractMDAModel abstractMDAModel = (AbstractMDAModel)dataTreeInterface;
                abstractMDAModel.setProtected(bl);
            }
        }
    }

    public class AnalysTreeTableModel
    extends ModelTreeTableModel {
        public AnalysTreeTableModel(AbstractMDAContainerWindow abstractMDAContainerWindow, AbstractDataNode abstractDataNode, String[] stringArray) {
            super(abstractDataNode, stringArray);
        }

        @Override
        public Object getValueAt(JTree jTree, Object object, int n, int n2) {
            if (object instanceof DataContainer) {
                return object.toString();
            }
            if (object instanceof AbstractMDAModel) {
                if (n2 == 0) {
                    try {
                        if (jTree.isExpanded(n)) {
                            return "-";
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    return "+";
                }
                return ((AbstractMDAModel)object).getValueAt(n2 - 1);
            }
            if (object instanceof Object[]) {
                if (n2 < 2) {
                    return "";
                }
                return ((Object[])object)[n2 - 1];
            }
            return "";
        }

        @Override
        protected Object[] getChildren(Object object) {
            if (object instanceof DataContainer) {
                return ((DataContainer)object).toArray();
            }
            if (object instanceof AbstractMDAModel) {
                return ((AbstractMDAModel)object).getChildren(false);
            }
            return this.emptyObject;
        }
    }
}

