/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.mda.model;

import java.io.IOException;
import java.util.Collections;
import java.util.Comparator;
import no.uib.cipr.matrix.DenseVector;
import se.prediktera.map.common.MapProperty;
import se.prediktera.map.common.NiceDataFormat;
import se.prediktera.map.common.RandomInputStream;
import se.prediktera.map.common.RandomOutputStream;
import se.prediktera.map.datasetcontainer.AbstractDataNode;
import se.prediktera.map.datasetcontainer.DataContainer;
import se.prediktera.map.datasetcontainer.datainfo.AbstractDataInfo;
import se.prediktera.map.datasetcontainer.dataset.DataSet;
import se.prediktera.map.datasetcontainer.matrix.AbstractDataMatrix;
import se.prediktera.map.datasetcontainer.matrix.ModelMatrix;
import se.prediktera.map.datasetcontainer.matrix.event.DataMatrixEvent;
import se.prediktera.map.model.AbstractModelResults;

public abstract class AbstractMDAResults
extends AbstractModelResults {
    protected ModelMatrix[] mr;
    protected AbstractDataInfo obs;
    protected AbstractDataInfo var;
    private int round;
    private final int nomatrix;

    public AbstractMDAResults(AbstractDataNode abstractDataNode, DataSet dataSet, int n) {
        this.nomatrix = n;
        this.mr = new ModelMatrix[this.nomatrix];
        this.round = 0;
        if (dataSet != null) {
            AbstractDataInfo[] abstractDataInfoArray = dataSet.getDataInfo();
            if (abstractDataInfoArray == null) {
                return;
            }
            this.obs = abstractDataInfoArray[0];
            this.var = abstractDataInfoArray[1];
        }
    }

    public AbstractMDAResults(RandomInputStream randomInputStream, MapProperty mapProperty, String[] stringArray) throws IOException {
        this.round = mapProperty.getPropertyInt("round");
        this.nomatrix = Math.min(mapProperty.getPropertyInt("nrmodels", 0), stringArray.length);
        if (this.nomatrix > 0) {
            this.mr = new ModelMatrix[stringArray.length];
            for (int i = 0; i < this.nomatrix; ++i) {
                this.mr[i] = (ModelMatrix)mapProperty.resolveNodeFromName(randomInputStream, stringArray[i]);
            }
        }
    }

    public void DecRound() {
        --this.round;
    }

    public boolean firstRound() {
        return this.round == 0;
    }

    public void flipComponent(int n) {
        for (int i = this.mr.length - 1; i >= 0; --i) {
            String string;
            if (this.mr[i] == null || !(string = this.mr[i].toString().toLowerCase()).equals("t") && !string.equals("p") && !string.equals("c") && !string.equals("w") && !string.equals("u")) continue;
            DenseVector denseVector = this.mr[i].getRM(n);
            for (int j = 0; j < denseVector.size(); ++j) {
                denseVector.set(j, -denseVector.get(j));
            }
            this.mr[i].triggerEvent(new DataMatrixEvent((Object)this, this.mr[i]));
        }
    }

    public abstract Object[] getCompData(int var1, boolean var2);

    @Override
    public Object getCompData(int n, int n2) {
        return this.getCompData(n, true)[n2];
    }

    public abstract ModelMatrix getDModX();

    public abstract ModelMatrix getHotellingT2();

    @Override
    public ModelMatrix[] getMR() {
        return this.mr;
    }

    public ModelMatrix getMR(int n) {
        if (n >= 0 && n < this.mr.length && this.mr[n] != null) {
            return this.mr[n];
        }
        return null;
    }

    @Override
    public int getRound() {
        return this.round;
    }

    @Override
    public boolean hasRounds() {
        return this.round > 0;
    }

    public void IncRound() {
        ++this.round;
    }

    public void removeLastRow() {
        for (int i = 0; i < this.nomatrix; ++i) {
            if (this.mr[i] == null) continue;
            this.mr[i].removeLastRow();
        }
        this.DecRound();
    }

    public void resetResults(AbstractDataNode abstractDataNode, AbstractDataMatrix abstractDataMatrix, AbstractDataMatrix abstractDataMatrix2) {
        this.round = 0;
        for (int i = this.mr.length - 1; i >= 0; --i) {
            if (this.mr[i] == null) continue;
            this.mr[i].resize(abstractDataMatrix);
        }
    }

    public void save(RandomOutputStream randomOutputStream, String[] stringArray) throws IOException {
        randomOutputStream.writePropertyInt("round", this.round);
        randomOutputStream.writePropertyInt("nrmodels", this.nomatrix);
        for (int i = 0; i < this.nomatrix; ++i) {
            if (this.mr[i] == null) continue;
            randomOutputStream.writePropertyNode(stringArray[i], this.mr[i]);
        }
    }

    public abstract void Save(RandomOutputStream var1) throws IOException;

    public void setSize(int n) {
    }

    public void undoRow() {
        for (int i = 0; i < this.nomatrix; ++i) {
            if (this.mr[i] == null || this.mr[i].getN() <= this.round) continue;
            this.mr[i].removeLastRow();
        }
    }

    @Override
    protected void cleanUpChild() {
        this.round = 0;
        this.obs = null;
        this.var = null;
        if (this.mr != null) {
            for (int i = 0; i < this.nomatrix; ++i) {
                if (this.mr[i] == null) continue;
                this.mr[i].cleanUp();
                this.mr[i] = null;
            }
            this.mr = null;
        }
    }

    protected String getCompString(ModelMatrix modelMatrix, int n) {
        if (this.hasRounds() && modelMatrix != null) {
            double d = modelMatrix.getScalar(n);
            if (Double.isNaN(d)) {
                return "-";
            }
            return NiceDataFormat.toString(d);
        }
        return "";
    }

    protected void sortExplainedVariances(DataContainer dataContainer) {
        if (dataContainer != null) {
            Collections.sort(dataContainer, new SortExplainedVariances());
        }
    }

    @Override
    public ModelMatrix getMatrix(int n) {
        if (this.mr != null && n >= 0 && n < this.mr.length) {
            return this.mr[n];
        }
        return null;
    }

    private static class SortExplainedVariances
    implements Comparator {
        String[] evOrder = new String[]{"R2X", "R2X_cum", "R2X_var", "R2X_var_cum", "R2Y", "R2Y_cum", "R2Y_var", "R2Y_var_cum", "RMSE_var_cum", "Q2X", "Q2X_cum", "Q2X_var", "Q2X_var_cum", "Q2Y", "Q2Y_cum", "Q2Y_var", "Q2Y_var_cum"};

        private SortExplainedVariances() {
        }

        public int compare(Object object, Object object2) {
            String string = object.toString();
            String string2 = object2.toString();
            return Float.compare(this.getIndex(string), this.getIndex(string2));
        }

        private int getIndex(String string) {
            for (int i = 0; i < this.evOrder.length; ++i) {
                if (!this.evOrder[i].equalsIgnoreCase(string)) continue;
                return i;
            }
            return Integer.MAX_VALUE;
        }
    }
}

