/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.mda.model;

import java.awt.event.ActionEvent;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.ImageIcon;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import no.uib.cipr.matrix.DenseMatrix;
import no.uib.cipr.matrix.DenseVector;
import no.uib.cipr.matrix.Matrix;
import se.prediktera.map.common.CMenu;
import se.prediktera.map.common.CMenuItem;
import se.prediktera.map.common.RandomOutputStream;
import se.prediktera.map.common.Threader;
import se.prediktera.map.common.error.ErrorHandler;
import se.prediktera.map.common.progress.ProgressManager;
import se.prediktera.map.data.datasettable.DataSetTableInfo;
import se.prediktera.map.datasetcontainer.Case;
import se.prediktera.map.datasetcontainer.DataContainer;
import se.prediktera.map.datasetcontainer.DataTreeClass;
import se.prediktera.map.datasetcontainer.DataTreeInterface;
import se.prediktera.map.datasetcontainer.classes.InnerColumnClass;
import se.prediktera.map.datasetcontainer.datainfo.Description;
import se.prediktera.map.datasetcontainer.dataset.DataSet;
import se.prediktera.map.datasetcontainer.dataset.event.DataSetEvent;
import se.prediktera.map.datasetcontainer.dataset.event.DataSetListener;
import se.prediktera.map.datasetcontainer.event.DataTreeEvent;
import se.prediktera.map.datasetcontainer.matrix.AbstractDataMatrix;
import se.prediktera.map.datasetcontainer.matrix.AbstractMVmatrix;
import se.prediktera.map.datasetcontainer.matrix.DataTypeInterface;
import se.prediktera.map.datasetcontainer.matrix.MVmatrix;
import se.prediktera.map.datasetcontainer.matrix.ModelMatrix;
import se.prediktera.map.datasetcontainer.transform.AbstractDataTransform;
import se.prediktera.map.main.Data_GUI;
import se.prediktera.map.main.IniManager;
import se.prediktera.map.main.Main_GUI;
import se.prediktera.map.main.Project_GUI;
import se.prediktera.map.main.extclass.DataTreeExtLibInterface;
import se.prediktera.map.main.extclass.ExtClassLoader;
import se.prediktera.map.model.AbstractModel;
import se.prediktera.map.model.AbstractModelContainerWindow;
import se.prediktera.map.model.AbstractModelResults;
import se.prediktera.map.model.output.OutputClass;
import se.prediktera.map.model.output.OutputDialog;
import se.prediktera.map.register.RegisterKeyManager;
import se.prediktera.mda.model.AbstractMDAResults;
import se.prediktera.mda.model.AnalysPredictionNode;
import se.prediktera.mda.model.ComponentHistoryNode;
import se.prediktera.mda.model.ModelContainer;
import se.prediktera.mda.model.ModelException;
import se.prediktera.mda.model.SIMCA.SIMCAModel;

public abstract class AnalysModel
extends AbstractModel
implements DataTreeExtLibInterface,
DataTypeInterface {
    protected static final int NITMAX = 200;
    protected int minNK;
    protected ModelMatrix[] mr;
    protected AbstractMDAResults res;
    protected ModelListener modelListener = new ModelListener();
    protected int[] Xindx;
    protected int[] Yindx;
    protected boolean calcPred = false;
    protected AbstractMVmatrix X;
    protected AbstractMVmatrix Y;
    protected DataContainer transformedContainer = new DataContainer("Transformed X and Y", 6, false);

    public static final void nipalsRowMv(AbstractDataMatrix abstractDataMatrix, DenseVector denseVector, final double d, DenseVector denseVector2) {
        final int n = abstractDataMatrix.getK();
        int n2 = abstractDataMatrix.getN();
        final double[] dArray = denseVector.getData();
        final double[] dArray2 = denseVector2.getData();
        final boolean[][] blArray = abstractDataMatrix.getMissingMatrix();
        final int[] nArray = abstractDataMatrix.getMissingCountForRows(true);
        Threader threader = new Threader(){

            @Override
            protected void doOp(boolean bl, int n6, int n2) {
                for (int i = n6; i < n2; ++i) {
                    if (nArray[i] == 0) {
                        int n3 = i;
                        dArray2[n3] = dArray2[n3] / d;
                        continue;
                    }
                    double d3 = 0.0;
                    boolean[] blArray2 = blArray[i];
                    for (int j = 0; j < n; ++j) {
                        if (blArray2[j]) continue;
                        double d2 = dArray[j];
                        d3 += d2 * d2;
                    }
                    if (Double.compare(d3, 0.0) == 0) {
                        int n4 = i;
                        dArray2[n4] = dArray2[n4] / d;
                        continue;
                    }
                    int n5 = i;
                    dArray2[n5] = dArray2[n5] / d3;
                }
            }
        };
        threader.execute(n2);
    }

    protected static final void nipalsColMv(AbstractDataMatrix abstractDataMatrix, DenseVector denseVector, final double d, DenseVector denseVector2) {
        int n = abstractDataMatrix.getK();
        final int n2 = abstractDataMatrix.getN();
        final double[] dArray = denseVector.getData();
        final double[] dArray2 = denseVector2.getData();
        final boolean[][] blArray = abstractDataMatrix.getMissingMatrix();
        final int[] nArray = abstractDataMatrix.getMissingCountForColumns(true);
        Threader threader = new Threader(){

            @Override
            protected void doOp(boolean bl, int n, int n22) {
                for (int i = n; i < n22; ++i) {
                    if (nArray[i] == 0) {
                        int n3 = i;
                        dArray2[n3] = dArray2[n3] / d;
                        continue;
                    }
                    double d3 = 0.0;
                    for (int j = 0; j < n2; ++j) {
                        if (blArray[j][i]) continue;
                        double d2 = dArray[j];
                        d3 += d2 * d2;
                    }
                    if (Double.compare(d3, 0.0) == 0) {
                        int n4 = i;
                        dArray2[n4] = dArray2[n4] / d;
                        continue;
                    }
                    int n5 = i;
                    dArray2[n5] = dArray2[n5] / d3;
                }
            }
        };
        threader.execute(n);
    }

    public void addRemoveAddComponentPopupMenu(JPopupMenu jPopupMenu) {
        ImageIcon imageIcon = new ImageIcon(Main_GUI.class.getResource("gif/compplus.gif"));
        CMenuItem cMenuItem = new CMenuItem("Add One Component", imageIcon){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                AnalysModel.this.historyManager.postEdit(new ComponentHistoryNode(null, 1));
            }
        };
        cMenuItem.setEnabled(this.canAddComponent());
        jPopupMenu.add(cMenuItem);
        imageIcon = new ImageIcon(Main_GUI.class.getResource("gif/compminus.gif"));
        CMenuItem cMenuItem2 = new CMenuItem("Remove One Component", imageIcon){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                AnalysModel.this.historyManager.postEdit(new ComponentHistoryNode(null, -1));
            }
        };
        cMenuItem2.setEnabled(this.canRemoveComponent());
        jPopupMenu.add(cMenuItem2);
        CMenuItem cMenuItem3 = new CMenuItem("Set Component", true){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                String string = JOptionPane.showInputDialog(IniManager.getMainFrame(), "Set number of components", String.valueOf(AnalysModel.this.res.getRound()));
                if (string != null) {
                    try {
                        int n = Integer.parseInt(string);
                        n = Math.min(n, AnalysModel.this.getMaxComponentCount());
                        AnalysModel.this.historyManager.postEdit(new ComponentHistoryNode(null, n - AnalysModel.this.res.getRound()));
                    }
                    catch (NumberFormatException numberFormatException) {
                        JOptionPane.showConfirmDialog(IniManager.getMainFrame(), "\"" + string + "\" is an illigal number", "Illigal number", -1, 1);
                    }
                }
            }
        };
        cMenuItem3.setEnabled(!this.isProtected());
        jPopupMenu.add(cMenuItem3);
        jPopupMenu.addSeparator();
        CMenu cMenu = new CMenu("Flip Component", true);
        for (int i = 0; i < this.res.getRound(); ++i) {
            CMenuItem cMenuItem4 = new CMenuItem((Object)String.valueOf(i + 1)){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    int n = (Integer)this.getObject();
                    AnalysModel.this.res.flipComponent(n);
                }
            };
            cMenuItem4.setObject(i);
            cMenu.add(cMenuItem4);
        }
        jPopupMenu.add(cMenu);
    }

    @Override
    public void addToPopupMenu(Project_GUI project_GUI, JPopupMenu jPopupMenu) {
        CMenuItem cMenuItem;
        if (project_GUI != null) {
            super.addToPopupMenu(project_GUI, jPopupMenu);
            if (this.dataSet != null) {
                cMenuItem = new CMenuItem((Object)project_GUI.getData_GUI(), DataSet.icon);
                cMenuItem.setText("View DataSet");
                cMenuItem.addActionListener(actionEvent -> {
                    CMenuItem cMenuItem = (CMenuItem)actionEvent.getSource();
                    Data_GUI data_GUI = (Data_GUI)cMenuItem.getObject();
                    DataSetTableInfo dataSetTableInfo = new DataSetTableInfo();
                    data_GUI.createWindowFromWizard(this.dataSet, dataSetTableInfo);
                });
                jPopupMenu.add(cMenuItem);
                ImageIcon imageIcon = new ImageIcon(Main_GUI.class.getResource("gif/update.png"));
                CMenuItem cMenuItem2 = new CMenuItem("Apply DataSet Changes", imageIcon){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        AnalysModel.this.setChanged();
                        AnalysModel.this.dataSet.checkApplyChangesNeeded();
                    }
                };
                cMenuItem2.setEnabled(this.getDatasetchanged());
                jPopupMenu.add(cMenuItem2);
            }
            if (this.supportPrediction()) {
                jPopupMenu.addSeparator();
                cMenuItem = new CMenuItem(true);
                cMenuItem.setText("Predict Data from File");
                cMenuItem.addActionListener(actionEvent -> this.createPredictionOnFile(project_GUI));
                jPopupMenu.add(cMenuItem);
            }
        }
        if (this.dataSet != null && !this.isModelContainer()) {
            jPopupMenu.addSeparator();
            this.addRemoveAddComponentPopupMenu(jPopupMenu);
        }
        if (!this.isModelContainer() && RegisterKeyManager.isPredikteraDevelopmentLicense()) {
            cMenuItem = new CMenuItem("Show output dialog", true);
            cMenuItem.addActionListener(actionEvent -> {
                OutputDialog.showDialog(IniManager.getMainFrame(), this);
                this.dataTreeManager.updateHistory();
            });
            jPopupMenu.add(cMenuItem);
        }
    }

    @Override
    public void applyTransformationX(AbstractDataMatrix abstractDataMatrix) {
        if (this.X != null) {
            this.X.applyTransformations(abstractDataMatrix, null, false);
        }
    }

    @Override
    public void applyTransformationY(AbstractDataMatrix abstractDataMatrix) {
        if (this.Y != null) {
            this.Y.applyTransformations(abstractDataMatrix, null, false);
        }
    }

    public abstract boolean calcModel(ProgressManager var1, int var2);

    public boolean canAddComponent() {
        return !this.isProtected() && this.res != null && this.res.getRound() < this.getMaxComponentCount();
    }

    public boolean canRemoveComponent() {
        return !this.isProtected() && this.hasComponents();
    }

    @Override
    public void changeComponent(ProgressManager progressManager, int n) {
        int n2 = this.res.getRound();
        int n3 = n2 + n;
        if (n3 < 0) {
            n = -n2;
            n3 = 0;
        }
        if (n == 0) {
            return;
        }
        try {
            Project_GUI project_GUI;
            this.beginUpdateRecursive();
            this.beginCalculations();
            if (n > 0) {
                if (progressManager != null) {
                    progressManager.setMaximumAndReset(n * 200);
                }
                this.calcModel(progressManager, n);
            } else {
                for (int i = this.res.getRound() - 1; i >= n3; --i) {
                    if (this.calcPred) {
                        this.calcPrediction(progressManager, false, true);
                    }
                    this.removeComponentLocal(i);
                    this.res.removeLastRow();
                }
            }
            this.endCalculations();
            this.endUpdateRecursive();
            this.checkForSimcaPrediction(progressManager);
            this.modelChanged(this);
            this.updateModelContainer((byte)3);
            if (n < 0 && (project_GUI = this.getProject_GUI()) != null) {
                project_GUI.purgeSignal();
            }
        }
        catch (Exception exception) {
            ErrorHandler.logAndShowEvinceErrorDialogForException(exception);
        }
    }

    public void checkForSimcaPrediction(ProgressManager progressManager) {
        if (this.getTreeParent() instanceof SIMCAModel) {
            try {
                SIMCAModel sIMCAModel = (SIMCAModel)this.getTreeParent();
                sIMCAModel.finishPrediction(progressManager);
            }
            catch (Exception exception) {
                ErrorHandler.logAndReportException(exception);
            }
        }
    }

    @Override
    public Case getCase() {
        if (this.dataSet == null) {
            return super.getCase();
        }
        return this.dataSet.getCase();
    }

    @Override
    public InnerColumnClass getClassByName(String string) {
        if (this.dataSet != null) {
            try {
                return this.dataSet.getCategory(string);
            }
            catch (Exception exception) {
                ErrorHandler.logAndReportException(exception);
            }
        }
        return null;
    }

    public abstract String[] getComponentNamesLocal();

    @Override
    public ExtClassLoader.LicenseLibrary getLibrary() {
        return ExtClassLoader.LicenseLibrary.MDA;
    }

    @Override
    public AnalysPredictionNode getLocalPredictionNode() {
        for (int i = 0; i < this.getTreeNodeCount(); ++i) {
            if (!(this.getTreeNodeAt(i) instanceof AnalysPredictionNode)) continue;
            return (AnalysPredictionNode)this.getTreeNodeAt(i);
        }
        return null;
    }

    @Override
    public AbstractDataMatrix getMatrixByName(String string) {
        Object object;
        if (this.mr != null) {
            object = this.mr;
            int n = ((ModelMatrix[])object).length;
            for (int i = 0; i < n; ++i) {
                ModelMatrix modelMatrix = object[i];
                if (modelMatrix == null || !modelMatrix.toString().equalsIgnoreCase(string)) continue;
                return modelMatrix;
            }
        }
        if ((object = this.getNodeByName(string)) instanceof AbstractDataMatrix) {
            return (AbstractDataMatrix)object;
        }
        if (this.transformedContainer != null && (object = this.transformedContainer.getNodeByName(string)) instanceof AbstractDataMatrix) {
            return (AbstractDataMatrix)object;
        }
        return null;
    }

    public int getMaxComponentCount() {
        if (this.X == null) {
            return 0;
        }
        return Math.min(this.X.getN(), this.X.getK());
    }

    public int getNitmax() {
        return 200;
    }

    @Override
    public byte getNodeType() {
        return 5;
    }

    public int getRealYindex() {
        if (this.Y != null && this.Y.getKref() != null && this.Y.getKref().length == 1) {
            return this.Y.getKref()[0];
        }
        return this.getYindex();
    }

    @Override
    public AbstractModelResults getResults() {
        return this.res;
    }

    public String getWhatIsHappenIfDelete() {
        return "What is happening if delete";
    }

    public int[] getXindx() {
        return this.Xindx;
    }

    public abstract AbstractMVmatrix getXMatrix();

    public int getYindex() {
        if (this.Yindx != null) {
            for (int i = 0; i < this.Yindx.length; ++i) {
                if (this.Yindx[i] == -1) continue;
                return i;
            }
        }
        return -1;
    }

    @Override
    public int[] getYindx() {
        return this.Yindx;
    }

    public abstract AbstractMVmatrix getYMatrix();

    public boolean hasComponents() {
        return this.res != null && this.res.hasRounds();
    }

    @Override
    public void modelChanged(AbstractModel abstractModel) {
        super.modelChanged(abstractModel);
        DataTreeInterface dataTreeInterface = abstractModel.getTreeParent();
        if (dataTreeInterface instanceof ModelContainer) {
            ((ModelContainer)dataTreeInterface).modelChanged(abstractModel);
        }
    }

    @Override
    public void reverseTransformationsX(DenseMatrix denseMatrix, int[] nArray, boolean bl) {
        MVmatrix mVmatrix = new MVmatrix((Matrix)denseMatrix, true);
        mVmatrix.setKref(nArray);
        this.X.reverseTransformations(mVmatrix, null, bl);
        mVmatrix.cleanUp();
    }

    @Override
    public void reverseTransformationsY(DenseMatrix denseMatrix, int[] nArray, boolean bl) {
        MVmatrix mVmatrix = new MVmatrix((Matrix)denseMatrix, true);
        mVmatrix.setKref(nArray);
        mVmatrix.beginCalculations();
        this.Y.reverseTransformations(mVmatrix, null, bl);
        mVmatrix.endCalculations();
        mVmatrix.cleanUp();
    }

    @Override
    public void SavePropertyLocal(RandomOutputStream randomOutputStream) throws IOException {
        super.SavePropertyLocal(randomOutputStream);
        randomOutputStream.writePropertyInt("minNK", this.minNK);
        randomOutputStream.writePropertyIntArray("Xindx", this.Xindx);
        randomOutputStream.writePropertyIntArray("Yindx", this.Yindx);
        randomOutputStream.writePropertyBoolean("calcPred", this.calcPred);
        randomOutputStream.writePropertyNode("trfC", this.transformedContainer);
        this.SaveModel(randomOutputStream);
    }

    @Override
    public void setTreeParent(DataTreeInterface dataTreeInterface) {
        if (dataTreeInterface instanceof DataSet) {
            this.dataSet = (DataSet)dataTreeInterface;
            super.setTreeParent(dataTreeInterface);
        } else if (dataTreeInterface instanceof ModelContainer) {
            super.setTreeParent(dataTreeInterface);
        }
    }

    public void setXindx(int[] nArray) {
        this.Xindx = nArray;
    }

    public void setYindx(int[] nArray) {
        this.Yindx = nArray;
    }

    public void updateModelContainer(byte by) {
        Project_GUI project_GUI = this.getProject_GUI();
        if (project_GUI != null && project_GUI.getModel_GUI().getContainerWindow(this) != null) {
            AbstractModelContainerWindow abstractModelContainerWindow = project_GUI.getModel_GUI().getContainerWindow(this);
            abstractModelContainerWindow.updateTable(this, by);
        }
    }

    protected void calcPrediction(ProgressManager progressManager, boolean bl, boolean bl2) throws Exception {
        List<AnalysPredictionNode> list = this.getAllPredictionNodes();
        for (AnalysPredictionNode analysPredictionNode : list) {
            if (!analysPredictionNode.canCalculate()) continue;
            if (bl) {
                analysPredictionNode.calcOnePrediction(progressManager);
            } else {
                analysPredictionNode.removeOnePrediction();
            }
            if (!bl2) continue;
            analysPredictionNode.finishPrediction(progressManager);
        }
    }

    @Override
    protected void cleanUpChild() {
        super.cleanUpChild();
        this.mr = null;
        if (this.res != null) {
            this.res.cleanUp();
            this.res = null;
        }
        if (this.dataSet != null) {
            AbstractDataMatrix abstractDataMatrix;
            AbstractDataMatrix abstractDataMatrix2 = this.dataSet.getMatrix(0);
            if (abstractDataMatrix2 != null) {
                abstractDataMatrix2.removeDataTreeChangeListener(this.modelListener);
            }
            if ((abstractDataMatrix = this.dataSet.getMatrix(2)) != null) {
                abstractDataMatrix.removeDataTreeChangeListener(this.modelListener);
            }
            this.dataSet.removeDataTreeChangeListener(this.modelListener);
            this.dataSet = null;
        }
        this.modelListener = null;
        this.Xindx = null;
        this.Yindx = null;
        if (this.X != null) {
            this.X.cleanUp();
            this.X = null;
        }
        if (this.Y != null) {
            this.Y.cleanUp();
            this.Y = null;
        }
        this.transformedContainer = null;
    }

    @Override
    protected synchronized void doUpdateLocal(ProgressManager progressManager) {
        if (this.res == null) {
            return;
        }
        try {
            this.beginUpdateRecursive();
            int n = this.res.getRound();
            try {
                if (!this.resetModel(progressManager)) {
                    this.endUpdateRecursive();
                    return;
                }
            }
            catch (ModelException modelException) {
                ErrorHandler.logAndReportException(modelException);
            }
            this.resetCrossvalidation();
            List<AnalysPredictionNode> list = this.getAllPredictionNodes();
            for (AnalysPredictionNode analysPredictionNode : list) {
                analysPredictionNode.resetPrediction();
            }
            this.beginCalculations();
            int n2 = this.getMaxComponentCount();
            if (n2 < n) {
                this.res.setSize(n2);
            }
            this.calcModel(progressManager, n);
            this.endCalculations();
            this.endUpdateRecursive();
            if (this.dataTreeManager != null) {
                this.dataTreeManager.updateHistory();
            }
        }
        catch (Exception exception) {
            ErrorHandler.logAndShowEvinceErrorDialogForException(exception);
        }
    }

    protected List<AnalysPredictionNode> getAllPredictionNodes() {
        ArrayList<AnalysPredictionNode> arrayList = new ArrayList<AnalysPredictionNode>();
        this.addAllPredictionNodes(arrayList, this);
        DataContainer dataContainer = this.getExternalPredictions();
        if (dataContainer != null) {
            this.addAllPredictionNodes(arrayList, dataContainer);
        }
        return arrayList;
    }

    protected abstract void removeComponentLocal(int var1) throws Exception;

    protected void resetCrossvalidation() {
    }

    protected abstract boolean resetModel(ProgressManager var1) throws Exception;

    @Override
    protected void saveModel(DataTreeInterface dataTreeInterface, RandomOutputStream randomOutputStream, int n, AbstractModel.SaveType saveType) throws IOException {
        if (!saveType.isComplete() && (dataTreeInterface.toString().equals("Xres") || dataTreeInterface.toString().equals("Yres"))) {
            AbstractDataMatrix abstractDataMatrix = (AbstractDataMatrix)dataTreeInterface;
            MVmatrix mVmatrix = new MVmatrix(0, 0, abstractDataMatrix.toString());
            mVmatrix.setVisibleInTree(false);
            mVmatrix.setID(((DataTreeClass)dataTreeInterface).getID());
            for (int i = 0; i < dataTreeInterface.getTreeNodeCount(); ++i) {
                mVmatrix.add(dataTreeInterface.getTreeNodeAt(i));
            }
            if (abstractDataMatrix.getRowDescription() != null && !mVmatrix.contains(abstractDataMatrix.getRowDescription())) {
                mVmatrix.add(abstractDataMatrix.getRowDescription());
            }
            if (abstractDataMatrix.getColumnDescription() != null && !mVmatrix.contains(abstractDataMatrix.getColumnDescription())) {
                mVmatrix.add(abstractDataMatrix.getColumnDescription());
            }
            dataTreeInterface = mVmatrix;
        }
        super.saveModel(dataTreeInterface, randomOutputStream, n, saveType);
    }

    protected abstract void SaveModel(RandomOutputStream var1) throws IOException;

    @Override
    protected void setProtectedLocal(ProgressManager progressManager, boolean bl) {
        if (!bl) {
            this.setChanged(progressManager);
        }
    }

    @Override
    protected boolean supportInterface(DataTreeInterface dataTreeInterface, AbstractModel.SaveType saveType) {
        if (!saveType.isComplete()) {
            if (dataTreeInterface instanceof DataContainer && (dataTreeInterface.toString().equals("Explained variances") || dataTreeInterface.toString().equals("Output Container")) || dataTreeInterface instanceof AbstractDataTransform || dataTreeInterface instanceof Description) {
                return true;
            }
            if (dataTreeInterface instanceof OutputClass || dataTreeInterface instanceof AbstractDataMatrix && ((AbstractDataMatrix)dataTreeInterface).getTreeParent() instanceof AbstractDataTransform) {
                return true;
            }
            if (dataTreeInterface instanceof AbstractDataMatrix && ((AbstractDataMatrix)dataTreeInterface).getTreeParent() instanceof ModelMatrix) {
                return true;
            }
            if (dataTreeInterface instanceof ModelMatrix && ((ModelMatrix)dataTreeInterface).getColumnType() == 4) {
                return true;
            }
            return dataTreeInterface.equals(this.X) || dataTreeInterface.equals(this.Y);
        }
        return super.supportInterface(dataTreeInterface, saveType);
    }

    private void addAllPredictionNodes(List<AnalysPredictionNode> list, DataTreeInterface dataTreeInterface) {
        for (int i = 0; i < dataTreeInterface.getTreeNodeCount(); ++i) {
            DataTreeInterface dataTreeInterface2 = dataTreeInterface.getTreeNodeAt(i);
            if (!(dataTreeInterface2 instanceof AnalysPredictionNode)) continue;
            list.add((AnalysPredictionNode)dataTreeInterface2);
        }
    }

    private class ModelListener
    implements DataSetListener {
        private ModelListener() {
        }

        @Override
        public void dataSetChanged(DataSetEvent dataSetEvent) {
            if (AnalysModel.this.getDatasetchanged()) {
                if (!(AnalysModel.this.getTreeParent() instanceof ModelContainer)) {
                    AnalysModel.this.setChanged(dataSetEvent.getProgressManager());
                }
                AnalysModel.this.updateModelContainer((byte)-1);
            }
        }

        @Override
        public void dataSetPurged(DataSetEvent dataSetEvent) {
            AnalysModel.this.setChanged(dataSetEvent.getProgressManager());
        }

        @Override
        public void eventFinished(DataTreeEvent dataTreeEvent) {
        }

        @Override
        public void nodeReplaced(DataTreeEvent dataTreeEvent) {
            AnalysModel.this.setChanged(dataTreeEvent.getProgressManager());
        }

        @Override
        public void propertyChanged(DataTreeEvent dataTreeEvent) {
        }
    }
}

