/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.mda.model;

import java.io.IOException;
import java.util.Properties;
import se.prediktera.map.common.MapProperty;
import se.prediktera.map.common.NiceDataFormat;
import se.prediktera.map.common.RandomInputStream;
import se.prediktera.map.common.RandomOutputStream;
import se.prediktera.map.common.progress.ProgressManager;
import se.prediktera.map.datasetcontainer.BasicTreeInterface;
import se.prediktera.map.datasetcontainer.datainfo.AbstractDataInfo;
import se.prediktera.map.datasetcontainer.datainfo.DataGroupValues;
import se.prediktera.map.datasetcontainer.datainfo.Description;
import se.prediktera.map.datasetcontainer.datainfo.IncExclude;
import se.prediktera.map.datasetcontainer.datainfo.InnerColumnBoolean;
import se.prediktera.map.datasetcontainer.datainfo.InnerColumnString;
import se.prediktera.map.datasetcontainer.datainfo.VariablesInfo;
import se.prediktera.map.datasetcontainer.dataset.DataSet;
import se.prediktera.map.datasetcontainer.dataset.event.DataSetEvent;
import se.prediktera.map.datasetcontainer.dataset.event.DataSetListener;
import se.prediktera.map.datasetcontainer.event.DataTreeEvent;
import se.prediktera.map.datasetcontainer.matrix.AbstractDataMatrix;
import se.prediktera.map.datasetcontainer.matrix.AbstractMVmatrix;
import se.prediktera.map.datasetcontainer.matrix.DataTypeInterface;
import se.prediktera.map.datasetcontainer.matrix.ModelMatrix;
import se.prediktera.map.main.extclass.ExtClassLoader;
import se.prediktera.map.main.script.ScriptHelper;
import se.prediktera.map.model.AbstractPrediction;
import se.prediktera.mda.model.AbstractMDAModel;
import se.prediktera.mda.model.AbstractMDAResults;

public abstract class AnalysPredictionNode
extends AbstractPrediction
implements DataTypeInterface {
    protected ModelMatrix[] predMR;
    protected boolean calcDModXY = true;
    protected boolean predClasses = true;
    protected boolean optimize = false;
    private final PredictionListener predictionListener = new PredictionListener();

    public AnalysPredictionNode(AbstractMDAModel abstractMDAModel, DataSet dataSet, Properties properties, boolean bl) {
        super("AnalysPredictionNode", dataSet, abstractMDAModel, bl);
        if (properties != null) {
            if (properties.containsKey("dmodx")) {
                this.calcDModXY = ScriptHelper.getPropertyBool(properties, "dmodx");
            }
            if (properties.containsKey("predclasses")) {
                this.predClasses = ScriptHelper.getPropertyBool(properties, "predclasses");
            }
            if (properties.containsKey("optimize")) {
                this.optimize = ScriptHelper.getPropertyBool(properties, "optimize");
            }
        }
        this.init();
    }

    public AnalysPredictionNode(RandomInputStream randomInputStream, MapProperty mapProperty) throws IOException {
        super(randomInputStream, mapProperty);
        this.calcDModXY = mapProperty.getPropertyBoolean("dmodx", true);
        this.init();
    }

    public void calcAllPredictions(ProgressManager progressManager) {
        if (this.canCalculate()) {
            this.beginCalculations();
            if (this.model != null && this.model.getResults() != null) {
                for (int i = 0; i < this.model.getResults().getRound(); ++i) {
                    this.calcOnePrediction(progressManager);
                }
            }
            this.finishPrediction(progressManager);
            this.endCalculations();
        }
    }

    public abstract boolean canCalculate();

    @Override
    public void cleanUpChild() {
        super.cleanUpChild();
        this.predMR = null;
    }

    public boolean dataSetContainsModelDescriptions(InnerColumnString innerColumnString, InnerColumnString innerColumnString2, int[] nArray, int n) {
        if (innerColumnString2 == null) {
            return false;
        }
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            String string = innerColumnString2.getValueLocal(nArray != null ? nArray[i] : i);
            n2 = this.indexOfString(innerColumnString, null, string, n2);
            if (n2 >= 0) continue;
            return false;
        }
        return true;
    }

    public abstract void finishPrediction(ProgressManager var1);

    @Override
    public ExtClassLoader.LicenseLibrary getLibrary() {
        return ExtClassLoader.LicenseLibrary.MDA;
    }

    @Override
    public String getInformation() {
        StringBuilder stringBuilder = new StringBuilder("<HTML><BODY>");
        stringBuilder.append("<table border=\"0\" cellpadding=\"0\" cellspacing=\"0\" >");
        stringBuilder.append("<TR><TD>Model:</TD><TD>").append(this.model.toString()).append("</TD></TR>");
        stringBuilder.append("<TR><TD>DataSet:</TD><TD>").append(this.dataSet.toString()).append("</TD></TR>");
        stringBuilder.append("<TR><TD>Case:</TD><TD>").append(this.dataSet.getCase().toString()).append("</TD></TR>");
        stringBuilder.append("</TABLE></BODY></HTML>");
        return stringBuilder.toString();
    }

    @Override
    public AbstractDataMatrix getMatrixByName(String string) {
        Object object;
        if (this.predMR != null) {
            object = this.predMR;
            int n = ((ModelMatrix[])object).length;
            for (int i = 0; i < n; ++i) {
                ModelMatrix modelMatrix = object[i];
                if (modelMatrix == null || !modelMatrix.toString().equals(string)) continue;
                return modelMatrix;
            }
        }
        if ((object = this.getNodeByName(string)) instanceof AbstractDataMatrix) {
            return (AbstractDataMatrix)object;
        }
        return null;
    }

    public ModelMatrix getPredMR(int n) {
        if (n >= 0 && n < this.predMR.length && this.predMR[n] != null) {
            return this.predMR[n];
        }
        return null;
    }

    @Override
    public byte getNodeType() {
        return 5;
    }

    public AbstractMVmatrix getXMatrix() {
        return null;
    }

    public AbstractMVmatrix getYMatrix() {
        return null;
    }

    public int indexOfString(InnerColumnString innerColumnString, int[] nArray, String string, int n) {
        if (string != null) {
            int n2 = nArray != null ? nArray.length : innerColumnString.getSize();
            string = string.toLowerCase().trim();
            double d = NiceDataFormat.toNumber(string);
            for (int i = n; i < n2; ++i) {
                double d2;
                String string2 = innerColumnString.getValueLocal(nArray != null ? nArray[i] : i);
                if (string2 == null) continue;
                string2 = string2.toLowerCase().trim();
                if (!Double.isNaN(d) && !Double.isNaN(d2 = NiceDataFormat.toNumber(string2)) && d == d2) {
                    return i;
                }
                if (!string.equals(string2)) continue;
                return i;
            }
        }
        return -1;
    }

    @Override
    public boolean isVisibleInTree() {
        return super.isVisibleInTree() && this.canCalculate();
    }

    @Override
    public void SavePropertyLocal(RandomOutputStream randomOutputStream) throws IOException {
        super.SavePropertyLocal(randomOutputStream);
        randomOutputStream.writePropertyBoolean("dmodx", this.calcDModXY);
    }

    protected abstract AbstractMDAResults calcOnePrediction(ProgressManager var1);

    public abstract AbstractMDAResults getPredictions();

    protected boolean checkDimensions() {
        AbstractDataMatrix abstractDataMatrix = this.model.getMatrixByName("Xres");
        AbstractDataMatrix abstractDataMatrix2 = this.getReferenceMatrix();
        int n = abstractDataMatrix != null && abstractDataMatrix.getK() > 0 ? abstractDataMatrix.getK() : abstractDataMatrix2.getK();
        AbstractDataMatrix abstractDataMatrix3 = this.getDataSetMatrixToPredictInX();
        int n2 = abstractDataMatrix3.getK();
        if (n2 > 0 && n != n2) {
            Object object;
            BasicTreeInterface basicTreeInterface;
            DataGroupValues dataGroupValues;
            Object object2;
            VariablesInfo variablesInfo = this.dataSet.getVarDataInfo();
            Description description = abstractDataMatrix2.getRowDescription();
            if (description != null) {
                object2 = (InnerColumnString)description.getPrimaryColumn();
                dataGroupValues = (Description)variablesInfo.getGroupColumnByType(0);
                basicTreeInterface = (InnerColumnString)dataGroupValues.getPrimaryColumn();
                if (this.dataSetContainsModelDescriptions((InnerColumnString)basicTreeInterface, (InnerColumnString)object2, (int[])(object = abstractDataMatrix2.getKref()), n)) {
                    IncExclude incExclude = (IncExclude)variablesInfo.getGroupColumnByType(1);
                    InnerColumnBoolean innerColumnBoolean = (InnerColumnBoolean)incExclude.getPrimaryColumn();
                    IncExclude incExclude2 = (IncExclude)variablesInfo.getGroupColumnByType(3);
                    InnerColumnBoolean innerColumnBoolean2 = (InnerColumnBoolean)incExclude2.getPrimaryColumn();
                    int n3 = 0;
                    for (int i = 0; i < incExclude.getRows(); ++i) {
                        if (!innerColumnBoolean2.getValueBool(i)) continue;
                        String string = ((InnerColumnString)basicTreeInterface).getValueLocal(i);
                        int n4 = this.indexOfString((InnerColumnString)object2, (int[])object, string, n3);
                        innerColumnBoolean.setValueBool(i, n4 >= 0);
                        if (n4 < 0) continue;
                        n3 = n4;
                    }
                    this.dataSet.updateReferences();
                    return true;
                }
            }
            if (this.model.getDataSet() != null) {
                object2 = this.model.getDataSet().getVarDataInfo();
                dataGroupValues = (IncExclude)((AbstractDataInfo)object2).getGroupColumnByType(3);
                basicTreeInterface = (IncExclude)variablesInfo.getGroupColumnByType(1);
                if (object2 != null && this.countX((IncExclude)dataGroupValues) == ((DataGroupValues)basicTreeInterface).getRows()) {
                    object = (IncExclude)((AbstractDataInfo)object2).getGroupColumnByType(1);
                    int n5 = 0;
                    for (int i = 0; i < ((DataGroupValues)object).getRows(); ++i) {
                        if (!((IncExclude)dataGroupValues).isIncluded(i)) continue;
                        ((IncExclude)basicTreeInterface).setIncluded(n5++, ((IncExclude)object).isIncluded(i));
                    }
                    this.dataSet.updateReferences();
                    return true;
                }
            }
            if (this.model.getIncludedArray() != null && ((Object)(object2 = (Object)this.model.getIncludedArray())).length == (dataGroupValues = (IncExclude)variablesInfo.getGroupColumnByType(1)).getRows()) {
                for (int i = 0; i < ((Object)object2).length; ++i) {
                    ((IncExclude)dataGroupValues).setIncluded(i, (boolean)object2[i]);
                }
                this.dataSet.updateReferences();
                return true;
            }
            throw new RuntimeException("The number of variables in the model and in the dataset does not agree (" + n + "/" + n2 + ")");
        }
        return true;
    }

    protected AbstractDataMatrix getReferenceMatrix() {
        return this.model.getMatrixByName("P");
    }

    protected abstract void removeOnePrediction() throws Exception;

    protected abstract void resetPrediction() throws Exception;

    private int countX(IncExclude incExclude) {
        int n = 0;
        for (int i = 0; i < incExclude.getRows(); ++i) {
            if (!incExclude.isIncluded(i)) continue;
            ++n;
        }
        return n;
    }

    private void init() {
        if (this.dataSet != null && this.model != null && !this.dataSet.equals(this.model.getDataSet())) {
            this.dataSet.addDataTreeChangeListener(this.predictionListener);
        }
    }

    private synchronized void recalcAllPredictions(ProgressManager progressManager) {
        try {
            this.beginUpdateRecursive();
            this.resetPrediction();
            this.calcAllPredictions(progressManager);
            this.endUpdateRecursive();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private class PredictionListener
    implements DataSetListener {
        private PredictionListener() {
        }

        @Override
        public void dataSetChanged(DataSetEvent dataSetEvent) {
            AnalysPredictionNode.this.recalcAllPredictions(dataSetEvent.getProgressManager());
        }

        @Override
        public void dataSetPurged(DataSetEvent dataSetEvent) {
        }

        @Override
        public void eventFinished(DataTreeEvent dataTreeEvent) {
        }

        @Override
        public void nodeReplaced(DataTreeEvent dataTreeEvent) {
            AnalysPredictionNode.this.recalcAllPredictions(dataTreeEvent.getProgressManager());
        }

        @Override
        public void propertyChanged(DataTreeEvent dataTreeEvent) {
        }
    }
}

