/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.mda.model;

import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.Vector;
import javax.swing.ComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.ListDataListener;
import se.prediktera.map.common.swing.ComboItem;
import se.prediktera.map.common.swing.JComboBoxCell;
import se.prediktera.map.common.wizard.AbstractWizard;
import se.prediktera.map.common.wizard.WizardPageClass;
import se.prediktera.map.datasetcontainer.Case;
import se.prediktera.map.datasetcontainer.DataContainer;
import se.prediktera.map.datasetcontainer.DataTreeClass;
import se.prediktera.map.datasetcontainer.DataTreeInterface;
import se.prediktera.map.datasetcontainer.datainfo.AbstractInnerColumn;
import se.prediktera.map.datasetcontainer.datainfo.ObservationInfo;
import se.prediktera.map.datasetcontainer.dataset.DataSet;
import se.prediktera.map.datasetcontainer.matrix.AbstractDataMatrix;
import se.prediktera.map.datasetcontainer.transform.Transformations;
import se.prediktera.map.main.IniManager;
import se.prediktera.map.main.script.AbstractScriptInfo;
import se.prediktera.map.main.script.ScriptManager;
import se.prediktera.map.model.AbstractModel;
import se.prediktera.map.model.AbstractModelContainerWindow;
import se.prediktera.map.model.modelgenerator.ModelInit;
import se.prediktera.mda.model.AbstractCVModelInfo;
import se.prediktera.mda.model.CrossvalidationPanel;

public class CommonPanel
extends WizardPageClass {
    private final JTextField textModelName = new JTextField();
    private final JLabel dataSetLabel = new JLabel();
    private final JLabel comboBoxIncludeXByLabel = new JLabel();
    private final JComboBox comboBoxIncludeXBy = new JComboBox();
    private final JComboBoxCell comboBoxComponents = new JComboBoxCell(false);
    private DataSet lastDataSet = null;
    private String defaultModelName;
    private AbstractModelContainerWindow currentMcw;
    private final CrossvalidationPanel cvPanel;
    private final JComboBoxCell scriptComboBox = new JComboBoxCell();
    private int maxdefaultindex = 0;

    public CommonPanel(AbstractCVModelInfo abstractCVModelInfo) {
        this.cvPanel = new CrossvalidationPanel(abstractCVModelInfo);
        JLabel jLabel = new JLabel("Model settings");
        jLabel.setFont(new Font("Dialog", 1, 12));
        this.comboBoxComponents.setModel(new ComponentBoxModel());
        this.comboBoxIncludeXBy.addItem("Default");
        this.setLayout(new GridBagLayout());
        this.add((Component)jLabel, new GridBagConstraints(0, 0, 2, 1, 0.0, 0.0, 18, 0, new Insets(6, 6, 12, 0), 0, 0));
        this.add((Component)new JLabel("Model Name:"), new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(6, 18, 0, 0), 0, 0));
        this.add((Component)this.textModelName, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 17, 2, new Insets(6, 6, 0, 12), 0, 0));
        this.add((Component)new JLabel("DataSet:"), new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(6, 18, 0, 0), 0, 0));
        this.add((Component)this.dataSetLabel, new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 10, 2, new Insets(6, 6, 0, 12), 0, 0));
        this.add((Component)new JLabel("Components:"), new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 17, 0, new Insets(6, 18, 0, 0), 0, 0));
        this.add((Component)this.comboBoxComponents, new GridBagConstraints(1, 3, 1, 1, 0.0, 0.0, 10, 2, new Insets(6, 6, 0, 12), 0, 0));
        this.comboBoxIncludeXByLabel.setText("Category:");
        this.add((Component)this.comboBoxIncludeXByLabel, new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 18, 0, new Insets(6, 18, 0, 0), 0, 0));
        this.add((Component)this.comboBoxIncludeXBy, new GridBagConstraints(1, 4, 1, 1, 0.0, 0.0, 18, 2, new Insets(6, 6, 0, 12), 0, 0));
        this.add((Component)this.cvPanel, new GridBagConstraints(0, 10, 2, 1, 0.0, 0.0, 18, 2, new Insets(6, 0, 0, 0), 0, 0));
        JLabel jLabel2 = new JLabel("Templates");
        jLabel2.setFont(new Font("Dialog", 1, 12));
        this.add((Component)jLabel2, new GridBagConstraints(0, 11, 2, 1, 0.0, 0.0, 18, 0, new Insets(6, 6, 12, 0), 0, 0));
        this.add((Component)new JLabel("Template:"), new GridBagConstraints(0, 12, 1, 1, 0.0, 0.0, 17, 0, new Insets(6, 18, 0, 0), 0, 0));
        this.add((Component)this.scriptComboBox, new GridBagConstraints(1, 12, 1, 1, 0.0, 0.0, 10, 2, new Insets(6, 6, 0, 12), 0, 0));
        this.add((Component)new JLabel(""), new GridBagConstraints(0, 20, 1, 1, 0.0, 1.0, 18, 0, new Insets(0, 0, 0, 0), 0, 0));
    }

    public void addEmptyClass() {
        this.comboBoxIncludeXBy.addItem("Empty SIMCA Model");
    }

    public void beginWizard(ModelInit modelInit, Vector vector, AbstractModel abstractModel) {
        ObservationInfo observationInfo;
        this.lastDataSet = modelInit.getDataSet();
        this.defaultModelName = modelInit.getModelName();
        this.setModelContainer(vector, this.lastDataSet);
        if (this.lastDataSet != null && this.lastDataSet != null && (observationInfo = this.lastDataSet.getObsDataInfo()) != null) {
            Transformations transformations = observationInfo.getTransformationNode();
            int n = transformations.getColumnCount();
            for (int i = 0; i < n; ++i) {
                if (transformations.getColumnType(i) != 4) continue;
                this.comboBoxIncludeXBy.addItem(transformations.getInnerColumn(i));
            }
        }
        this.cvPanel.beginWizard(modelInit, abstractModel);
        this.maxdefaultindex = ScriptManager.addScriptInfoComboBox(this.scriptComboBox, "model", modelInit.getModelType(), modelInit);
        if (abstractModel != null) {
            this.textModelName.setText(abstractModel.getName());
            this.comboBoxComponents.setSelectedIndex(abstractModel.getComponentsInt() + 1);
        }
    }

    public void excludeIncludeXBy() {
        this.comboBoxIncludeXByLabel.setVisible(false);
        this.comboBoxIncludeXBy.setVisible(false);
    }

    public AbstractModelContainerWindow getCurrentMcw() {
        return this.currentMcw;
    }

    public CrossvalidationPanel getCvPanel() {
        return this.cvPanel;
    }

    public Object getIncludeXByItem() {
        return this.comboBoxIncludeXBy.getSelectedItem();
    }

    public String getModelName(String string) {
        String string2 = this.textModelName.getText();
        if (string2.length() == 0) {
            return string;
        }
        return string2;
    }

    public int getNumberOfComponents() {
        return this.comboBoxComponents.getSelectedIndex() - 1;
    }

    public AbstractScriptInfo getScriptInfo(ModelInit modelInit) {
        Object object = this.scriptComboBox.getSelectedItem();
        if (object instanceof AbstractScriptInfo) {
            AbstractScriptInfo abstractScriptInfo = (AbstractScriptInfo)object;
            String string = "SCRIPT_MODEL_" + modelInit.getModelType() + "_DEFAULT_";
            IniManager.setScriptSettings(string.toUpperCase() + this.maxdefaultindex, abstractScriptInfo.toString());
            return abstractScriptInfo;
        }
        return null;
    }

    public boolean hasIncludeXBy() {
        return this.comboBoxIncludeXBy.getSelectedItem() instanceof AbstractInnerColumn;
    }

    public boolean isCrossvalidation() {
        if (this.cvPanel != null) {
            return this.cvPanel.getCrossvalidationType() > 0;
        }
        return false;
    }

    public boolean isFullCV() {
        if (this.cvPanel != null) {
            return this.cvPanel.isFullCV();
        }
        return false;
    }

    public void removeAllClass() {
        this.comboBoxIncludeXBy.removeAllItems();
    }

    @Override
    public void setWizard(AbstractWizard abstractWizard) {
        super.setWizard(abstractWizard);
        abstractWizard.addNextListener(this.textModelName);
    }

    @Override
    protected void cleanUpChild() {
        this.currentMcw = null;
        this.cvPanel.cleanUp();
        this.lastDataSet = null;
    }

    private void setDataSet(DataContainer dataContainer) {
        if (dataContainer == null) {
            this.dataSetLabel.setText("N/A");
        } else {
            DataTreeClass dataTreeClass = null;
            for (int i = 0; i < dataContainer.size(); ++i) {
                DataTreeInterface dataTreeInterface = dataContainer.getTreeNodeAt(i);
                if (!(dataTreeInterface instanceof DataSet)) continue;
                DataSet dataSet = (DataSet)dataTreeInterface;
                if (this.lastDataSet != null && dataTreeClass == this.lastDataSet) continue;
                dataTreeClass = dataSet;
            }
            if (dataTreeClass != null) {
                this.dataSetLabel.setText(dataTreeClass.toString());
            }
        }
    }

    private void setModelContainer(Vector vector, DataSet dataSet) {
        for (int i = 0; i < vector.size(); ++i) {
            AbstractModelContainerWindow abstractModelContainerWindow = (AbstractModelContainerWindow)vector.elementAt(i);
            DataContainer dataContainer = abstractModelContainerWindow.getDataContainer();
            if (this.currentMcw != null || dataSet == null || !dataSet.isRelatedTo(dataContainer)) continue;
            this.currentMcw = abstractModelContainerWindow;
            this.textModelName.setText(dataContainer.getUniqueName(this.defaultModelName));
            Case case_ = this.currentMcw.getDataSetContainer();
            this.setDataSet(case_.getDsContainer());
            SwingUtilities.invokeLater(() -> {
                this.textModelName.selectAll();
                this.textModelName.requestFocus();
            });
            break;
        }
    }

    private class ComponentBoxModel
    implements ComboBoxModel {
        private final ComboItem separator = new ComboItem("%SEPARATOR#", 0);
        private Object selectedItem = "[AUTO]";

        private ComponentBoxModel() {
        }

        @Override
        public void addListDataListener(ListDataListener listDataListener) {
        }

        @Override
        public Object getElementAt(int n) {
            if (n == 0) {
                return "[AUTO]";
            }
            if (n == 1) {
                return this.separator;
            }
            return String.valueOf(n - 1);
        }

        @Override
        public Object getSelectedItem() {
            return this.selectedItem;
        }

        @Override
        public int getSize() {
            if (CommonPanel.this.lastDataSet == null) {
                return 0;
            }
            AbstractDataMatrix abstractDataMatrix = CommonPanel.this.lastDataSet.getMatrix(0);
            return 2 + Math.min(abstractDataMatrix.getN(), abstractDataMatrix.getK());
        }

        @Override
        public void removeListDataListener(ListDataListener listDataListener) {
        }

        @Override
        public void setSelectedItem(Object object) {
            this.selectedItem = object;
        }
    }
}

