/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.mda.model;

import java.io.IOException;
import javax.swing.SwingUtilities;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import se.prediktera.map.common.MapProperty;
import se.prediktera.map.common.RandomInputStream;
import se.prediktera.map.common.RandomOutputStream;
import se.prediktera.map.common.progress.ProgressManagerImpl;
import se.prediktera.map.history.AbstractHistoryNode;
import se.prediktera.map.main.extclass.DataTreeExtLibInterface;
import se.prediktera.map.main.extclass.ExtClassLoader;
import se.prediktera.mda.model.AbstractMDAModel;

public class ComponentHistoryNode
extends AbstractHistoryNode
implements DataTreeExtLibInterface {
    private int component_number;
    private final AbstractMDAModel model;

    private static String getComponentInfo(int n) {
        int n2 = Math.abs(n);
        return switch (n2) {
            case 1 -> "One";
            case 2 -> "Two";
            case 3 -> "Three";
            case 4 -> "Four";
            case 5 -> "Five";
            case 6 -> "Six";
            case 7 -> "Seven";
            case 8 -> "Eight";
            case 9 -> "Nine";
            default -> String.valueOf(n2);
        };
    }

    public ComponentHistoryNode(AbstractMDAModel abstractMDAModel, int n) {
        super(ComponentHistoryNode.getComponentInfo(n) + " component(s) " + (n > 0 ? "added" : "removed"));
        this.model = abstractMDAModel;
        this.component_number = n;
        long l = System.currentTimeMillis();
        this.changeComponent(true);
        this.duration = System.currentTimeMillis() - l;
    }

    public ComponentHistoryNode(RandomInputStream randomInputStream, MapProperty mapProperty) throws IOException {
        super(randomInputStream, mapProperty);
        this.component_number = mapProperty.hasProperty("ac") ? (mapProperty.getPropertyBoolean("ac") ? 1 : -1) : mapProperty.getPropertyInt("an");
        this.model = (AbstractMDAModel)mapProperty.resolveNodeFromName(randomInputStream, "model");
    }

    @Override
    public ExtClassLoader.LicenseLibrary getLibrary() {
        return ExtClassLoader.LicenseLibrary.MDA;
    }

    @Override
    public byte getNodeType() {
        return 5;
    }

    @Override
    public byte getTreeType() {
        return 5;
    }

    @Override
    public void redo() throws CannotRedoException {
        super.redo();
        this.changeComponent(true);
    }

    @Override
    public void SavePropertyLocal(RandomOutputStream randomOutputStream) throws IOException {
        super.SavePropertyLocal(randomOutputStream);
        randomOutputStream.writePropertyInt("an", this.component_number);
        randomOutputStream.writePropertyNode("model", this.model);
    }

    @Override
    public void undo() throws CannotUndoException {
        super.undo();
        this.changeComponent(false);
    }

    @Override
    protected void ClearDataLocal() throws IOException {
    }

    @Override
    protected void LoadDataLocal(RandomInputStream randomInputStream) throws IOException {
    }

    @Override
    protected void SaveDataLocal(RandomOutputStream randomOutputStream) throws IOException {
    }

    private void changeComponent(final boolean bl) {
        ProgressManagerImpl progressManagerImpl = new ProgressManagerImpl(this){
            final /* synthetic */ ComponentHistoryNode this$0;
            {
                this.this$0 = componentHistoryNode;
            }

            @Override
            public Object doWork() {
                boolean bl2 = this.this$0.component_number > 0;
                this.setInfoText((bl2 == bl ? "Adding" : "Removing") + " " + ComponentHistoryNode.getComponentInfo(this.this$0.component_number).toLowerCase() + " Component(s)");
                this.this$0.beginUpdateRecursive();
                this.this$0.model.changeComponent(this, (bl ? 1 : -1) * this.this$0.component_number);
                this.this$0.endUpdateRecursive();
                return null;
            }
        };
        SwingUtilities.invokeLater(progressManagerImpl);
    }
}

