/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.mda.model;

import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import se.prediktera.map.common.JTextFieldButtonUppDown;
import se.prediktera.map.common.cleanup.CleanUpPanel;
import se.prediktera.map.common.swing.ComboBoxRenderer;
import se.prediktera.map.common.swing.ComboItem;
import se.prediktera.map.datasetcontainer.DataContainer;
import se.prediktera.map.datasetcontainer.classes.InnerColumnClass;
import se.prediktera.map.datasetcontainer.datainfo.AbstractDataInfo;
import se.prediktera.map.datasetcontainer.datainfo.ObservationInfo;
import se.prediktera.map.datasetcontainer.matrix.AbstractDataMatrix;
import se.prediktera.map.datasetcontainer.matrix.LayerMatrix;
import se.prediktera.map.datasetcontainer.transform.Transformations;
import se.prediktera.map.main.IniManager;
import se.prediktera.map.model.AbstractModel;
import se.prediktera.map.model.modelgenerator.ModelInit;
import se.prediktera.mda.model.AbstractCVModelInfo;
import se.prediktera.mda.model.AbstractMDAModel;
import se.prediktera.mda.model.CrossvalidationModel;

public class CrossvalidationPanel
extends CleanUpPanel {
    private final JComboBox boxCrossvalidation = new JComboBox();
    private final JComboBox boxCrossvalidationClass = new JComboBox();
    private final JTextFieldButtonUppDown textGroups = new JTextFieldButtonUppDown(2.0, 2.147483647E9, false);
    private final ComboItem classButton = new ComboItem(AbstractMDAModel.CV_NAME[3], 0);
    private boolean changedCrossvalidationValue = false;
    private final JCheckBox ciCheckBox = new JCheckBox("Calculate Confidence Intervals", true);
    private final JRadioButton segmentedCVRadioButton = new JRadioButton("Partial");
    private final JRadioButton fullCVRadioButton = new JRadioButton("Full");
    private final JRadioButton noneCVRadioButton = new JRadioButton("None");

    public CrossvalidationPanel(AbstractCVModelInfo abstractCVModelInfo) {
        super(new GridBagLayout());
        ButtonGroup buttonGroup = new ButtonGroup();
        String string = IniManager.getUserSettings("cvType");
        if (string == null) {
            string = "full";
            IniManager.setUserSettings("cvType", "full");
        }
        if (string != null && string.equals("full") && abstractCVModelInfo.getType().startsWith("pls")) {
            this.fullCVRadioButton.setSelected(true);
        } else {
            this.segmentedCVRadioButton.setSelected(true);
        }
        buttonGroup.add(this.segmentedCVRadioButton);
        buttonGroup.add(this.fullCVRadioButton);
        buttonGroup.add(this.noneCVRadioButton);
        this.noneCVRadioButton.addItemListener(itemEvent -> this.setEnabled());
        for (int i = 1; i < AbstractMDAModel.CV_NAME.length; ++i) {
            if (i == 6 && !abstractCVModelInfo.getType().equals("pls-da")) continue;
            if (i == 3) {
                this.boxCrossvalidation.addItem(this.classButton);
                continue;
            }
            this.boxCrossvalidation.addItem(AbstractMDAModel.CV_NAME[i]);
        }
        String string2 = IniManager.getUserSettings("cvExclusion");
        if (string2 != null) {
            this.boxCrossvalidation.setSelectedItem(string2);
        } else {
            this.boxCrossvalidation.setSelectedIndex(0);
        }
        this.boxCrossvalidation.addActionListener(new ComboListener());
        this.boxCrossvalidation.setRenderer(new ComboBoxRenderer());
        this.boxCrossvalidation.addItemListener(itemEvent -> {
            if (itemEvent.getStateChange() == 1) {
                this.setEnabled();
            }
        });
        this.boxCrossvalidationClass.setEnabled(false);
        this.textGroups.setNumber(7.0);
        JLabel jLabel = new JLabel("Cross-validation");
        jLabel.setFont(new Font("Dialog", 1, 12));
        int n = 0;
        this.add((Component)jLabel, new GridBagConstraints(0, n++, 3, 1, 0.0, 0.0, 18, 0, new Insets(6, 6, 12, 0), 0, 0));
        this.add((Component)new JLabel("Type:"), new GridBagConstraints(0, n, 1, 1, 0.0, 0.0, 17, 0, new Insets(6, 18, 0, 0), 0, 0));
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        jPanel.add((Component)this.segmentedCVRadioButton, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(6, 0, 0, 0), 0, 0));
        if (abstractCVModelInfo != null && abstractCVModelInfo.getType().startsWith("pls")) {
            jPanel.add((Component)this.fullCVRadioButton, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(6, 18, 0, 0), 0, 0));
        }
        jPanel.add((Component)this.noneCVRadioButton, new GridBagConstraints(2, 0, 1, 1, 1.0, 0.0, 17, 0, new Insets(6, 18, 0, 0), 0, 0));
        this.add((Component)jPanel, new GridBagConstraints(1, n++, 1, 1, 1.0, 0.0, 10, 2, new Insets(6, 6, 0, 12), 0, 0));
        this.add((Component)new JLabel("Exclusion by:"), new GridBagConstraints(0, n, 1, 1, 0.0, 0.0, 17, 0, new Insets(6, 18, 0, 0), 0, 0));
        this.add((Component)this.boxCrossvalidation, new GridBagConstraints(1, n++, 2, 1, 1.0, 0.0, 10, 2, new Insets(6, 6, 0, 12), 0, 0));
        this.add((Component)new JLabel("Rounds:"), new GridBagConstraints(0, n, 1, 1, 0.0, 0.0, 17, 0, new Insets(6, 18, 0, 0), 0, 0));
        this.add((Component)this.textGroups, new GridBagConstraints(1, n++, 2, 1, 0.0, 0.0, 10, 1, new Insets(6, 6, 0, 12), 0, 0));
        this.add((Component)new JLabel("Category:"), new GridBagConstraints(0, n, 1, 1, 0.0, 0.0, 17, 0, new Insets(6, 18, 0, 0), 0, 0));
        this.add((Component)this.boxCrossvalidationClass, new GridBagConstraints(1, n++, 2, 1, 0.0, 0.0, 10, 2, new Insets(6, 6, 0, 12), 0, 0));
        this.add((Component)this.ciCheckBox, new GridBagConstraints(1, n, 2, 1, 1.0, 0.0, 10, 2, new Insets(6, 6, 0, 12), 0, 0));
        this.add((Component)new JLabel(""), new GridBagConstraints(0, 11, 1, 1, 0.0, 1.0, 18, 0, new Insets(0, 6, 0, 0), 0, 0));
    }

    public void beginWizard(ModelInit modelInit, AbstractModel abstractModel) {
        this.setClasses(modelInit.getDataSetContainer(), null);
        ObservationInfo observationInfo = modelInit.getDataSet().getObsDataInfo();
        this.textGroups.setMinMax(2.0, observationInfo.getActiveTrueSize(1));
        this.textGroups.setNumber(7.0);
        String string = IniManager.getUserSettings("cvExclusion");
        if (string != null) {
            this.boxCrossvalidation.setSelectedItem(string);
        } else if (modelInit.getDataSet().getOriginalMatrix() instanceof LayerMatrix && !observationInfo.isGroup()) {
            this.noneCVRadioButton.setSelected(true);
        } else {
            this.boxCrossvalidation.setSelectedIndex(0);
        }
        this.setEnabled();
        this.changedCrossvalidationValue = true;
        if (abstractModel instanceof CrossvalidationModel) {
            CrossvalidationModel crossvalidationModel = (CrossvalidationModel)abstractModel;
            byte by = crossvalidationModel.getCrossvalidationType();
            if (by != 0) {
                if (crossvalidationModel.isTypeFull()) {
                    this.fullCVRadioButton.setSelected(true);
                } else {
                    this.segmentedCVRadioButton.setSelected(true);
                }
                this.boxCrossvalidation.setSelectedIndex(by - 1);
                this.textGroups.setNumber(crossvalidationModel.getNr_groups());
                String string2 = crossvalidationModel.getCvCategoryName();
                if (string2 != null) {
                    this.setCrossvalidationClass(string2);
                }
            } else {
                this.noneCVRadioButton.setSelected(true);
            }
            this.ciCheckBox.setSelected(crossvalidationModel.getCI());
        }
    }

    private void setCrossvalidationClass(String string) {
        for (int i = 0; i < this.boxCrossvalidationClass.getItemCount(); ++i) {
            if (!this.boxCrossvalidationClass.getItemAt(i).toString().equals(string)) continue;
            this.boxCrossvalidationClass.setSelectedIndex(i);
            break;
        }
    }

    public boolean calculateConfidenceInterval() {
        return this.ciCheckBox.isSelected();
    }

    public Object getCrossvalidationClass() {
        return this.boxCrossvalidationClass.getSelectedItem();
    }

    public int getCrossvalidationType() {
        if (this.noneCVRadioButton.isSelected()) {
            return 0;
        }
        return this.boxCrossvalidation.getSelectedIndex() + 1;
    }

    public byte getCrossvalidationType(AbstractDataMatrix abstractDataMatrix) {
        if (!this.changedCrossvalidationValue) {
            if (abstractDataMatrix instanceof LayerMatrix) {
                this.noneCVRadioButton.setSelected(true);
            }
            this.boxCrossvalidation.setSelectedIndex(0);
            this.changedCrossvalidationValue = true;
        }
        return (byte)this.getCrossvalidationType();
    }

    public int getNumberGroups() {
        return (int)this.textGroups.getNumber();
    }

    public boolean hasGroup() {
        return this.textGroups.isEnabled();
    }

    public boolean isCI() {
        return false;
    }

    public boolean isCrossvalidation() {
        return !this.noneCVRadioButton.isSelected();
    }

    public boolean isFullCV() {
        return this.fullCVRadioButton.isSelected();
    }

    public void setClasses(DataContainer dataContainer, InnerColumnClass innerColumnClass) {
        AbstractDataInfo abstractDataInfo;
        this.boxCrossvalidationClass.removeAllItems();
        if (dataContainer != null && (abstractDataInfo = dataContainer.getCase().getDataInfo(0)) != null) {
            Transformations transformations = abstractDataInfo.getTransformationNode();
            int n = transformations.getColumnCount();
            for (int i = 0; i < n; ++i) {
                if (transformations.getColumnType(i) != 4 || transformations.getInnerColumn(i).equals(innerColumnClass)) continue;
                this.boxCrossvalidationClass.addItem(transformations.getInnerColumn(i));
            }
        }
        this.classButton.setEnabled(this.boxCrossvalidationClass.getItemCount() > 0);
    }

    @Override
    protected void cleanUpChild() {
    }

    private void setEnabled() {
        if (this.noneCVRadioButton.isSelected()) {
            this.boxCrossvalidation.setEnabled(false);
            this.textGroups.setEnabled(false);
            this.boxCrossvalidationClass.setEnabled(false);
        } else {
            this.boxCrossvalidation.setEnabled(true);
            int n = this.getCrossvalidationType();
            if (n == 3) {
                this.textGroups.setEnabled(false);
                this.boxCrossvalidationClass.setEnabled(true);
            } else if (n == 5) {
                this.textGroups.setEnabled(false);
                this.boxCrossvalidationClass.setEnabled(false);
            } else {
                this.textGroups.setEnabled(true);
                this.boxCrossvalidationClass.setEnabled(false);
            }
        }
    }

    private class ComboListener
    implements ActionListener {
        private Object currentItem;

        public ComboListener() {
            this.currentItem = CrossvalidationPanel.this.boxCrossvalidation.getSelectedItem();
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            Object object = CrossvalidationPanel.this.boxCrossvalidation.getSelectedItem();
            if (object instanceof ComboItem && !((ComboItem)object).isEnabled()) {
                CrossvalidationPanel.this.boxCrossvalidation.setSelectedItem(this.currentItem);
            } else {
                this.currentItem = object;
            }
        }
    }
}

