/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.mda.model.GA;

import java.util.Arrays;
import java.util.Properties;
import java.util.Random;
import no.uib.cipr.matrix.DenseVector;
import se.prediktera.map.common.NiceDataFormat;
import se.prediktera.map.common.cleanup.CleanUpClass;
import se.prediktera.map.common.error.ErrorHandler;
import se.prediktera.map.common.progress.ProgressManager;
import se.prediktera.map.datasetcontainer.datainfo.AbstractDataInfo;
import se.prediktera.map.datasetcontainer.datainfo.IncExclude;
import se.prediktera.map.datasetcontainer.datainfo.InnerColumnBoolean;
import se.prediktera.map.datasetcontainer.dataset.DataSet;
import se.prediktera.map.datasetcontainer.matrix.ModelMatrix;
import se.prediktera.map.main.script.ScriptHelper;
import se.prediktera.map.model.GA.AbstractIndivide;
import se.prediktera.map.model.GA.IndivideFactoryInterface;
import se.prediktera.mda.model.PLS.PLSModel;
import se.prediktera.mda.model.PLS.PLSpredictionNode;

public class PlsGAFactory
extends CleanUpClass
implements IndivideFactoryInterface<Individe> {
    private PLSModel inPlsModel;
    private PLSModel plsModel;
    private int[] availableIntervall;
    private boolean[] unique;
    private boolean linearadjustment = false;
    private boolean variableSelection = false;

    public PlsGAFactory(ProgressManager progressManager, PLSModel pLSModel, Properties properties) {
        int n;
        this.inPlsModel = pLSModel;
        this.plsModel = new PLSModel(progressManager, pLSModel.getDataSet(), null, null, true);
        this.plsModel.setCrossvalidation((byte)0, 0, "", false);
        this.plsModel.calcModel(progressManager, pLSModel.getResults().getRound());
        DataSet dataSet = this.plsModel.getDataSet();
        if (properties != null) {
            if (ScriptHelper.hasKey(properties, "linearadjustment")) {
                this.linearadjustment = ScriptHelper.getPropertyBool(properties, "linearadjustment");
            }
            if (ScriptHelper.hasKey(properties, "varselection")) {
                this.variableSelection = ScriptHelper.getPropertyBool(properties, "varselection");
            }
        }
        AbstractDataInfo abstractDataInfo = null;
        abstractDataInfo = this.variableSelection ? dataSet.getVarDataInfo() : dataSet.getObsDataInfo();
        IncExclude incExclude = (IncExclude)abstractDataInfo.getGroupColumnByType(1);
        IncExclude incExclude2 = null;
        incExclude2 = this.variableSelection ? (IncExclude)abstractDataInfo.getGroupColumnByType(3) : (IncExclude)abstractDataInfo.getGroupColumnByType(4);
        InnerColumnBoolean innerColumnBoolean = (InnerColumnBoolean)incExclude.getPrimaryColumn();
        InnerColumnBoolean innerColumnBoolean2 = (InnerColumnBoolean)incExclude2.getPrimaryColumn();
        int n2 = 0;
        for (n = 0; n < innerColumnBoolean.getSize(); ++n) {
            if (!innerColumnBoolean.getValueBool(n) || !innerColumnBoolean2.getValueBool(n)) continue;
            ++n2;
        }
        this.availableIntervall = new int[n2];
        n = 0;
        for (int i = 0; i < innerColumnBoolean.getSize(); ++i) {
            if (!innerColumnBoolean.getValueBool(i) || !innerColumnBoolean2.getValueBool(i)) continue;
            this.availableIntervall[n++] = i;
        }
        this.unique = new boolean[this.availableIntervall.length];
    }

    @Override
    public AbstractIndivide<Individe> createIndivide(Random random) {
        Individe individe = new Individe();
        if (this.linearadjustment) {
            individe.scalefactor = new double[3];
            individe.offset = new double[3];
            for (int i = 0; i < 3; ++i) {
                individe.scalefactor[i] = random.nextDouble() * 2.0;
                individe.offset[i] = random.nextDouble() * 5.0;
            }
        }
        individe.intervall = new int[this.availableIntervall.length];
        individe.size = this.setRandomIntervall(random, individe.intervall, this.availableIntervall, this.availableIntervall.length, 0);
        individe.size = this.setRandomIntervall(random, individe.intervall, this.availableIntervall, this.availableIntervall.length, individe.size);
        return individe;
    }

    @Override
    public AbstractIndivide<Individe> crossOver(Random random, Individe individe, Individe individe2, double d) {
        Individe individe3 = new Individe();
        if (this.linearadjustment) {
            individe3.scalefactor = new double[3];
            individe3.offset = new double[3];
            for (int i = 0; i < 3; ++i) {
                double d2 = random.nextDouble();
                individe3.scalefactor[i] = individe.scalefactor[i] * d2 + individe2.scalefactor[i] * (1.0 - d2);
                double d3 = random.nextDouble();
                individe3.offset[i] = individe.offset[i] * d3 + individe2.offset[i] * (1.0 - d3);
            }
        }
        individe3.intervall = new int[this.availableIntervall.length];
        individe3.size = this.setRandomIntervall(random, individe3.intervall, individe.intervall, individe.size, 0);
        individe3.size = this.setRandomIntervall(random, individe3.intervall, individe2.intervall, individe2.size, individe3.size);
        return individe3;
    }

    @Override
    public void mutate(Individe individe, Random random, double d) {
        double d2 = (1.0 - d) * 0.8 + 0.2;
        if (this.linearadjustment) {
            int n = 0;
            while (n < 3) {
                int n2 = n;
                individe.scalefactor[n2] = individe.scalefactor[n2] + (random.nextDouble() - 0.5) * 2.0 * d2;
                int n3 = n++;
                individe.offset[n3] = individe.offset[n3] + (random.nextDouble() - 0.5) * 5.0 * d2;
            }
        }
        if (random.nextDouble() < d2) {
            individe.size = this.setRandomIntervall(random, individe.intervall, (int[])individe.intervall.clone(), individe.size, 0);
            individe.size = this.setRandomIntervall(random, individe.intervall, this.availableIntervall, this.availableIntervall.length, individe.size);
        }
    }

    @Override
    protected void cleanUpChild() {
        if (this.plsModel != null) {
            this.plsModel.cleanUp();
            this.plsModel = null;
        }
        this.inPlsModel = null;
        this.availableIntervall = null;
        this.unique = null;
    }

    private int setRandomIntervall(Random random, int[] nArray, int[] nArray2, int n, int n2) {
        int n3 = (int)((double)((float)n * random.nextFloat()) + 0.5);
        return this.setRandomIntervall(random, nArray, nArray2, n, n2, n3);
    }

    private int setRandomIntervall(Random random, int[] nArray, int[] nArray2, int n, int n2, int n3) {
        int n4 = n3;
        int n5 = 0;
        int n6 = n2;
        Arrays.fill(this.unique, false);
        while (n4 > 0) {
            n5 = (int)(((double)n - 1.0) * (double)random.nextFloat() + 0.5);
            if (this.unique[n5]) continue;
            this.unique[n5] = true;
            boolean bl = true;
            for (int i = 0; i < n2; ++i) {
                if (nArray[i] != nArray2[n5]) continue;
                bl = false;
                break;
            }
            if (bl) {
                nArray[n6++] = nArray2[n5];
            }
            --n4;
        }
        return n6;
    }

    public class Individe
    extends AbstractIndivide {
        private double[] scalefactor;
        private double[] offset;
        private int[] intervall;
        private int size;
        private double rmseptot;

        @Override
        public double evaluate(ProgressManager progressManager, Properties properties) throws Exception {
            try {
                PLSModel pLSModel = PlsGAFactory.this.plsModel;
                if (properties != null && ScriptHelper.hasKey(properties, "setchanged") && ScriptHelper.getPropertyBool(properties, "setchanged")) {
                    pLSModel = PlsGAFactory.this.inPlsModel;
                }
                DataSet dataSet = pLSModel.getDataSet();
                dataSet.setManual(progressManager, true);
                if (PlsGAFactory.this.variableSelection) {
                    if (this.size < 25) {
                        return 0.0;
                    }
                    dataSet.includeOnly("var", new int[][]{this.intervall}, new int[]{this.size}, properties);
                } else {
                    dataSet.includeOnly("obs", new int[][]{{1, 4, 7}, this.intervall}, new int[]{3, this.size}, properties);
                }
                if (PlsGAFactory.this.linearadjustment) {
                    pLSModel.setScalefactor(this.scalefactor);
                    pLSModel.setOffset(this.offset);
                }
                if (PlsGAFactory.this.variableSelection ? dataSet.getMatrix(0).getK() < dataSet.getMatrix(2).getK() : dataSet.getMatrix(0).getN() < dataSet.getMatrix(2).getK()) {
                    return 0.0;
                }
                pLSModel.setChanged(progressManager);
                PLSpredictionNode pLSpredictionNode = (PLSpredictionNode)pLSModel.getLocalPredictionNode();
                ModelMatrix modelMatrix = (ModelMatrix)pLSpredictionNode.get("RMSEP_var");
                DenseVector denseVector = modelMatrix.getLastRM();
                this.rmseptot = 0.0;
                for (int i = 0; i < denseVector.size(); ++i) {
                    this.rmseptot += denseVector.get(i);
                }
                this.rmseptot /= (double)denseVector.size();
                this.fitnessValue = 50.0 - this.rmseptot;
                if (this.fitnessValue < 5.0) {
                    this.fitnessValue = 5.0;
                }
                this.fitnessValue *= this.fitnessValue;
                return this.fitnessValue;
            }
            catch (Exception exception) {
                ErrorHandler.logAndReportException(exception);
                return 0.0;
            }
        }

        @Override
        public void print(int n) {
            int n2;
            System.out.print("Generation: " + (n + 1) + "\tFitness value: " + NiceDataFormat.toString(this.getFitnessValue()));
            System.out.print(", rmsep: " + NiceDataFormat.toString(this.rmseptot, 4));
            if (this.scalefactor != null && this.offset != null) {
                for (n2 = 0; n2 < 3; ++n2) {
                    System.out.print(", sf: " + NiceDataFormat.toString(this.scalefactor[n2], 4));
                    System.out.print(", o: " + NiceDataFormat.toString(this.offset[n2], 4));
                }
            }
            System.out.print(", i: ");
            for (n2 = 0; n2 < this.size; ++n2) {
                System.out.print(", " + this.intervall[n2]);
            }
            System.out.println("");
        }
    }
}

