/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.mda.model.GA.plsda;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import org.jgap.BulkFitnessFunction;
import org.jgap.Chromosome;
import org.jgap.Configuration;
import org.jgap.FitnessFunction;
import org.jgap.Gene;
import org.jgap.Genotype;
import org.jgap.IBreeder;
import org.jgap.IChromosome;
import org.jgap.InvalidConfigurationException;
import org.jgap.NaturalSelector;
import org.jgap.Population;
import org.jgap.RandomGenerator;
import org.jgap.event.EventManager;
import org.jgap.event.IEventManager;
import org.jgap.impl.BestChromosomesSelector;
import org.jgap.impl.BooleanGene;
import org.jgap.impl.DefaultConfiguration;
import org.jgap.impl.GABreeder;
import org.jgap.impl.StockRandomGenerator;
import se.prediktera.map.common.Threader;
import se.prediktera.map.common.ThreaderWithId;
import se.prediktera.map.common.progress.ProgressManager;
import se.prediktera.map.datasetcontainer.classes.InnerColumnClass;
import se.prediktera.map.datasetcontainer.dataset.DataSet;
import se.prediktera.map.datasetcontainer.matrix.AbstractDataMatrix;
import se.prediktera.map.datasetcontainer.matrix.ModelMatrix;
import se.prediktera.map.main.script.ScriptHelper;
import se.prediktera.map.model.AbstractModel;
import se.prediktera.map.model.analysis.AbstractAnalysisInfo;
import se.prediktera.map.register.RegisterKeyManager;
import se.prediktera.mda.model.GA.plsda.PlsDaGAHelper;
import se.prediktera.mda.model.GA.plsda.ThreadFitnessFunction;

public class PlsDaGAInfo
extends AbstractAnalysisInfo {
    private int evolution = 0;
    private Gene[] sampleGenes;
    private Configuration conf;

    @Override
    public Object performAnalysis(ProgressManager progressManager, Object[] objectArray, Properties properties) {
        IChromosome iChromosome;
        int n;
        Population population;
        Genotype genotype;
        AbstractDataMatrix abstractDataMatrix;
        Object object;
        int n2;
        DataSet dataSet = (DataSet)objectArray[0];
        int n3 = 20;
        int n4 = 15;
        int n5 = 5;
        int n6 = n3 * 3;
        if (properties != null) {
            if (ScriptHelper.hasKey(properties, "maxcomponents")) {
                n5 = ScriptHelper.getPropertyInt(properties, "maxcomponents");
            }
            if (ScriptHelper.hasKey(properties, "wait")) {
                n4 = ScriptHelper.getPropertyInt(properties, "wait");
            }
        }
        Configuration.reset();
        ThreadFitnessFunction threadFitnessFunction = new ThreadFitnessFunction(progressManager, dataSet, n5);
        try {
            this.conf = new DefaultConfiguration();
            this.conf.setBreeder((IBreeder)new ThreadBreeder());
            this.conf.setFitnessFunction((FitnessFunction)threadFitnessFunction);
            n2 = threadFitnessFunction.getClassSize();
            n3 = Math.min(n2, n3);
            this.sampleGenes = new Gene[n2];
            int n7 = 0;
            for (int i = 0; i < n2; ++i) {
                this.sampleGenes[n7++] = new BooleanGene(this.conf);
            }
            object = new Chromosome(this.conf, this.sampleGenes);
            abstractDataMatrix = dataSet.getMatrix(0);
            this.conf.setSampleChromosome((IChromosome)object);
            this.conf.setPreservFittestIndividual(true);
            this.conf.setKeepPopulationSizeConstant(false);
            this.conf.setPopulationSize(n6 + abstractDataMatrix.getN() + 100);
            this.conf.setSampleChromosome((IChromosome)object);
            BestChromosomesSelector bestChromosomesSelector = new BestChromosomesSelector(this.conf, 1.0);
            bestChromosomesSelector.setDoubletteChromosomesAllowed(false);
            this.conf.addNaturalSelector((NaturalSelector)bestChromosomesSelector, true);
            this.conf.setRandomGenerator((RandomGenerator)new StockRandomGenerator());
            this.conf.setEventManager((IEventManager)new EventManager());
            genotype = Genotype.randomInitialGenotype((Configuration)this.conf);
            population = genotype.getPopulation();
        }
        catch (InvalidConfigurationException invalidConfigurationException) {
            throw new RuntimeException(invalidConfigurationException);
        }
        AbstractModel abstractModel = dataSet.createModel(progressManager, "PCA", 3.0);
        object = abstractModel.getScores();
        int n8 = 0;
        for (n = 0; n < ((ModelMatrix)object).getN(); ++n) {
            iChromosome = new ArrayList(((ModelMatrix)object).getK());
            for (int i = 0; i < ((ModelMatrix)object).getK(); ++i) {
                iChromosome.add(new IndexClass(i, ((ModelMatrix)object).getValue(n, i)));
            }
            Collections.sort(iChromosome, (indexClass, indexClass2) -> Double.compare(indexClass.value, indexClass2.value));
            double d = (double)iChromosome.size() / (double)(n3 + 1);
            for (int i = 0; i < n3; ++i) {
                IChromosome iChromosome2 = population.getChromosome(n8++);
                Gene[] geneArray = iChromosome2.getGenes();
                int n9 = (int)(d * (double)(i + 1));
                for (int j = 0; j < n2; ++j) {
                    IndexClass indexClass3 = (IndexClass)iChromosome.get(j);
                    geneArray[indexClass3.index].setAllele((Object)(j > n9 ? 1 : 0));
                }
            }
        }
        abstractModel.delete();
        for (n = 1; n < abstractDataMatrix.getN(); ++n) {
            iChromosome = population.getChromosome(n8++);
            Gene[] geneArray = iChromosome.getGenes();
            for (int i = 0; i < geneArray.length; ++i) {
                geneArray[i].setAllele((Object)(i < n ? 1 : 0));
            }
        }
        threadFitnessFunction.resetTime();
        Threader.setDefaultNoThreads(1);
        progressManager.setMaximumAndReset(100);
        progressManager.setInfoText("Evaluating best PLS-DA separation (Approx 1 min)");
        long l = System.currentTimeMillis();
        double d = 0.0;
        this.evolution = 0;
        while (this.evolution < 800) {
            long l2;
            genotype.evolve();
            IChromosome iChromosome3 = genotype.getFittestChromosome();
            double d2 = iChromosome3.getFitnessValueDirectly();
            if (d < d2) {
                d = d2;
                this.traverseFittestChromosome(threadFitnessFunction, genotype.getPopulation(), iChromosome3);
                l = System.currentTimeMillis();
            }
            if ((l2 = System.currentTimeMillis() - l) > (long)(n4 * 1000)) {
                System.out.println("Not enough progress was made after initial delay");
                break;
            }
            ++this.evolution;
        }
        Threader.setDefaultNoThreads(-1);
        InnerColumnClass innerColumnClass = threadFitnessFunction.getIcc();
        IChromosome iChromosome4 = genotype.getFittestChromosome();
        PlsDaGAHelper.setClasses(progressManager, dataSet, innerColumnClass, iChromosome4);
        threadFitnessFunction.cleanUp();
        this.sampleGenes = null;
        this.conf = null;
        return null;
    }

    @Override
    public boolean supportParam(Object[] objectArray) {
        return RegisterKeyManager.isPredikteraDevelopmentLicense();
    }

    public String toString() {
        return "GAPLSDA";
    }

    private void traverseFittestChromosome(ThreadFitnessFunction threadFitnessFunction, final Population population, IChromosome iChromosome) {
        final double d = iChromosome.getFitnessValueDirectly();
        int n = Runtime.getRuntime().availableProcessors();
        final IChromosome[] iChromosomeArray = new IChromosome[n];
        for (int i = 0; i < iChromosomeArray.length; ++i) {
            iChromosomeArray[i] = (IChromosome)iChromosome.clone();
            iChromosomeArray[i].setApplicationData((Object)i);
        }
        ThreaderWithId threaderWithId = new ThreaderWithId(this, n){

            @Override
            protected void doOp(int n, List<Integer> list) {
                for (Integer n2 : list) {
                    IChromosome iChromosome = iChromosomeArray[n];
                    iChromosome.resetAge();
                    iChromosome.setFitnessValueDirectly(-1.0);
                    BooleanGene booleanGene = (BooleanGene)iChromosome.getGene(n2.intValue());
                    Boolean bl = (Boolean)booleanGene.getAllele();
                    booleanGene.setAllele((Object)(bl == false ? 1 : 0));
                    double d2 = iChromosome.getFitnessValue();
                    if (d2 > d) {
                        population.addChromosome((IChromosome)iChromosomeArray[n].clone());
                    }
                    booleanGene.setAllele((Object)bl);
                }
            }
        };
        threaderWithId.execute(iChromosome.size());
    }

    protected class ThreadBreeder
    extends GABreeder {
        protected ThreadBreeder() {
        }

        protected void updateChromosomes(final Population population, Configuration configuration) {
            boolean bl;
            int n = population.size();
            BulkFitnessFunction bulkFitnessFunction = configuration.getBulkFitnessFunction();
            boolean bl2 = bl = bulkFitnessFunction != null;
            if (!bl) {
                ThreaderWithId threaderWithId = new ThreaderWithId(this){

                    @Override
                    protected void doOp(int n, List<Integer> list) {
                        for (Integer n2 : list) {
                            IChromosome iChromosome = population.getChromosome(n2.intValue());
                            iChromosome.setApplicationData((Object)n);
                            iChromosome.getFitnessValue();
                        }
                    }
                };
                threaderWithId.execute(n);
            }
        }
    }

    private static class IndexClass {
        int index;
        double value;

        public IndexClass(int n, double d) {
            this.index = n;
            this.value = d;
        }
    }
}

