/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.mda.model.GA.plsda;

import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.jgap.FitnessFunction;
import org.jgap.IChromosome;
import se.prediktera.map.common.NiceDataFormat;
import se.prediktera.map.common.error.ErrorHandler;
import se.prediktera.map.common.progress.ProgressManager;
import se.prediktera.map.datasetcontainer.classes.InnerColumnClass;
import se.prediktera.map.datasetcontainer.datainfo.AbstractDataInfo;
import se.prediktera.map.datasetcontainer.datainfo.ObservationInfo;
import se.prediktera.map.datasetcontainer.dataset.DataSet;
import se.prediktera.map.datasetcontainer.matrix.AbstractDataMatrix;
import se.prediktera.map.datasetcontainer.matrix.AbstractMVmatrix;
import se.prediktera.map.datasetcontainer.matrix.ModelMatrix;
import se.prediktera.map.datasetcontainer.transform.AbstractTransform;
import se.prediktera.map.datasetcontainer.transform.category.Category;
import se.prediktera.map.datasetcontainer.transform.category.DataInfoClassEvent;
import se.prediktera.map.model.AbstractModel;
import se.prediktera.mda.model.GA.plsda.PlsDaGAHelper;
import se.prediktera.mda.model.PLS.PLSModel;

public class ThreadFitnessFunction
extends FitnessFunction {
    private final ProgressManager pManager;
    private final ProgressManager internalManager = ProgressManager.createEmpty();
    private final DataSet dataSet;
    private final InnerColumnClass icc;
    private double fittest = 0.0;
    private final HashMap<Integer, ThreadDataSet> hashMap = new HashMap();
    private int iindex = 0;
    private int maxcomponents = 5;
    private final double PLSDA_COMPONENTS = -1.0;
    private final boolean forceprint = false;
    private long time = 0L;
    private final int evolution = 0;

    public ThreadFitnessFunction(ProgressManager progressManager, DataSet dataSet, int n) throws RuntimeException {
        this.pManager = progressManager;
        this.dataSet = dataSet;
        this.maxcomponents = n;
        Category category = (Category)dataSet.createModification(this.internalManager, "obs", "category");
        category.setDefaultType(AbstractTransform.Type.localAdd);
        category.setName("Type");
        this.icc = category.getInnerColumn();
        this.icc.addClass("A", "blue");
        this.icc.addClass("B", "green");
        ObservationInfo observationInfo = dataSet.getObsDataInfo();
        observationInfo.triggerGlobalEvent(new DataInfoClassEvent((AbstractDataInfo)observationInfo, 0, category, category.getClassTypes(), 0));
        category.updateClasses();
    }

    public void cleanUp() {
        Set<Map.Entry<Integer, ThreadDataSet>> set = this.hashMap.entrySet();
        for (Map.Entry<Integer, ThreadDataSet> entry : set) {
            ThreadDataSet threadDataSet = entry.getValue();
            threadDataSet.model.delete();
        }
    }

    public double evaluateSetup(int n) throws Exception {
        ThreadDataSet threadDataSet = this.hashMap.get(n);
        Properties properties = new Properties();
        properties.put("ycategory", "Type");
        properties.put("crossvalidation", "true");
        properties.put("cvfull", "false");
        properties.put("cvtype", "evenlyspread");
        properties.put("dmodx", "false");
        properties.put("keep", "true");
        properties.put("maxcomponents", String.valueOf(this.maxcomponents));
        properties.put("autofit", "true");
        if (threadDataSet.model == null) {
            threadDataSet.model = (PLSModel)this.createModel(threadDataSet.dataSet, properties);
            threadDataSet.model.setCalcDmodX(false);
            threadDataSet.model.setKeep();
            threadDataSet.model.setRecalcautofit(true);
        } else if (!threadDataSet.model.doUpdateLocalFast(this.internalManager)) {
            return 0.0;
        }
        ModelMatrix modelMatrix = (ModelMatrix)threadDataSet.model.get("q2y_cum");
        double d = modelMatrix.getLastScalar();
        double d2 = d * 10.0;
        d2 = d2 < 0.0 ? 0.0 : (d2 *= d2 * d2 * d2);
        if (d2 > this.fittest) {
            ModelMatrix modelMatrix2 = (ModelMatrix)threadDataSet.model.get("nit");
            this.fittest = d2;
            double d3 = (double)(System.currentTimeMillis() - this.time) / 1000.0;
            System.out.println(n + ", " + this.iindex + ", 0, " + NiceDataFormat.toString(d) + ", value=" + NiceDataFormat.toString(PlsDaGAHelper.calcRangvalue(d)) + ", fitness=" + NiceDataFormat.toString(d2) + ", components=" + threadDataSet.model.getComponentsInt() + ", time=" + NiceDataFormat.toString(d3) + ", average=" + NiceDataFormat.toString(d3 / (double)this.iindex) + ", nit=" + modelMatrix2.getLastScalar());
            int n2 = (int)(PlsDaGAHelper.calcRangvalue(d) * 25.0 - 25.0);
            this.pManager.setProgressValue(n2);
        }
        return d2;
    }

    public synchronized double evaluateSync(ThreadDataSet threadDataSet, IChromosome iChromosome, int n) throws Exception {
        if (PlsDaGAHelper.setClasses(this.internalManager, threadDataSet.dataSet, threadDataSet.icc, iChromosome) && threadDataSet.dataSet.hasY() > 0.0) {
            return this.evaluateSetup(n);
        }
        return 0.0;
    }

    public int getClassSize() {
        AbstractDataMatrix abstractDataMatrix = this.dataSet.getMatrix(0);
        return abstractDataMatrix.getN();
    }

    public InnerColumnClass getIcc() {
        return this.icc;
    }

    public void resetTime() {
        this.time = System.currentTimeMillis();
    }

    protected double evaluate(IChromosome iChromosome) {
        block6: {
            try {
                ThreadDataSet threadDataSet;
                ++this.iindex;
                int n = 0;
                Object object = iChromosome.getApplicationData();
                if (object instanceof Integer) {
                    n = (Integer)object;
                }
                if ((threadDataSet = this.hashMap.get(n)) == null) {
                    threadDataSet = this.createDataSet(this.dataSet);
                    this.hashMap.put(n, threadDataSet);
                }
                AbstractMVmatrix abstractMVmatrix = null;
                if (threadDataSet.model != null) {
                    abstractMVmatrix = threadDataSet.model.getKeepY();
                    if (PlsDaGAHelper.setClasses(this.internalManager, threadDataSet.dataSet, abstractMVmatrix, iChromosome) && threadDataSet.dataSet.hasY() > 0.0) {
                        return this.evaluateSetup(n);
                    }
                    break block6;
                }
                return this.evaluateSync(threadDataSet, iChromosome, n);
            }
            catch (Exception exception) {
                ErrorHandler.logAndReportException(exception);
            }
        }
        return 0.0;
    }

    private synchronized ThreadDataSet createDataSet(DataSet dataSet) throws Exception {
        return new ThreadDataSet(dataSet);
    }

    private synchronized AbstractModel createModel(DataSet dataSet, Properties properties) throws Exception {
        return dataSet.createModel(this.internalManager, "PLS-DA", -1.0, properties);
    }

    private static class ThreadDataSet {
        private final DataSet dataSet;
        private final InnerColumnClass icc;
        private PLSModel model;

        public ThreadDataSet(DataSet dataSet) throws Exception {
            this.dataSet = dataSet;
            this.icc = this.dataSet.getCategory("Type");
        }
    }
}

