/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.mda.model;

import java.awt.Window;
import java.io.File;
import java.util.ArrayList;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import se.prediktera.map.common.CCheckBoxMenuItem;
import se.prediktera.map.common.CMenu;
import se.prediktera.map.common.CMenuItem;
import se.prediktera.map.common.error.ErrorHandler;
import se.prediktera.map.common.progress.ProgressManager;
import se.prediktera.map.common.progress.ProgressManagerImpl;
import se.prediktera.map.common.swing.filechooser.jopensaveDialog;
import se.prediktera.map.dataimport.ImportHelper;
import se.prediktera.map.datasetcontainer.transform.category.CategoryHierarchy;
import se.prediktera.map.main.IniManager;
import se.prediktera.map.main.Project_GUI;
import se.prediktera.map.main.script.LoadHelper;
import se.prediktera.map.model.AbstractModel;
import se.prediktera.map.model.ModelManager;

public class ModelConnection {
    public static void addToPopupMenu(Project_GUI project_GUI, JPopupMenu jPopupMenu, final AbstractModel abstractModel) {
        CMenu cMenu = new CMenu("Connection", true);
        jPopupMenu.add(cMenu);
        CCheckBoxMenuItem cCheckBoxMenuItem = new CCheckBoxMenuItem(abstractModel.isEnabled() ? "Disable" : "Enable", true);
        cCheckBoxMenuItem.setSelected(abstractModel.isEnabled());
        cCheckBoxMenuItem.addItemListener(itemEvent -> abstractModel.setEnabled(itemEvent.getStateChange() == 1));
        cMenu.add(cCheckBoxMenuItem);
        cMenu.addSeparator();
        CMenuItem cMenuItem = new CMenuItem("Connect to internal model class", true);
        cMenuItem.addActionListener(actionEvent -> {
            ArrayList<AbstractModel> arrayList = new ArrayList<AbstractModel>();
            ModelManager.collectModels(abstractModel.getRoot(), arrayList);
            Object object = JOptionPane.showInputDialog(IniManager.getMainFrame(), "Select internal model to connect to:", "Select model", 3, null, arrayList.toArray(), null);
            if (object != null) {
                AbstractModel abstractModel2 = (AbstractModel)object;
                ModelConnection.connectModelToClass(IniManager.getMainFrame(), abstractModel2, abstractModel);
            }
        });
        cMenu.add(cMenuItem);
        cMenuItem = new CMenuItem("Connect to external model class", true);
        cMenuItem.addActionListener(actionEvent -> {
            final jopensaveDialog jopensaveDialog2 = ImportHelper.createModelDialog("Choose calibration model", null, true);
            jopensaveDialog2.setMultiSelectionEnabled(false);
            if (jopensaveDialog2.openshow()) {
                ProgressManagerImpl progressManagerImpl = new ProgressManagerImpl(){

                    @Override
                    public Object doWork() {
                        try {
                            File file = jopensaveDialog2.getSelectedFile();
                            ModelConnection.connectModelToClass(this.getWindow(), abstractModel, ModelConnection.getModelFromFile(this, file));
                        }
                        catch (Exception exception) {
                            ErrorHandler.logAndShowEvinceErrorDialogForException(exception);
                        }
                        return null;
                    }
                };
                IniManager.setWorkDir((byte)5, jopensaveDialog2.getCurrentDirectory());
                progressManagerImpl.invokeNow();
            }
        });
        cMenu.add(cMenuItem);
        cMenuItem = new CMenuItem("Clear connection", true);
        cMenuItem.addActionListener(actionEvent -> {
            abstractModel.setReplaceModel(null);
            abstractModel.setReplaceClassName(null);
            abstractModel.getDataTreeManager().updateHistory();
            abstractModel.setProjectChanged();
        });
        cMenu.add(cMenuItem);
        cMenu.addSeparator();
        if (abstractModel.getModelName().equals("PLS-DA")) {
            cMenuItem = new CMenuItem("Split model into hierarchy", true);
            cMenuItem.addActionListener(actionEvent -> CategoryHierarchy.createHierarchy(project_GUI, abstractModel));
            cMenu.add(cMenuItem);
            cMenu.addSeparator();
        }
        cMenuItem = new CMenuItem("Add external model", true);
        cMenuItem.addActionListener(actionEvent -> {
            final jopensaveDialog jopensaveDialog2 = ImportHelper.createModelDialog("Choose calibration model", null, true);
            jopensaveDialog2.setMultiSelectionEnabled(false);
            if (jopensaveDialog2.openshow()) {
                ProgressManagerImpl progressManagerImpl = new ProgressManagerImpl(){

                    @Override
                    public Object doWork() {
                        try {
                            File file = jopensaveDialog2.getSelectedFile();
                            ModelConnection.connectModelToClass(this.getWindow(), abstractModel, ModelConnection.getModelFromFile(this, file));
                        }
                        catch (Exception exception) {
                            ErrorHandler.logAndShowEvinceErrorDialogForException(exception);
                        }
                        return null;
                    }
                };
                IniManager.setWorkDir((byte)5, jopensaveDialog2.getCurrentDirectory());
                progressManagerImpl.invokeNow();
            }
        });
        cMenu.add(cMenuItem);
    }

    public static void connectToParentModel(AbstractModel abstractModel, AbstractModel abstractModel2, String string) {
        abstractModel2.setReplaceModel(abstractModel);
        abstractModel2.setReplaceClassName(string);
        abstractModel2.setEnabled(true);
        abstractModel.setEnabled(true);
        abstractModel2.getDataTreeManager().updateHistory();
    }

    public static void connectModelToClass(Window window, AbstractModel abstractModel, AbstractModel abstractModel2) {
        Object object;
        Object[] objectArray = abstractModel.getVariableArray();
        if (objectArray != null && (object = JOptionPane.showInputDialog(window, "Select class:", "Select class (" + String.valueOf(abstractModel) + ")", 3, null, objectArray, null)) != null) {
            ModelConnection.connectToParentModel(abstractModel, abstractModel2, String.valueOf(object));
        }
    }

    private static AbstractModel getModelFromFile(ProgressManager progressManager, File file) {
        AbstractModel abstractModel = null;
        if (LoadHelper.isProjectFile(file.getName())) {
            ArrayList<AbstractModel> arrayList = new ArrayList<AbstractModel>();
            ModelManager.collectModels(progressManager, file, arrayList);
            Object[] objectArray = arrayList.toArray();
            abstractModel = (AbstractModel)JOptionPane.showInputDialog(progressManager.getWindow(), "Select model from list", "Select model in project", 1, null, objectArray, null);
            if (abstractModel == null) {
                return null;
            }
        } else {
            abstractModel = ModelManager.loadModelIntoProject(progressManager, file);
        }
        return abstractModel;
    }
}

