/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.mda.model;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import se.prediktera.map.common.CMenu;
import se.prediktera.map.common.CMenuItem;
import se.prediktera.map.common.MapProperty;
import se.prediktera.map.common.RandomInputStream;
import se.prediktera.map.common.RandomOutputStream;
import se.prediktera.map.common.cleanup.CleanUpVector;
import se.prediktera.map.common.error.ErrorHandler;
import se.prediktera.map.common.progress.ProgressManager;
import se.prediktera.map.common.progress.ProgressManagerImpl;
import se.prediktera.map.data.modeltable.AbstractTModel;
import se.prediktera.map.datasetcontainer.DataContainer;
import se.prediktera.map.datasetcontainer.DataTreeClass;
import se.prediktera.map.datasetcontainer.DataTreeInterface;
import se.prediktera.map.datasetcontainer.classes.ClassTypes;
import se.prediktera.map.datasetcontainer.classes.InnerColumnClass;
import se.prediktera.map.datasetcontainer.datainfo.ObservationInfo;
import se.prediktera.map.datasetcontainer.dataset.DataSet;
import se.prediktera.map.datasetcontainer.event.DataTreeEvent;
import se.prediktera.map.datasetcontainer.matrix.AbstractDataMatrix;
import se.prediktera.map.datasetcontainer.matrix.MVmatrix;
import se.prediktera.map.datasetcontainer.matrix.event.DataMatrixEvent;
import se.prediktera.map.datasetcontainer.transform.AbstractTransform;
import se.prediktera.map.datasetcontainer.transform.Transformations;
import se.prediktera.map.datasetcontainer.transform.category.Category;
import se.prediktera.map.main.IniManager;
import se.prediktera.map.main.Project_GUI;
import se.prediktera.map.model.AbstractModel;
import se.prediktera.map.model.AbstractPrediction;
import se.prediktera.map.model.ModelHelper;
import se.prediktera.map.model.ModelListener;
import se.prediktera.mda.model.AbstractMDAModel;
import se.prediktera.mda.model.AnalysTableModel;
import se.prediktera.mda.model.CrossvalidationModel;
import se.prediktera.mda.model.ModelContainerSummary;
import se.prediktera.mda.model.PCA.PCAModel;
import se.prediktera.mda.model.PLS.PLSModel;

public class ModelContainer
extends AbstractMDAModel {
    private boolean isSingleY = false;
    private String className = null;
    private ArrayList<String> subClassList = null;
    private int Yindex = -1;
    private boolean subclasschanged = false;
    private ModelContainerSummary sSX_CUM_Summary;
    private ModelContainerSummary q2Y_CUM_Summary;

    public ModelContainer(DataSet dataSet, String string, boolean bl, String string2) {
        super(dataSet, null, null, false);
        this.isSingleY = bl;
        this.className = string2;
        this.setName(string);
        this.transformedContainer.setVisibleInTree(false);
        this.createSummary();
    }

    public ModelContainer(DataSet dataSet, String string, String string2, int n) {
        super(dataSet, null, null, false);
        this.className = string2;
        this.Yindex = n;
        if (n >= 0) {
            AbstractDataMatrix abstractDataMatrix = dataSet.getMatrix(2);
            this.setName(abstractDataMatrix.getColumnDescription(n, 0));
        } else {
            this.setName(string);
        }
        this.transformedContainer.setVisibleInTree(false);
        this.createSummary();
    }

    public ModelContainer(RandomInputStream randomInputStream, MapProperty mapProperty) throws IOException {
        super(randomInputStream, mapProperty);
        this.isSingleY = mapProperty.getPropertyBoolean("singeY");
        this.className = mapProperty.getPropertyStringUTF("className");
        this.Yindex = mapProperty.getPropertyInt("Yindex", -1);
        this.sSX_CUM_Summary = (ModelContainerSummary)mapProperty.resolveNodeFromName(randomInputStream, "sCS");
        this.q2Y_CUM_Summary = (ModelContainerSummary)mapProperty.resolveNodeFromName(randomInputStream, "qCS");
        if (this.sSX_CUM_Summary == null && this.q2Y_CUM_Summary == null) {
            this.createSummary();
        }
    }

    @Override
    public void addModelListener(ModelListener modelListener) {
        super.addModelListener(modelListener);
        for (int i = 0; i < this.getTreeNodeCount(); ++i) {
            if (!(this.getTreeNodeAt(i) instanceof AbstractMDAModel)) continue;
            ((AbstractMDAModel)this.getTreeNodeAt(i)).addModelListener(modelListener);
        }
    }

    @Override
    public void addToPopupMenu(Project_GUI project_GUI, JPopupMenu jPopupMenu) {
        super.addToPopupMenu(project_GUI, jPopupMenu);
        if (!this.isSingleY && this.dataSet != null) {
            ObservationInfo observationInfo = this.dataSet.getObsDataInfo();
            Transformations transformations = observationInfo.getTransformationNode();
            CMenu cMenu = null;
            for (int i = 0; i < transformations.getColumnCount(); ++i) {
                final AbstractTransform abstractTransform = transformations.getTransform(i);
                if (!(abstractTransform instanceof Category) || abstractTransform.toString().equals(this.className)) continue;
                if (cMenu == null) {
                    cMenu = new CMenu("Create models from class...", false);
                    jPopupMenu.addSeparator();
                    jPopupMenu.add(cMenu);
                }
                CMenuItem cMenuItem = new CMenuItem(abstractTransform);
                cMenuItem.addActionListener(new ActionListener(){
                    final /* synthetic */ ModelContainer this$0;
                    {
                        this.this$0 = modelContainer;
                    }

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        this.this$0.className = abstractTransform.toString();
                        this.this$0.hideModels();
                        this.this$0.triggerPropertyEvent(new DataTreeEvent((Object)this, (DataTreeInterface)this.this$0, 0));
                        ProgressManagerImpl progressManagerImpl = new ProgressManagerImpl(){

                            @Override
                            public Object doWork() {
                                this$0.doUpdateLocal(this);
                                return null;
                            }
                        };
                        progressManagerImpl.invokeLater();
                    }
                });
                cMenu.add(cMenuItem);
            }
            if (this.className != null && this.dataSet != null) {
                CMenuItem cMenuItem = new CMenuItem((Object)"Include/exclude class models");
                cMenuItem.addActionListener(actionEvent2 -> {
                    JDialog jDialog = new JDialog(IniManager.getMainFrame());
                    jDialog.setTitle("Select included class models");
                    jDialog.setMinimumSize(new Dimension(250, 0));
                    JPanel jPanel = (JPanel)jDialog.getContentPane();
                    jPanel.setLayout(new GridBagLayout());
                    InnerColumnClass innerColumnClass = this.getInnerColumnClass();
                    ClassTypes classTypes = innerColumnClass.getObject();
                    for (int i = 1; i < classTypes.size(); ++i) {
                        String string = classTypes.getTypeDescription(i);
                        JCheckBox jCheckBox = new JCheckBox(string, this.subClassList == null || this.subClassList.contains(string));
                        jCheckBox.addItemListener(itemEvent -> {
                            this.subclasschanged = true;
                        });
                        jPanel.add((Component)jCheckBox, new GridBagConstraints(0, i, 1, 1, 0.0, 0.0, 17, 0, new Insets(i == 1 ? 12 : 6, 12, 0, 12), 0, 0));
                    }
                    JButton jButton = new JButton("OK");
                    jPanel.add((Component)jButton, new GridBagConstraints(0, classTypes.size(), 1, 1, 1.0, 1.0, 10, 0, new Insets(12, 6, 6, 6), 0, 0));
                    jButton.addActionListener(actionEvent -> {
                        if (this.subclasschanged) {
                            this.subClassList = new ArrayList();
                            for (int i = 0; i < jPanel.getComponentCount(); ++i) {
                                JCheckBox jCheckBox;
                                Component component = jPanel.getComponent(i);
                                if (!(component instanceof JCheckBox) || !(jCheckBox = (JCheckBox)component).isSelected()) continue;
                                this.subClassList.add(jCheckBox.getText());
                            }
                            jDialog.dispose();
                            ProgressManagerImpl progressManagerImpl = new ProgressManagerImpl(){

                                @Override
                                public Object doWork() {
                                    ModelContainer.this.doUpdateLocal(this);
                                    return null;
                                }
                            };
                            progressManagerImpl.invokeLater();
                        } else {
                            jDialog.dispose();
                        }
                    });
                    this.subclasschanged = false;
                    jDialog.pack();
                    jDialog.setLocationRelativeTo(IniManager.getMainFrame());
                    jDialog.setVisible(true);
                });
                jPopupMenu.add(cMenuItem);
            }
        }
    }

    public List<AbstractMDAModel> buildModelList() {
        ArrayList<AbstractMDAModel> arrayList = new ArrayList<AbstractMDAModel>();
        this.buildModelList(arrayList, this);
        return arrayList;
    }

    public void buildModelList(List<AbstractMDAModel> list, DataTreeInterface dataTreeInterface) {
        for (int i = 0; i < dataTreeInterface.getTreeNodeCount(); ++i) {
            AbstractMDAModel abstractMDAModel;
            DataTreeInterface dataTreeInterface2 = dataTreeInterface.getTreeNodeAt(i);
            if (dataTreeInterface2 instanceof AbstractMDAModel && !(abstractMDAModel = (AbstractMDAModel)dataTreeInterface2).isModelContainer()) {
                list.add(abstractMDAModel);
            }
            this.buildModelList(list, dataTreeInterface2);
        }
    }

    @Override
    public boolean calcModel(ProgressManager progressManager, int n) {
        for (int i = 0; i < this.getTreeNodeCount(); ++i) {
            AbstractMDAModel abstractMDAModel;
            DataTreeInterface dataTreeInterface = this.getTreeNodeAt(i);
            if (!(dataTreeInterface instanceof AbstractMDAModel) || (abstractMDAModel = (AbstractMDAModel)dataTreeInterface).isExternal()) continue;
            progressManager.setMaximumAndReset(abstractMDAModel.getNitmax() * n);
            abstractMDAModel.calcModel(progressManager, n);
        }
        this.finishCalculation(progressManager);
        return true;
    }

    @Override
    public AbstractPrediction createPredictionLocal(ProgressManager progressManager, DataSet dataSet, Properties properties) {
        for (int i = 0; i < this.getTreeNodeCount(); ++i) {
            DataTreeInterface dataTreeInterface = this.getTreeNodeAt(i);
            if (!(dataTreeInterface instanceof AbstractMDAModel)) continue;
            AbstractMDAModel abstractMDAModel = (AbstractMDAModel)dataTreeInterface;
            abstractMDAModel.createPredictionLocal(progressManager, dataSet, properties);
        }
        return null;
    }

    @Override
    public AbstractDataMatrix getMatrixByName(String string) {
        DataTreeInterface dataTreeInterface;
        AbstractDataMatrix abstractDataMatrix = super.getMatrixByName(string);
        if (abstractDataMatrix != null) {
            return abstractDataMatrix;
        }
        DataTreeInterface dataTreeInterface2 = this.getNodeByName("explainedvariances");
        if (dataTreeInterface2 instanceof DataTreeClass && (dataTreeInterface = ((DataTreeClass)dataTreeInterface2).getNodeByName(string)) instanceof AbstractDataMatrix) {
            return (AbstractDataMatrix)dataTreeInterface;
        }
        return null;
    }

    @Override
    public AbstractTModel createTableModel() {
        List<AbstractMDAModel> list = this.buildModelList();
        if (!list.isEmpty()) {
            return new AnalysTableModel(list);
        }
        return null;
    }

    public void finishCalculation(ProgressManager progressManager) {
    }

    @Override
    public Object[] getChildren(boolean bl) {
        ArrayList<AbstractMDAModel> arrayList = new ArrayList<AbstractMDAModel>();
        for (int i = 0; i < this.getTreeNodeCount(); ++i) {
            if (!(this.getTreeNodeAt(i) instanceof AbstractMDAModel)) continue;
            arrayList.add((AbstractMDAModel)this.getTreeNodeAt(i));
        }
        return arrayList.toArray();
    }

    @Override
    public String getClassName() {
        return this.className;
    }

    @Override
    public String[] getComponentNamesLocal() {
        return null;
    }

    @Override
    public ImageIcon getIcon(byte by) {
        return null;
    }

    @Override
    public String getInformation() {
        StringBuilder stringBuilder = new StringBuilder(420);
        stringBuilder.append("<HTML><BODY>");
        stringBuilder.append("<table border=\"0\" cellpadding=\"0\" cellspacing=\"0\" >");
        stringBuilder.append("<TR><TD>Model:</TD><TD>").append(this.getModelName()).append("</TD></TR>");
        if (this.getCase() != null) {
            stringBuilder.append("<tr><td></td><td>").append(this.getCase()).append("</td></tr>");
        }
        stringBuilder.append("<TR><TD>DataSet:</TD><TD>").append(this.getTreeParent() != null ? this.getTreeParent() : "N/A").append("</TD></TR>");
        stringBuilder.append("</TABLE></BODY></HTML>");
        return stringBuilder.toString();
    }

    public InnerColumnClass getInnerColumnClass() {
        return this.getClassByName(this.className);
    }

    public AbstractModel getModelAt(int n) {
        int n2 = 0;
        for (int i = 0; i < this.getTreeNodeCount(); ++i) {
            if (!(this.getTreeNodeAt(i) instanceof AbstractModel) || n != n2++) continue;
            return (AbstractModel)this.getTreeNodeAt(i);
        }
        return null;
    }

    public int getModelCount() {
        int n = 0;
        for (int i = 0; i < this.getTreeNodeCount(); ++i) {
            if (!(this.getTreeNodeAt(i) instanceof AbstractModel)) continue;
            ++n;
        }
        return n;
    }

    @Override
    public String getModelName() {
        return "Model Container";
    }

    public ModelContainerSummary getQ2Y_CUM_Summary() {
        return this.q2Y_CUM_Summary;
    }

    public ModelContainerSummary getSSX_CUM_Summary() {
        return this.sSX_CUM_Summary;
    }

    @Override
    public AbstractModel getSubModel(Double d) {
        return this.getModelAt(d.intValue() - 1);
    }

    @Override
    public AbstractModel getSubModel(String string) {
        for (int i = 0; i < this.getTreeNodeCount(); ++i) {
            DataTreeInterface dataTreeInterface = this.getTreeNodeAt(i);
            if (!(dataTreeInterface instanceof AbstractModel) || !dataTreeInterface.toString().equalsIgnoreCase(string)) continue;
            return (AbstractModel)dataTreeInterface;
        }
        return null;
    }

    @Override
    public byte getTreeType() {
        return 8;
    }

    @Override
    public Object getValueAt(int n) {
        if (n == 0) {
            return this;
        }
        return "";
    }

    public int[] getXindxByClass(AbstractDataMatrix abstractDataMatrix, InnerColumnClass innerColumnClass, int n) {
        int[] nArray = new int[abstractDataMatrix.getN() + 1];
        int n2 = 0;
        int[] nArray2 = abstractDataMatrix.getNref();
        int n3 = abstractDataMatrix.getN();
        for (int i = 0; i < n3; ++i) {
            if (innerColumnClass.getValueShort(nArray2[i]) == n) {
                nArray[i] = n2;
                continue;
            }
            nArray[i] = -1;
            ++n2;
        }
        nArray[nArray.length - 1] = n2;
        return nArray;
    }

    @Override
    public MVmatrix getXMatrix() {
        return null;
    }

    @Override
    public int getYindex() {
        return this.Yindex;
    }

    @Override
    public MVmatrix getYMatrix() {
        return null;
    }

    @Override
    public boolean isModelContainer() {
        return true;
    }

    @Override
    public boolean isNode() {
        return true;
    }

    @Override
    public boolean isReduced() {
        AbstractMDAModel abstractMDAModel = this.getReferenceModel(true);
        if (abstractMDAModel != null) {
            return abstractMDAModel.isReduced();
        }
        return false;
    }

    @Override
    public boolean isUnfolded() {
        for (int i = 0; i < this.getTreeNodeCount(); ++i) {
            DataTreeInterface dataTreeInterface = this.getTreeNodeAt(i);
            if (!(dataTreeInterface instanceof AbstractMDAModel)) continue;
            AbstractMDAModel abstractMDAModel = (AbstractMDAModel)dataTreeInterface;
            return abstractMDAModel.isUnfolded();
        }
        return false;
    }

    @Override
    public Object[] list(String string) {
        if (string.equalsIgnoreCase("model")) {
            List<AbstractMDAModel> list = this.buildModelList();
            return list.toArray();
        }
        return super.list(string);
    }

    @Override
    public void modelChanged(AbstractModel abstractModel) {
        this.sSX_CUM_Summary.triggerEvent(new DataMatrixEvent((Object)this, this.sSX_CUM_Summary));
        this.q2Y_CUM_Summary.triggerEvent(new DataMatrixEvent((Object)this, this.q2Y_CUM_Summary));
    }

    @Override
    public void removeModelListener(ModelListener modelListener) {
        super.removeModelListener(modelListener);
        for (int i = 0; i < this.getTreeNodeCount(); ++i) {
            if (!(this.getTreeNodeAt(i) instanceof AbstractMDAModel)) continue;
            ((AbstractMDAModel)this.getTreeNodeAt(i)).removeModelListener(modelListener);
        }
    }

    @Override
    public boolean supportPrediction() {
        return false;
    }

    @Override
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder().append(super.toString());
        if (this.isSingleY) {
            stringBuilder.append(" (Single Y").append((String)(this.className != null ? ", " + this.className : "")).append(")");
        } else if (this.Yindex < 0) {
            stringBuilder.append(" (").append(this.className != null ? this.className : "No class").append(")");
        }
        return stringBuilder.toString();
    }

    protected AbstractMDAModel createDefaultModel(ProgressManager progressManager, AbstractMDAModel abstractMDAModel, int[] nArray, int n) throws Exception {
        AbstractMDAModel abstractMDAModel2 = null;
        if (abstractMDAModel != null) {
            abstractMDAModel2 = abstractMDAModel.createModel(progressManager, this.dataSet, nArray, n >= 0 ? ModelHelper.createYindx(this.dataSet, n) : null, abstractMDAModel.calcPred);
        } else {
            abstractMDAModel2 = this.isSingleY ? new PLSModel(progressManager, this.dataSet, this.Xindx, n >= 0 ? ModelHelper.createYindx(this.dataSet, n) : null, this.calcPred) : new PCAModel(progressManager, this.dataSet, this.Xindx, this.calcPred, true);
            abstractMDAModel = abstractMDAModel2;
        }
        if (abstractMDAModel instanceof CrossvalidationModel) {
            CrossvalidationModel crossvalidationModel = (CrossvalidationModel)abstractMDAModel;
            CrossvalidationModel crossvalidationModel2 = (CrossvalidationModel)abstractMDAModel2;
            crossvalidationModel2.nr_groups = crossvalidationModel.nr_groups;
            crossvalidationModel2.calc_ci = crossvalidationModel.calc_ci;
            crossvalidationModel2.setType(crossvalidationModel.isTypeFull());
            if (crossvalidationModel.indxVector != null) {
                crossvalidationModel2.indxVector = (Vector)crossvalidationModel.indxVector.clone();
            }
        }
        return abstractMDAModel2;
    }

    @Override
    protected AbstractMDAModel createModel(ProgressManager progressManager, DataSet dataSet, int[] nArray, int[] nArray2, boolean bl) throws Exception {
        return null;
    }

    @Override
    protected synchronized void doUpdateLocal(ProgressManager progressManager) {
        DataTreeClass dataTreeClass;
        Object object;
        if (this.dataSet == null) {
            return;
        }
        HashMap<Object, DataTreeClass> hashMap = new HashMap<Object, DataTreeClass>();
        for (int i = 0; i < this.getTreeNodeCount(); ++i) {
            object = this.getTreeNodeAt(i);
            if (!(object instanceof AbstractMDAModel) || ((AbstractModel)(dataTreeClass = (AbstractMDAModel)object)).isExternal()) continue;
            Object object2 = object = this.isSingleY ? Integer.valueOf(((AbstractMDAModel)dataTreeClass).getRealYindex()) : dataTreeClass.toString();
            if (hashMap.containsKey(object)) {
                hashMap.put("$$Dummy_Key" + i, dataTreeClass);
                dataTreeClass.setVisibleInTree(false);
                continue;
            }
            hashMap.put(object, dataTreeClass);
        }
        if (this.isSingleY) {
            this.dataSet.excludeNonVarying(progressManager, true);
            AbstractDataMatrix abstractDataMatrix = this.dataSet.getMatrix(2);
            for (int i = 0; i < abstractDataMatrix.getK(); ++i) {
                object = abstractDataMatrix.getKref();
                var6_11 = i;
                if (object != null && i < ((Object)object).length) {
                    var6_11 = object[i];
                }
                var7_12 = (AbstractMDAModel)hashMap.get(var6_11);
                var8_13 = abstractDataMatrix.getColumnDescription(i, 0);
                if (var7_12 != null && var8_13.equals(((DataTreeClass)var7_12).toString())) {
                    ((AbstractMDAModel)var7_12).setYindx(ModelHelper.createYindx(this.dataSet, i));
                    ((AbstractMDAModel)var7_12).doUpdateLocal(progressManager);
                    hashMap.remove(var6_11);
                } else {
                    var7_12 = this.createModel(progressManager, null, i);
                }
                if (var7_12 == null) continue;
                ((DataTreeClass)var7_12).setName(var8_13);
                this.triggerPropertyEvent(new DataTreeEvent((Object)this, (DataTreeInterface)var7_12, var8_13));
                ((DataTreeClass)var7_12).setVisibleInTree(true);
            }
        } else if (this.className != null) {
            InnerColumnClass innerColumnClass = this.getInnerColumnClass();
            dataTreeClass = this.dataSet.getMatrix(0);
            object = innerColumnClass.getObject();
            for (var6_11 = 1; var6_11 < ((ArrayList)object).size(); ++var6_11) {
                if (this.subClassList != null && !this.subClassList.contains(((ClassTypes)object).getTypeDescription((int)var6_11)) || (var7_12 = (Object)this.getXindxByClass((AbstractDataMatrix)dataTreeClass, innerColumnClass, (int)var6_11))[((Object)var7_12).length - 1] >= ((Object)var7_12).length - 1) continue;
                var8_13 = ((ClassTypes)object).getTypeDescription((int)var6_11);
                AbstractMDAModel abstractMDAModel = (AbstractMDAModel)hashMap.get(var8_13);
                if (abstractMDAModel != null) {
                    abstractMDAModel.setXindx((int[])var7_12);
                    if (this.Yindex >= 0) {
                        abstractMDAModel.setYindx(ModelHelper.createYindx(this.dataSet, this.Yindex));
                    }
                    abstractMDAModel.doUpdateLocal(progressManager);
                    hashMap.remove(var8_13);
                } else {
                    abstractMDAModel = this.createModel(progressManager, (int[])var7_12, this.Yindex);
                }
                if (abstractMDAModel == null) continue;
                abstractMDAModel.setName(var8_13);
                this.triggerPropertyEvent(new DataTreeEvent((Object)this, (DataTreeInterface)abstractMDAModel, this.name));
                abstractMDAModel.setVisibleInTree(true);
            }
        }
        for (Map.Entry entry : hashMap.entrySet()) {
            object = (AbstractMDAModel)entry.getValue();
            ((CleanUpVector)object).cleanUp();
            this.removeTreeNode((DataTreeInterface)object);
        }
        this.finishCalculation(progressManager);
        this.modelChanged(this);
        this.purgeSignal();
    }

    @Override
    protected void removeComponentLocal(int n) throws Exception {
        for (int i = 0; i < this.getTreeNodeCount(); ++i) {
            AbstractMDAModel abstractMDAModel;
            DataTreeInterface dataTreeInterface = this.getTreeNodeAt(i);
            if (!(dataTreeInterface instanceof AbstractMDAModel) || (abstractMDAModel = (AbstractMDAModel)dataTreeInterface).isExternal()) continue;
            abstractMDAModel.removeComponentLocal(n);
        }
    }

    @Override
    protected void SaveModel(RandomOutputStream randomOutputStream) throws IOException {
        randomOutputStream.writePropertyBoolean("singeY", this.isSingleY);
        randomOutputStream.writePropertyStringUTF("className", this.className);
        randomOutputStream.writePropertyInt("Yindex", this.Yindex);
        randomOutputStream.writePropertyNode("sCS", this.sSX_CUM_Summary);
        randomOutputStream.writePropertyNode("qCS", this.q2Y_CUM_Summary);
    }

    @Override
    protected boolean supportInterface(DataTreeInterface dataTreeInterface, AbstractModel.SaveType saveType) {
        if (!saveType.isComplete()) {
            if (dataTreeInterface instanceof AbstractMDAModel) {
                return true;
            }
            for (int i = 0; i < this.getTreeNodeCount(); ++i) {
                if (!(this.getTreeNodeAt(i) instanceof AbstractMDAModel) || !((AbstractMDAModel)this.getTreeNodeAt(i)).supportInterface(dataTreeInterface, saveType)) continue;
                return true;
            }
        }
        return super.supportInterface(dataTreeInterface, saveType);
    }

    private AbstractMDAModel createModel(ProgressManager progressManager, int[] nArray, int n) {
        try {
            if (!this.isSingleY || this.className == null) {
                AbstractMDAModel abstractMDAModel = this.createDefaultModel(progressManager, this.getReferenceModel(true), nArray, n);
                abstractMDAModel.beginCalculations();
                abstractMDAModel.calcModel(progressManager, 3);
                abstractMDAModel.endCalculations();
                this.addTreeNode(abstractMDAModel);
                return abstractMDAModel;
            }
            AbstractDataMatrix abstractDataMatrix = this.dataSet.getMatrix(2);
            ModelContainer modelContainer = new ModelContainer(this.dataSet, abstractDataMatrix.getColumnDescription(n, 0), this.className, n);
            this.addTreeNode(modelContainer);
            modelContainer.doUpdateLocal(progressManager);
        }
        catch (Exception exception) {
            ErrorHandler.logAndReportException(exception);
        }
        return null;
    }

    private void createSummary() {
        DataContainer dataContainer = new DataContainer("Explained variances", -1);
        this.addTreeNode(dataContainer);
        this.sSX_CUM_Summary = new ModelContainerSummary(this, 0);
        dataContainer.addTreeNode(this.sSX_CUM_Summary);
        this.q2Y_CUM_Summary = new ModelContainerSummary(this, 1);
        dataContainer.addTreeNode(this.q2Y_CUM_Summary);
    }

    private AbstractMDAModel getReferenceModel(boolean bl) {
        DataTreeInterface dataTreeInterface;
        for (int i = 0; i < this.getTreeNodeCount(); ++i) {
            if (!(this.getTreeNodeAt(i) instanceof AbstractMDAModel)) continue;
            return (AbstractMDAModel)this.getTreeNodeAt(i);
        }
        if (bl && (dataTreeInterface = this.getTreeParent()) instanceof ModelContainer) {
            ModelContainer modelContainer = (ModelContainer)dataTreeInterface;
            for (int i = 0; i < modelContainer.getTreeNodeCount(); ++i) {
                if (!(modelContainer.getTreeNodeAt(i) instanceof ModelContainer)) continue;
                return ((ModelContainer)modelContainer.getTreeNodeAt(i)).getReferenceModel(false);
            }
        }
        return null;
    }

    private void hideModels() {
        List<AbstractMDAModel> list = this.buildModelList();
        for (AbstractMDAModel abstractMDAModel : list) {
            abstractMDAModel.setVisibleInTree(false);
        }
    }
}

