/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.mda.model;

import java.io.IOException;
import se.prediktera.map.common.MapProperty;
import se.prediktera.map.common.RandomInputStream;
import se.prediktera.map.common.RandomOutputStream;
import se.prediktera.map.data.SimpleTableModel;
import se.prediktera.map.datasetcontainer.datainfo.AbstractDataInfo;
import se.prediktera.map.datasetcontainer.datainfo.Description;
import se.prediktera.map.datasetcontainer.datainfo.InnerColumnString;
import se.prediktera.map.datasetcontainer.matrix.AbstractDataMatrix;
import se.prediktera.map.datasetcontainer.matrix.ModelMatrix;
import se.prediktera.map.main.extclass.DataTreeExtLibInterface;
import se.prediktera.map.main.extclass.ExtClassLoader;
import se.prediktera.map.model.AbstractModel;
import se.prediktera.mda.model.AbstractCVResults;
import se.prediktera.mda.model.ModelContainer;

public class ModelContainerSummary
extends AbstractDataMatrix
implements DataTreeExtLibInterface {
    public static final int SSX_CUM = 0;
    public static final int Q2Y_CUM = 1;
    private final ModelContainer modelContainer;
    private final int summaryType;
    private String SSXY_CUM_name = "N/A";
    private String Q2Y_CUM_name = "N/A";

    public ModelContainerSummary(ModelContainer modelContainer, int n) {
        super("ModelContainerSummary");
        this.modelContainer = modelContainer;
        this.summaryType = n;
        this.setRowType(4);
        this.setColumnType(4);
    }

    public ModelContainerSummary(RandomInputStream randomInputStream, MapProperty mapProperty) throws IOException {
        super(randomInputStream, mapProperty);
        this.modelContainer = (ModelContainer)mapProperty.resolveNodeFromName(randomInputStream, "MC");
        this.summaryType = mapProperty.getPropertyInt("sT");
        this.SSXY_CUM_name = mapProperty.getPropertyStringUTF("SSXY_CUM_name", "N/A");
        this.Q2Y_CUM_name = mapProperty.getPropertyStringUTF("Q2Y_CUM_name", "N/A");
    }

    @Override
    public Object clone() {
        return new ModelContainerSummary(this.modelContainer, this.summaryType);
    }

    @Override
    public SimpleTableModel createTableModel(boolean bl) {
        return new SimpleTableModel(this, this.getN(), this.getK(), false){

            @Override
            protected int getColumnDescriptionCountInternal() {
                return 1;
            }

            @Override
            protected int getRowDescriptionCountInternal() {
                return 1;
            }
        };
    }

    @Override
    public String getColumnDescription(int n, int n2) {
        return this.toString();
    }

    @Override
    public int getColumnType() {
        return 4;
    }

    @Override
    public AbstractDataInfo getDataInfo(int n) {
        ModelMatrix modelMatrix;
        if (this.modelContainer.getModelCount() > 0 && (modelMatrix = this.getModelMatrix(0)) != null) {
            return modelMatrix.getDataInfo(n);
        }
        return null;
    }

    @Override
    public ExtClassLoader.LicenseLibrary getLibrary() {
        return ExtClassLoader.LicenseLibrary.MDA;
    }

    @Override
    public int getK() {
        return 1;
    }

    @Override
    public int getN() {
        return this.modelContainer.getModelCount();
    }

    @Override
    public byte getNodeType() {
        return 5;
    }

    @Override
    public Description getRowDescription() {
        this.rowDescription = new Description(this.getN());
        InnerColumnString innerColumnString = this.rowDescription.addStringColumn(this.toString());
        for (int i = 0; i < this.getN(); ++i) {
            innerColumnString.setValueLocal(i, this.getRowDescription(i, 0));
        }
        return this.rowDescription;
    }

    @Override
    public String getRowDescription(int n, int n2) {
        AbstractModel abstractModel = this.modelContainer.getModelAt(n);
        if (abstractModel != null) {
            ModelMatrix modelMatrix = this.getModelMatrix(n);
            return modelMatrix.getRowDescription(modelMatrix.getN() - 1, n2) + " (" + String.valueOf(abstractModel) + ")";
        }
        return "N/A";
    }

    @Override
    public int getRowType() {
        return 8;
    }

    @Override
    public byte getTreeType() {
        return 14;
    }

    @Override
    public double getValue(int n, int n2) {
        ModelMatrix modelMatrix = this.getModelMatrix(n);
        if (modelMatrix != null) {
            return modelMatrix.getValue(modelMatrix.getN() - 1, n2);
        }
        return 0.0;
    }

    public boolean hasValidData() {
        for (int i = 0; i < this.getN(); ++i) {
            if (this.getValue(i, 0) == 0.0) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isModel() {
        return true;
    }

    @Override
    public void SavePropertyLocal(RandomOutputStream randomOutputStream) throws IOException {
        super.SavePropertyLocal(randomOutputStream);
        randomOutputStream.writePropertyNode("MC", this.modelContainer);
        randomOutputStream.writePropertyInt("sT", this.summaryType);
        randomOutputStream.writePropertyStringUTF("SSXY_CUM_name", this.SSXY_CUM_name);
        randomOutputStream.writePropertyStringUTF("Q2Y_CUM_name", this.Q2Y_CUM_name);
    }

    @Override
    public void setKInfo(int n, int n2, String string) {
    }

    @Override
    public void setNInfo(int n, int n2, String string) {
    }

    @Override
    public void setValue(int n, int n2, double d) {
    }

    @Override
    public void setValue(int n, int n2, double d, boolean bl) {
    }

    @Override
    public String toString() {
        if (this.SSXY_CUM_name.equals("N/A") && this.Q2Y_CUM_name.equals("N/A")) {
            this.getModelMatrix(0);
        }
        return switch (this.summaryType) {
            case 0 -> this.SSXY_CUM_name + " (Summary)";
            case 1 -> this.Q2Y_CUM_name + " (Summary)";
            default -> "N/A";
        };
    }

    @Override
    protected void ClearChild() throws IOException {
    }

    @Override
    protected void LoadChild(RandomInputStream randomInputStream) throws IOException {
    }

    @Override
    protected void SaveChild(RandomOutputStream randomOutputStream) throws IOException {
    }

    private ModelMatrix getModelMatrix(int n) {
        AbstractModel abstractModel = this.modelContainer.getModelAt(n);
        if (abstractModel != null && abstractModel.getResults() != null) {
            AbstractCVResults abstractCVResults = (AbstractCVResults)abstractModel.getResults();
            switch (this.summaryType) {
                case 0: {
                    ModelMatrix modelMatrix = abstractCVResults.getSSXY_CUM();
                    if (modelMatrix != null) {
                        this.SSXY_CUM_name = modelMatrix.toString();
                    }
                    return modelMatrix;
                }
                case 1: {
                    ModelMatrix modelMatrix = abstractCVResults.getQ2Y_CUM();
                    if (modelMatrix != null) {
                        this.Q2Y_CUM_name = modelMatrix.toString();
                    }
                    return modelMatrix;
                }
            }
        }
        return null;
    }
}

