/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.mda.model.PCA;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import javax.swing.JPopupMenu;
import no.uib.cipr.matrix.AbstractMatrix;
import no.uib.cipr.matrix.DenseMatrix;
import no.uib.cipr.matrix.DenseVector;
import no.uib.cipr.matrix.Matrix;
import no.uib.cipr.matrix.Vector;
import se.prediktera.map.common.MapProperty;
import se.prediktera.map.common.NiceDataFormat;
import se.prediktera.map.common.RandomInputStream;
import se.prediktera.map.common.RandomOutputStream;
import se.prediktera.map.common.cleanup.CleanUpInterface;
import se.prediktera.map.common.error.ErrorHandler;
import se.prediktera.map.common.jama.MatrixExtensions;
import se.prediktera.map.common.progress.ProgressManager;
import se.prediktera.map.data.modeltable.AbstractTModel;
import se.prediktera.map.datasetcontainer.Case;
import se.prediktera.map.datasetcontainer.DataContainer;
import se.prediktera.map.datasetcontainer.DataTreeInterface;
import se.prediktera.map.datasetcontainer.dataset.DataSet;
import se.prediktera.map.datasetcontainer.matrix.AbstractDataMatrix;
import se.prediktera.map.datasetcontainer.matrix.AbstractMVmatrix;
import se.prediktera.map.datasetcontainer.matrix.MVmatrix;
import se.prediktera.map.datasetcontainer.matrix.ModelMatrix;
import se.prediktera.map.main.IniManager;
import se.prediktera.map.main.Main_GUI;
import se.prediktera.map.main.Project_GUI;
import se.prediktera.map.main.StatusBar;
import se.prediktera.map.model.AbstractModel;
import se.prediktera.map.model.AbstractPrediction;
import se.prediktera.mda.model.AbstractCVResults;
import se.prediktera.mda.model.AbstractMDAModel;
import se.prediktera.mda.model.AnalysPredictionNode;
import se.prediktera.mda.model.AnalysTableModel;
import se.prediktera.mda.model.CrossvalidationModel;
import se.prediktera.mda.model.ModelException;
import se.prediktera.mda.model.PCA.PCApredictionNode;
import se.prediktera.mda.model.SIMCA.SIMCAModel;

public class PCAModel
extends CrossvalidationModel {
    public static final int T = 0;
    public static final int P = 1;
    public static final int DMODX = 2;
    public static final int R2X_VAR = 3;
    public static final int R2X_VAR_CUM = 4;
    public static final int R2X = 5;
    public static final int R2X_CUM = 6;
    public static final int EIG = 7;
    public static final int NIT = 8;
    public static final int Q2X_VAR = 9;
    public static final int Q2X_VAR_CUM = 10;
    public static final int Q2X = 11;
    public static final int Q2X_CUM = 12;
    public static final int S0 = 13;
    public static final int HOTELLINGT2 = 14;
    public static final int TPRED = 0;
    public static final int DMODXPRED = 1;
    public static final int HOTELLINGT2PRED = 2;
    private static final String[] resultNames = new String[]{"T", "P", "ObsDMX", "R2X_var", "R2X_var_cum", "R2X", "R2X_cum", "Eig", "Nit", "Q2X_var", "Q2X_var_cum", "Q2X", "Q2X_cum", "S0", "Hotelling T2"};
    private static final String[] htmlResultNames = new String[]{"<html><b>T</b></html>", "<html><b>P</b></html>", "<html>ObsDM<b>X</b></html>", "<html>SS<b>X</b>_var</html>", "<html>SS<b>X</b>_var_cum</html>", "<html>SS<b>X</b></html>", "<html>SS<b>X</b>_cum</html>", "Eig", "Nit", "<html>SS<b>X</b>_CV_var</html>", "<html>SS<b>X</b>_CV_var_cum</html>", "<html>SS<b>X</b>_CV</html>", "<html>SS<b>X</b>_CV_cum</html>", "<html>S<sup>0</sup></html>", "<html>Hotelling T2</html>"};
    private static final String[] post102LoadNames = new String[]{"T", "P", "ObsDMX", "SSX_var", "SSX_var_cum", "SSX", "SSX_cum", "Eig", "Nit", "SSX_CV_var", "SSX_CV_var_cum", "SSX_CV", "SSX_CV_cum", "S0", "Hotelling T2"};
    private static final String[] pre102LoadNames = new String[]{"T", "P", "DmodX", "ssx_var", "ssx_var_cum", "ssx", "ssx_cum", "Eig", "nit", "s0"};
    private static String[] loadResultNames = post102LoadNames;
    private static final String[] resultInfo = new String[]{"Scores in <b>X</b>", "Loadings in <b>X</b>", "Observation Distance to Model in <b>X</b>", "Explained variance by model for <b>X</b> variables", "Cumulative explained variance by model for <b>X</b> variables", "Explained variance by model for <b>X</b>", "Cumulative explained variance by model for <b>X</b>", "Eigenvalues", "Number of iterations", "Explained cross-validated variance by model for variables in <b>X</b>", "Cumulative explained cross-validated variance by model for variables in <b>X</b>", "Explained cross-validated variance by model for <b>X</b>", "Cumulative explained cross-validated variance by model for <b>X</b>", "S<sub>0</sub> constant for Distance to Model in <b>X</b>", "Hotelling T2"};
    private double ssx_orig;
    private MVmatrix ssx_var_orig = null;

    public static boolean calcModel(DenseMatrix denseMatrix) {
        int n = denseMatrix.numColumns();
        DenseMatrix denseMatrix2 = new DenseMatrix(n, n);
        Matrix matrix = denseMatrix.transpose();
        matrix.mult((Matrix)denseMatrix, (Matrix)denseMatrix2);
        return false;
    }

    public static String[] getComponentNames() {
        return new String[]{"Model", "DataSet", "A", "R2X", "R2X_cum", "Q2X", "Q2X_cum", "Eig", "N", "K", "Pre-processing"};
    }

    public static void main(String[] stringArray) {
        double[][] dArray = new double[256][200000];
        for (int i = 0; i < 256; ++i) {
            for (int j = 0; j < 200000; ++j) {
                dArray[i][j] = Math.random();
            }
        }
        PCAModel.calcModel(new DenseMatrix(dArray));
    }

    private static void initMatrixWithMissing(int[] nArray, AbstractMVmatrix abstractMVmatrix, AbstractDataMatrix abstractDataMatrix, boolean bl) {
        boolean[][] blArray = abstractMVmatrix.getMissingMatrix();
        AbstractMatrix abstractMatrix = abstractMVmatrix.getMatrix();
        int n = abstractDataMatrix.getK();
        int n2 = abstractDataMatrix.getN();
        for (int n3 : nArray) {
            if (n3 < 0) continue;
            for (int i = 0; i < n; ++i) {
                int n4 = (n3 + i) % n2;
                if (bl) {
                    if (blArray != null && blArray[n4][i]) continue;
                    abstractMatrix.set(n4, i, 0.0);
                    abstractMVmatrix.addMissing(n4, i);
                    continue;
                }
                if (abstractDataMatrix.isMissing(n4, i)) continue;
                abstractMatrix.set(n4, i, abstractDataMatrix.getValue(n4, i));
                abstractMVmatrix.removeMissing(n4, i);
            }
        }
    }

    public PCAModel(DataSet dataSet, MVmatrix mVmatrix) throws Exception {
        super(dataSet, null, null, false);
        this.X = mVmatrix;
        this.res = new PCAresults(this, mVmatrix);
        this.mr = this.res.getMR();
        this.ssx_var_orig = mVmatrix.SumSQ(this.ssx_var_orig);
        this.ssx_orig = this.ssx_var_orig.SumScalar();
        this.minNK = mVmatrix.getK() < mVmatrix.getN() ? mVmatrix.getK() : mVmatrix.getN();
        this.transformedContainer.addTreeNode(this.createTransformed((byte)0));
        this.transformedContainer.addTreeNode(this.createTransformed((byte)1));
    }

    public PCAModel(ProgressManager progressManager, DataSet dataSet, int[] nArray, boolean bl, boolean bl2) {
        super(dataSet, nArray, null, bl);
        if (!this.resetModel(progressManager, bl2)) {
            throw new ModelException.ModelNoDataException("X and Y matrix dimensions cannot be zero");
        }
        this.addTreeNode(this.X);
        this.res = new PCAresults(this, this.X);
        this.mr = this.res.getMR();
        this.ssx_var_orig.setName("R2X_var_Orig");
        this.ssx_var_orig.setHtmlName("<html>R2<b>X</b>_var_Orig</html>");
        this.ssx_var_orig.setMatrixInfo("Original variance of <b>X</b> variables");
        if (bl) {
            this.addTreeNode(this.createPredictionLocal(progressManager, dataSet, null));
        }
        this.transformedContainer.addTreeNode(this.createTransformed((byte)0));
        this.transformedContainer.addTreeNode(this.createTransformed((byte)1));
    }

    public PCAModel(RandomInputStream randomInputStream, MapProperty mapProperty) throws IOException {
        super(randomInputStream, mapProperty);
        if (randomInputStream.getSaveVersion() < 102L) {
            loadResultNames = pre102LoadNames;
        }
        this.X = (AbstractMVmatrix)mapProperty.resolveNodeFromName(randomInputStream, "X");
        this.ssx_var_orig = (MVmatrix)mapProperty.resolveNodeFromName(randomInputStream, "ssx_var_orig");
        if (mapProperty.hasProperty("ssx_orig")) {
            this.ssx_orig = mapProperty.getLVDouble();
        }
        this.res = new PCAresults(randomInputStream, mapProperty);
        this.mr = this.res.getMR();
    }

    @Override
    public void addToPopupMenu(Project_GUI project_GUI, JPopupMenu jPopupMenu) {
        super.addToPopupMenu(project_GUI, jPopupMenu);
        jPopupMenu.addSeparator();
        this.addCommonToMenu(project_GUI, jPopupMenu);
    }

    @Override
    public boolean calcModel(ProgressManager progressManager, int n) {
        try {
            boolean bl = false;
            if (n < 0) {
                bl = true;
                n = this.indxVector == null ? 3 : 50;
            }
            n = Math.min(n, this.getMaxComponentCount());
            int n2 = this.getResults().getRound();
            progressManager.setAbortable(true);
            for (int i = 0; i < n && !progressManager.isAborted(); ++i) {
                CleanUpInterface cleanUpInterface;
                int n3 = this.res.getRound() + 1;
                if (bl) {
                    progressManager.setInfoText("Calculating component " + n3 + " with auto fit");
                } else if (n3 > n) {
                    progressManager.setInfoText("Calculating component " + n3);
                } else {
                    progressManager.setInfoText("Calculating component " + n3 + "/" + (n + n2));
                }
                this.calculateOneComponent(progressManager, this.X, null, (PCAresults)this.res);
                boolean bl2 = false;
                if (this.indxVector != null) {
                    cleanUpInterface = (PCAresults)this.res;
                    progressManager.setInfoText("Cross-validating component " + n3);
                    this.crossValidate(progressManager, this.indxVector);
                    if (bl && i > 1) {
                        boolean bl3 = bl2 = ((PCAresults)cleanUpInterface).getQ2X().getLastScalar() < 0.0 || this.mr[7].getLastScalar() < 0.5;
                    }
                }
                if (bl2 || progressManager.isAborted()) {
                    this.res.undoRow();
                    break;
                }
                MatrixExtensions.minusEqualsTimesTransposeOf(this.X, this.mr[0].getLastRM(), this.mr[1].getLastRM());
                if (this.calcDmodX) {
                    this.addDModXYandDcrit(this.mr[2], this.X, this.res.getRound() + 1);
                }
                if ((cleanUpInterface = this.getMatrix(13)) != null) {
                    ((ModelMatrix)cleanUpInterface).addRow(this.getCalculatedS0());
                }
                MVmatrix mVmatrix = this.X.SumSQ();
                DenseVector denseVector = this.mr[4].getLastRM();
                double d = this.mr[6].getLastScalar();
                this.mr[4].addRow(new DenseVector(MatrixExtensions.arrayRightDivide(this.ssx_var_orig.minus(mVmatrix), this.ssx_var_orig.getDoubleMatrix()).getData(), false));
                mVmatrix.beginCalculations();
                double d2 = mVmatrix.SumScalar();
                mVmatrix.endCalculations();
                double d3 = (this.ssx_orig - d2) / this.ssx_orig;
                this.mr[6].addRow(d3);
                if (this.res.hasRounds()) {
                    this.mr[5].addRow(d3 - d);
                    this.mr[3].addRow((DenseVector)new DenseVector((Vector)this.mr[4].getLastRM()).add(-1.0, (Vector)denseVector));
                } else {
                    this.mr[5].addRow(d3);
                    this.mr[3].addRow(this.mr[4].getLastRM().copy());
                }
                this.mr[7].addRow(this.mr[5].getLastScalar() * (double)this.minNK);
                this.res.IncRound();
                if (this.calcPred) {
                    this.calcPrediction(progressManager, true, false);
                }
                this.addHotellingT2(this.getMatrix(14), this.getMatrix(0), this.getMatrix(5));
            }
            this.finishPrediction(progressManager);
            this.updateOutput();
            return true;
        }
        catch (Exception exception) {
            ErrorHandler.logAndShowEvinceErrorDialogForException(exception);
            return false;
        }
    }

    @Override
    public AbstractPrediction createPredictionLocal(ProgressManager progressManager, DataSet dataSet, Properties properties) {
        return new PCApredictionNode(progressManager, this, dataSet, properties, true);
    }

    @Override
    public AbstractTModel createTableModel() {
        return new AnalysTableModel(this);
    }

    @Override
    public String[] getComponentNamesLocal() {
        return PCAModel.getComponentNames();
    }

    @Override
    public String getInformation() {
        StringBuilder stringBuilder = new StringBuilder(420);
        stringBuilder.append("<HTML><BODY>");
        stringBuilder.append("<table border=\"0\" cellpadding=\"0\" cellspacing=\"0\" >");
        stringBuilder.append("<TR><TD>Model:</TD><TD>").append(this.getModelName()).append("</TD></TR>");
        if (this.getCase() != null) {
            stringBuilder.append("<tr><td></td><td>").append(this.getCase()).append("</td></tr>");
        }
        stringBuilder.append("<TR><TD>DataSet:</TD><TD>").append(this.dataSet != null ? this.dataSet : "N/A").append("</TD></TR>");
        if (this.X != null) {
            stringBuilder.append("<TR><TD>Pre-proc.:</TD><TD>").append(this.X.getTransformationInfo()).append("</TD></TR>");
            stringBuilder.append("<TR><TD>N:</TD><TD>").append(this.X.getN()).append("</TD></TR>");
            stringBuilder.append("<TR><TD>K:</TD><TD>").append(this.X.getK()).append("</TD></TR>");
            stringBuilder.append("<TR><TD>Comp:</TD><TD>").append(this.res.getRound()).append("</TD></TR>");
            stringBuilder.append("<TR><TD>R2X_cum:</TD><TD>").append(NiceDataFormat.toString(this.mr[6].getLastScalar())).append("</TD></TR>");
            stringBuilder.append("<TR><TD>Eig:</TD><TD>").append(NiceDataFormat.toString(this.mr[7].getLastScalar())).append("</TD></TR>");
        }
        this.addCrossvalidationInfo(stringBuilder);
        if (this.isUseDcrit()) {
            stringBuilder.append("<TR></TR><TR><TD>Dcrit:</TD><TD>").append(NiceDataFormat.toString(this.getDcritX())).append("</TD></TR>");
        }
        stringBuilder.append("</TABLE></BODY></HTML>");
        return stringBuilder.toString();
    }

    public ModelMatrix getLoading() {
        return this.mr[1];
    }

    @Override
    public String getModelName() {
        return "PCA";
    }

    @Override
    public ModelMatrix getScores() {
        return this.mr[0];
    }

    @Override
    public ModelMatrix getR2X() {
        return this.mr[5];
    }

    @Override
    public byte getTreeType() {
        return 0;
    }

    @Override
    public AbstractMVmatrix getXMatrix() {
        return this.X;
    }

    @Override
    public AbstractMVmatrix getYMatrix() {
        return null;
    }

    @Override
    public void SaveModel(RandomOutputStream randomOutputStream) throws IOException {
        super.SaveModel(randomOutputStream);
        randomOutputStream.writePropertyNode("X", this.X);
        randomOutputStream.writePropertyNode("ssx_var_orig", this.ssx_var_orig);
        randomOutputStream.writePropertyDouble("ssx_orig", this.ssx_orig);
        this.res.Save(randomOutputStream);
    }

    @Override
    public void setDcritX(double d) {
        super.setDcritX(d);
        DataTreeInterface dataTreeInterface = this.getTreeParent();
        if (dataTreeInterface instanceof SIMCAModel) {
            SIMCAModel sIMCAModel = (SIMCAModel)dataTreeInterface;
            sIMCAModel.updateSIMCAclassification();
        }
    }

    public void setDcritXsimca(double d) {
        super.setDcritX(d);
    }

    @Override
    public void setProjectChanged() {
        super.setProjectChanged();
    }

    public void updatePCAclassification() {
        List<AnalysPredictionNode> list = this.getAllPredictionNodes();
        for (PCApredictionNode pCApredictionNode : list) {
            pCApredictionNode.createPredictionClasses();
        }
        this.fireUpdatedEvent();
    }

    protected void calculateOneComponent(ProgressManager progressManager, AbstractMVmatrix abstractMVmatrix, DenseVector denseVector, PCAresults pCAresults) throws Exception {
        Object[] objectArray;
        double d;
        DenseVector denseVector2;
        AbstractMatrix abstractMatrix = abstractMVmatrix.getMatrix();
        int n = abstractMVmatrix.getN();
        if (denseVector == null) {
            MVmatrix mVmatrix = this.ssx_var_orig;
            if (this.res.hasRounds()) {
                mVmatrix = abstractMVmatrix.SumSQ();
            }
            denseVector2 = abstractMVmatrix.extractColVector(this.getMaxPos(mVmatrix));
        } else {
            denseVector2 = denseVector;
        }
        double d2 = denseVector2.dot((Vector)denseVector2);
        DenseVector denseVector3 = new DenseVector(denseVector2.size());
        DenseVector denseVector4 = null;
        DenseVector denseVector5 = new DenseVector(abstractMatrix.numColumns());
        int n2 = 0;
        for (double d3 = 42.0; n2 < 200 && d3 > 1.0E-12 && (progressManager == null || !progressManager.isAborted()); d3 /= d, ++n2) {
            denseVector4 = denseVector3;
            denseVector3 = denseVector2;
            denseVector2 = denseVector4;
            MatrixExtensions.transMult(denseVector5, (Matrix)abstractMatrix, denseVector3);
            if (abstractMVmatrix.hasMissing()) {
                PCAModel.nipalsColMv(abstractMVmatrix, denseVector3, d2, denseVector5);
            }
            denseVector5.scale(1.0 / denseVector5.norm(Vector.Norm.Two));
            MatrixExtensions.mult(denseVector2, (Matrix)abstractMatrix, denseVector5);
            if (abstractMVmatrix.hasMissing()) {
                PCAModel.nipalsRowMv(abstractMVmatrix, denseVector5, 1.0, denseVector2);
            }
            d3 = 0.0;
            objectArray = denseVector3.getData();
            double[] dArray = denseVector2.getData();
            d = 0.0;
            double d4 = 0.0;
            for (int i = 0; i < n && !progressManager.isAborted(); ++i) {
                d4 = dArray[i];
                d += d4 * d4;
                d3 += (d4 -= objectArray[i]) * d4;
            }
            d2 = d;
            if (progressManager == null) continue;
            progressManager.incStep((int)this.itmean);
        }
        objectArray = pCAresults.getMR();
        objectArray[0].addRow(denseVector2);
        objectArray[1].addRow(denseVector5);
        objectArray[8].addRow(n2);
        if (progressManager != null && n2 > 0) {
            progressManager.subMaximum(200 - (int)(this.itmean * (double)n2));
            this.itmean = (this.itmean + (double)(200 / n2)) / 2.0;
        }
    }

    @Override
    protected void cleanUpChild() {
        super.cleanUpChild();
        if (this.ssx_var_orig != null) {
            this.ssx_var_orig.cleanUp();
        }
        this.ssx_var_orig = null;
    }

    @Override
    protected AbstractMDAModel createModel(ProgressManager progressManager, DataSet dataSet, int[] nArray, int[] nArray2, boolean bl) throws Exception {
        return new PCAModel(progressManager, dataSet, nArray, bl, true);
    }

    @Override
    protected AbstractCVResults createResults(Case case_, AbstractDataMatrix abstractDataMatrix, AbstractDataMatrix abstractDataMatrix2) throws Exception {
        return new PCAresults(null, abstractDataMatrix);
    }

    protected void crossValidate(ProgressManager progressManager, java.util.Vector<int[]> vector) throws Exception {
        int n;
        PCAresults pCAresults = (PCAresults)this.res;
        int n2 = pCAresults.getRound();
        progressManager.lockForChanges(true);
        DenseVector denseVector = this.X.sumSq();
        double d = denseVector.norm(Vector.Norm.One);
        DenseVector denseVector2 = new DenseVector(this.X.getK());
        int n3 = this.X.getN();
        int n4 = this.X.getK();
        AbstractMVmatrix abstractMVmatrix = this.X.createReferenceMatrix();
        abstractMVmatrix.beginCalculations();
        AbstractMVmatrix abstractMVmatrix2 = (AbstractMVmatrix)this.X.clone();
        abstractMVmatrix2.beginCalculations();
        DenseVector denseVector3 = pCAresults.getT().getLastRM();
        ArrayList<DenseVector[]> arrayList = null;
        if (this.calc_ci) {
            arrayList = new ArrayList<DenseVector[]>();
        }
        int n5 = vector.size();
        for (int i = 0; i < n5; ++i) {
            Object object;
            Object object2;
            int[] nArray = vector.elementAt(i);
            AbstractMVmatrix abstractMVmatrix3 = abstractMVmatrix;
            AbstractMVmatrix abstractMVmatrix4 = abstractMVmatrix2;
            abstractMVmatrix3.setMissing(this.X);
            PCAModel.initMatrixWithMissing(nArray, abstractMVmatrix4, this.X, true);
            boolean[][] blArray = abstractMVmatrix4.getMissingMatrix();
            boolean[][] blArray2 = abstractMVmatrix3.getMissingMatrix();
            for (int j = 0; j < n3; ++j) {
                object2 = blArray == null ? null : blArray[j];
                object = blArray2 == null ? null : blArray2[j];
                for (int k = 0; k < n4; ++k) {
                    if (object2 != null && object2[k] || object != null && object[k]) continue;
                    abstractMVmatrix3.addMissing(j, k);
                }
            }
            PCAresults pCAresults2 = new PCAresults(null, abstractMVmatrix4);
            this.calculateOneComponent(progressManager, abstractMVmatrix4, denseVector3.copy(), pCAresults2);
            object2 = pCAresults2.getP().getLastRM();
            object = pCAresults2.getT().getLastRM();
            if (this.X.hasMissing()) {
                PCAModel.nipalsRowMv(this.X, (DenseVector)object2, (DenseVector)object);
            }
            DenseMatrix denseMatrix = MatrixExtensions.timesTransposeOf((DenseVector)object, (DenseVector)object2);
            if (this.calc_ci && arrayList != null) {
                arrayList.add(new DenseVector[]{(DenseVector)object2});
            }
            pCAresults2.cleanUp();
            pCAresults2 = null;
            MVmatrix mVmatrix = abstractMVmatrix3.minusMV((Matrix)denseMatrix);
            DenseVector denseVector4 = mVmatrix.sumSq();
            mVmatrix.cleanUp();
            denseVector2.add((Vector)denseVector4);
            if (i >= n5 - 1) continue;
            PCAModel.initMatrixWithMissing(nArray, abstractMVmatrix2, this.X, false);
        }
        abstractMVmatrix.endCalculations();
        abstractMVmatrix.cleanUp();
        abstractMVmatrix2.endCalculations();
        abstractMVmatrix2.cleanUp();
        DenseVector denseVector5 = new DenseVector(n4);
        for (n = 0; n < n4; ++n) {
            denseVector5.set(n, 1.0);
        }
        denseVector5.add(-1.0, (Vector)new DenseVector((Vector)MatrixExtensions.arrayRightDivide(denseVector2, denseVector), false));
        pCAresults.getQ2X_VAR().addRow(denseVector5);
        pCAresults.getQ2X().addRow(1.0 - denseVector2.norm(Vector.Norm.One) / d);
        pCAresults.getQ2X_CUM().addRow(this.calc_cv_cum(pCAresults.getQ2X()));
        pCAresults.getQ2X_VAR_CUM().addRow(new DenseVector(denseVector5.size()));
        n = pCAresults.getQ2Y_VAR().getK();
        for (int i = 0; i < n; ++i) {
            pCAresults.getQ2X_VAR_CUM().setValue(n2, i, this.calc_cv_var_cum(denseVector5, i, pCAresults.getQ2X_VAR()));
        }
        if (this.calc_ci && arrayList != null && !arrayList.isEmpty()) {
            this.calcConfidenceInterval(arrayList, new ModelMatrix[]{pCAresults.getP()});
            arrayList.clear();
            arrayList = null;
        }
        progressManager.lockForChanges(false);
    }

    @Override
    protected AbstractMVmatrix getCvMatrix() {
        return this.X;
    }

    @Override
    protected void modelCutoffChanged() {
        super.modelCutoffChanged();
        this.updatePCAclassification();
    }

    @Override
    protected void removeComponentLocal(int n) throws Exception {
        MatrixExtensions.plusEqualsTimesTransposeOf(this.X, this.mr[0].getRM(n), this.mr[1].getRM(n));
    }

    @Override
    protected boolean resetModel(ProgressManager progressManager, boolean bl) {
        AbstractDataMatrix abstractDataMatrix;
        super.resetModel(progressManager, bl);
        if (bl) {
            this.dataSet.excludeNonVarying(progressManager, false);
        }
        if ((abstractDataMatrix = this.dataSet.getMatrix(0)).getK() <= 0) {
            Main_GUI.setStatusMessage(StatusBar.MessageType.WARNING, "Cannot recalculate model \"" + String.valueOf(this) + "\": X matrix dimensions cannot be zero", 10);
            return false;
        }
        this.X = abstractDataMatrix.subMatrix(progressManager, this.X, this.Xindx, null, IniManager.getModelDataType());
        this.X.setName("Xres");
        this.X.setHtmlName("<html><b>X</b><sub>res</sub></html>");
        this.X.setMatrixInfo("Residual <b>X</b> matrix");
        if (progressManager != null) {
            progressManager.setInfoText("Applying transformations");
        }
        this.X.beginCalculations();
        abstractDataMatrix.applyTransformations(this.X, progressManager);
        if (this.res != null) {
            this.res.resetResults(this, this.X, null);
            this.mr = this.res.getMR();
        }
        this.ssx_var_orig = this.X.SumSQ(this.ssx_var_orig);
        this.ssx_var_orig.beginCalculations();
        this.ssx_orig = this.ssx_var_orig.SumScalar();
        this.minNK = this.X.getK() < this.X.getN() ? this.X.getK() : this.X.getN();
        this.ssx_var_orig.endCalculations();
        this.X.endCalculations();
        return true;
    }

    @Override
    protected boolean supportInterface(DataTreeInterface dataTreeInterface, AbstractModel.SaveType saveType) {
        if (saveType.equals((Object)AbstractModel.SaveType.REDUCED) && (dataTreeInterface.equals(this.res.getMR()[0]) || dataTreeInterface.equals(this.res.getMR()[2])) || dataTreeInterface.equals(this.res.getMR()[1])) {
            return true;
        }
        return super.supportInterface(dataTreeInterface, saveType);
    }

    public class PCAresults
    extends AbstractCVResults {
        public PCAresults(AbstractMDAModel abstractMDAModel, AbstractDataMatrix abstractDataMatrix) {
            int n;
            boolean bl;
            super(abstractMDAModel, PCAModel.this.dataSet, loadResultNames.length);
            this.mr[0] = new ModelMatrix(this.obs, abstractDataMatrix);
            this.mr[1] = new ModelMatrix(this.var, abstractDataMatrix);
            boolean bl2 = bl = abstractMDAModel != null;
            if (bl) {
                this.mr[2] = new ModelMatrix(this.obs, abstractDataMatrix);
                this.mr[3] = new ModelMatrix(this.var, abstractDataMatrix);
                this.mr[4] = new ModelMatrix(this.var, abstractDataMatrix);
                this.mr[9] = new ModelMatrix(this.var, abstractDataMatrix);
                this.mr[10] = new ModelMatrix(this.var, abstractDataMatrix);
                this.mr[14] = new ModelMatrix(this.obs, abstractDataMatrix);
            }
            int n2 = n = bl ? 5 : 8;
            while (n <= 8) {
                this.mr[n] = new ModelMatrix(null, (AbstractDataMatrix)null);
                this.mr[n].setColumnType(4);
                this.mr[n].setRowType(8);
                ++n;
            }
            if (bl) {
                this.mr[11] = new ModelMatrix(null, (AbstractDataMatrix)null);
                this.mr[11].setColumnType(4);
                this.mr[11].setRowType(8);
                this.mr[12] = new ModelMatrix(null, (AbstractDataMatrix)null);
                this.mr[12].setColumnType(4);
                this.mr[12].setRowType(8);
                this.mr[13] = new ModelMatrix(null, (AbstractDataMatrix)null);
                this.mr[13].setColumnType(4);
                this.mr[13].setRowType(8);
                this.mr[13].setVisibleInTree(false);
            }
            if (abstractMDAModel != null) {
                this.initVectors();
                DataContainer dataContainer = new DataContainer("Explained variances", -1);
                for (int i = this.mr.length - 1; i >= 0; --i) {
                    if (this.mr[i] == null) continue;
                    this.mr[i].setName(resultNames[i]);
                    this.mr[i].setHtmlName(htmlResultNames[i]);
                    this.mr[i].setMatrixInfo(resultInfo[i]);
                    if (this.mr[i].toString().startsWith("R2") || this.mr[i].toString().startsWith("Q2")) {
                        dataContainer.insertTreeNode(this.mr[i]);
                        continue;
                    }
                    abstractMDAModel.insertTreeNode(this.mr[i]);
                }
                PCAModel.this.ssx_var_orig.setVisibleInTree(false);
                this.sortExplainedVariances(dataContainer);
                dataContainer.addTreeNode(PCAModel.this.ssx_var_orig);
                abstractMDAModel.addTreeNode(dataContainer);
            }
        }

        public PCAresults(RandomInputStream randomInputStream, MapProperty mapProperty) throws IOException {
            super(randomInputStream, mapProperty, loadResultNames);
            this.initVectors();
            for (int i = 0; i < this.mr.length; ++i) {
                if (this.mr[i] == null) continue;
                this.mr[i].setName(resultNames[i]);
                this.mr[i].setHtmlName(htmlResultNames[i]);
            }
        }

        @Override
        public ModelMatrix getC() {
            return this.mr[1];
        }

        @Override
        public Object[] getCompData(int n, boolean bl) {
            Object[] objectArray = new Object[]{this, "", "", "", "", "", "", "", "", "", ""};
            objectArray[0] = this.getCompData(n, 0);
            if (bl) {
                objectArray[1] = this.getCompData(n, 1);
            }
            objectArray[2] = this.getCompData(n, 2);
            objectArray[3] = this.getCompData(n, 3);
            objectArray[4] = this.getCompData(n, 4);
            objectArray[5] = this.getCompData(n, 5);
            objectArray[6] = this.getCompData(n, 6);
            objectArray[7] = this.getCompData(n, 7);
            if (bl) {
                objectArray[8] = this.getCompData(n, 8);
                objectArray[9] = this.getCompData(n, 9);
                objectArray[10] = this.getCompData(n, 10);
            }
            return objectArray;
        }

        @Override
        public Object getCompData(int n, int n2) {
            switch (n2) {
                case 0: {
                    return new AbstractMDAModel.ComponentResult(PCAModel.this, n);
                }
                case 1: {
                    return PCAModel.this.dataSet != null ? PCAModel.this.dataSet.toString() : "N/A";
                }
                case 2: {
                    return String.valueOf(n + 1);
                }
                case 3: 
                case 4: {
                    return this.getCompString(this.mr[5 + n2 - 3], n);
                }
                case 5: 
                case 6: {
                    if (!this.hasRounds() || this.mr.length < 11) break;
                    return this.getCompString(this.mr[11 + n2 - 5], n);
                }
                case 7: {
                    return this.getCompString(this.mr[7], n);
                }
                case 8: {
                    return String.valueOf(PCAModel.this.X.getN());
                }
                case 9: {
                    return String.valueOf(PCAModel.this.X.getK());
                }
                case 10: {
                    return PCAModel.this.X.getTransformationInfo();
                }
            }
            return "";
        }

        @Override
        public ModelMatrix getDModX() {
            return this.mr[2];
        }

        @Override
        public ModelMatrix getHotellingT2() {
            return this.mr[14];
        }

        @Override
        public ModelMatrix getP() {
            return this.mr[1];
        }

        public ModelMatrix getQ2X() {
            return this.getQ2Y();
        }

        public ModelMatrix getQ2X_CUM() {
            return this.getQ2Y_CUM();
        }

        public ModelMatrix getQ2X_VAR() {
            return this.getQ2Y_VAR();
        }

        public ModelMatrix getQ2X_VAR_CUM() {
            return this.getQ2Y_VAR_CUM();
        }

        @Override
        public ModelMatrix getQ2Y() {
            return this.mr.length > 11 ? this.mr[11] : null;
        }

        @Override
        public ModelMatrix getQ2Y_CUM() {
            return this.mr.length > 12 ? this.mr[12] : null;
        }

        @Override
        public ModelMatrix getQ2Y_VAR() {
            return this.mr.length > 9 ? this.mr[9] : null;
        }

        @Override
        public ModelMatrix getQ2Y_VAR_CUM() {
            return this.mr.length > 10 ? this.mr[10] : null;
        }

        @Override
        public ModelMatrix getSSX() {
            return this.mr[5];
        }

        @Override
        public ModelMatrix getSSXY_CUM() {
            return this.mr[6];
        }

        @Override
        public ModelMatrix getSSXY() {
            return this.mr[5];
        }

        @Override
        public ModelMatrix getT() {
            return this.mr[0];
        }

        @Override
        public ModelMatrix getW() {
            return this.mr[1];
        }

        @Override
        public void Save(RandomOutputStream randomOutputStream) throws IOException {
            this.save(randomOutputStream, loadResultNames);
        }

        private void initVectors() {
            for (int i = 2; i < this.mr.length; ++i) {
                if (this.mr[i] == null) continue;
                this.mr[i].setVector(false);
            }
        }
    }
}

