/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.mda.model.PCA;

import java.io.IOException;
import java.util.Properties;
import no.uib.cipr.matrix.DenseMatrix;
import no.uib.cipr.matrix.DenseVector;
import no.uib.cipr.matrix.Matrix;
import se.prediktera.map.common.MapProperty;
import se.prediktera.map.common.RandomInputStream;
import se.prediktera.map.common.RandomOutputStream;
import se.prediktera.map.common.jama.MatrixExtensions;
import se.prediktera.map.common.progress.ProgressManager;
import se.prediktera.map.datasetcontainer.AbstractDataNode;
import se.prediktera.map.datasetcontainer.classes.ClassTypes;
import se.prediktera.map.datasetcontainer.classes.prediction.InnerColumnPredClass;
import se.prediktera.map.datasetcontainer.classes.prediction.PredictionClasses;
import se.prediktera.map.datasetcontainer.datainfo.AbstractDataInfo;
import se.prediktera.map.datasetcontainer.datainfo.ObservationInfo;
import se.prediktera.map.datasetcontainer.dataset.DataSet;
import se.prediktera.map.datasetcontainer.matrix.AbstractDataMatrix;
import se.prediktera.map.datasetcontainer.matrix.AbstractMVmatrix;
import se.prediktera.map.datasetcontainer.matrix.MVmatrix;
import se.prediktera.map.datasetcontainer.matrix.ModelMatrix;
import se.prediktera.map.datasetcontainer.transform.category.DataInfoClassEvent;
import se.prediktera.map.main.IniManager;
import se.prediktera.mda.model.AbstractMDAModel;
import se.prediktera.mda.model.AbstractMDAResults;
import se.prediktera.mda.model.AnalysPredictionNode;
import se.prediktera.mda.model.PCA.PCAModel;
import se.prediktera.mda.model.SIMCA.SIMCAModel;

public class PCApredictionNode
extends AnalysPredictionNode {
    private static final String[] resultNames = new String[]{"Tpred", "ObsDMXpred", "Hotelling T2 pred"};
    private static final String[] pre102ResultNames = new String[]{"Tpred", "DModXpred", "Hotelling T2 pred"};
    private static final String[] htmlResultNames = new String[]{"<html><b>T</b>pred</html>", "<html>ObsDM<b>X</b>pred</html>", "<html>Hotelling T2 pred</html>"};
    private static final String[] resultInfo = new String[]{"Predicted Scores in <b>X</b>", "Predicted Observation Distance to Model in <b>X</b>", "Hotelling T2 pred"};
    private static String[] loadResultNames = resultNames;
    private PCApredictions pred;
    private AbstractMVmatrix predX;

    public PCApredictionNode(ProgressManager progressManager, AbstractMDAModel abstractMDAModel, DataSet dataSet) throws Exception {
        this(progressManager, abstractMDAModel, dataSet, null, true);
    }

    public PCApredictionNode(ProgressManager progressManager, AbstractMDAModel abstractMDAModel, DataSet dataSet, Properties properties, boolean bl) {
        super(abstractMDAModel, dataSet, properties, bl);
        this.resetPrediction();
        this.predX.setName("Xres Test");
        this.predX.setHtmlName("<html><b>X</b>res Test</html>");
        this.addTreeNode(this.predX, abstractMDAModel);
        this.pred = new PCApredictions(this, this, this.predX);
        this.predMR = this.pred.getMR();
        this.calcAllPredictions(progressManager);
    }

    public PCApredictionNode(RandomInputStream randomInputStream, MapProperty mapProperty) throws IOException {
        super(randomInputStream, mapProperty);
        if (randomInputStream.getSaveVersion() < 102L) {
            loadResultNames = pre102ResultNames;
        }
        this.predX = (AbstractMVmatrix)mapProperty.resolveNodeFromName(randomInputStream, "Te");
        this.pred = new PCApredictions(this, randomInputStream, mapProperty);
        this.predMR = this.pred.getMR();
    }

    @Override
    public boolean canCalculate() {
        return this.predX.getMatrixSize() > 0;
    }

    @Override
    public void cleanUpChild() {
        super.cleanUpChild();
        if (this.pred != null) {
            this.pred.cleanUp();
            this.pred = null;
        }
        this.predX = null;
    }

    public void createPredictionClasses() {
        short s;
        int n;
        double d;
        DenseVector denseVector;
        ModelMatrix modelMatrix;
        if (this.predMR[1] == null || this.predMR[1].getMatrixSize() == 0 || this.model.getTreeParent() instanceof SIMCAModel) {
            return;
        }
        PCAModel pCAModel = (PCAModel)this.model;
        ObservationInfo observationInfo = this.dataSet.getObsDataInfo();
        if (observationInfo == null) {
            return;
        }
        PredictionClasses predictionClasses = (PredictionClasses)observationInfo.getGroupColumnByType(11);
        if (predictionClasses == null) {
            predictionClasses = new PredictionClasses(observationInfo.getRowCount());
            observationInfo.addTreeNode(predictionClasses);
        }
        String string = "Pred. " + this.model.toString();
        InnerColumnPredClass innerColumnPredClass = predictionClasses.getPredictionClass(this.model, string);
        innerColumnPredClass.beginUpdate();
        ClassTypes classTypes = new ClassTypes(innerColumnPredClass);
        classTypes.addString(pCAModel.toString());
        innerColumnPredClass.holdObject(classTypes);
        int[] nArray = this.predX.getNref();
        boolean bl = pCAModel.isUseDcrit();
        if (bl) {
            modelMatrix = this.predMR[1];
            denseVector = modelMatrix.getLastRM();
            d = pCAModel.getDcritX();
            for (n = 0; n < denseVector.size(); ++n) {
                s = 0;
                if (denseVector.get(n) < d) {
                    s = 1;
                }
                innerColumnPredClass.setValueShort(nArray != null ? nArray[n] : n, s);
            }
        }
        if (pCAModel.isUseHotelling()) {
            modelMatrix = this.predMR[2];
            denseVector = modelMatrix.getLastRM();
            d = pCAModel.getHotellingt2();
            for (n = 0; n < denseVector.size(); ++n) {
                if (bl && innerColumnPredClass.getValueShort(nArray != null ? nArray[n] : n) == 0) continue;
                s = 0;
                if (denseVector.get(n) < d) {
                    s = 1;
                }
                innerColumnPredClass.setValueShort(nArray != null ? nArray[n] : n, s);
            }
        }
        if (!bl && !pCAModel.isUseHotelling()) {
            innerColumnPredClass.fillColumn((short)1);
        }
        innerColumnPredClass.endUpdate();
        observationInfo.triggerGlobalEvent(new DataInfoClassEvent((AbstractDataInfo)observationInfo, 7, null, classTypes, 3));
    }

    @Override
    public void finishPrediction(ProgressManager progressManager) {
        if (this.predClasses) {
            this.createPredictionClasses();
        }
    }

    @Override
    public ModelMatrix getDModX() {
        return this.getPredMR(1);
    }

    @Override
    public ModelMatrix getHotellingT2() {
        return this.getPredMR(2);
    }

    @Override
    public PCApredictions getPredictions() {
        return this.pred;
    }

    @Override
    public byte getTreeType() {
        return 2;
    }

    @Override
    public AbstractMVmatrix getXMatrix() {
        return this.predX;
    }

    @Override
    public MVmatrix getYMatrix() {
        AbstractMDAResults abstractMDAResults = (AbstractMDAResults)this.model.getResults();
        DenseMatrix denseMatrix = null;
        for (int i = this.pred.getRound() - 1; i >= 0; --i) {
            DenseMatrix denseMatrix2 = MatrixExtensions.timesTransposeOf(this.predMR[0].getRM(i), abstractMDAResults.getMR()[1].getRM(i));
            if (denseMatrix != null) {
                denseMatrix.add(1.0, (Matrix)denseMatrix2);
                continue;
            }
            denseMatrix = denseMatrix2;
        }
        if (denseMatrix == null) {
            return null;
        }
        this.model.reverseTransformationsX(denseMatrix, this.predX.getKref(), this.pred.getRound() > 1);
        return new MVmatrix((Matrix)denseMatrix, true);
    }

    @Override
    public void SavePropertyLocal(RandomOutputStream randomOutputStream) throws IOException {
        super.SavePropertyLocal(randomOutputStream);
        randomOutputStream.writePropertyNode("Te", this.predX);
        this.pred.Save(randomOutputStream);
    }

    @Override
    protected AbstractMDAResults calcOnePrediction(ProgressManager progressManager) {
        this.beginCalculations();
        AbstractMDAResults abstractMDAResults = (AbstractMDAResults)this.model.getResults();
        int n = this.pred.getRound();
        DenseVector denseVector = abstractMDAResults.getMR()[1].getRM(n);
        DenseVector denseVector2 = this.predX.times(denseVector);
        if (this.predX.hasMissing()) {
            AbstractMDAModel.nipalsRowMv(this.predX, denseVector, denseVector2);
        }
        MatrixExtensions.minusEqualsTimesTransposeOf(this.predX, denseVector2, denseVector);
        this.predMR[0].addRow(denseVector2);
        if (this.calcDModXY && (!this.optimize || n == abstractMDAResults.getRound() - 1)) {
            ModelMatrix modelMatrix = abstractMDAResults.getMR(13);
            double d = modelMatrix != null ? modelMatrix.getScalar(n) : 1.0;
            this.predMR[1].addRow(this.model.predictDModXY(this.predX, n + 1, d));
            this.model.calculateHotellingT2(this.predMR[2], this.predMR[0], this.model.getResults().getMatrix(5));
        }
        this.predMR[1].setVisibleInTree(this.calcDModXY);
        this.pred.IncRound();
        this.endCalculations();
        return this.pred;
    }

    @Override
    protected void removeOnePrediction() throws Exception {
        this.beginCalculations();
        AbstractMDAResults abstractMDAResults = (AbstractMDAResults)this.model.getResults();
        DenseVector denseVector = this.predMR[0].getLastRM();
        DenseVector denseVector2 = abstractMDAResults.getMR()[1].getLastRM();
        this.predX.plusEqualsMV((Matrix)MatrixExtensions.timesTransposeOf(denseVector, denseVector2));
        this.pred.removeLastRow();
        this.endCalculations();
    }

    @Override
    protected void resetPrediction() {
        this.checkDimensions();
        AbstractDataMatrix abstractDataMatrix = this.getDataSetMatrixToPredictInX();
        this.predX = abstractDataMatrix.subMatrix(this.predX, null, null, IniManager.getPredictionDataType());
        this.predX.beginCalculations();
        this.model.applyTransformationX(this.predX);
        if (this.pred != null) {
            this.pred.resetResults(this, this.predX, null);
        }
        this.predX.endCalculations();
    }

    public class PCApredictions
    extends AbstractMDAResults {
        public PCApredictions(PCApredictionNode pCApredictionNode, AbstractDataNode abstractDataNode, AbstractDataMatrix abstractDataMatrix) {
            super(abstractDataNode, pCApredictionNode.dataSet, resultNames.length);
            for (int i = 0; i < this.mr.length; ++i) {
                this.mr[i] = new ModelMatrix(this.obs, abstractDataMatrix);
                this.mr[i].setName(resultNames[i]);
                this.mr[i].setHtmlName(htmlResultNames[i]);
                this.mr[i].setMatrixInfo(resultInfo[i]);
                if (i > 0) {
                    this.mr[i].setVector(false);
                }
                abstractDataNode.addTreeNode(this.mr[i]);
            }
        }

        public PCApredictions(PCApredictionNode pCApredictionNode, RandomInputStream randomInputStream, MapProperty mapProperty) throws IOException {
            super(randomInputStream, mapProperty, loadResultNames);
        }

        @Override
        public Object[] getCompData(int n, boolean bl) {
            return null;
        }

        @Override
        public ModelMatrix getDModX() {
            return null;
        }

        @Override
        public ModelMatrix getHotellingT2() {
            return null;
        }

        public ModelMatrix getTpred() {
            return this.mr[0];
        }

        @Override
        public void Save(RandomOutputStream randomOutputStream) throws IOException {
            this.save(randomOutputStream, resultNames);
        }
    }
}

